#	
#

#
# Code maturity level options
#
CONFIG_EXPERIMENTAL=y

#
# Loadable module support
#
CONFIG_MODULES=y
CONFIG_MODVERSIONS=y
CONFIG_KMOD=y

#
# Processor and bus type and features
#
CONFIG_SMP=y
# CONFIG_CPU_FREQ is not set
# CONFIG_SOFTWARE_SUSPEND is not set


#
# Options that affect more than one architecture but are not asked for
# others
#
CONFIG_MICROCODE=m
# CONFIG_SCx200_GPIO is not set
# CONFIG_SCx200 is not set
# CONFIG_SCx200_WDT is not set
# CONFIG_BLK_DEV_SC1200 is not set
# CONFIG_SCx200_ACB is not set

#
# General setup
#
CONFIG_NET=y
# CONFIG_NET_PKTGEN is not set
CONFIG_HOTPLUG=y
CONFIG_BSD_PROCESS_ACCT=y
CONFIG_NR_CPUS=32
CONFIG_MAX_USER_RT_PRIO=100
CONFIG_MAX_RT_PRIO=0
CONFIG_BINFMT_AOUT=m
CONFIG_AUDIT=m

#
# ACPI Support
#
# CONFIG_ACPI is not set
# CONFIG_ACPI_ENABLE is not set
# CONFIG_ACPI_HT_ONLY is not set
# CONFIG_ACPI_DISABLE is not set
# CONFIG_ACPI_DEBUG is not set
CONFIG_ACPI_AC=m
CONFIG_ACPI_BATTERY=m
CONFIG_ACPI_BUTTON=m
CONFIG_ACPI_FAN=m
CONFIG_ACPI_PROCESSOR=m
CONFIG_ACPI_THERMAL=m
# CONFIG_ACPI_ASUS is not set
# CONFIG_ACPI_TOSHIBA is not set

CONFIG_PARPORT=m

# CONFIG_IPMI_HANDLER is not set
# CONFIG_IPMI_PANIC_EVENT is not set
# CONFIG_IPMI_DEVICE_INTERFACE is not set
# CONFIG_IPMI_KCS is not set
# CONFIG_IPMI_WATCHDOG is not set

#
# Busses
#

# CONFIG_MCA is not set
CONFIG_PCI=y
CONFIG_PCI_NAMES=y
# CONFIG_ISA is not set
# CONFIG_SBUS is not set
# CONFIG_HOTPLUG_PCI is not set
# CONFIG_HOTPLUG_PCI_COMPAQ_NVRAM is not set
# CONFIG_HOTPLUG_PCI_IBM is not set
# CONFIG_HOTPLUG_PCI_H2999 is not set
CONFIG_HIGHIO=y
CONFIG_EISA=y
CONFIG_PNP=y
CONFIG_ISAPNP=y

#
# PCMCIA/CardBus support
#
CONFIG_PCMCIA=m
CONFIG_CARDBUS=y
CONFIG_I82365=y
CONFIG_I82092=y
CONFIG_TCIC=y
CONFIG_SYSVIPC=y
CONFIG_SYSCTL=y
CONFIG_KCORE_ELF=y
# CONFIG_KCORE_AOUT is not set
CONFIG_BINFMT_ELF=y
CONFIG_BINFMT_MISC=m
CONFIG_PM=y
CONFIG_APM=y
# CONFIG_APM_IGNORE_USER_SUSPEND is not set
# CONFIG_APM_DO_ENABLE is not set
CONFIG_APM_CPU_IDLE=y
# CONFIG_APM_DISPLAY_BLANK is not set
CONFIG_APM_RTC_IS_GMT=y
# CONFIG_APM_REAL_MODE_POWER_OFF is not set
# CONFIG_AMD_PM768 is not set
# CONFIG_BATTERY_GERICOM is not set

#
# Memory Technology Devices (MTD)
#
# CONFIG_MTD is not set

#
# Parallel port support
#
CONFIG_PARPORT_PC=m
CONFIG_PARPORT_PC_PCMCIA=m
# CONFIG_PARPORT_PC_FIFO is not set
# CONFIG_PARPORT_PC_SUPERIO is not set
# CONFIG_PARPORT_AMIGA is not set
# CONFIG_PARPORT_MFC3 is not set
# CONFIG_PARPORT_ATARI is not set
CONFIG_PARPORT_1284=y
CONFIG_PARPORT_SERIAL=m
CONFIG_TIPAR=m

#
# Plug and Play configuration
#
# CONFIG_PNPBIOS is not set



#
# Block devices
#
CONFIG_BLK_STATS=y
CONFIG_BLK_DEV_FD=y

# CONFIG_BLK_DEV_XD is not set

#
# Parallel IDE high-level drivers
#
# CONFIG_PARIDE is not set
CONFIG_PARIDE_PARPORT=m
CONFIG_PARIDE_PD=m
CONFIG_PARIDE_PCD=m
CONFIG_PARIDE_PF=m
CONFIG_PARIDE_PT=m
CONFIG_PARIDE_PG=m
CONFIG_PARIDE_BPCK6=m

#
# Parallel IDE protocol modules
#
CONFIG_PARIDE_ATEN=m
CONFIG_PARIDE_BPCK=m
CONFIG_PARIDE_COMM=m
CONFIG_PARIDE_DSTR=m
CONFIG_PARIDE_FIT2=m
CONFIG_PARIDE_FIT3=m
CONFIG_PARIDE_EPAT=m
CONFIG_PARIDE_EPIA=m
CONFIG_PARIDE_FRIQ=m
CONFIG_PARIDE_FRPW=m
CONFIG_PARIDE_KBIC=m
CONFIG_PARIDE_KTTI=m
CONFIG_PARIDE_ON20=m
CONFIG_PARIDE_ON26=m
CONFIG_PARIDE_EPATC8=y
# CONFIG_BLK_CPQ_DA is not set
# CONFIG_BLK_CPQ_CISS_DA is not set
# CONFIG_CISS_MONITOR_THREAD is not set
# CONFIG_BLK_DEV_DAC960 is not set
CONFIG_BLK_DEV_NBD=m
CONFIG_BLK_DEV_SX8=m
CONFIG_BLK_DEV_RAM=y
CONFIG_BLK_DEV_RAM_SIZE=8192
CONFIG_BLK_DEV_INITRD=y
CONFIG_BLK_DEV_LOOP=m
# CONFIG_BLK_DEV_UMEM is not set


#
# Multi-device support (RAID and LVM)
#
CONFIG_MD=y
CONFIG_BLK_DEV_MD=y
CONFIG_MD_LINEAR=m
CONFIG_MD_RAID0=m
CONFIG_MD_RAID1=m
CONFIG_MD_RAID5=m
CONFIG_MD_MULTIPATH=m
CONFIG_BLK_DEV_LVM=m
CONFIG_LVM_PROC_FS=m
# CONFIG_BLK_DEV_DM is not set


#
# Networking options
#
CONFIG_PACKET=y
CONFIG_PACKET_MMAP=y
CONFIG_NETLINK=y
CONFIG_NETLINK_DEV=y
CONFIG_RTNETLINK=y
# CONFIG_IP6_NF_QUEUE is not set
CONFIG_NETFILTER=y
# CONFIG_NETFILTER_DEBUG is not set
CONFIG_FILTER=y
CONFIG_UNIX=y
CONFIG_INET=y
CONFIG_TUX=m
CONFIG_TUX_EXTCGI=y
# CONFIG_TUX_EXTENDED_LOG is not set
# CONFIG_TUX_DEBUG is not set
# CONFIG_IP_PNP is not set
CONFIG_NET_IPIP=m
CONFIG_NET_IPGRE=m
CONFIG_NET_IPGRE_BROADCAST=y
CONFIG_IP_MROUTE=y
CONFIG_IP_PIMSM_V1=y         
CONFIG_IP_ADVANCED_ROUTER=y
CONFIG_IP_MULTICAST=y
CONFIG_IP_MULTIPLE_TABLES=y
CONFIG_BNEP_MC_FILTER=y
CONFIG_BNEP_PROTO_FILTER=y
CONFIG_IP_ROUTE_FWMARK=y
CONFIG_IP_ROUTE_NAT=y
CONFIG_IP_ROUTE_MULTIPATH=y   
CONFIG_IP_ROUTE_TOS=y
CONFIG_IP_ROUTE_VERBOSE=y
CONFIG_IP_ROUTE_LARGE_TABLES=y
CONFIG_IP_PIMSM_V2=y
CONFIG_INET_AH=m
CONFIG_INET_ESP=m
CONFIG_INET6_IPCOMP=m
CONFIG_INET6_AH=m
CONFIG_INET6_ESP=m
CONFIG_XFRM_USER=y
CONFIG_NET_KEY=m
CONFIG_INET_IPCOMP=m
CONFIG_CRYPTO=m
CONFIG_CRYPTO_HMAC=m
CONFIG_CRYPTO_NULL=m
CONFIG_CRYPTO_MD4=m
CONFIG_CRYPTO_MD5=m
CONFIG_CRYPTO_SHA1=m
CONFIG_CRYPTO_SHA256=m
CONFIG_CRYPTO_SHA512=m
CONFIG_CRYPTO_DES=m
CONFIG_CRYPTO_BLOWFISH=m
CONFIG_CRYPTO_TWOFISH=m
CONFIG_CRYPTO_SERPENT=m
CONFIG_CRYPTO_AES=m
CONFIG_CRYPTO_DEFLATE=m
CONFIG_CRYPTO_CAST5=m
CONFIG_CRYPTO_CAST6=m
CONFIG_CRYPTO_TEST=m
# CONFIG_CRYPTO_AEP is not set
CONFIG_CIPHERS=m
CONFIG_CRYPTODEV=m
CONFIG_CIPHER_AES=m
CONFIG_CIPHER_IDENTITY=m
CONFIG_CRYPTOLOOP=m
CONFIG_CRYPTO_BROADCOM=m

# CONFIG_ARPD is not set
# CONFIG_INET_ECN is not set
CONFIG_SYN_COOKIES=y
CONFIG_NETCONSOLE=m


#
#   IP: Netfilter Configuration
#
CONFIG_IP_NF_CONNTRACK=m
CONFIG_IP_NF_FTP=m
CONFIG_IP_NF_IRC=m
CONFIG_IP_NF_QUEUE=m
CONFIG_IP_NF_IPTABLES=m
CONFIG_IP_NF_ARPTABLES=m
CONFIG_IP_NF_ARPFILTER=m
CONFIG_IP_NF_MATCH_LIMIT=m
CONFIG_IP_NF_MATCH_MAC=m
CONFIG_IP_NF_MATCH_MARK=m
CONFIG_IP_NF_MATCH_MULTIPORT=m
CONFIG_IP_NF_MATCH_TOS=m
CONFIG_IP_NF_MATCH_TCPMSS=m
CONFIG_IP_NF_MATCH_STATE=m
CONFIG_IP_NF_MATCH_UNCLEAN=m
CONFIG_IP_NF_MATCH_OWNER=m
CONFIG_IP_NF_MATCH_LENGTH=m
CONFIG_IP_NF_MATCH_TTL=m
CONFIG_IP_NF_MATCH_AH_ESP=m
CONFIG_IP_NF_MATCH_PKTTYPE=m
CONFIG_IP_NF_MATCH_ECN=m
CONFIG_IP_NF_MATCH_DSCP=m
CONFIG_IP_NF_MATCH_HELPER=m
CONFIG_IP_NF_MATCH_CONNTRACK=m
CONFIG_IP_NF_FILTER=m
CONFIG_IP_NF_TARGET_REJECT=m
CONFIG_IP_NF_TARGET_MIRROR=m
CONFIG_IP_NF_NAT=m
CONFIG_IP_NF_NAT_NEEDED=y
CONFIG_IP_NF_NAT_SNMP_BASIC=m
CONFIG_IP_NF_NAT_LOCAL=m
CONFIG_IP_NF_TARGET_MASQUERADE=m
CONFIG_IP_NF_TARGET_ULOG=m
CONFIG_IP_NF_TARGET_REDIRECT=m
CONFIG_IP_NF_TARGET_ECN=m
CONFIG_IP_NF_TARGET_DSCP=m
CONFIG_IP_NF_AMANDA=m
CONFIG_IP_NF_TFTP=m
CONFIG_IP_NF_ARP_MANGLE=m
CONFIG_IP_NF_MATCH_RECENT=m


#
#   IP_VS: IP Virtual Services support
#
CONFIG_IP_VS=m
# CONFIG_IP_VS_DEBUG is not set

CONFIG_IP_VS_TAB_BITS=16

CONFIG_IP_VS_LC=m
CONFIG_IP_VS_RR=m
CONFIG_IP_VS_WLC=m
CONFIG_IP_VS_WRR=m
CONFIG_IP_VS_LBLC=m
CONFIG_IP_VS_LBLCR=m
CONFIG_IP_VS_DH=m
CONFIG_IP_VS_SH=m
CONFIG_IP_VS_FTP=m

CONFIG_IP_NF_NAT_FTP=m
CONFIG_IP_NF_MANGLE=m
CONFIG_IP_NF_TARGET_TOS=m
CONFIG_IP_NF_TARGET_MARK=m
CONFIG_IP_NF_TARGET_LOG=m
CONFIG_IP_NF_TARGET_TCPMSS=m
CONFIG_IP_NF_COMPAT_IPCHAINS=m
CONFIG_IP_NF_COMPAT_IPFWADM=m
CONFIG_IPV6=m
CONFIG_IPV6_EUI64=y
CONFIG_IPV6_NO_PB=y           
CONFIG_IPV6_TUNNEL=m
CONFIG_IPV6_PRIVACY=y
# CONFIG_KHTTPD is not set

#
#   IPv6: Netfilter Configuration
#
CONFIG_IP6_NF_IPTABLES=m
CONFIG_IP6_NF_MATCH_LIMIT=m
CONFIG_IP6_NF_MATCH_MARK=m
CONFIG_IP6_NF_MATCH_MAC=m
CONFIG_IP6_NF_MATCH_MULTIPORT=m
CONFIG_IP6_NF_MATCH_OWNER=m
CONFIG_IP6_NF_MATCH_LENGTH=m
CONFIG_IP6_NF_MATCH_EUI64=m

CONFIG_IP6_NF_FILTER=m
CONFIG_IP6_NF_MANGLE=m
CONFIG_IP6_NF_TARGET_MARK=m
CONFIG_IP6_NF_TARGET_LOG=m
CONFIG_IP6_NF_MATCH_RT=m
CONFIG_IP6_NF_MATCH_OPTS=m
CONFIG_IP6_NF_MATCH_FRAG=m
CONFIG_IP6_NF_MATCH_HL=m
CONFIG_IP6_NF_MATCH_IPV6HEADER=m
CONFIG_IP6_NF_MATCH_AHESP=m


CONFIG_VLAN_8021Q=m

#
#  
#
CONFIG_IPX=m
# CONFIG_IPX_INTERN is not set
CONFIG_ATALK=m
CONFIG_DECNET=m
CONFIG_DECNET_SIOCGIFCONF=y
CONFIG_DECNET_ROUTER=y
CONFIG_DECNET_ROUTE_FWMARK=y
CONFIG_BRIDGE=m
CONFIG_BRIDGE_NF=y
# CONFIG_X25 is not set
# CONFIG_LAPB is not set
# CONFIG_LLC is not set
CONFIG_NET_DIVERT=y
# CONFIG_ECONET is not set
# CONFIG_NET_FASTROUTE is not set
# CONFIG_NET_HW_FLOWCONTROL is not set
# CONFIG_WAN_ROUTER is not set

#
# QoS and/or fair queueing
#
CONFIG_NET_SCHED=y
CONFIG_NET_SCH_CBQ=m
CONFIG_NET_SCH_HTB=m
CONFIG_NET_SCH_CSZ=m
# CONFIG_NET_SCH_ATM is not set
CONFIG_NET_SCH_PRIO=m
CONFIG_NET_SCH_RED=m
CONFIG_NET_SCH_SFQ=m
CONFIG_NET_SCH_TEQL=m
CONFIG_NET_SCH_TBF=m
CONFIG_NET_SCH_GRED=m
CONFIG_NET_SCH_DSMARK=m
CONFIG_NET_SCH_INGRESS=m
CONFIG_NET_QOS=y
CONFIG_NET_ESTIMATOR=y
CONFIG_NET_CLS=y
CONFIG_NET_CLS_TCINDEX=m
CONFIG_NET_CLS_ROUTE4=m
CONFIG_NET_CLS_FW=m
CONFIG_NET_CLS_U32=m
CONFIG_NET_CLS_RSVP=m
CONFIG_NET_CLS_RSVP6=m
CONFIG_NET_CLS_POLICE=y


#
# Telephony Support
#
CONFIG_PHONE=m
CONFIG_PHONE_IXJ=m
CONFIG_PHONE_IXJ_PCMCIA=m

#
# ATA/IDE/MFM/RLL support
#

#
# IDE, ATA and ATAPI Block devices
#
CONFIG_IDE=y
CONFIG_IDE_KNOWS=y
CONFIG_HAZARD_READ=y
# CONFIG_BLK_DEV_IDECD_BAILOUT is not set
CONFIG_BLK_DEV_IDE=y
CONFIG_BLK_DEV_IDECD=m
CONFIG_BLK_DEV_IDECS=m
CONFIG_BLK_DEV_IDEFLOPPY=y
CONFIG_BLK_DEV_IDESCSI=m
CONFIG_BLK_DEV_CMD640=y
# CONFIG_BLK_DEV_CMD640_ENHANCED is not set
# CONFIG_BLK_DEV_ISAPNP is not set
# CONFIG_BLK_DEV_RZ1000 is not set
CONFIG_IDEDMA_PCI_AUTO=y
CONFIG_IDEDISK_MULTI_MODE=y
# CONFIG_IDEDMA_PCI_WIP is not set
CONFIG_IDEDMA_NEW_DRIVE_LISTINGS=y
CONFIG_BLK_DEV_AEC62XX=y
CONFIG_AEC62XX_TUNING=y
CONFIG_BLK_DEV_ALI15X3=y
CONFIG_BLK_DEV_AMD7409=y
CONFIG_BLK_DEV_CMD64X=y
CONFIG_BLK_DEV_CY82C693=y
CONFIG_BLK_DEV_CS5530=y
CONFIG_BLK_DEV_SL82C105=y
# CONFIG_BLK_DEV_NS87415 is not set
# CONFIG_BLK_DEV_OPTI621 is not set
CONFIG_BLK_DEV_PDC202XX=y
# CONFIG_PDC202XX_BURST is not set
CONFIG_BLK_DEV_SIS5513=y
CONFIG_BLK_DEV_SLC90E66=y
# CONFIG_BLK_DEV_TRM290 is not set
CONFIG_BLK_DEV_VIA82CXXX=y
CONFIG_IDEDMA_AUTO=y
CONFIG_BLK_DEV_IDE_MODES=y

#
# Please see Documentation/ide.txt for help/info on IDE drives
#
# CONFIG_BLK_DEV_HD_IDE is not set
# CONFIG_BLK_DEV_HD is not set
CONFIG_BLK_DEV_IDEDISK=y
# CONFIG_BLK_DEV_OFFBOARD is not set
CONFIG_BLK_DEV_ATARAID=m
CONFIG_BLK_DEV_ATARAID_HPT=m
CONFIG_BLK_DEV_ATARAID_PDC=m
CONFIG_BLK_DEV_ATARAID_SII=m
# CONFIG_BLK_DEV_IDEDISK_VENDOR is not set
# CONFIG_BLK_DEV_IDEDISK_FUJITSU is not set
# CONFIG_BLK_DEV_IDEDISK_IBM is not set
# CONFIG_BLK_DEV_IDEDISK_MAXTOR is not set
# CONFIG_BLK_DEV_IDEDISK_QUANTUM is not set
# CONFIG_BLK_DEV_IDEDISK_SEAGATE is not set
# CONFIG_BLK_DEV_IDEDISK_WD is not set
# CONFIG_BLK_DEV_COMMERIAL is not set
# CONFIG_BLK_DEV_TIVO is not set
CONFIG_BLK_DEV_IDETAPE=m


#
# IDE chipset support/bugfixes
#
CONFIG_BLK_DEV_IDEPCI=y
CONFIG_IDEPCI_SHARE_IRQ=y
CONFIG_BLK_DEV_IDEDMA_PCI=y
CONFIG_BLK_DEV_IDEDMA=y
# CONFIG_IDEDMA_ONLYDISK is not set
# CONFIG_BLK_DEV_IDEDMA_FORCED is not set
# CONFIG_IDEDISK_STROKE is not set
# CONFIG_IDE_TASK_IOCTL is not set
# CONFIG_BLK_DEV_SERVICE is not set
# CONFIG_PKT_TASK_IOCTL is not set
# CONFIG_IDE_TASK_IOCTL_DEBUG is not set
# CONFIG_IDE_TASKFILE_IO is not set

# CONFIG_WDC_ALI15X3 is not set
# CONFIG_AMD7409_OVERRIDE is not set
CONFIG_BLK_DEV_HPT34X=y
# CONFIG_HPT34X_AUTODMA is not set
CONFIG_BLK_DEV_HPT366=y
CONFIG_BLK_DEV_PIIX=y
CONFIG_PIIX_TUNING=y
CONFIG_BLK_DEV_AMD74XX=y
CONFIG_BLK_DEV_CENATEK=y
CONFIG_PDC202XX_FORCE=y
CONFIG_BLK_DEV_SVWKS=y
CONFIG_BLK_DEV_GENERIC=y
# CONFIG_AMD74XX_OVERRIDE is not set
CONFIG_BLK_DEV_NFORCE=y
CONFIG_BLK_DEV_PDC202XX_OLD=y
CONFIG_BLK_DEV_PDC202XX_NEW=y
CONFIG_BLK_DEV_SIIMAGE=y
CONFIG_BLK_DEV_TRIFLEX=y

# CONFIG_BLK_DEV_OSB4 is not set
# CONFIG_IDE_CHIPSETS is not set
# CONFIG_IDEDMA_IVB is not set
# CONFIG_DMA_NONPCI is not set
CONFIG_BLK_DEV_CMD680=y
CONFIG_BLK_DEV_ADMA100=y

#
# SCSI support
#
CONFIG_SCSI=m

#
# SCSI support type (disk, tape, CD-ROM)
#
CONFIG_SD_EXTRA_DEVS=256
CONFIG_CHR_DEV_ST=m
CONFIG_CISS_SCSI_TAPE=y
CONFIG_CHR_DEV_OSST=m
CONFIG_CHR_DEV_SG=m
CONFIG_BLK_DEV_SD=m
CONFIG_BLK_DEV_SR=m
CONFIG_BLK_DEV_SR_VENDOR=y
CONFIG_SR_EXTRA_DEVS=4
# CONFIG_SCSI_DEBUG_QUEUES is not set
CONFIG_SCSI_LOGGING=y


#
# Some SCSI devices (e.g. CD jukebox) support multiple LUNs
#
# CONFIG_SCSI_MULTI_LUN is not set
CONFIG_SCSI_CONSTANTS=y

#
# SCSI low-level drivers
#
CONFIG_BLK_DEV_3W_XXXX_RAID=m
CONFIG_SCSI_AIC7XXX=m
CONFIG_SCSI_AIC7XXX_OLD=m
CONFIG_AIC7XXX_OLD_PROC_STATS=y
CONFIG_SCSI_AACRAID=m
# CONFIG_SCSI_BUSLOGIC is not set
CONFIG_SCSI_GDTH=m
CONFIG_SCSI_NCR53C8XX=m
CONFIG_SCSI_SYM53C8XX=m
CONFIG_SCSI_NCR53C8XX_DEFAULT_TAGS=8
# CONFIG_SCSI_NCR53C8XX_PQS_PDS is not set
CONFIG_SCSI_QLOGIC_FAS=m
CONFIG_SCSI_QLOGIC_ISP=m
CONFIG_SCSI_QLOGIC_FC=m
CONFIG_AIC7XXX_TCQ_ON_BY_DEFAULT=y
# CONFIG_AIC7XXX_PROC_STATS is not set
CONFIG_AIC7XXX_RESET_DELAY_MS=15000
CONFIG_AIC7XXX_CMDS_PER_DEVICE=32
CONFIG_AIC7XXX_RESET_DELAY=5000
# CONFIG_AIC7XXX_BUILD_FIRMWARE is not set
CONFIG_AIC7XXX_OLD_TCQ_ON_BY_DEFAULT=y
CONFIG_AIC7XXX_OLD_CMDS_PER_DEVICE=32
# CONFIG_AIC7XXX_PROBE_EISA_VL is not set
CONFIG_SCSI_AIC79XX=m
CONFIG_AIC79XX_CMDS_PER_DEVICE=32
CONFIG_AIC79XX_RESET_DELAY_MS=15000
# CONFIG_AIC79XX_BUILD_FIRMWARE is not set
# CONFIG_AIC79XX_ENABLE_RD_STRM is not set
# CONFIG_AIC79XX_DEBUG_ENABLE is not set
CONFIG_AIC79XX_DEBUG_MASK=0
CONFIG_AIC7XXX_DEBUG_MASK=0
# CONFIG_AIC7XXX_DEBUG_ENABLE is not set
# CONFIG_AIC7XXX_REG_PRETTY_PRINT is not set
# CONFIG_AIC79XX_REG_PRETTY_PRINT is not set
CONFIG_SCSI_MEGARAID=m
CONFIG_SCSI_MEGARAID2=m
CONFIG_SCSI_SATA=y
CONFIG_SCSI_SATA_SVW=m
CONFIG_SCSI_ATA_PIIX=m
CONFIG_SCSI_SATA_PROMISE=m
CONFIG_SCSI_SATA_SIL=m
CONFIG_SCSI_SATA_VIA=m
CONFIG_SCSI_SATA_VITESSE=m
CONFIG_SCSI_SATA_SIS=m
CONFIG_SCSI_SATA_SX4=m
CONFIG_SCSI_SATA_NV=m
# CONFIG_SCSI_OMIT_FLASHPOINT is not set
CONFIG_SCSI_EATA_TAGGED_QUEUE=y
# CONFIG_SCSI_EATA_LINKED_COMMANDS is not set
CONFIG_SCSI_EATA_MAX_TAGS=16
# CONFIG_SCSI_GENERIC_NCR53C400 is not set
CONFIG_SCSI_G_NCR5380_PORT=y
# CONFIG_SCSI_G_NCR5380_MEM is not set
# CONFIG_SCSI_IPS is not set
CONFIG_SCSI_PPA=m
CONFIG_SCSI_IMM=m
# CONFIG_SCSI_IZIP_EPP16 is not set
# CONFIG_SCSI_IZIP_SLOW_CTR is not set
# CONFIG_SCSI_NCR53C7xx_sync is not set
CONFIG_SCSI_NCR53C7xx_FAST=y
CONFIG_SCSI_NCR53C7xx_DISCONNECT=y
CONFIG_SCSI_NCR53C8XX_MAX_TAGS=32
# CONFIG_SCSI_NCR53C8XX_PROFILE is not set
# CONFIG_SCSI_NCR53C8XX_IOMAPPED is not set
# CONFIG_SCSI_NCR53C8XX_SYMBIOS_COMPAT is not set
CONFIG_SCSI_NCR53C8XX_SYNC=80
CONFIG_SCSI_SYM53C8XX_2=m
CONFIG_SCSI_SYM53C8XX_DMA_ADDRESSING_MODE=1
CONFIG_SCSI_SYM53C8XX_DEFAULT_TAGS=16
CONFIG_SCSI_SYM53C8XX_MAX_TAGS=64
# CONFIG_SCSI_SYM53C8XX_IOMAPPED is not set
CONFIG_PCMCIA_NINJA_SCSI=m
CONFIG_SCSI_QLOGIC_1280=m
CONFIG_FC_QLA2100=m
CONFIG_FC_QLA2200=m
CONFIG_FC_QLA2300=m
# CONFIG_SCSI_QLOGIC_FC_FIRMWARE is not set
CONFIG_SCSI_LPFC=m
CONFIG_SCSI_NEWISP=m
CONFIG_SCSI_SEAGATE=m
# CONFIG_SCSI_DC390T_NOGENSUPP is not set
# CONFIG_SCSI_U14_34F_LINKED_COMMANDS is not set
CONFIG_SCSI_U14_34F_MAX_TAGS=8
CONFIG_SCSI_ULTRASTOR=m
CONFIG_SCSI_ISCSI=m
CONFIG_SCSI_NSP32=m
# CONFIG_SCSI_NCR_D700 is not set
# CONFIG_SCSI_LASI700 is not set
CONFIG_53C700_IO_MAPPED=y
# CONFIG_SCSI_7000FASST is not set
# CONFIG_SCSI_ACARD is not set
# CONFIG_SCSI_AHA152X is not set
# CONFIG_SCSI_AHA1542 is not set
# CONFIG_SCSI_AHA1740 is not set
# CONFIG_PCMCIA_APA1480 is not set
# CONFIG_SCSI_ADVANSYS is not set
# CONFIG_SCSI_IN2000 is not set
# CONFIG_SCSI_AM53C974 is not set
# CONFIG_SCSI_CPQFCTS is not set
# CONFIG_SCSI_DMX3191D is not set
# CONFIG_SCSI_DTC3280 is not set
# CONFIG_SCSI_EATA is not set
# CONFIG_SCSI_EATA_DMA is not set
# CONFIG_SCSI_EATA_PIO is not set
# CONFIG_SCSI_FUTURE_DOMAIN is not set
# CONFIG_SCSI_GENERIC_NCR5380 is not set
# CONFIG_SCSI_INITIO is not set
# CONFIG_SCSI_INIA100 is not set
# CONFIG_SCSI_NCR53C406A is not set
# CONFIG_SCSI_NCR53C7xx is not set
# CONFIG_SCSI_PCI2000 is not set
# CONFIG_SCSI_PAS16 is not set
# CONFIG_SCSI_PCI2220I is not set
# CONFIG_SCSI_PSI240I is not set
# CONFIG_SCSI_SIM710 is not set
# CONFIG_SCSI_SYM53C416 is not set
# CONFIG_SCSI_DC390T is not set
# CONFIG_SCSI_T128 is not set
# CONFIG_SCSI_U14_34F is not set
# CONFIG_SCSI_DEBUG is not set
CONFIG_SCSI_IPR=m

#
# PCMCIA SCSI adapter support
#
CONFIG_SCSI_PCMCIA=y
CONFIG_PCMCIA_QLOGIC=m

#
# Fusion MPT device support
#
CONFIG_FUSION=m
# CONFIG_FUSION_BOOT is not set
#
# (ability to boot linux kernel from Fusion device is DISABLED!)
#
# CONFIG_FUSION_ISENSE is not set
CONFIG_FUSION_CTL=m
CONFIG_FUSION_LAN=m
CONFIG_FUSION_MAX_SGE=40

#
# IEEE 1394 (FireWire) support
#
# CONFIG_IEEE1394 is not set
# CONFIG_IEEE1394_PCILYNX is not set
# CONFIG_IEEE1394_PCILYNX_LOCALRAM is not set
CONFIG_IEEE1394_PCILYNX_PORTS=y
CONFIG_IEEE1394_OHCI1394=m
CONFIG_IEEE1394_VIDEO1394=m
CONFIG_IEEE1394_RAWIO=m
CONFIG_IEEE1394_SBP2=m
# CONFIG_IEEE1394_VERBOSEDEBUG is not set
CONFIG_IEEE1394_ETH1394=m
CONFIG_IEEE1394_DV1394=m
CONFIG_IEEE1394_CMP=m
CONFIG_IEEE1394_AMDTP=m
CONFIG_IEEE1394_SBP2_PHYS_DMA=y
CONFIG_IEEE1394_OUI_DB=m



#
# I2O device support
#
CONFIG_I2O=m
CONFIG_I2O_PCI=m
CONFIG_I2O_BLOCK=m
CONFIG_I2O_LAN=m
CONFIG_I2O_SCSI=m
CONFIG_I2O_PROC=m
# CONFIG_SCSI_DPT_I2O is not set


#
# Network device support
#
CONFIG_NETDEVICES=y

#
# ARCnet devices
#
# CONFIG_ARCNET is not set

#
# Appletalk devices
#
CONFIG_APPLETALK=y
CONFIG_DEV_APPLETALK=y
CONFIG_LTPC=m
CONFIG_COPS=m
CONFIG_COPS_DAYNA=y
CONFIG_COPS_TANGENT=y
CONFIG_IPDDP=m
CONFIG_IPDDP_ENCAP=y
CONFIG_IPDDP_DECAP=y
CONFIG_DUMMY=m
CONFIG_BONDING=m
CONFIG_EQUALIZER=m
CONFIG_TUN=m
CONFIG_ETHERTAP=m
CONFIG_NET_SB1000=m

#
# Ethernet (10 or 100Mbit)
#
CONFIG_NET_ETHERNET=y
CONFIG_NET_VENDOR_3COM=y
CONFIG_EL3=m
# CONFIG_EWRK3 is not set
# CONFIG_3C359 is not set
# CONFIG_3C515 is not set
# CONFIG_ELMC is not set
# CONFIG_ELMC_II is not set
CONFIG_VORTEX=m
CONFIG_TYPHOON=m
# CONFIG_AMD8111_ETH is not set
# CONFIG_NET_VENDOR_SMC is not set
CONFIG_WD80x3=m
CONFIG_ULTRA=m
CONFIG_ULTRA32=m
CONFIG_SMC9194=m
# CONFIG_NET_VENDOR_RACAL is not set
CONFIG_NI5010=m
CONFIG_NI52=m
CONFIG_NI65=m
CONFIG_AT1700=m
CONFIG_DEPCA=m
# CONFIG_HP100 is not set
# CONFIG_NET_ISA is not set
CONFIG_E2100=m
CONFIG_EEXPRESS=m
CONFIG_EEXPRESS_PRO=m
CONFIG_HPLAN_PLUS=m
CONFIG_HPLAN=m
CONFIG_ETH16I=m
CONFIG_NE2000=m
CONFIG_SK_G16=m
CONFIG_NET_PCI=y
CONFIG_PCNET32=m
CONFIG_ADAPTEC_STARFIRE=m
CONFIG_AC3200=m
CONFIG_APRICOT=m
CONFIG_CS89x0=m
CONFIG_TULIP=m
# CONFIG_TULIP_MWI is not set
CONFIG_TULIP_MMIO=y
# CONFIG_DE4X5 is not set
# CONFIG_DGRS is not set
CONFIG_EEPRO100=m
# CONFIG_EEPRO100_PM is not set
# CONFIG_EEPRO100_PIO is not set
CONFIG_LNE390=m
CONFIG_LP486E=m
# CONFIG_FEALNX is not set
CONFIG_E100=m
CONFIG_NATSEMI=m
# CONFIG_NATSEMI_CABLE_MAGIC is not set
CONFIG_NE2K_PCI=m
CONFIG_NE3210=m
CONFIG_ES3210=m
CONFIG_8139TOO=m
CONFIG_R8169=m
# CONFIG_8139_OLD_RX_RESET is not set
CONFIG_8139CP=m
# CONFIG_8139TOO_TUNE_TWISTER is not set
CONFIG_8139TOO_8129=y
# CONFIG_8139_NEW_RX_RESET is not set
# CONFIG_8139TOO_PIO is not set
CONFIG_RTL8129=m
CONFIG_SIS900=m
CONFIG_SIS900_OLD=m
# CONFIG_EPIC100 is not set
# CONFIG_SUNDANCE is not set
# CONFIG_SUNDANCE_MMIO is not set
# CONFIG_SUNGEM is not set
CONFIG_TLAN=m
# CONFIG_VIA_RHINE is not set
# CONFIG_VIA_RHINE_MMIO is not set
CONFIG_WINBOND_840=m
# CONFIG_HAPPYMEAL is not set
# CONFIG_NET_POCKET is not set
CONFIG_ATP=m
CONFIG_DE600=m
CONFIG_DE620=m
# CONFIG_LAN_SAA9730 is not set
# CONFIG_TC35815 is not set
CONFIG_DM9102=m
CONFIG_B44=m

#
# Ethernet (1000 Mbit)
#
CONFIG_E1000=m
CONFIG_E1000_NAPI=y
CONFIG_ACENIC=m
CONFIG_TIGON3=m
# CONFIG_ACENIC_OMIT_TIGON_I is not set
CONFIG_HAMACHI=m
CONFIG_NS83820=m
CONFIG_YELLOWFIN=m
CONFIG_NET_BROADCOM=m
CONFIG_DL2K=m
CONFIG_SK98LIN=m
CONFIG_FDDI=y
CONFIG_DEFXX=m
CONFIG_SKFP=m
# CONFIG_HIPPI is not set
CONFIG_PLIP=m
CONFIG_PPP=m
CONFIG_PPP_FILTER=y
CONFIG_PPP_MULTILINK=y
CONFIG_PPP_ASYNC=m
CONFIG_PPP_SYNC_TTY=m
# CONFIG_SYNCLINKMP is not set
# CONFIG_PPP_DEFLATE is not set
# CONFIG_PPP_BSDCOMP is not set
# CONFIG_PPPOE is not set
CONFIG_SLIP=m
CONFIG_SLIP_COMPRESSED=y
CONFIG_SLIP_SMART=y
CONFIG_SLIP_MODE_SLIP6=y

#
# Wireless LAN (non-hamradio)
#
CONFIG_CIPE=m
# CONFIG_NET_RADIO is not set
CONFIG_STRIP=m
CONFIG_WAVELAN=m
CONFIG_ARLAN=m
CONFIG_AIRONET4500=m
CONFIG_AIRONET4500_NONCS=m
CONFIG_AIRONET4500_PNP=y
CONFIG_AIRONET4500_PCI=y
CONFIG_AIRONET4500_ISA=y
CONFIG_AIRONET4500_I365=y
CONFIG_AIRONET4500_PROC=m
CONFIG_AIRO=m
CONFIG_AIRO_CS=m
CONFIG_HERMES=m
CONFIG_PLX_HERMES=m
CONFIG_PCI_HERMES=m



#
# Token Ring devices
#
CONFIG_TR=y
CONFIG_IBMTR=m
CONFIG_IBMOL=m
CONFIG_IBMLS=m
# CONFIG_TMS380TR is not set
CONFIG_TMSPCI=m
# CONFIG_TMSISA is not set
CONFIG_ABYSS=m
CONFIG_SMCTR=m
CONFIG_NET_FC=y
# CONFIG_IPHASE5526 is not set
# CONFIG_RCPCI is not set
CONFIG_SHAPER=m

#
# Wan interfaces
#
# CONFIG_WAN is not set
CONFIG_HOSTESS_SV11=m
CONFIG_COSA=m
CONFIG_FARSYNC=m
CONFIG_ATI_XX20=m
# CONFIG_ATI_CD1865 is not set
CONFIG_SYNCLINK_CS=m
# CONFIG_COMX is not set
# CONFIG_LANMEDIA is not set
CONFIG_SEALEVEL_4021=m
# CONFIG_SYNCLINK_SYNCPPP is not set
# CONFIG_HDLC is not set
CONFIG_DLCI=m
CONFIG_DLCI_COUNT=24
CONFIG_DLCI_MAX=8
CONFIG_SDLA=m
CONFIG_WAN_ROUTER_DRIVERS=y
CONFIG_VENDOR_SANGOMA=m
CONFIG_WANPIPE_CARDS=4
CONFIG_WANPIPE_CHDLC=y
CONFIG_WANPIPE_PPP=y
CONFIG_WANPIPE_FR=y
CONFIG_WANPIPE_X25=y
CONFIG_WANPIPE_MULTPPP=y
CONFIG_CYCLADES_SYNC=m
CONFIG_CYCLOMX_X25=y
# CONFIG_LAPBETHER is not set
# CONFIG_X25_ASY is not set
CONFIG_SBNI=m
CONFIG_SBNI_MULTILINE=y

#
# PCMCIA network device support
#
CONFIG_NET_PCMCIA=y
CONFIG_PCMCIA_3C589=m
CONFIG_PCMCIA_3C574=m
CONFIG_PCMCIA_FMVJ18X=m
CONFIG_PCMCIA_PCNET=m
CONFIG_PCMCIA_NMCLAN=m
CONFIG_PCMCIA_SMC91C92=m
CONFIG_PCMCIA_XIRC2PS=m
CONFIG_PCMCIA_AXNET=m
# CONFIG_ARCNET_COM20020_CS is not set
CONFIG_PCMCIA_IBMTR=m
CONFIG_PCMCIA_XIRTULIP=m
CONFIG_PCMCIA_XIRCOM=m
CONFIG_NET_PCMCIA_RADIO=y
CONFIG_PCMCIA_RAYCS=m
CONFIG_PCMCIA_NETWAVE=m
CONFIG_PCMCIA_WAVELAN=m
CONFIG_PCMCIA_WVLAN=m
CONFIG_PCMCIA_HERMES=m
CONFIG_PCMCIA_HERMES_OLD=m
CONFIG_AIRONET4500_CS=m
# CONFIG_AIRONET4800_CS is not set

#
# ATM drivers
#
# CONFIG_ATM is not set
CONFIG_ATM_TCP=m
CONFIG_ATM_ENI=m
CONFIG_ATM_NICSTAR=m
CONFIG_ATM_IA=m
# CONFIG_ATM_IA_DEBUG is not set
CONFIG_ATM_CLIP=y
# CONFIG_ATM_CLIP_NO_ICMP is not set
CONFIG_ATM_LANE=m
CONFIG_ATM_MPOA=m
CONFIG_PPPOATM=m
CONFIG_ATM_LANAI=m
CONFIG_ATM_BR2684=m
CONFIG_ATM_BR2684_IPFILTER=y
# CONFIG_ATM_ENI_DEBUG is not set
# CONFIG_ATM_ENI_TUNE_BURST is not set
CONFIG_ATM_FIRESTREAM=m
CONFIG_ATM_ZATM=m
# CONFIG_ATM_ZATM_DEBUG is not set
CONFIG_ATM_ZATM_EXACT_TS=y
CONFIG_ATM_NICSTAR_USE_SUNI=y
CONFIG_ATM_NICSTAR_USE_IDT77105=y
CONFIG_ATM_AMBASSADOR=m
# CONFIG_ATM_AMBASSADOR_DEBUG is not set
CONFIG_ATM_HORIZON=m
# CONFIG_ATM_HORIZON_DEBUG is not set
CONFIG_ATM_FORE200E_MAYBE=m
CONFIG_ATM_FORE200E_PCA=y
CONFIG_ATM_FORE200E_PCA_DEFAULT_FW=y
CONFIG_ATM_FORE200E_TX_RETRY=16
CONFIG_ATM_FORE200E_DEBUG=0
CONFIG_ATM_FORE200E=m
CONFIG_ATM_IDT77252=m
# CONFIG_ATM_IDT77252_DEBUG is not set
# CONFIG_ATM_IDT77252_RCV_ALL is not set


#
# Amateur Radio support
#
# CONFIG_HAMRADIO is not set
CONFIG_AX25=m
CONFIG_EDP2=m
# CONFIG_AX25_DAMA_SLAVE is not set
CONFIG_NETROM=m
CONFIG_ROSE=m
# CONFIG_MKISS is not set
# CONFIG_6PACK is not set
# CONFIG_BPQETHER is not set
# CONFIG_DMASCC is not set
# CONFIG_SCC is not set
# CONFIG_BAYCOM_SER_FDX is not set
# CONFIG_BAYCOM_SER_HDX is not set
# CONFIG_BAYCOM_PAR is not set
# CONFIG_BAYCOM_EPP is not set
CONFIG_SOUNDMODEM_SBC=y
CONFIG_SOUNDMODEM_WSS=y
CONFIG_SOUNDMODEM_AFSK1200=y
CONFIG_SOUNDMODEM_AFSK2400_7=y
CONFIG_SOUNDMODEM_AFSK2400_8=y
CONFIG_SOUNDMODEM_AFSK2666=y
CONFIG_SOUNDMODEM_HAPN4800=y
CONFIG_SOUNDMODEM_PSK4800=y
CONFIG_SOUNDMODEM_FSK9600=y
# CONFIG_YAM is not set

#
# IrDA (infrared) support
#
CONFIG_IRDA=m

#
# IrDA protocols
#
CONFIG_IRLAN=m
CONFIG_IRNET=m
CONFIG_IRCOMM=m
CONFIG_IRDA_ULTRA=y
CONFIG_IRDA_OPTIONS=y

#
#   IrDA options
#
CONFIG_IRDA_CACHE_LAST_LSAP=y
CONFIG_IRDA_FAST_RR=y
# CONFIG_IRDA_DEBUG is not set

#
# Infrared-port device drivers
#

#
# SIR device drivers
#
CONFIG_IRTTY_SIR=m
CONFIG_IRPORT_SIR=m

#
# FIR device drivers
#
CONFIG_NSC_FIR=m
CONFIG_WINBOND_FIR=m
CONFIG_TOSHIBA_FIR=m
CONFIG_SMC_IRCC_FIR=m
CONFIG_ALI_FIR=m
CONFIG_VLSI_FIR=m

#
# Dongle support
#
CONFIG_DONGLE=y
CONFIG_ESI_DONGLE=m
CONFIG_ACTISYS_DONGLE=m
CONFIG_TEKRAM_DONGLE=m
CONFIG_GIRBIL_DONGLE=m
CONFIG_LITELINK_DONGLE=m
CONFIG_OLD_BELKIN_DONGLE=m
CONFIG_MCP2120_DONGLE=m
CONFIG_ACT200L_DONGLE=m
CONFIG_MA600_DONGLE=m
CONFIG_TOSHIBA_OLD=m

#
# ISDN subsystem
#
# CONFIG_ISDN is not set
CONFIG_ISDN_PPP=y
CONFIG_ISDN_PPP_VJ=y
CONFIG_ISDN_MPP=y
CONFIG_ISDN_PPP_BSDCOMP=m
CONFIG_ISDN_AUDIO=y
CONFIG_ISDN_TTY_FAX=y

#
# ISDN feature submodules
#
CONFIG_ISDN_DRV_LOOP=m
# CONFIG_ISDN_DIVERSION is not set


#
# low-level hardware drivers
#

#
# Passive ISDN cards
#
CONFIG_ISDN_DRV_HISAX=m
CONFIG_HISAX_DEBUG=y
CONFIG_HISAX_ENTERNOW_PCI=m
CONFIG_ISDN_DRV_EICON=m
CONFIG_ISDN_DRV_EICON_DIVAS=m
# CONFIG_ISDN_DRV_EICON_OLD is not set

#
#   D-channel protocol features
#
CONFIG_HISAX_EURO=y
CONFIG_DE_AOC=y
# CONFIG_HISAX_NO_SENDCOMPLETE is not set
# CONFIG_HISAX_NO_LLC is not set
# CONFIG_HISAX_NO_KEYPAD is not set
CONFIG_HISAX_1TR6=y
CONFIG_HISAX_NI1=y

#
#   HiSax supported cards
#
CONFIG_HISAX_16_0=y
CONFIG_HISAX_16_3=y
CONFIG_HISAX_TELESPCI=y
CONFIG_HISAX_S0BOX=y
CONFIG_HISAX_AVM_A1=y
CONFIG_HISAX_AVM_A1_CS=m
CONFIG_HISAX_FRITZPCI=y
CONFIG_HISAX_FRITZ_PCIPNP=m
CONFIG_HISAX_AVM_A1_PCMCIA=y
CONFIG_HISAX_ELSA=y
CONFIG_HISAX_ELSA_CS=m
CONFIG_HISAX_IX1MICROR2=y
CONFIG_HISAX_DIEHLDIVA=y
CONFIG_HISAX_ASUSCOM=y
CONFIG_HISAX_TELEINT=y
CONFIG_HISAX_HFCS=y
CONFIG_HISAX_SEDLBAUER=y
CONFIG_HISAX_SEDLBAUER_CS=m
CONFIG_HISAX_SPORTSTER=y
CONFIG_HISAX_MIC=y
CONFIG_HISAX_NETJET=y
CONFIG_HISAX_NETJET_U=y
CONFIG_HISAX_NICCY=y
CONFIG_HISAX_ISURF=y
CONFIG_HISAX_HSTSAPHIR=y
CONFIG_HISAX_BKM_A4T=y
CONFIG_HISAX_SCT_QUADRO=y
CONFIG_HISAX_GAZEL=y
CONFIG_HISAX_HFC_PCI=y
CONFIG_HISAX_W6692=y
CONFIG_HISAX_HFC_SX=y
CONFIG_HISAX_ST5481=y
CONFIG_HISAX_MAX_CARDS=8

#
# Active ISDN cards
#
CONFIG_ISDN_DRV_ICN=m
CONFIG_ISDN_DRV_PCBIT=m
# CONFIG_ISDN_DRV_SC is not set
# CONFIG_ISDN_DRV_ACT2000 is not set
CONFIG_ISDN_DRV_EICON_PCI=m
# CONFIG_ISDN_DRV_EICON_ISA is not set
CONFIG_ISDN_CAPI=m
CONFIG_ISDN_DRV_AVMB1_VERBOSE_REASON=y
CONFIG_ISDN_CAPI_MIDDLEWARE=y
CONFIG_ISDN_CAPI_CAPI20=m
CONFIG_ISDN_CAPI_CAPIFS_BOOL=y
CONFIG_ISDN_CAPI_CAPIFS=m
CONFIG_ISDN_CAPI_CAPIDRV=m
CONFIG_ISDN_DRV_AVMB1_B1ISA=m
CONFIG_ISDN_DRV_AVMB1_B1PCI=m
CONFIG_ISDN_DRV_AVMB1_B1PCIV4=y
CONFIG_ISDN_DRV_AVMB1_B1PCMCIA=m
CONFIG_ISDN_DRV_AVMB1_T1ISA=m
CONFIG_ISDN_DRV_AVMB1_AVM_CS=m
CONFIG_ISDN_DRV_AVMB1_T1PCI=m
CONFIG_ISDN_DRV_AVMB1_C4=m
CONFIG_HYSDN=m
CONFIG_HYSDN_CAPI=y
CONFIG_ISDN_DRV_TPAM=m

#
# Input core support
#
CONFIG_INPUT=m
CONFIG_INPUT_GAMEPORT=m
CONFIG_INPUT_KEYBDEV=m
CONFIG_INPUT_MOUSEDEV=m
CONFIG_INPUT_MOUSEDEV_SCREEN_X=1024
CONFIG_INPUT_MOUSEDEV_SCREEN_Y=768
CONFIG_INPUT_JOYDEV=m
CONFIG_INPUT_STINGER=m
CONFIG_INPUT_CS461X=m
CONFIG_INPUT_EVDEV=m
CONFIG_INPUT_ANALOG=m
CONFIG_INPUT_INTERACT=m
CONFIG_INPUT_WARRIOR=m 
CONFIG_INPUT_EMU10K1=m
CONFIG_INPUT_SERIO=m



#
# Character devices
#
# CONFIG_CD_NO_IDESCSI is not set
CONFIG_VT=y
CONFIG_VT_CONSOLE=y
# CONFIG_ECC is not set
CONFIG_SERIAL=y
CONFIG_SERIAL_CONSOLE=y
CONFIG_SERIAL_MANY_PORTS=y
CONFIG_SERIAL_SHARE_IRQ=y
CONFIG_SERIAL_HCDP=y
CONFIG_SERIAL_ACPI=y
CONFIG_SERIAL_EXTENDED=y
CONFIG_SERIAL_NONSTANDARD=y
# CONFIG_SERIAL_DETECT_IRQ is not set
CONFIG_SERIAL_MULTIPORT=y
CONFIG_ICOM=m
# CONFIG_HUB6 is not set
# CONFIG_COMPUTONE is not set
# CONFIG_ROCKETPORT is not set
CONFIG_CYCLADES=m
# CONFIG_CYZ_INTR is not set
# CONFIG_DIGIEPCA is not set
CONFIG_DIGI=m
CONFIG_ESPSERIAL=m
# CONFIG_DSCC4 is not set
CONFIG_MOXA_INTELLIO=m
CONFIG_MOXA_SMARTIO=m
CONFIG_ISI=m
CONFIG_SYNCLINK=m
CONFIG_N_HDLC=m
CONFIG_RISCOM8=m
CONFIG_SPECIALIX=m
CONFIG_SPECIALIX_RTSCTS=y
CONFIG_SX=m
# CONFIG_RIO is not set
CONFIG_STALDRV=y
CONFIG_STALLION=m
CONFIG_ISTALLION=m
CONFIG_UNIX98_PTYS=y
CONFIG_UNIX98_PTY_COUNT=2048
CONFIG_PRINTER=m
CONFIG_LP_CONSOLE=y
CONFIG_PPDEV=m
CONFIG_MWAVE=m
# CONFIG_SONYPI is not set
CONFIG_HANGCHECK_TIMER=m
CONFIG_HANGCHECK_DELAY=m

#
# I2C support
#
# CONFIG_I2C is not set
CONFIG_I2C_ALI15X3=m
CONFIG_I2C_HYDRA=m
CONFIG_I2C_I810=m
CONFIG_I2C_ALGOBIT=m
CONFIG_I2C_PHILIPSPAR=m
CONFIG_I2C_ELV=m
CONFIG_I2C_VELLEMAN=m
CONFIG_I2C_ALGOPCF=m
CONFIG_I2C_ELEKTOR=m
CONFIG_I2C_MAINBOARD=y
CONFIG_I2C_AMD756=m
CONFIG_I2C_I801=m
CONFIG_I2C_PIIX4=m
CONFIG_I2C_VIA=m
CONFIG_I2C_VIAPRO=m
CONFIG_I2C_VOODOO3=m
CONFIG_I2C_ALI1535=m
# CONFIG_I2C_TSUNAMI is not set
CONFIG_I2C_SIS5595=m
CONFIG_I2C_ISA=m
CONFIG_I2C_CHARDEV=m
CONFIG_I2C_PROC=m

#
# Hardware sensors support
#
CONFIG_SENSORS=m
CONFIG_SENSORS_ADM1021=m
CONFIG_SENSORS_ADM1025=m
CONFIG_SENSORS_ADM9240=m
CONFIG_SENSORS_GL518SM=m
CONFIG_SENSORS_GL520SM=m
CONFIG_SENSORS_LM75=m
CONFIG_SENSORS_LM78=m
CONFIG_SENSORS_LM80=m
CONFIG_SENSORS_LM87=m
CONFIG_SENSORS_LM92=m
CONFIG_SENSORS_SMSC47M1=m
CONFIG_SENSORS_VT1211=m
CONFIG_SENSORS_VT8231=m
CONFIG_SENSORS_PCF8574=m
CONFIG_SENSORS_PCF8591=m
CONFIG_SENSORS_SIS5595=m
CONFIG_SENSORS_THMC50=m
CONFIG_SENSORS_VIA686A=m
CONFIG_SENSORS_W83781D=m
CONFIG_SENSORS_OTHER=y
CONFIG_SENSORS_BT869=m
CONFIG_SENSORS_DDCMON=m
CONFIG_SENSORS_EEPROM=m
CONFIG_SENSORS_LTC1710=m
CONFIG_SENSORS_MATORB=m
CONFIG_SENSORS_ADM1024=m
CONFIG_SENSORS_DS1621=m
CONFIG_SENSORS_FSCPOS=m
CONFIG_SENSORS_FSCSCY=m
CONFIG_SENSORS_MAXILIFE=m
CONFIG_SENSORS_IT87=m
CONFIG_SENSORS_MTP008=m

#
# Mice
#
CONFIG_ATIXL_BUSMOUSE=m
CONFIG_LOGIBUSMOUSE=m
CONFIG_MS_BUSMOUSE=m
CONFIG_MOUSE=y
CONFIG_PSMOUSE=y
CONFIG_MK712_MOUSE=m
# CONFIG_BUSMOUSE is not set
# CONFIG_82C710_MOUSE is not set
# CONFIG_PC110_PAD is not set


#
# Joysticks
#
CONFIG_INPUT_NS558=m
CONFIG_INPUT_LIGHTNING=m
CONFIG_INPUT_PCIGAME=m
CONFIG_INPUT_A3D=m
CONFIG_INPUT_ADI=m
CONFIG_INPUT_COBRA=m
CONFIG_INPUT_GF2K=m 
CONFIG_INPUT_GRIP=m
CONFIG_INPUT_TMDC=m
CONFIG_INPUT_SIDEWINDER=m
CONFIG_INPUT_SERPORT=m
CONFIG_INPUT_SPACEORB=m
CONFIG_INPUT_MAGELLAN=m
CONFIG_INPUT_SPACEBALL=m
CONFIG_INPUT_IFORCE_232=m
CONFIG_INPUT_IFORCE_USB=m
CONFIG_INPUT_DB9=m
CONFIG_INPUT_GAMECON=m
CONFIG_INPUT_TURBOGRAFX=m


#
# Input core support is needed for joysticks
#
# CONFIG_QIC02_TAPE is not set

#
# Watchdog Cards
#
CONFIG_WATCHDOG=y
# CONFIG_WATCHDOG_NOWAYOUT is not set
# CONFIG_WDT_501 is not set
CONFIG_SOFT_WATCHDOG=m
# CONFIG_WDT is not set
# CONFIG_WDTPCI is not set
# CONFIG_ADVANTECH_WDT is not set
# CONFIG_MACHZ_WDT is not set
# CONFIG_PCWATCHDOG is not set
# CONFIG_W83877F_WDT is not set
# CONFIG_ACQUIRE_WDT is not set
# CONFIG_EUROTECH_WDT is not set
# CONFIG_IB700_WDT is not set
# CONFIG_SC520_WDT is not set
# CONFIG_ALIM7101_WDT is not set
# CONFIG_WAFER_WDT is not set
# CONFIG_SC1200_WDT is not set
# CONFIG_ALIM1535_WDT is not set
# CONFIG_60XX_WDT is not set
# CONFIG_MIXCOMWD is not set
CONFIG_I810_TCO=m
# CONFIG_AMD7XX_TCO is not set
CONFIG_INTEL_RNG=m
CONFIG_AMD_RNG=m
# CONFIG_APPLICOM is not set

#
# Ftape, the floppy tape device driver
#
CONFIG_ZFTAPE=m
CONFIG_ZFT_DFLT_BLK_SZ=10240

#
#   The compressor will be built as a module only!
#
CONFIG_ZFT_COMPRESSOR=m
CONFIG_FT_NR_BUFFERS=3
# CONFIG_FT_PROC_FS is not set
CONFIG_FT_NORMAL_DEBUG=y
# CONFIG_FT_FULL_DEBUG is not set
# CONFIG_FT_NO_TRACE is not set
# CONFIG_FT_NO_TRACE_AT_ALL is not set

#
# Hardware configuration
#
CONFIG_FT_STD_FDC=y
# CONFIG_FT_MACH2 is not set
# CONFIG_FT_PROBE_FC10 is not set
# CONFIG_FT_ALT_FDC is not set
CONFIG_FT_FDC_THR=8
CONFIG_FT_FDC_MAX_RATE=2000
CONFIG_FT_ALPHA_CLOCK=0

# CONFIG_AGP is not set
CONFIG_AGP_INTEL=y
CONFIG_AGP_I810=y
CONFIG_AGP_VIA=y
CONFIG_AGP_AMD=y
CONFIG_AGP_AMD_8151=y
CONFIG_AGP_SIS=y
CONFIG_AGP_ALI=y
CONFIG_AGP_SWORKS=y
CONFIG_AGP_NVIDIA=y
# CONFIG_DRM is not set
# CONFIG_DRM_OLD is not set
CONFIG_DRM_NEW=y
CONFIG_DRM_TDFX=m
CONFIG_DRM_GAMMA=m
CONFIG_DRM_R128=m
CONFIG_DRM_I810=m
# CONFIG_DRM_I810_XFREE_41 is not set
CONFIG_DRM_I830=m
CONFIG_DRM_MGA=m
CONFIG_DRM_RADEON=m
CONFIG_DRM_SIS=m
# CONFIG_DRM41_SIS is not set
CONFIG_PCMCIA_SERIAL=m

#
# PCMCIA character device support
#
CONFIG_PCMCIA_SERIAL_CS=m
CONFIG_PCMCIA_SERIAL_CB=m

#
# Multimedia devices
#

#
# Video For Linux
#
CONFIG_I2C_PARPORT=m


#
# Video Adapters
#
# CONFIG_VIDEO_DEV is not set
CONFIG_VIDEO_PROC_FS=y
CONFIG_VIDEO_BT848=m
CONFIG_VIDEO_W9966=m
CONFIG_VIDEO_BWQCAM=m
CONFIG_VIDEO_CQCAM=m
CONFIG_VIDEO_CPIA=m
CONFIG_VIDEO_CPIA_PP=m
CONFIG_VIDEO_CPIA_USB=m
CONFIG_VIDEO_SAA5249=m
CONFIG_TUNER_3036=m
CONFIG_VIDEO_STRADIS=m
CONFIG_VIDEO_ZORAN=m
CONFIG_VIDEO_ZORAN_BUZ=m
CONFIG_VIDEO_ZORAN_DC10=m
CONFIG_VIDEO_ZORAN_LML33=m
CONFIG_VIDEO_BUZ=m
CONFIG_VIDEO_ZR36120=m
CONFIG_VIDEO_PMS=m
# CONFIG_VIDEO_MARGI is not set
# CONFIG_VIDEO_LS220 is not set

#
# Radio Adapters
#
CONFIG_RADIO_CADET=m
CONFIG_RADIO_RTRACK=m
CONFIG_RADIO_RTRACK2=m
CONFIG_RADIO_AZTECH=m
CONFIG_RADIO_GEMTEK=m
CONFIG_RADIO_GEMTEK_PCI=m
CONFIG_RADIO_MAESTRO=m
CONFIG_RADIO_MAXIRADIO=m
CONFIG_RADIO_MIROPCM20=m
CONFIG_RADIO_MIROPCM20_RDS=m
CONFIG_RADIO_SF16FMI=m
CONFIG_RADIO_SF16FMR2=m
CONFIG_RADIO_TERRATEC=m
CONFIG_RADIO_TRUST=m
CONFIG_RADIO_TYPHOON=m
CONFIG_RADIO_TYPHOON_PROC_FS=y
CONFIG_RADIO_ZOLTRIX=m


#
# File systems
#
CONFIG_FS_POSIX_ACL=y
CONFIG_QUOTA=y
# CONFIG_QFMT_V1 is not set
CONFIG_QFMT_V2=y

# CONFIG_QIFACE_COMPAT is not set
CONFIG_AFS_FS=m
CONFIG_AUTOFS_FS=m
CONFIG_AUTOFS4_FS=m
CONFIG_BEFS_FS=m
# CONFIG_BEFS_DEBUG is not set
CONFIG_REISERFS_FS=m
# CONFIG_REISERFS_CHECK is not set
CONFIG_REISERFS_PROC_INFO=y
# CONFIG_ADFS_FS is not set
# CONFIG_ADFS_FS_RW is not set
# CONFIG_AFFS_FS is not set
CONFIG_HFS_FS=m
# CONFIG_BFS_FS is not set
CONFIG_FAT_FS=m
CONFIG_MSDOS_FS=m
CONFIG_UMSDOS_FS=m
CONFIG_VFAT_FS=m
# CONFIG_EFS_FS is not set
# CONFIG_JFFS_FS is not set
CONFIG_CRAMFS=m
CONFIG_SWAPFS=y
CONFIG_TMPFS=y
CONFIG_RAMFS=m
# CONFIG_HUGETLBFS is not set
CONFIG_ISO9660_FS=y
CONFIG_ZISOFS=y
CONFIG_JOLIET=y
CONFIG_MINIX_FS=m
# CONFIG_NTFS_FS is not set
# CONFIG_NTFS_RW is not set
# CONFIG_HPFS_FS is not set
CONFIG_JFS_FS=m
CONFIG_JFS_DEBUG=y
CONFIG_JFS_POSIX_ACL=y
# CONFIG_JFS_STATISTICS is not set
CONFIG_PROC_FS=y
# CONFIG_DEVFS_FS is not set
# CONFIG_DEVFS_MOUNT is not set
# CONFIG_DEVFS_DEBUG is not set
CONFIG_DEVPTS_FS=y
# CONFIG_QNX4FS_FS is not set
# CONFIG_QNX4FS_RW is not set
CONFIG_ROMFS_FS=m
CONFIG_EXT2_FS=y
CONFIG_SYSV_FS=m
CONFIG_CMS_FS=m
CONFIG_EXT3_FS=m
CONFIG_EXT3_INDEX=y
CONFIG_EXT3_FS_XATTR=y
CONFIG_EXT3_FS_XATTR_SHARING=y
CONFIG_EXT3_FS_XATTR_USER=y
CONFIG_EXT3_FS_XATTR_TRUSTED=y
CONFIG_EXT3_FS_POSIX_ACL=y
# CONFIG_JBD_DEBUG is not set
# CONFIG_BUFFER_DEBUG is not set
# CONFIG_SYSV_FS_WRITE is not set
CONFIG_UDF_FS=m
CONFIG_UDF_RW=y
CONFIG_UFS_FS=m
# CONFIG_UFS_FS_WRITE is not set
# CONFIG_SIMICSFS is not set
# CONFIG_DDFS is not set
# CONFIG_XFS_FS is not set
# CONFIG_HFSPLUS_FS is not set

#
# Network File Systems
#
CONFIG_CODA_FS=m
CONFIG_NFS_FS=m
CONFIG_NFS_DIRECTIO=y
CONFIG_NFS_V3=y
# CONFIG_ROOT_NFS is not set
CONFIG_NFSD=m
CONFIG_NFSD_TCP=y
CONFIG_NFSD_V3=y
CONFIG_NFS_ACL=y
CONFIG_NFSD_ACL=y
CONFIG_SUNRPC=m
CONFIG_LOCKD=m
CONFIG_LOCKD_V4=y
CONFIG_VXFS_FS=m
CONFIG_SMB_FS=m
CONFIG_MORE_UNNAMED_MAJORS=y
# CONFIG_SMB_NLS_DEFAULT is not set
CONFIG_NCP_FS=m
CONFIG_NCPFS_PACKET_SIGNING=y
CONFIG_NCPFS_IOCTL_LOCKING=y
CONFIG_NCPFS_STRONG=y
CONFIG_NCPFS_NFS_NS=y
CONFIG_NCPFS_OS2_NS=y
CONFIG_NCPFS_SMALLDOS=y
CONFIG_NCPFS_NLS=y
CONFIG_NCPFS_EXTRAS=y
# CONFIG_INTERMEZZO_FS is not set


#
# Partition Types
#
CONFIG_PARTITION_ADVANCED=y
# CONFIG_ACORN_PARTITION is not set
CONFIG_OSF_PARTITION=y
# CONFIG_AMIGA_PARTITION is not set
# CONFIG_ATARI_PARTITION is not set
CONFIG_MAC_PARTITION=y
CONFIG_BSD_DISKLABEL=y
CONFIG_MINIX_SUBPARTITION=y   
CONFIG_SOLARIS_X86_PARTITION=y
CONFIG_UNIXWARE_DISKLABEL=y
CONFIG_SGI_PARTITION=y
# CONFIG_ULTRIX_PARTITION is not set
CONFIG_SUN_PARTITION=y
CONFIG_MSDOS_PARTITION=y
# CONFIG_LDM_PARTITION is not set
# CONFIG_EFI_PARTITION is not set

CONFIG_SMB_NLS=y
CONFIG_NLS=y

#
# Native Language Support
#
CONFIG_NLS_DEFAULT="iso8859-1"
CONFIG_NLS_CODEPAGE_437=m
CONFIG_NLS_CODEPAGE_737=m
CONFIG_NLS_CODEPAGE_775=m
CONFIG_NLS_CODEPAGE_850=m
CONFIG_NLS_CODEPAGE_852=m
CONFIG_NLS_CODEPAGE_855=m
CONFIG_NLS_CODEPAGE_857=m
CONFIG_NLS_CODEPAGE_860=m
CONFIG_NLS_CODEPAGE_861=m
CONFIG_NLS_CODEPAGE_862=m
CONFIG_NLS_CODEPAGE_863=m
CONFIG_NLS_CODEPAGE_864=m
CONFIG_NLS_CODEPAGE_865=m
CONFIG_NLS_CODEPAGE_866=m
CONFIG_NLS_CODEPAGE_869=m
CONFIG_NLS_CODEPAGE_874=m
CONFIG_NLS_CODEPAGE_932=m
CONFIG_NLS_CODEPAGE_936=m
CONFIG_NLS_CODEPAGE_949=m
CONFIG_NLS_CODEPAGE_950=m
CONFIG_NLS_CODEPAGE_1250=m
CONFIG_NLS_ISO8859_1=m
CONFIG_NLS_ISO8859_2=m
CONFIG_NLS_ISO8859_3=m
CONFIG_NLS_ISO8859_4=m
CONFIG_NLS_ISO8859_5=m
CONFIG_NLS_ISO8859_6=m
CONFIG_NLS_ISO8859_7=m
CONFIG_NLS_ISO8859_8=m
CONFIG_NLS_ISO8859_9=m
CONFIG_NLS_ISO8859_13=m
CONFIG_NLS_ISO8859_14=m
CONFIG_NLS_ISO8859_15=m
CONFIG_NLS_KOI8_R=m
CONFIG_NLS_UTF8=m
CONFIG_NLS_CODEPAGE_1251=m
CONFIG_NLS_KOI8_U=m

#
# Misc chardevices
#
# CONFIG_NVRAM is not set
# CONFIG_RTC is not set
# CONFIG_DTLK is not set
# CONFIG_R3964 is not set
# CONFIG_FTAPE is not set

#
# Console drivers
#
# CONFIG_VGA_CONSOLE is not set
CONFIG_VIDEO_SELECT=y
# CONFIG_VIDEO_IGNORE_BAD_MODE is not set
CONFIG_MDA_CONSOLE=m

#
# Frame-buffer support
#
CONFIG_FB=y
CONFIG_DUMMY_CONSOLE=y
# CONFIG_FB_E1355 is not set
# CONFIG_FB_PM2_FIFO_DISCONNECT is not set
# CONFIG_FB_PM2 is not set
CONFIG_FB_PM2_PCI=y
# CONFIG_FB_CYBER2000 is not set
CONFIG_FB_VESA=y
# CONFIG_FB_VGA16 is not set
# CONFIG_FB_HGA is not set
CONFIG_FB_MATROX=y
CONFIG_FB_MATROX_G100=y
CONFIG_FB_MATROX_G100A=y
# CONFIG_FB_MATROX_I2C is not set
# CONFIG_FB_MATROX_MAVEN is not set
# CONFIG_FB_MATROX_MULTIHEAD is not set
# CONFIG_FB_MATROX_MILLENIUM is not set
# CONFIG_FB_MATROX_MYSTIQUE is not set
CONFIG_FB_MATROX_G450=y
# CONFIG_FB_MATROX_PROC is not set
# CONFIG_FB_NEOMAGIC is not set
CONFIG_FB_ATY_GX=y 
CONFIG_FB_ATY_CT=y 
CONFIG_FB_ATY_CT_VAIO_LCD=y
# CONFIG_FB_TRIDENT is not set
# CONFIG_FB_RADEON is not set
# CONFIG_FB_VOODOO1 is not set
# CONFIG_FB_SIS is not set
CONFIG_FB_SIS_300=y
CONFIG_FB_SIS_315=y
# CONFIG_FB_VIRTUAL is not set
# CONFIG_FBCON_ADVANCED is not set
CONFIG_FBCON_HGA=m
CONFIG_FB_PM3=m
# CONFIG_FB_INTEL is not set
# CONFIG_FB_RIVA is not set
# CONFIG_FB_CLGEN is not set

# CONFIG_FBCON_FONTS is not set
CONFIG_FONT_8x8=y
CONFIG_FONT_8x16=y
CONFIG_FBCON_MFB=m
CONFIG_FBCON_CFB8=y
CONFIG_FBCON_CFB16=y
CONFIG_FBCON_CFB24=y
CONFIG_FBCON_CFB32=y
# CONFIG_FBCON_FONTWIDTH8_ONLY is not set

#
# Sound
#
# CONFIG_SOUND is not set
CONFIG_SOUND_CMPCI=m
CONFIG_SOUND_CMPCI_SPDIFLOOP=y
CONFIG_SOUND_CMPCI_4CH=y
CONFIG_SOUND_CMPCI_REAR=y
CONFIG_SOUND_CMPCI_FM=y
CONFIG_SOUND_CMPCI_MIDI=y
CONFIG_SOUND_CMPCI_JOYSTICK=y
CONFIG_SOUND_CMPCI_CM8738=y
CONFIG_SOUND_CMPCI_MPUIO=330
CONFIG_SOUND_CMPCI_SPEAKERS=2
# CONFIG_SOUND_CMPCI_SPDIFINVERSE is not set
CONFIG_SOUND_EMU10K1=m
CONFIG_SOUND_AUDIGY=m
CONFIG_MIDI_EMU10K1=m
CONFIG_SOUND_FUSION=m
CONFIG_SOUND_FORTE=m
CONFIG_SOUND_CS4281=m
CONFIG_SOUND_ES1370=m
CONFIG_SOUND_ES1371=m
CONFIG_SOUND_ESSSOLO1=m
CONFIG_SOUND_MAESTRO=m
CONFIG_SOUND_MAESTRO3=m
CONFIG_SOUND_SONICVIBES=m
CONFIG_SOUND_TRIDENT=m
# CONFIG_SOUND_MSNDCLAS is not set
# CONFIG_SOUND_MSNDPIN is not set
CONFIG_SOUND_VIA82CXXX=m
# CONFIG_SOUND_VIA82CXXX_PROCFS is not set
CONFIG_MIDI_VIA82CXXX=y
CONFIG_SOUND_OSS=m
# CONFIG_SOUND_TRACEINIT is not set
CONFIG_SOUND_DMAP=y
# CONFIG_SOUND_AD1816 is not set
CONFIG_SOUND_AD1889=m
# CONFIG_SOUND_SGALAXY is not set
# CONFIG_SOUND_ADLIB is not set
# CONFIG_SOUND_ACI_MIXER is not set
# CONFIG_SOUND_BT878 is not set
# CONFIG_SOUND_CS4232 is not set
CONFIG_SOUND_ALI5455=m
# CONFIG_SOUND_SSCAPE is not set
# CONFIG_SOUND_GUS is not set
CONFIG_SOUND_ICH=m
CONFIG_SOUND_VMIDI=m
# CONFIG_SOUND_TRIX is not set
# CONFIG_SOUND_MSS is not set
# CONFIG_SOUND_MPU401 is not set
# CONFIG_SOUND_NM256 is not set
# CONFIG_SOUND_MAD16 is not set
# CONFIG_SOUND_PAS is not set
# CONFIG_PAS_JOYSTICK is not set
# CONFIG_SOUND_PSS is not set
# CONFIG_PSS_MIXER is not set
# CONFIG_PSS_HAVE_BOOT is not set
# CONFIG_SOUND_SB is not set
# CONFIG_SOUND_AWE32_SYNTH is not set
# CONFIG_SOUND_WAVEFRONT is not set
# CONFIG_SOUND_MAUI is not set
# CONFIG_SOUND_YM3812 is not set
# CONFIG_SOUND_OPL3SA1 is not set
# CONFIG_SOUND_OPL3SA2 is not set
CONFIG_SOUND_YMFPCI=y
CONFIG_SOUND_YMFPCI_LEGACY=y
# CONFIG_SOUND_UART6850 is not set
# CONFIG_SOUND_AEDSP16 is not set
# CONFIG_SOUND_TVMIXER is not set
CONFIG_SOUND_RME96XX=m
# CONFIG_SOUND_KAHLUA is not set


#
# USB support
#
CONFIG_USB=m
# CONFIG_USB_DEBUG is not set
CONFIG_USB_LONG_TIMEOUT=y
# CONFIG_USB_LARGE_CONFIG is not set

#
# Miscellaneous USB options
#
CONFIG_USB_DEVICEFS=y
# CONFIG_USB_BANDWIDTH is not set

#
# USB Controllers
#
CONFIG_USB_UHCI=m
CONFIG_USB_UHCI_ALT=m
CONFIG_USB_OHCI=m
CONFIG_USB_EHCI_HCD=m

#
# USB Device Class drivers
#
CONFIG_USB_AUDIO=m
CONFIG_USB_BLUETOOTH=m
CONFIG_USB_PRINTER=m
CONFIG_USB_ACM=m

#
# USB Storage
#

CONFIG_USB_STORAGE=m
# CONFIG_USB_STORAGE_DEBUG is not set
CONFIG_USB_STORAGE_FREECOM=y
CONFIG_USB_STORAGE_HP8200e=y
CONFIG_USB_STORAGE_SDDR09=y
CONFIG_USB_STORAGE_DPCM=y
CONFIG_USB_STORAGE_DATAFAB=y
CONFIG_USB_STORAGE_JUMPSHOT=y
CONFIG_USB_STORAGE_ISD200=y
CONFIG_USB_STORAGE_SDDR55=y
CONFIG_USB_HPUSBSCSI=y


#
# USB Human Interface Devices (HID)
#
CONFIG_USB_HID=m
CONFIG_USB_HIDDEV=m
CONFIG_USB_HIDINPUT=m

# CONFIG_USB_KBD is not set
# CONFIG_USB_MOUSE is not set
CONFIG_USB_WACOM=m
CONFIG_USB_AIPTEK=m
CONFIG_USB_BRLVGER=m
CONFIG_USB_KBTAB=m

#
# USB Imaging devices
#
# CONFIG_USB_DC2XX is not set
CONFIG_USB_MDC800=m
CONFIG_USB_SCANNER=m
CONFIG_USB_MICROTEK=m
CONFIG_USB_HP5300=m
# CONFIG_USB_ID75 is not set


#
# USB Multimedia devices
#
CONFIG_USB_IBMCAM=m
CONFIG_USB_OV511=m
CONFIG_USB_DSBR=m
CONFIG_USB_DABUSB=m
CONFIG_USB_PWC=m
CONFIG_USB_KONICAWC=m
CONFIG_USB_SE401=m
CONFIG_USB_STV680=m
CONFIG_USB_VICAM=m
# CONFIG_USB_EMI26 is not set
CONFIG_USB_MIDI=m


#
# USB Network adaptors
#
CONFIG_USB_PLUSB=m
CONFIG_USB_PEGASUS=m
CONFIG_USB_KAWETH=m
CONFIG_USB_CATC=m
CONFIG_USB_NET1080=m
CONFIG_USB_USBNET=m
CONFIG_USB_CDCETHER=m
CONFIG_USB_RTL8150=m
CONFIG_USB_AUERSWALD=m
CONFIG_USB_SERIAL_EDGEPORT=m
CONFIG_USB_SERIAL_PL2303=m
CONFIG_USB_SERIAL_CYBERJACK=m
CONFIG_USB_SERIAL_IR=m
CONFIG_USB_SERIAL_IPAQ=m
CONFIG_USB_SERIAL_KLSI=m
CONFIG_USB_AUERISDN=m
# CONFIG_USB_AX8817X is not set

#
# USB port drivers
#
CONFIG_USB_USS720=m

#
# USB Serial Converter support
#
CONFIG_USB_SERIAL=m
# CONFIG_USB_SERIAL_DEBUG is not set
CONFIG_USB_SERIAL_GENERIC=y
CONFIG_USB_SERIAL_BELKIN=m
CONFIG_USB_SERIAL_WHITEHEAT=m
CONFIG_USB_SERIAL_DIGI_ACCELEPORT=m
CONFIG_USB_SERIAL_EMPEG=m
CONFIG_USB_SERIAL_FTDI_SIO=m
CONFIG_USB_SERIAL_VISOR=m
CONFIG_USB_SERIAL_KEYSPAN_PDA=m
CONFIG_USB_SERIAL_KEYSPAN=m
# CONFIG_USB_SERIAL_KEYSPAN_USA28 is not set
CONFIG_USB_SERIAL_KEYSPAN_USA28X=y
CONFIG_USB_SERIAL_KEYSPAN_USA28XA=y
CONFIG_USB_SERIAL_KEYSPAN_USA28XB=y
# CONFIG_USB_SERIAL_KEYSPAN_USA19 is not set
# CONFIG_USB_SERIAL_KEYSPAN_USA18X is not set
CONFIG_USB_SERIAL_KEYSPAN_USA19W=y
CONFIG_USB_SERIAL_KEYSPAN_USA19QW=y
CONFIG_USB_SERIAL_KEYSPAN_USA19QI=y
CONFIG_USB_SERIAL_KEYSPAN_MPR=m
CONFIG_USB_SERIAL_KEYSPAN_USA49W=y
CONFIG_USB_SERIAL_KEYSPAN_USA49WLC=y
CONFIG_BLUEZ_USB_SCO=m
CONFIG_USB_SERIAL_MCT_U232=m
CONFIG_USB_SERIAL_OMNINET=m
CONFIG_USB_SERIAL_XIRCOM=m
CONFIG_USB_SERIAL_EDGEPORT_TI=m
CONFIG_USB_SERIAL_KOBIL_SCT=m

CONFIG_USB_TIGL=m


#
# USB misc drivers
#
CONFIG_USB_RIO500=m
CONFIG_USB_IRDA=m
CONFIG_USB_LCD=m
CONFIG_USB_POWERMATE=m


#
# USB Bluetooth
#
CONFIG_BLUEZ=m
CONFIG_BLUEZ_L2CAP=m
CONFIG_BLUEZ_HCIUSB=m
CONFIG_BLUEZ_HCIUART=m
CONFIG_BLUEZ_HCIEMU=m
CONFIG_BLUEZ_HCIVHCI=m
CONFIG_BLUEZ_SCO=m
CONFIG_BLUEZ_USB_FW_LOAD=m
CONFIG_BLUEZ_USB_ZERO_PACKET=m
CONFIG_BLUEZ_HCIUART_H4=m
CONFIG_BLUEZ_HCIDTL1=m
CONFIG_BLUEZ_BNEP=m
CONFIG_BLUEZ_HCIBLUECARD=m
CONFIG_BLUEZ_HCIBT3C=m
CONFIG_BLUEZ_RFCOMM=m
CONFIG_BLUEZ_BNEP_MC_FILTER=m
CONFIG_BLUEZ_BNEP_PROTO_FILTER=m
CONFIG_BLUEZ_HCIUART_BCSP=m
CONFIG_BLUEZ_HCIBTUART=m
CONFIG_BLUEZ_RFCOMM_TTY=m
CONFIG_BLUEZ_HCIUART_BCSP_TXCRC=m

#
# Linux ABI
#
CONFIG_ABI=m 
CONFIG_ABI_SVR4=m
CONFIG_ABI_IBCS=m
CONFIG_ABI_IBCS_SCO=y
CONFIG_ABI_IBCS_ISC=y
CONFIG_ABI_IBCS_WYSE=y
# CONFIG_ABI_XENIX is not set
CONFIG_ABI_UW7=m
# CONFIG_ABI_SOLARIS is not set
CONFIG_ABI_ISC=m
CONFIG_ABI_SCO=m
# CONFIG_ABI_SCO_UTSNAME_HACK is not set
# CONFIG_ABI_WYSE is not set

CONFIG_BINFMT_XOUT=m
# CONFIG_BINFMT_XOUT_X286 is not set
# CONFIG_ABI_VERBOSE_ERRORS is not set

#
# Addon drivers
#
# CONFIG_MEGARAC is not set

#
# Speakup for Section 508 stuff
#
CONFIG_SPEAKUP=m
CONFIG_SPEAKUP_ACNTSA=y
CONFIG_SPEAKUP_ACNTPC=y
CONFIG_SPEAKUP_APOLO=y
CONFIG_SPEAKUP_AUDPTR=y
CONFIG_SPEAKUP_BNS=y
CONFIG_SPEAKUP_DECTLK=y
CONFIG_SPEAKUP_DECEXT=y
CONFIG_SPEAKUP_DTLK=y
CONFIG_SPEAKUP_LTLK=y
CONFIG_SPEAKUP_SPKOUT=y
CONFIG_SPEAKUP_TXPRT=y
CONFIG_SPEAKUP_DEFAULT=none
# CONFIG_SPEAKUP_KEYMAP is not set


#
# Kernel hacking
#
# CONFIG_SMALL is not set
CONFIG_KERNEL_DEBUG=y
CONFIG_DEBUG_KERNEL=y
# CONFIG_DEBUG_SPINLOCK is not set
# CONFIG_DEBUG_SLAB is not set
CONFIG_DEBUG_BUGVERBOSE=y
CONFIG_DEBUG_HIGHMEM=y
CONFIG_DEBUG_STACKOVERFLOW=y
# CONFIG_DEBUG_IOVIRT is not set

# CONFIG_IKCONFIG is not set
CONFIG_MAGIC_SYSRQ=y
CONFIG_LOLAT=y
# CONFIG_LOLAT_SYSCTL is not set
# CONFIG_FRAME_POINTER is not set
CONFIG_KALLSYMS=y
CONFIG_PANIC_MORSE=y
CONFIG_PROFILING=y
CONFIG_OPROFILE=m
# CONFIG_DISKDUMP is not set
# CONFIG_SCSI_DUMP is not set

#
# Library routines
#
CONFIG_CRC32=m
CONFIG_QSORT=y
CONFIG_ZLIB_DEFLATE=m
CONFIG_PPC=y
CONFIG_PPC64=y
CONFIG_IRQ_ALL_CPUS=y
CONFIG_RTAS_FLASH=m
CONFIG_PPC_RTAS=y
# CONFIG_RTAS_ERRINJCT is not set
CONFIG_SHARED_MEMORY_ADDRESSING=y
CONFIG_PROC_DEVICETREE=y
# CONFIG_CMDLINE_BOOL is not set
CONFIG_SCANLOG=m
CONFIG_LPARCFG=y
CONFIG_BINFMT_ELF32=y
CONFIG_OPROFILE=m
CONFIG_PARPORT=m
# CONFIG_BLK_CPQ_DA is not set
# CONFIG_BLK_CPQ_CISS_DA is not set
# CONFIG_BLK_DEV_DAC960 is not set
# CONFIG_BLK_DEV_UMEM is not set
# CONFIG_IEEE1394 is not set
# CONFIG_MACE is not set
# CONFIG_BMAC is not set
# CONFIG_GMAC is not set
# CONFIG_SCSI_MESH is not set
# CONFIG_SCSI_MAC53C94 is not set
CONFIG_SCSI_IPR=m
# CONFIG_HAPPYMEAL is not set
# CONFIG_SUNGEM is not set
# CONFIG_EWRK3 is not set
# CONFIG_3C359 is not set
# CONFIG_3C515 is not set
# CONFIG_NET_VENDOR_SMC is not set
# CONFIG_NET_VENDOR_RACAL is not set
# CONFIG_HP100 is not set
# CONFIG_DE4X5 is not set
# CONFIG_DGRS is not set
# CONFIG_FEALNX is not set
# CONFIG_EPIC100 is not set
# CONFIG_SUNDANCE is not set
# CONFIG_TC35815 is not set
# CONFIG_VIA_RHINE is not set
# CONFIG_NET_POCKET is not set
# CONFIG_NET_RADIO is not set
# CONFIG_IPHASE5526 is not set
# CONFIG_WAN is not set
# CONFIG_ISDN is not set
CONFIG_SERIAL_NONSTANDARD=y
# CONFIG_ROCKETPORT is not set
# CONFIG_DIGIEPCA is not set
# CONFIG_ATI_CD1865 is not set
CONFIG_ICOM=m
CONFIG_WATCHDOG=y
CONFIG_SOFT_WATCHDOG=m
# CONFIG_WDT is not set
# CONFIG_WDTPCI is not set
# CONFIG_ADVANTECH_WDT is not set
# CONFIG_MACHZ_WDT is not set
# CONFIG_PCWATCHDOG is not set
# CONFIG_W83877F_WDT is not set
# CONFIG_ACQUIRE_WDT is not set
# CONFIG_EUROTECH_WDT is not set
# CONFIG_IB700_WDT is not set
# CONFIG_SC520_WDT is not set
# CONFIG_ALIM7101_WDT is not set
# CONFIG_WAFER_WDT is not set
# CONFIG_SC1200_WDT is not set
# CONFIG_ALIM1535_WDT is not set
# CONFIG_AGP is not set
# CONFIG_DRM is not set
# CONFIG_HUGETLBFS is not set
# CONFIG_VGA_CONSOLE is not set
CONFIG_FB_OF=y
# CONFIG_FB_CONTROL is not set
# CONFIG_FB_PLATINUM is not set
# CONFIG_FB_VALKYRIE is not set
# CONFIG_FB_CT65550 is not set
# CONFIG_FB_IMSTT is not set
# CONFIG_FB_S3TRIO is not set
# CONFIG_FB_VGA16 is not set
# CONFIG_FB_HGA is not set
CONFIG_FB_MATROX=y
# CONFIG_FB_MATROX_I2C is not set
# CONFIG_FB_MATROX_MAVEN is not set
# CONFIG_FB_MATROX_MILLENIUM is not set
# CONFIG_FB_MATROX_MYSTIQUE is not set
# CONFIG_FB_MATROX_MULTIHEAD is not set
# CONFIG_FB_NEOMAGIC is not set
# CONFIG_FB_ATY is not set
# CONFIG_FB_ATY128 is not set
# CONFIG_FB_3DFX is not set
# CONFIG_FB_RADEON is not set
# CONFIG_FB_VOODOO1 is not set
# CONFIG_SOUND is not set
# CONFIG_PPCDBG is not set
# CONFIG_KGDB is not set
# CONFIG_KDB is not set
# CONFIG_DEBUG_SLAB is not set
# CONFIG_DUMP is not set
CONFIG_XMON=y
# CONFIG_AMD8111_ETH is not set
CONFIG_PPC_PSERIES=y
# CONFIG_HMT is not set
# CONFIG_MSCHUNKS is not set
CONFIG_JS20=y
CONFIG_ALTIVEC=y
CONFIG_HVC_CONSOLE=y
CONFIG_BLK_DEV_FD=y
CONFIG_SCSI_SYM53C8XX=m
CONFIG_SCSI_NCR53C8XX_SYNC=80
CONFIG_SCSI_NCR53C8XX_DEFAULT_TAGS=8
CONFIG_PARPORT=m
CONFIG_PARPORT_PC=m
CONFIG_PARPORT_PC_CML1=m
CONFIG_PARPORT_1284=y
# CONFIG_PARPORT_OTHER is not set
# CONFIG_PARIDE is not set
CONFIG_IBMVETH=m
CONFIG_SCSI_IBMVSCSI=m
