/*****************************************************************************
 *                                                                           *
 * COPYRIGHT (c) INTERNATIONAL BUSINESS MACHINES CORPORARTION, 2000          *
 * ALL RIGHTS RESERVED.                                                      *
 *                                                                           *
 * UNPUBLISHED RIGHTS RESERVED UNDER THE COPYRIGHT LAWS                      *
 * OF THE UNITED STATES.                                                     *
 *                                                                           *
 * Permission to use, copy, modify, and  distribute this software  for any   *
 * purpose with or without fee is hereby granted, provided  that the above   *
 * copyright notice and  this permission notice  appear in all copies, and   *
 * that the name of IBM not be used in advertising or publicity pertaining   *
 * to  distribution of  the document or  software without specific, written  *
 * prior permission.                                                         *
 *                                                                           *
 * DISCLAIMER OF WARRANTY AND LIMITATION OF LIABILITY                        *
 *                                                                           *
 * THE SOFTWARE  IS PROVIDED  "AS IS"  AND  IBM  CORPORATION.  DISCLAIMS ALL *
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES *
 * OF  MERCHANTABILITY  AND  FITNESS.  IN  NO EVENT  SHALL  IBM BE LIABLE    *
 * FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL  DAMAGES OR ANY       *
 * DAMAGES WHATSOEVER RESULTING  FROM LOSS OF USE,  DATA OR PROFITS, WHETHER *
 * IN AN ACTION OF CONTRACT,  NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING   *
 * OUT  OF OR  IN CONNECTION WITH  THE USE OR PERFORMANCE OF THIS SOFTWARE   *
 *                                                                           *
 *****************************************************************************/
 
/*

    CGI in C for straight DYNAMIC GET for SPECweb99:

    In rc file set:

DYN_GET_SCRIPT=http://les385/specweb99/cgi-bin/dyn_get_script.cgi?/specweb99

    Example Request issued by Client:

GET /specweb99/cgi-bin/dyn_get_script.cgi?/specweb99/file_set/dir00000/class0_0

*/

#include "fcgi_stdio.h"

#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <ctype.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include <sys/trchkid.h>

#include <sys/wait.h>
pid_t pid;
int status;

void mys1();
int pipefd_stdout[2];
int pipefd_stderr[2];

#define BOILERPLATE_START \
"<html>\n"\
"<head><title>SPECweb99 Dynamic GET & POST Test</title></head>\n"\
"<body>\n"\
"<p>SERVER_SOFTWARE = %s\n"\
"<p>REMOTE_ADDR = %s\n"\
"<p>SCRIPT_NAME = %s\n"\
"<p>QUERY_STRING = %s\n"\
"<pre>\n"

#define BOILERPLATE_END "\n</pre>\n</body></html>\n"


#define BUFLEN 128*1024*10
#define ERROR_NO_DOC_TOP "Can't find top of document tree, please configure value CGI script manually.\n"



void DoOutput(char *Buf, int Len);
int ReadFile(char *FileName, char *Buf, int BufSize);

main () {
  char Buffer[BUFLEN];
  FILE *fp;


    /* close all file descriptors but stdin, stdout, and stderr */
    fcntl(3, F_CLOSEM, 0);

    while(FCGI_Accept() >= 0) {
	/* need to open two pipes, respectively for stdout and stderr. */
	if (pipe(pipefd_stdout) == -1) {
	    perror("pipe");
	    fprintf(stderr, "Error!  Can't pipe() pipefd_stdout\n");
	    exit(1);
	}
	if (pipe(pipefd_stderr) == -1) {
	    perror("pipe");
	    fprintf(stderr, "Error!  Can't pipe() pipefd_stderr\n");
	    exit(1);
	}
	if ((pid = f_fork()) == -1) {
	    perror("fork");
	    exit(1);
	} else if (pid == 0) {	/* child */
	char args[8];
	    close(pipefd_stdout[0]);
	    close(pipefd_stderr[0]);
	    /* The cgi remain intact since I redirect fd 1 and 2. */
	    dup2(pipefd_stdout[1], 1);

	    dup2(pipefd_stderr[1], 2);

	    mys1();

	    exit(0);

	} else {	/* parent */ /* one cgi request at a time if wait */
	int read_length;
	int count;

	    close(pipefd_stdout[1]); 
	    close(pipefd_stderr[0]);
	    close(pipefd_stderr[1]);
	    read_length = 0;
	    while (1) {
		count = read(pipefd_stdout[0], &Buffer[read_length], 16384);
		if (count <= 0) break;
		read_length += count;
	    } 
	    close(pipefd_stdout[0]); 

	    /* forward it to web server */
	    fwrite(Buffer, sizeof(char), read_length, stdout);
	    waitpid(pid, &status, 0);
	}
    }
}

/* ****************************************** */
/* Code below is strictly for CGI applications, not fcgi daemon
*/

void mys1() {
  int len;
  char Buffer[BUFLEN];

  char *ServerSoftware;
  char *RemoteAddr;
  char *ScriptName;
  char *QueryString;
  char *TopDir;
  char *RequestMethod;

  char FileName[PATH_MAX];

  ServerSoftware = getenv("SERVER_SOFTWARE");
  RemoteAddr = getenv("REMOTE_ADDR");
  ScriptName = getenv("SCRIPT_NAME");
  QueryString = getenv("QUERY_STRING");
  RequestMethod = getenv("REQUEST_METHOD");

  TopDir = getenv ("DOCUMENT_ROOT");

  len = sprintf(Buffer, BOILERPLATE_START, ServerSoftware, RemoteAddr, 
		ScriptName,QueryString);

  if (TopDir == NULL) {
    strncpy(&Buffer[len], ERROR_NO_DOC_TOP, sizeof(ERROR_NO_DOC_TOP));
    len += sizeof(ERROR_NO_DOC_TOP) - 1 ;
    DoOutput(Buffer, len);
    return;
  }

  /* Just get the file requested in QueryString */
  sprintf(FileName,"%s%s",TopDir, QueryString);
  len += ReadFile(FileName, &Buffer[len], BUFLEN - len);

  DoOutput(Buffer, len);

}


void 
DoOutput(char *Buf, int Len) {
 
  int TempLen;
  int len;
  char buffer[BUFSIZ];

  TempLen = sizeof(BOILERPLATE_END);   
  strncpy(&Buf[Len], BOILERPLATE_END, TempLen);
  Len += TempLen - 1;

    len = sprintf (buffer, "Content-type: text/html\nContent-Length: %d\n\n", Len);
    write(1, buffer, len);
    write(1, Buf, Len);
}

int 
ReadFile(char *FileName, char *Buf, int BufSize) {

  int Desc;
  int Len;

  if ( (Desc = open(FileName, O_RDONLY, NULL)) == -1)
    return sprintf(Buf, "Error opening file '%s': %s", FileName, 
		   strerror(errno));
  else {
    Len = read (Desc, (void *) Buf, BufSize);
    close(Desc);
    return Len;
  }
}
