/*****************************************************************************
 *                                                                           *
 * COPYRIGHT (c) COMPAQ COMPUTER CORPORATION, 1998                           *
 * ALL RIGHTS RESERVED.                                                      *
 *                                                                           *
 * UNPUBLISHED RIGHTS RESERVED UNDER THE COPYRIGHT LAWS                      *
 * OF THE UNITED STATES.                                                     *
 *                                                                           *
 * Permission to use, copy, modify, and  distribute this software  for any   *
 * purpose with or without fee is hereby granted, provided  that the above   *
 * copyright notice and  this permission notice  appear in all copies, and   *
 * that the name of Compaq Computer Corporation not be used in advertising   *
 * or publicity  pertaining to  distribution of  the document or  software   *
 * without specific, written prior permission.                               *
 *                                                                           *
 * DISCLAIMER OF WARRANTY AND LIMITATION OF LIABILITY                        *
 *                                                                           *
 * THE SOFTWARE  IS PROVIDED "AS IS" AND COMPAQ COMPUTER CORP. DISCLAIMS ALL *
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES *
 * OF  MERCHANTABILITY  AND  FITNESS.  IN  NO EVENT  SHALL  COMPAQ  COMPUTER *
 * CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL *
 * DAMAGES  OR  ANY DAMAGES WHATSOEVER RESULTING  FROM LOSS OF USE,  DATA OR *
 * PROFITS, WHETHER  IN AN ACTION OF CONTRACT,  NEGLIGENCE OR OTHER TORTIOUS *
 * ACTION, ARISING OUT  OF OR  IN CONNECTION WITH  THE USE OR PERFORMANCE OF *
 * THIS SOFTWARE.                                                            *
 *                                                                           *
 *****************************************************************************/
 
/*

    CGI in C for straight DYNAMIC GET for SPECweb98:

    In rc file set:

DYN_GET_SCRIPT=http://les385/specweb98/cgi-bin/dyn_get_script.cgi?/specweb98

    Example Request issued by Client:

GET /specweb98/cgi-bin/dyn_get_script.cgi?/specweb98/file_set/dir00000/class0_0

*/


#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <ctype.h>
#include <errno.h>
#include <string.h>
/* #include <unistd.h> */
#include <io.h>
#include <time.h>

#define BOILERPLATE_START \
"<html>\n"\
"<head><title>SPECweb98 Dynamic GET & POST Test</title></head>\n"\
"<body>\n"\
"<p>SERVER_SOFTWARE = %s\n"\
"<p>REMOTE_ADDR = %s\n"\
"<p>SCRIPT_NAME = %s\n"\
"<p>QUERY_STRING = %s\n"\
"<pre>\n"

#define BOILERPLATE_END "\n</pre>\n</body></html>\n"


#define BUFLEN 128*1024*10
#define ERROR_NO_DOC_TOP "Can't find top of document tree, please configure value CGI script manually.\n"
#define PATH_MAX 256


void DoOutput(char *Buf, int Len);
int ReadFile(char *FileName, char *Buf, int BufSize);


void main () {
//  int c;
//  int fd;
  int len;
//  int TempLen;

//  char *qs;

  char Buffer[BUFLEN];

  char *ServerSoftware;
  char *RemoteAddr;
  char *ScriptName;
  char *QueryString;
  char *TopDir;
  char *RequestMethod;


//  char LogFile[PATH_MAX];
  char FileName[PATH_MAX];
//  char CtrFile[PATH_MAX];

  (void) _setmode(_fileno(stdout), _O_BINARY);

  ServerSoftware = getenv("SERVER_SOFTWARE");
  RemoteAddr = getenv("REMOTE_ADDR");
  ScriptName = getenv("SCRIPT_NAME");
  QueryString = getenv("QUERY_STRING");
  RequestMethod = getenv("REQUEST_METHOD");

 // TopDir = getenv ("DOCUMENT_ROOT");
  TopDir = getenv ("PATH_TRANSLATED");

  len = sprintf(Buffer, BOILERPLATE_START, ServerSoftware, RemoteAddr, 
		ScriptName,QueryString);

  if (TopDir == NULL) {
    strncpy(&Buffer[len], ERROR_NO_DOC_TOP, sizeof(ERROR_NO_DOC_TOP));
    len += sizeof(ERROR_NO_DOC_TOP) - 1 ;
    DoOutput(Buffer, len);
    return;
  }

  /* Just get the file requested in QueryString */
  sprintf(FileName,"%s%s",TopDir, QueryString);
  len += ReadFile(FileName, &Buffer[len], BUFLEN - len);

  DoOutput(Buffer, len);

}


void 
DoOutput(char *Buf, int Len) {
 
  int TempLen;

  TempLen = sizeof(BOILERPLATE_END);   
  strncpy(&Buf[Len], BOILERPLATE_END, TempLen);
  Len += TempLen - 1;

  printf ("Content-type: text/html\nContent-Length: %d\n\n", Len);
  fwrite(Buf, sizeof(char), Len, stdout);

}


int 
ReadFile(char *FileName, char *Buf, int BufSize) {

  int Desc;
  int Len;

  if ( (Desc = _open(FileName, O_RDONLY, NULL)) == -1)
    return sprintf(Buf, "Error opening file '%s': %s", FileName, 
		   strerror(errno));
  else {
    Len = _read (Desc, (void *) Buf, BufSize);
    _close(Desc);
    return Len;
  }
}

