//
//  utility.c
//
//  Author: Tai-Yi Huang (tyhuang)      June, 2000
//
//

#include "define.h"

time_t GetTimeInfo (
        time_t *timeptr
        )
{
        time_t tim;
        FT nt_time;

        GetSystemTimeAsFileTime( &(nt_time.ft_struct) );

        tim = (time_t)((nt_time.ft_scalar - EPOCH_BIAS) / 10000000i64);

        if (timeptr)
                *timeptr = tim;         /* store time if requested */

        return tim;
}

BOOLEAN DetermineIfClass1Or2(HANDLE Request) {

    PCHAR       HttpRequest = TwcQueryHttpRequest(Request);
    PCHAR       StrPtr;

    StrPtr = strstr(HttpRequest, "class");
    StrPtr += 5;

    if (*StrPtr == '1' || (*StrPtr == '2')) {

        return TRUE;

    } else {

        return FALSE;
    }
}

VOID
SpecParseCookieString(
    HANDLE          Request,
    PULONG          UserId,
    PULONG          LastAd) {

    PCHAR       StrPtr;
    PCHAR       HttpRequest = TwcQueryHttpRequest(Request);

    StrPtr = strstr(HttpRequest, "my_cookie=user_id=");

    StrPtr += 18;

    *UserId = atoi(StrPtr);

    StrPtr = strstr(StrPtr, "last_ad=");

    *LastAd = atoi(StrPtr+8);
}

VOID
SpecParsePostInput(
    HANDLE          Request,
    PCHAR           UrlRoot,
    PULONG          DirNum,
    PULONG          ClassNum,
    PULONG          FileNum,
    PULONG          ClientNum,
    PCHAR           *QueryString) {

    BOOLEAN     CF1, CF2, CF3, CF4, CF5;
    PCHAR       Ptr1, Ptr2;
    ULONG       NumCmps = 0;
    CHAR        Str[10];
    ULONG       QueryStringSize;
    PCHAR       HttpRequest = TwcQueryHttpRequest(Request);
    ULONG       HttpRequestSize = TwcQueryHttpRequestSize(Request);

    CF1 = CF2 = CF3 = CF4 = CF5 = TRUE;

    // Setup QueryString 

    //*QueryString = strstr(HttpRequest, "urlroot");
    *QueryString = strstr(HttpRequest, "\r\n\r\n") + 4;

    QueryStringSize = HttpRequestSize - (*QueryString - HttpRequest);

    *(*QueryString + QueryStringSize) = '\0';

    // Setup UrlRoot, DirNum, ClassNum, etc

    Ptr1 = *QueryString;
    Ptr2 = HttpRequest + HttpRequestSize;

    while (Ptr1 < Ptr2) {

        if (CF1 && (0 == memcmp(Ptr1, "urlroot=", 8))) { // find "urlroot="

            Ptr1 += 8;

            while ((Ptr1 < Ptr2) && (*Ptr1 != '&')) {

                *UrlRoot++ = *Ptr1++;
            }

            *UrlRoot = '\0';
            Ptr1++;
            NumCmps++;
            CF1 = FALSE;

        } else if (CF2 && (0 == memcmp(Ptr1, "dir=", 4))) {

            Ptr1 += 4;

            *DirNum = atoi(Ptr1);

            while ((Ptr1 < Ptr2) && (*Ptr1 != '&')) Ptr1++;

            Ptr1++;
            NumCmps++;
            CF2 = FALSE;

        } else if (CF3 && (0 == memcmp(Ptr1, "class=", 6))) {

            Ptr1 += 6;

            *ClassNum = atoi(Ptr1);

            while ((Ptr1 < Ptr2) && (*Ptr1 != '&')) Ptr1++;

            Ptr1++;
            NumCmps++;
            CF3 = FALSE;

        } else if (CF4 && (0 == memcmp(Ptr1, "num=", 4))) {

            Ptr1 += 4;

            *FileNum = atoi(Ptr1);

            while ((Ptr1 < Ptr2) && (*Ptr1 != '&')) Ptr1++;

            Ptr1++;
            NumCmps++;
            CF4 = FALSE;

        } else if (CF5 && (0 == memcmp(Ptr1, "client=", 7))) {

            Ptr1 += 7;

            memcpy(Str, Ptr1, 5);
            Str[5] = '\0';

            *ClientNum = atoi(Str);

            while ((Ptr1 < Ptr2) && (*Ptr1 != '&')) Ptr1++;

            Ptr1++;
            NumCmps++;
            CF5 = FALSE;

        } else {

            break;

        }
    }
}

SPEC_REQ_TYPE SpecDetermineReqType(HANDLE Request) {

    SPEC_REQ_TYPE       ReqType;
    PCHAR               StrPtr, FixupPtr;

    StrPtr = TwcQueryHttpRequest(Request); 

    if (*((PULONG)StrPtr) == 'TSOP') {

        ReqType = SPEC_POST_DYNAMIC;

    } else if (FixupPtr = strchr(StrPtr, '?')) {

        if (0 == memcmp(FixupPtr + 1, "command/Reset", 13)) {

            ReqType = SPEC_COMMAND_RESET;

        } else if (0 == memcmp(FixupPtr + 1, "command/Fetch", 13)) {

            ReqType = SPEC_COMMAND_FETCH;

        } else {

            if (*(FixupPtr + 1) == ' ') {

                ReqType = SPEC_UNKNOWN_REQUEST;

                return ReqType;
            }

            StrPtr[TwcQueryHttpRequestSize(Request) - 1] = '\0';

            if (strstr(FixupPtr, "Cookie")) {

                ReqType = SPEC_CAD_DYNAMIC;

            } else {

                ReqType = SPEC_SIMPLE_DYNAMIC;
            }
        }

    } else {

        ReqType = SPEC_UNKNOWN_REQUEST;
    }

    return ReqType;
}




