/*++

Copyright (c) 1999  Microsoft Corporation

Module Name:

    Lock.h

Abstract:


Author:

    Tai-Yi Huang (tyhuang)    June-2000

Revision History:

--*/

#ifndef _SWC_LOCK_H_
#define _SWC_LOCK_H_

typedef struct _SWC_CACHE_ENTRY SWC_CACHE_ENTRY, *PSWC_CACHE_ENTRY;

//
// Spinlock definitions
//

#define SL_SPINCOUNT 4000*2
#define SL_LOCKED ((ULONG) (-1))
#define SL_FREE 0

typedef volatile long RWSpinLock[2];

typedef struct _readers_writer_lock {

    RWSpinLock                  Lock;
    PSWC_CACHE_ENTRY            SwcCacheEntry;

#if TYSTAT
    ULONG                       RefCount;
    ULONG                       ChainLength;
#endif


} RWLOCK, *PRWLOCK;


// VC 6 setting

#define InterlockedCompareExchangePrivate(Destination, ExChange, Comperand) \
    (LONG)InterlockedCompareExchange((PVOID *)(Destination), (PVOID)(ExChange), (PVOID)(Comperand))

#define InterlockedCompareExchangePointerPrivate(Destination, ExChange, Comperand) \
    InterlockedCompareExchange(Destination, ExChange, Comperand)

// NT Build setting

/*
#define InterlockedCompareExchangePrivate(Destination, ExChange, Comperand) \
    InterlockedCompareExchange((Destination), (ExChange), (Comperand))

#define InterlockedCompareExchangePointerPrivate(Destination, ExChange, Comperand) \
    InterlockedCompareExchangePointer(Destination, ExChange, Comperand)
*/

__inline VOID InitializeRWLock(RWSpinLock sl)
{
    sl[0] = SL_FREE;
    sl[1] = 0;
}

__inline VOID AcquireRWLockShared(RWSpinLock sl)
{
    long currentState, writersWaiting;

    while (1) {

        currentState = sl[0];
        writersWaiting = sl[1];

        if ((currentState != SL_LOCKED) && (!writersWaiting)) {

            if (currentState == (long) InterlockedCompareExchangePrivate((long *) &(sl[0]), currentState + 1, currentState)) {
                return;

            } else {

                continue;
            }
        } 
    }
}

__inline VOID ReleaseRWLockShared(RWSpinLock sl)
{
    InterlockedDecrement((long *) &(sl[0]));
}

__inline VOID AcquireRWLockExclusive(RWSpinLock sl)
{
    InterlockedIncrement((long *) &(sl[1]));

    if (sl[0] == SL_FREE) {
        if (SL_FREE == InterlockedCompareExchangePrivate((long *) &(sl[0]), SL_LOCKED, SL_FREE)) {
            return;
        }
    }

    while (1) {
        if (sl[0] == SL_FREE) {
            if (SL_FREE == InterlockedCompareExchangePrivate((long *) &(sl[0]), SL_LOCKED, SL_FREE)) {
                return;
            }
            else {
                continue;
            }
        }
    }
}

__inline void ReleaseRWLockExclusive(RWSpinLock sl)
{
    sl[0] = SL_FREE;
    InterlockedDecrement((long *) &(sl[1]));
}



#endif
