/*++

     Copyright (c) 1998 Microsoft Corporation

     ISAPI Request Class

     Module Name: isapireq.cxx


--*/


//
// Alloc and Free for ISAPI requests
//
#include "isapireq.hxx"
#include "spinlock.hxx"
#include "define.h"
#include "frootad.hxx"
#include "logfile.hxx"
#include <malloc.h>
#include <stdlib.h>
#include <time.h>
#include <process.h>

extern RootAd *pRootAd;
extern struct _logInfo logInfo;
extern DWORD  MAXFILEBUFSIZE;
extern char logFileName[];
extern char userFileName[128];
extern char customFileName[128];
extern bool	logInfoReady;
extern SpinLock slResetLock;

// http header with keep alive
static char HttpHeaderKA[] =
		"HTTP/1.0 200 OK\r\n"  
		"Connection: Keep-Alive\r\n"
		"Content-Type: text/html\r\n"
        "Content-Length: ";
size_t  HttpHeaderKALen = 82;

//http header tail
static char HttpHeaderTail[] = "\r\n\r\n";

size_t  HttpHeaderTailLen = 4;

// http header with no keep alive
static char HttpHeaderNonKA[] =
		"HTTP/1.0 200 OK\r\n"  
		"Connection: Close\r\n"
		"Content-Type: text/html\r\n"
        "Content-Length: ";

size_t  HttpHeaderNonKALen = 77;

// http header cookie part

static char HttpHeaderCookie[] = "\r\nSet-Cookie: ";

size_t HttpHeaderCookieLen = 14;

// SwHeader

static char SwHeader1[] ="<html>\n"    
        "<head><title>SPECweb99 Dynamic GET & POST Test</title></head>\n"
        "<body>\n<p>SERVER_SOFTWARE = ";

size_t	SwHeader1Len =  97;

static char SwHeader2[] =	"\n<p>REMOTE_ADDR = ";

size_t	SwHeader2Len =  18;

static char SwHeader3[] =   "\n<p>SCRIPT_NAME = ";

size_t	SwHeader3Len = 18;

static char SwHeader4[] =   "\n<p>QUERY_STRING = ";

size_t	SwHeader4Len = 19;

static char SwHeader5[] =   "\n<pre>\n\0";

size_t	SwHeader5Len = 8;



// footer
static char SwFooter[] = "</pre>\n</body>\n</html>\n";

DWORD footerLen  = sizeof(SwFooter) - 1;  //22

// Post Log format

char postLogFormat[]=
		"%10d %10d %10d %5d %2d %2d %10d %-60.60s %10d %10d\n"
		;

// post output cookie string

static char postLogCookie[] = "my_cookie=%d";

static bool firstPost = TRUE;

// the string to be searched
 
static char scanString[]=
		"<!WEB99CAD><IMG SRC=\"/file_set/dirNNNNN/classX_Y\"><!/WEB99CAD>";

// the  length of the string to be searched
static int scanLen = 62;

static DWORD ScanBufSize = DATA_BUF_SIZE;  


// replaced string format

static char repStringFormat[] = "%05d/class%1d_%1d";

// the length of replaced string


// house keeping

static	char		getPostLog[] = "/PostLog";
static	int			getPlLen = 8;
static	char		cmdFetch[] = "command/Fetch";
static	char		cmdReset[] = "command/Reset";
static	int			cmdLen = 13;	 // strlen(cmdFetch) and strlen(cmdFetch) 

// for command reset

static	char maxLoad[] ="command/Reset&maxload=";
static  int	 maxLoadLen = 22;
static	char ptTime[] = "&pttime=";
static  int  ptTimeLen = 8;
static	char maxThread[] = "&maxthread=";
static  int  maxThreadLen = 11;
static	char expiredList[] = "&exp=";
static  int  expiredListLen = 5;
static	char urlRoot[] = "&urlroot=http://";
static  int  urlRootLen = 16;

// MASKS

static	unsigned int GENDER_MASK	= 0X30000000;
static	unsigned int AGE_GROUP_MASK = 0X0f000000;
static	unsigned int REGION_MASK	= 0X00f00000;
static	unsigned int INTEREST1_MASK = 0X000ffc00;
static	unsigned int INTEREST2_MASK = 0X000003ff;


//MASK for WT

static	unsigned int WT_MASK	= 0X0f;

//for custom Ad 
static char cookieAdNoUser[] = "found_cookie=Ad_id=-1&Ad_weight=00&Expired=1\0";
static int  cookieAdNoUserLen = 45;			

//
// These three belong together
//

PISAPIRequest	isapiStack = NULL;
SpinLock		isapiStackLock;
volatile		ULONG isapiStackDepth = 0;

//
// These three belong together for DATA_BUF stack
//

PDATA_BUF	dataStack = NULL;
SpinLock	dataStackLock;
volatile	ULONG dataStackDepth = 0;

// constant varibles

Constant_Vars constantVars;

//
// Data buffer stack fucntions
//

BOOL
InitializeDataStack(
	)
{
	ULONG	i;
	PDATA_BUF	pTemp = NULL;

	InitSpinLock(&dataStackLock);

	for (i=0;i<INIT_DATA_BUF_STACK_DEPTH;i++) {
		dataStack = new DATA_BUF;
		
		if (!dataStack) {      // checking if allocation succeeds
            OutputDebugString("Allocation of a DATA_BUF structure failed\n");
			dataStack = pTemp;
			return FALSE;
		}

        dataStack->buf = (char *) VirtualAlloc(
                                    NULL,
                                    DATA_BUF_SIZE,
                                    MEM_RESERVE | MEM_COMMIT,
                                    PAGE_READWRITE
                                    );

        if (dataStack->buf == NULL) {
            OutputDebugString("Allocation of a data buffer failed\n");
            free(dataStack);
            dataStack = pTemp;
            return FALSE;
        }
            
		dataStack->next = pTemp;
		pTemp = dataStack;
		dataStackDepth++;
	}

	return TRUE;
}


void 
ClearDataStack(
	)
{
    PDATA_BUF pTemp;

    // Pop and free

    AcquireSpinLock(&dataStackLock);
    while (dataStack)
    {
        pTemp = dataStack;
        dataStack = dataStack->next;

        VirtualFree(
            pTemp->buf,
            NULL,
            MEM_DECOMMIT | MEM_RELEASE
        );

        free(pTemp);
    }
	dataStackDepth = 0;
    ReleaseSpinLock(&dataStackLock);
}

void 
FreeDataBuf(
	PDATA_BUF pDataBuf
	)
{
    //
    // Acquire the spin lock for the list
    // and push the request structure on
    // the stack. Note that the two branches
    // release the lock separately.
    //
    
    AcquireSpinLock(&dataStackLock);

    pDataBuf->next = dataStack;
    dataStack = pDataBuf;
    dataStackDepth++;

    ReleaseSpinLock(&dataStackLock);
    return;
}

PDATA_BUF
AllocDataBuf(
	)
{
    PDATA_BUF pDataBuf;

    //
    // Acquire the spin lock for the list
    // and pop the top. Note that we release
    // the lock in each branch separately
    //
    
    AcquireSpinLock(&dataStackLock);
    if (pDataBuf = dataStack)
    {
        dataStack = dataStack->next;
        dataStackDepth--;
        ReleaseSpinLock(&dataStackLock);
        return (pDataBuf);
    }

    //
    // there's nothing on the stack. Release
    // the lock and allocate from the heap.
    // The caller should check for malloc
    // failures.
    //
    
    else
    {
        ReleaseSpinLock(&dataStackLock);

        pDataBuf = new DATA_BUF;
        if (!pDataBuf) {      // checking if allocation succeeds
            OutputDebugString("Allocation of a DATA_BUF structure failed\n");
            return FALSE;
        }

        pDataBuf->buf = (char *) VirtualAlloc(
                                    NULL,
                                    DATA_BUF_SIZE,
                                    MEM_RESERVE | MEM_COMMIT,
                                    PAGE_READWRITE
                                    );

        if (pDataBuf->buf == NULL) {
            OutputDebugString("Allocation of a data buffer failed\n");
            free(pDataBuf);
            return FALSE;
        }
        
        return(pDataBuf);
    }
}


//
// Free and Alloc are very optimistic, and start off
// assuming that there is a Request structure cached
//


BOOL
InitializeISAPIStack(
	)
{
	ULONG	i;
	PISAPIRequest	pTemp = NULL;

	InitSpinLock(&isapiStackLock);

	for (i=0;i<INIT_ISAPI_STACK_DEPTH;i++) {

        isapiStack = (PISAPIRequest) VirtualAlloc(
                                        NULL,
                                        sizeof(ISAPIRequest),
                                        MEM_RESERVE | MEM_COMMIT,
                                        PAGE_READWRITE
                                        );
		
		// checking if allocation succeeds
		if (!isapiStack) {
            OutputDebugString("allocation of an ISAPI structure failed\n");
			isapiStack = pTemp;
			return FALSE;
		}

		//Create  the file overlapped  manual Reset Event.
		isapiStack->hFileEvent =  CreateEvent(NULL,TRUE,FALSE,NULL); 

		if( NULL == isapiStack->hFileEvent)
		{
            OutputDebugString("creation of event failed\n");
            VirtualFree(
                isapiStack,
                NULL,
                MEM_DECOMMIT | MEM_RELEASE
            );

			isapiStack = pTemp;
			return FALSE;
		}

		isapiStack->next = pTemp;
		pTemp = isapiStack;
		isapiStackDepth++;
	}

	return TRUE;
}


void 
ClearISAPIStack(
	)
{
    PISAPIRequest pTemp;

    // Pop and free

    AcquireSpinLock(&isapiStackLock);
    while (isapiStack)
    {
        pTemp = isapiStack;
        isapiStack = isapiStack->next;
		CloseHandle(pTemp->hFileEvent);

        VirtualFree(
            pTemp,
            NULL,
            MEM_DECOMMIT | MEM_RELEASE
        );
    }
	isapiStackDepth = 0;
    ReleaseSpinLock(&isapiStackLock);
}


void 
FreeISAPIRequest(
	PISAPIRequest pReq
	)
{
    
	// free data buffer

	if (pReq->_pDataBuf != NULL)
	{
		//send the data buffer back to stack

		FreeDataBuf( pReq->_pDataBuf);
		pReq->_pDataBuf =NULL;
	}

	// free file buffer for CAD get

    if (pReq->_fileBuf != NULL)
	{
		pReq->_fileBuf = NULL;
	}

    // Close file handle
    if (pReq->_reqFileHandle != NULL) {
    
        CloseHandle(pReq->_reqFileHandle);
        pReq->_reqFileHandle = NULL;
    }
    
    //
    // Acquire the spin lock for the list
    // and push the request structure on
    // the stack. Note that the two branches
    // release the lock separately.
    //
    
    AcquireSpinLock(&isapiStackLock);

    pReq->next = isapiStack;
    isapiStack = pReq;
    isapiStackDepth++;

    ReleaseSpinLock(&isapiStackLock);
    return;
}



PISAPIRequest  
AllocISAPIRequest(
	)
{
    PISAPIRequest pReq;

    //
    // Acquire the spin lock for the list
    // and pop the top. Note that we release
    // the lock in each branch separately
    //
    
    AcquireSpinLock(&isapiStackLock);
    if (pReq = isapiStack)
    {
        isapiStack = isapiStack->next;
        isapiStackDepth--;
        ReleaseSpinLock(&isapiStackLock);
        return (pReq);
    }

    //
    // there's nothing on the stack. Release
    // the lock and allocate from the heap.
    // The caller should check for malloc
    // failures.
    //
    
    else
    {
        ReleaseSpinLock(&isapiStackLock);
		pReq = (PISAPIRequest) VirtualAlloc(
                                NULL,
                                sizeof(ISAPIRequest),
                                MEM_RESERVE | MEM_COMMIT,
                                PAGE_READWRITE
                                );

		// checking if allocation succeeds
		if (!pReq) {
            OutputDebugString("allocation of an ISAPI structure failed\n");
			return(NULL);
		}

		//Create  the file overlapped  manual Reset Event.
		pReq->hFileEvent =  CreateEvent(NULL,TRUE,FALSE,NULL); 

		if( NULL == pReq->hFileEvent)
		{
            VirtualFree(
                pReq,
                NULL,
                MEM_DECOMMIT | MEM_RELEASE
            );

			return NULL;
		}

        return(pReq);
    }
}


BOOL
InitRequest(
	PISAPIRequest pReq,
	EXTENSION_CONTROL_BLOCK *ecb
	)
{
    pReq->_ecb = ecb;
    pReq->_queryString = ecb->lpszQueryString;

    // Calls to GetServerVariable  
	DWORD size = sizeof(pReq->_remoteAddr);
	if (!(ecb->GetServerVariable)(
                ecb->ConnID,
                "REMOTE_ADDR",
                pReq->_remoteAddr,
                &size
                )
       ) {
        return FALSE;
    }
	//
	// determine if cookies is passed in
	//
	size = sizeof(pReq->_cookie);
	if (!(ecb->GetServerVariable)(
                ecb->ConnID,
                "HTTP_COOKIE",
                pReq->_cookie,
                &size
                )
       ) {
        pReq->_cookie[0]='\0';
    }


    // 
	//Determine the request type
	//
    if (strcmp(ecb->lpszMethod, "GET") == 0) {
		
		if( (0 == memcmp(pReq->_queryString, cmdFetch, cmdLen))
			|| (0 == memcmp(pReq->_queryString, getPostLog, getPlLen))){
			// command/Fetch
			pReq->_type = IRT_CMD_FETCH;
		}else 
		{
			if(( 0 == memcmp(pReq->_queryString, cmdReset, cmdLen))){
				//command/Reset
				pReq->_type = IRT_CMD_RESET;
			} else 
			{
				if( pReq->_cookie[0]=='\0'){
					//simple get
					pReq->_type = IRT_GET_DYNAMIC;
				}else{
					// CAD get
					pReq->_type = IRT_GET_DYNAMIC_AD;
				}
			}
		}

        // need more processing to determine if cookies is passed in

    }
    else if (strcmp(ecb->lpszMethod, "POST") == 0) {
		//post
        pReq->_type = IRT_POST;
    }
    else {
        pReq->_type = IRT_NONE;
    }


	

	// determine keep alive
	if(!(ecb->ServerSupportFunction)(
				ecb->ConnID,   
				HSE_REQ_IS_KEEP_CONN,  
				 &(pReq->_keepAlive),   NULL,  NULL 
				 )){
		return FALSE;
	}

	//initailize other Req data members

	pReq->_useFileBuf = FALSE;
	pReq->_fileBuf = NULL;
	pReq->_offSet =0;
	pReq->_matchIndex =0;
	pReq->_headerStringLength =0;
	pReq->_pDataBuf = NULL;

	return TRUE;
}


DWORD
ExecuteRequest(
	PISAPIRequest pReq
	)
{
    switch (pReq->_type) {

        case IRT_GET_DYNAMIC: {  
			// simple dynamic get
            return ExecuteGetFile(pReq);
        }

		case IRT_GET_DYNAMIC_AD: {  
			// dynamic get with ROOT AD
			return ExecuteGetFileAD(pReq);
		}
        case IRT_POST: { 
			// post request
            return ExecutePostLog(pReq);
			
        }
		case IRT_CMD_FETCH: {
			// Command/Fetch
			return ExcuteCmdFetch(pReq);
			
		}
		case IRT_CMD_RESET: {
			//Command/Reset
			return ExcuteCmdReset(pReq);
			
		}

        default:
        case IRT_NONE: {
            return sendTextOutput(pReq, "\r\n");
        }
    }

}


DWORD
ExecuteGetFile(
	PISAPIRequest	pReq
	)
{
    char    errStr[1024];

    pReq->_reqFileHandle = CallCreateFile(pReq, pReq->_queryString);

    if (pReq->_reqFileHandle == NULL) {
        return sendTextOutput(pReq, "Failed to open the requested file!\n");
    }

    // Try TransmitFile
    if (!startTransmitFile(pReq)) {

        wsprintf(errStr,"Failed to Transmit File (%ld) for %s\n", 
                        GetLastError(), pReq->_queryString);
        return sendTextOutput(pReq, errStr);
    }
    else
		return HSE_STATUS_PENDING;
}

DWORD sendTextOutput(
	PISAPIRequest	pReq,
	char *text
	)
{    
    DWORD textLen = strlen(text);

    OutputDebugString(text);

    if (!sendOutputHeader(pReq, textLen)) {
        return HSE_STATUS_ERROR;
    }

    if (!(*pReq->_ecb->WriteClient)(
			pReq->_ecb->ConnID, 
			text, 
			&textLen, 
			0
		)) {
        return HSE_STATUS_ERROR;
    }

    if (!sendOutputFooter(pReq)) {
        return HSE_STATUS_ERROR;
    }

    if(pReq->_keepAlive)
    {
        return( HSE_STATUS_SUCCESS_AND_KEEP_CONN);
    }
    else
    {
         return(HSE_STATUS_SUCCESS);
    }
}



/*---------------------------------------------------------------------*
sendOutputHeader
*/

BOOL 
sendOutputHeader(
	PISAPIRequest	pReq,
	DWORD innerContentLength
	)
{
	composeHeaderString( &pReq, innerContentLength);

	if (!(*pReq->_ecb->WriteClient)(
			pReq->_ecb->ConnID, 
			pReq->_headerStringBuffer, 
			&(pReq->_headerStringLength), 
			0
		)) {
        return HSE_STATUS_ERROR;
    }

    return TRUE;
}


/*---------------------------------------------------------------------*
IsapiRequest::sendOutputFooter
*/

BOOL 
sendOutputFooter(
	PISAPIRequest	pReq
	)
{

    if (!(*pReq->_ecb->WriteClient)(pReq->_ecb->ConnID, SwFooter, &footerLen, 0)) {
        return FALSE;
    }

    return TRUE;
}

/*---------------------------------------------------------------------*
CallCreateFile
*/

HANDLE  
CallCreateFile(
	PISAPIRequest	pReq,
	CHAR *virtPath
	)
{
    HANDLE h;

    // get physical file name
    DWORD maxsize = strlen(virtPath) + MAX_PATH;
    CHAR *filename = (CHAR *)_alloca(maxsize);
	if( filename == NULL)
			return NULL;

    strcpy(filename, virtPath);

    // call SSF to map virtual to physical file name
    if (!(pReq->_ecb->ServerSupportFunction)(
            pReq->_ecb->ConnID,
            HSE_REQ_MAP_URL_TO_PATH,
            filename,
            &maxsize,
            NULL
            )
       ) {
        return NULL;
    }

    h = CreateFile(
            filename,
            GENERIC_READ,
            FILE_SHARE_READ,
            NULL,
            OPEN_EXISTING,
            FILE_ATTRIBUTE_NORMAL | FILE_FLAG_BACKUP_SEMANTICS | FILE_FLAG_OVERLAPPED,
            NULL
            );

    if (h != NULL && h != INVALID_HANDLE_VALUE)
        pReq->_reqFileSize = GetFileSize(h, NULL);

    return h;
}



BOOL 
startTransmitFile(
	PISAPIRequest	pReq
	)
{

    // Get handle
	HANDLE h = pReq->_reqFileHandle;
    if (h == NULL || h == INVALID_HANDLE_VALUE) {
        return FALSE;
    }

	composeHeaderString(&pReq);
    
    // Fill in the TF structure

	LPHSE_TF_INFO	pTfinfo = &pReq->_transmitFileInfo;
    memset(pTfinfo, 0, sizeof(pReq->_transmitFileInfo));
	
	pTfinfo->pfnHseIO  = TransmitFileCompletionCallback;

    pTfinfo->pContext      = pReq;
    pTfinfo->hFile         = h;
    pTfinfo->pszStatusCode = NULL;

	pTfinfo->BytesToWrite	= pReq->_reqFileSize;
	pTfinfo->Offset			= 0;
	pTfinfo->pHead			= pReq->_headerStringBuffer;
	pTfinfo->HeadLength		= pReq->_headerStringLength;

    pTfinfo->pTail         = SwFooter;
    pTfinfo->TailLength    = footerLen;

	if( pReq->_keepAlive != FALSE)
		pTfinfo->dwFlags       = HSE_IO_ASYNC;
	else
		pTfinfo->dwFlags = HSE_IO_ASYNC | HSE_IO_DISCONNECT_AFTER_SEND;


    // Call the SSF
    return (*pReq->_ecb->ServerSupportFunction)(
                pReq->_ecb->ConnID,
                HSE_REQ_TRANSMIT_FILE,
                pTfinfo,
                NULL,
                NULL
                );
}

//***********************************

/*---------------------------------------------------------------------*
TransmitFileCompletionCallback
*/

void WINAPI 
TransmitFileCompletionCallback(
	EXTENSION_CONTROL_BLOCK *ecb,
	VOID *context,
    DWORD cbIO,
    DWORD error
    )
{
	PISAPIRequest pReq = reinterpret_cast<PISAPIRequest>(context);

    
	DWORD status ; // = (error == 0) ? HSE_STATUS_SUCCESS_AND_KEEP_CONN
                               // : HSE_STATUS_ERROR;

	if( 0 == error )
	{
		if(pReq->_keepAlive)
		{
			status =  HSE_STATUS_SUCCESS_AND_KEEP_CONN;
		}
        else
		{
             status =  HSE_STATUS_SUCCESS;
		}
	}
    else
	{
			status =   HSE_STATUS_ERROR;
	}

	(*ecb->ServerSupportFunction)(
                ecb->ConnID,
                HSE_REQ_DONE_WITH_SESSION,
                &status,
                NULL,
                NULL
                );

	FreeISAPIRequest(pReq);
}


DWORD
ExecuteGetFileAD(
	PISAPIRequest	pReq
	)
{
    pReq->_reqFileHandle = CallCreateFile(pReq, pReq->_queryString);

    if (pReq->_reqFileHandle == NULL) {
        return sendTextOutput(pReq, "Failed to open the requested file!\n");
    }

	// if FileName contains string "class1" or "class2" ? avoid using strstr()
	char *p1 = "class";
	
	bool containCls12 = strMatchOr(pReq->_queryString, p1, '1', '2');

	// parse cookie string
	int userIndex =0;
	int lastAdId =0;

	if(!parseCookieString(pReq, &userIndex,&lastAdId)) 
		return sendTextOutput(pReq, "Failed to parse cookie string at CAD!\n");
		
	// If file name contains class1 or class2, try to find the matching string 
    // and fill pReq->_fileBuf, pReq->offSet and pReq->_useFileBuf. 
	
	if( containCls12)   
	{
		pReq->_pDataBuf = AllocDataBuf();
		if( pReq->_pDataBuf == NULL) {
			return sendTextOutput(pReq, "Failed to alloc a data buffer at CAD!\n");
        }

		pReq->_fileBuf = pReq->_pDataBuf->buf; 
  	}

	//fine matching record in user personality
	userIndex = userIndex -10000; //10001;

	if( ( (userIndex > pRootAd->userBufSize) || (userIndex < 0)))
	{   // no match record is found
    
		// copy return cookie string
		memcpy(pReq->_cookie,cookieAdNoUser, cookieAdNoUserLen);
			
		//call composeHeaderString() to compose the header string
		composeHeaderString(&pReq);

		if( containCls12)
		{ 
			// File name contains "class1" or "Class2"
			memcpy(pReq->_fileBuf,  pReq->_headerStringBuffer, pReq->_headerStringLength);

			return	transmitAndWriteFile(pReq, lastAdId);

		}
        else   // filename not contain class1 or class 2 just call transmit file
		{
			pReq->_useFileBuf = FALSE;
			pReq->_offSet = 0;

			if (!startTransmitFileAd(pReq)) {
				return sendTextOutput(pReq, "Failed to Transmit File at CAD!\n");
			}
            else
            {
				return HSE_STATUS_PENDING;
			}
		}
	} // end of personal record is not found


	// now, A matching personal record is found

	unsigned int UserDemographics = pRootAd->pUserPfBuf[userIndex];
	
	unsigned int CombinedDemographics =0;

	//get current time
	unsigned int Current_time;
				time((time_t*)&(Current_time));


	int Ad_index = lastAdId + 1; 
	unsigned int Ad_weight = 0;

	if( Ad_index > 359 )
		Ad_index = 0;

	while( Ad_index != lastAdId )
	{
		
		//calculate the weight value

		CombinedDemographics = ( (pRootAd->pCustomAdBuf[Ad_index]->AdDemographics)&UserDemographics);
		Ad_weight = 0;

		if(CombinedDemographics&GENDER_MASK )
			Ad_weight = Ad_weight + (((pRootAd->pCustomAdBuf[Ad_index]->Weightings)>>16)&WT_MASK );
		
		if(CombinedDemographics&AGE_GROUP_MASK )
			Ad_weight = Ad_weight + (((pRootAd->pCustomAdBuf[Ad_index]->Weightings)>>12)&WT_MASK );

		if(CombinedDemographics&REGION_MASK )
			Ad_weight = Ad_weight + (((pRootAd->pCustomAdBuf[Ad_index]->Weightings)>>8)&WT_MASK );

		if(CombinedDemographics&INTEREST1_MASK )
			Ad_weight = Ad_weight + (((pRootAd->pCustomAdBuf[Ad_index]->Weightings)>>4)&WT_MASK );

		if(CombinedDemographics&INTEREST2_MASK )
			Ad_weight = Ad_weight + ((pRootAd->pCustomAdBuf[Ad_index]->Weightings)&WT_MASK );


		if(Ad_weight >= (pRootAd->pCustomAdBuf[Ad_index]->MinMvalue) )
		{
			if( Current_time > ( pRootAd->pCustomAdBuf[Ad_index]->ExTime))
			{
				//Expired = TRUE;
				wsprintf(pReq->_cookie,"found_cookie=Ad_id=%d&Ad_weight=%d&Expired=1\0",
                                            Ad_index, Ad_weight);
			}
			else
			{
				//Expired = FALSE;
				wsprintf(pReq->_cookie,"found_cookie=Ad_id=%d&Ad_weight=%d&Expired=0\0",
                                            Ad_index, Ad_weight);
		
			}

			//call composeHeaderString() to compose the header string
			composeHeaderString(&pReq);
				
			if( containCls12)
			{ 
				// FileName contains "class1" or "Class2"
				memcpy(pReq->_fileBuf,  pReq->_headerStringBuffer, 
                                        pReq->_headerStringLength);

				return	transmitAndWriteFile(pReq, Ad_index);
			}
            else   // Filename does not contain class1 or class 2, call transmit file
			{
				pReq->_useFileBuf = FALSE;
				pReq->_offSet = 0;

				if (!startTransmitFileAd(pReq)) {
					return sendTextOutput(pReq, "Failed to Transmit File at CAD2!\n");
				}
                else
                {
					return HSE_STATUS_PENDING;
				}

			}
					
		} // end of Ad_Weight if
	
		Ad_index++;

		if( Ad_index > 359 )
			Ad_index = 0;
		
	}  // done with  Custom.Ads while

	//
	// outside Custom.Ads file
	//
	memcpy(pReq->_cookie,cookieAdNoUser, cookieAdNoUserLen);
	
	//call composeHeaderString() to compose the header string
	composeHeaderString(&pReq);


	if( containCls12)
	{ 
		// File Name contains "class1" or "Class2"
		memcpy(pReq->_fileBuf,  pReq->_headerStringBuffer, pReq->_headerStringLength);

		return	transmitAndWriteFile(pReq,lastAdId);

	}
    else   // filename not contain class1 or class 2 just call transmit file
	{
		pReq->_useFileBuf = FALSE;
		pReq->_offSet = 0;

		if (!startTransmitFileAd(pReq)) {
			return sendTextOutput(pReq, "Failed to Transmit File at CAD3!\n");
		}
        else
        {
			return HSE_STATUS_PENDING;
		}
	}
}

//
// This function parses input cookie string
// and put the user_id into pUserID and the last_id into pLastAd 
//

bool parseCookieString(PISAPIRequest pReq, int* pUserID, int* pLastAd) 
{

	char * pCookieSeg = "my_cookie=user_id=";
	char * pCookie = pReq->_cookie;

	int comLen = strlen(pCookieSeg);
	 
	if( !( 0 == memcmp(pCookie, pCookieSeg, comLen) ))
		return FALSE;

	pCookie += comLen;

	*pUserID = atoi(pCookie);

	// pCookie pointer to begin of &last_ad=
	while( (*pCookie <= '9') && (*pCookie>= '0'))
		pCookie++;

	pCookieSeg = "last_ad=";
	comLen = strlen(pCookieSeg);

	while ( ! ( ( 0== memcmp(pCookie, pCookieSeg, comLen)) || (*pCookie == '\0')))
		pCookie++;

	if( *pCookie == '\0')
		return FALSE;
	else
		pCookie +=comLen;

	//pCookie += comLen;

	*pLastAd = atoi(pCookie);

	return true;

}

//
//This function replace the string found in the file
//Example:  "NNNNN/classX_Y" => "00003/class2_5"
//

void
CustomAdScan(
	PISAPIRequest pReq,
	int Ad_Id
	)
{
		char tmpBuf[repStringLen] ;  /// "%5d/class%1d_%1d";
		int adid36 = Ad_Id/36;
		int adid9 = Ad_Id/9;
		int index = pReq->_matchIndex;

		wsprintf( tmpBuf, repStringFormat, adid36, (adid9 - (adid36<<2)), (Ad_Id -(adid9<<3) -adid9));
		memcpy(&(pReq->_fileBuf[index+34]),tmpBuf, repStringLen);	
}

//
//this function can be used to detect whether the file name contains string "class1" or "class2"
//For example: "/file_set/dir00001/class1_8" contains string "class1"
//
bool strMatchOr(char *p2, char *p1, char x, char y)
{
	int strCmpLen = strlen(p1);

	while( *p2)
	{
		if (0 == memcmp( p2, p1, strCmpLen))
		{
			p2 += strCmpLen;
			if( *p2 == x || *p2 == y)
				{
					return TRUE;
					
				}
			else	
				p2--;
		}

			p2++;
	}

	return FALSE;
}

//
//This function executes post request.
//

DWORD
ExecutePostLog(
	PISAPIRequest	pReq
	)
{
	int		timesStamp;  
	char    urlRoot[61];
	int		dirNum=0;
	int		classNum=0;
	int		fileNum=0;
	int     clientNum=0;
	int		MyCookie;
	int		lastAdId;
	postLogRd  logRd;

	// parse post input

	if (pReq->_ecb->lpbData != NULL )
	{
		if(!parsePostInput((char*)(pReq->_ecb->lpbData),
                pReq->_ecb->cbTotalBytes,
			    (char*)urlRoot, 
			    (int*)&dirNum, 
			    (int*)&classNum, 
			    (int*)&fileNum, 
			    (int*)&clientNum) )
		{
			return sendTextOutput(pReq, "PostLog operation failed: parse post input\n");
		}

	} else {

        return sendTextOutput(pReq, "PostLog operation failed: no post input\n");
    }
     

	// parse cookie string

	if(!parseCookieString(pReq, &MyCookie,&lastAdId))
	{
		return sendTextOutput(pReq, "PostLog operation failed: parse cookie string\n");
	}

	// concatenating the file name
	
	char nameFormat[] = "%sdir%05d/class%d_%d\0";

	// get current timestamp

	time((time_t*)&(timesStamp));

	// get process ID
	// processId = (int)GetCurrentThreadId(); //_getpid();

	// filling post record 
	logRd.timeStamp = timesStamp;

	//get thread ID

	logRd.pID = (int)GetCurrentThreadId();

	// make sure that the thread ID is positive

	logRd.pID = logRd.pID&0X7fffffff;

	logRd.dirNum =dirNum;
	logRd.classNum = classNum;
	logRd.fileNum = fileNum;
	logRd.clientNum = clientNum;

	wsprintf(logRd.fileName,nameFormat, urlRoot,dirNum,classNum,fileNum);
	logRd.myCookie = MyCookie;
	
    //write the record to log file

	if ((WriteLogShared( logRd ) != STATUS_SUCCESS) &&
		((WriteLogExclusive( logRd )) != STATUS_SUCCESS)) {

		return sendTextOutput(pReq, "Write PostLog operation failed\n");
	}

	// access file 'rootDir/filename'
	// Try to find in cache

    pReq->_reqFileHandle = CallCreateFile(pReq, logRd.fileName);

    if (pReq->_reqFileHandle == NULL) {
        return sendTextOutput(pReq, "Failed to open the requested file!\n");
    }

	// compose cookie string for sending to the client

	wsprintf(pReq->_cookie, postLogCookie, MyCookie );

	if (!startTransmitFile(pReq)) {
        return sendTextOutput(pReq, "Failed to Transmit File at Post!\n");
    }
    else
	{
		return HSE_STATUS_PENDING;
	}
		
}

//
// This function parses post request input
//
// Change this function to parse the request in various order.
//

bool parsePostInput(char * pPostInput,
        long numBytes,
		char* pUrlroot, 
		int* pDirNum, 
		int* pClassNum, 
		int* pFileNum, 
		int* pClientNum) 
{

	char	* pUrlrootSeg = "urlroot=";
	int		urlRootLen = strlen(pUrlrootSeg);
	char	* pDirSeg = "dir=";
	int		dirLen = strlen(pDirSeg);
	char	* pClassSeg = "class=";
	int		classLen = strlen(pClassSeg);
	char	* pFileSeg = "num=";
	int		fileLen = strlen(pFileSeg);
	char	* pClientSeg = "client=";
	int		clientLen = strlen(pClientSeg);

	bool    cmpF1 = TRUE, cmpF2 = TRUE, cmpF3 = TRUE, cmpF4 =TRUE, cmpF5=TRUE;

	char *p, *p2 ;

	int cmpNum =0;

	p = pPostInput;

	p2= pPostInput + numBytes;

	// get url root

	while( p < p2 )
	{
		

		if( cmpF1 && ( 0 == memcmp(p, pUrlrootSeg, urlRootLen) )) // get urlroot
		{
			p += urlRootLen;
		
            while( (*p != '&') && (p < p2) )
			{
				*pUrlroot++ = *p++;
			}

			*pUrlroot = '\0';
			p++;
			cmpNum++;
			cmpF1 = FALSE;

		}else if( cmpF2 &&( 0 == memcmp(p, pDirSeg, dirLen) ))   // get dir number
		{
			p += dirLen;

			*pDirNum = atoi(p);
			while( (*p != '&') && (p < p2) )
			{
				p++;
			}
			p++;
			cmpNum++;
			cmpF2 =FALSE;

		}else if( cmpF3 &&( 0 == memcmp(p, pClassSeg, classLen))) // get calss numer
		{
			p += classLen;

			*pClassNum  = atoi(p);

			while( (*p != '&') && (p < p2) )
			{
				p++;
			}
			p++;
			cmpNum++;
			cmpF3 =FALSE;

		}else if( cmpF4 &&( 0 == memcmp(p, pFileSeg, fileLen))) // get file numer
		{
			p += fileLen;

			*pFileNum  = atoi(p);

			while( (*p != '&') && (p < p2) )
			{
				p++;
			}
			p++;
			cmpNum++;
			cmpF4 =FALSE;

		}else if( cmpF5 &&( 0 == memcmp(p, pClientSeg, clientLen)) )// get client numer
		{
			p += clientLen;

			*pClientNum  = atoi(p);

			while( (*p != '&') && (p < p2) )
			{
				p++;
			}
			p++;
			cmpNum++;
			cmpF5 =FALSE;

		}else
		{
			break;
		}
		
	}

	if( cmpNum != 5)
		return FALSE;  // not get all required parameters
	else
		return true;

}

//
//This function excutes "command/Fetch" request.
//

DWORD ExcuteCmdFetch(PISAPIRequest pReq)
{		
	return transmitLogFile(pReq);
}

//
//This function excutes "command/Reset" request.
//

DWORD ExcuteCmdReset(PISAPIRequest pReq)
{

	DWORD maxsize = 128;
	char *pCmdInput= pReq->_queryString;
	char cmdLine[128];
	char cmdName[64];
	char physicDir[128];

	char *pMaxLoad, *pPtTime, *pMaxThread, *pExList, *pUrlRoot, *pUrlRoot2;

	// set pMaxLoad pointer to point the begining of max load data

	pMaxLoad = pCmdInput + maxLoadLen;
	
	pPtTime = pMaxLoad;
			

	// move pPtTime pointer to point the begining of point time data

	while( (*pPtTime != '&')&& (*pPtTime != '\0'))
	{
		pPtTime++;
	}

	if( *pPtTime == '\0')
		return sendTextOutput(pReq, "Failed to Parse cammand/Reset !");

	pMaxThread = pPtTime + ptTimeLen;

	// move pMaxThread pointer to point the begining max thread data

	while( (*pMaxThread != '&')&& (*pMaxThread != '\0'))
	{
		pMaxThread++;
	}

	if( *pMaxThread == '\0')
		return sendTextOutput(pReq, "Failed to Parse cammand/Reset !");

	pExList = pMaxThread + maxThreadLen;

	// move pExList pointer to point the begining expired list data


	while( (*pExList != '&')&& (*pExList!= '\0'))
	{
		pExList++;
	}

	if( *pExList == '\0')
		return sendTextOutput(pReq, "Failed to Parse cammand/Reset !");

	int exListLen = strlen(expiredList);

	pUrlRoot = pExList + exListLen;

	// move pUrlRoot pointer to point the begining Url root

	while( (*pUrlRoot != '&')&& (*pUrlRoot!= '\0'))
	{
		pUrlRoot++;
	}

	if( *pUrlRoot == '\0')
		return sendTextOutput(pReq, "Failed to Parse cammand/Reset !");

	pUrlRoot2 = pUrlRoot;  // for later using

	// read the virtual path to the physicDir[]
	int i =0;

	pUrlRoot = pUrlRoot + urlRootLen;

	while(*pUrlRoot!= '/')
	{
		pUrlRoot++;
	}

	while( *pUrlRoot!= '\0')
	{
		physicDir[i++] = *pUrlRoot++;
	}
		physicDir[i] = *pUrlRoot;

	// try to get physical dir here

	 // call SSF to map virtual to physical file name
    if (!(pReq->_ecb->ServerSupportFunction)(
            pReq->_ecb->ConnID,
            HSE_REQ_MAP_URL_TO_PATH,
            physicDir,
            &maxsize,
            NULL
            )
       ) {
        return NULL;
    }

	// generate user personality file command
	char *p = cmdLine;

	memcpy(p,"Upfgen99 -n ",12);
	 
	// copy MaxLoad
	p += 12;
	int cpyLen = (size_t)(pPtTime- pMaxLoad);
	memcpy(p,pMaxLoad, cpyLen);
	 
	p += cpyLen;

	memcpy(p, " -t ", 4);
	
	p +=4;

	// copy MaxThreads
	
	cpyLen = pExList - pMaxThread - maxThreadLen;

	memcpy(p, (pMaxThread+maxThreadLen),cpyLen);

	p += cpyLen;

	memcpy(p, " -C ",4);

	p +=4;
// gnd added 12-8-99 to work around PWS limitations
// memcpy(physicDir, "d:\\spec99\\\0",11);
	cpyLen = strlen(physicDir) +1;

	memcpy(p, physicDir, cpyLen);

	// execute upfgen99
	cpyLen--;

	memcpy(cmdName, physicDir, cpyLen);
	 
	memcpy(cmdName+cpyLen, "\\Upfgen99.exe\0",14);

	STARTUPINFO si1, si2;
	
	PROCESS_INFORMATION piP1, piP2;

	ZeroMemory(&si1, sizeof(si1));
	si1.cb = sizeof(si1);

	//Create a Process to Generate Cuttom Ad File.
	
	if(! CreateProcess( cmdName, cmdLine,NULL, NULL,FALSE, 
		CREATE_NO_WINDOW,NULL,NULL,&si1,&piP1))
	{
		return sendTextOutput(pReq, "Failed to Generate user personality File!\n");
	}
    else
	{
		CloseHandle(piP1.hThread);

		WaitForSingleObject(piP1.hProcess, INFINITE);

		CloseHandle(piP1.hProcess);
	}

	// generate custom ad file command
	p = cmdLine;

	memcpy(p,"Cadgen99 -C ",12);
	 
	// copy dirRoot
	p += 12;
	

	memcpy(p, constantVars.dirRoot, cpyLen);
	
	// copy Point time

	p += cpyLen;

	memcpy(p, " -e ", 4);
	
	p +=4;

	cpyLen = (size_t)(pMaxThread- pPtTime -ptTimeLen);

	memcpy(p,(pPtTime + ptTimeLen), cpyLen);

	// copy MaxThreads
	 
	p += cpyLen;

	memcpy(p, " -t ", 4);
	
	p +=4;
	
	cpyLen = pExList - pMaxThread - maxThreadLen;

	memcpy(p, (pMaxThread+maxThreadLen),cpyLen);

	p += cpyLen;

	memcpy(p, " ",1); // 

	p++;

	// copy expiredlist

	cpyLen = pUrlRoot2 - pExList - exListLen;

    char *p2 = pExList + exListLen;
    char *p3 = p2 + cpyLen;
    char *p4;


    while(  p2 < p3)
    {
        i =0;
        p4 = p2;
        while( (*p2++ != ',')&&( p2 <= p3))
        {
            i++;
        }

        memcpy(p, p4, i);

        p += i;

        if( p2 <p3)
        {
            memcpy(p, " ",1); //

            p++;
        }else
        {
            break;
        }
        // p2++;
    }

	//memcpy(p, ( pExList + exListLen), cpyLen);

	//p += cpyLen;

	memcpy(p, "\0",1);  // end of command cadgen99

	// execute cadgen99

	cpyLen = strlen(physicDir);

	memcpy(cmdName+cpyLen, "\\Cadgen99.exe\0",14);

	ZeroMemory(&si2, sizeof(si2));
	si2.cb = sizeof(si2);


	//Create a Process to Generate Cuttom Ad File.
	
	if( ! CreateProcess( cmdName, cmdLine,NULL, NULL,FALSE, 
		CREATE_NO_WINDOW,NULL,NULL,&si2,&piP2))
	{
		return sendTextOutput(pReq, "Failed to Generate Cuttom Ad File!\n");
	}
    else
	{
		CloseHandle(piP2.hThread);

		WaitForSingleObject(piP2.hProcess, INFINITE);

		CloseHandle(piP2.hProcess);
	}

	// set state to UNINIT the next request will initialize PostLog and RootAd
	
	// constantVars.init =  UNINIT;

	InterlockedExchange((LONG *)&constantVars.init,UNINIT);

	return sendTextOutput(pReq, "\n");
}

//
//This function transmits log file to the client
//

DWORD transmitLogFile(PISAPIRequest pReq)
{
	
	// flush the log buffer before transmition the log file.

    logInfoReady = FALSE;

    if( STATUS_ERROR ==  FlushCachedDataExclusive())
		return sendTextOutput(pReq, "Failed to flush post log data !!!!\n");
	
    HANDLE h = logInfo.currentBuffer->logFile;
    	            
    if (h == INVALID_HANDLE_VALUE) {
       return sendTextOutput(pReq, "Failed to open PostLog File!!!!\n");
    }
 
    DWORD fileSize = GetFileSize(h, NULL); // (DWORD)logInfo.currentBuffer->logFileOffset; 

	//call composeHeaderString() to compose the header string
	composeHeaderString(&pReq, fileSize);
	

	pReq->_pDataBuf = AllocDataBuf();

	if( pReq->_pDataBuf == NULL)
		return sendTextOutput(pReq, "Failed to alloc a data buffer at Fetch!\n");

	pReq->_fileBuf = pReq->_pDataBuf->buf; 


	// Start the loop to read log file to the buffer and then send it to the client

	// variables for read file and search string 
	
	DWORD	ScanFileSize = 0;
	DWORD	realReadIn =0;
	DWORD	scanBufSize =0;
	DWORD   writeBufLen =0;
	BOOL	bResult = FALSE;
	char	*pBuf = NULL;
	
	
	OVERLAPPED overLap;

	overLap.Internal = 0;
	overLap.InternalHigh = 0; 
	overLap.Offset = 0; 
	overLap.OffsetHigh =0; 
	overLap.hEvent = NULL; 
	
	// copy header to the buffer

	memcpy(pReq->_fileBuf, pReq->_headerStringBuffer, pReq->_headerStringLength);

	pBuf = pReq->_fileBuf + pReq->_headerStringLength; 

	scanBufSize = (DATA_BUF_SIZE - pReq->_headerStringLength);
					
	// read the file to the buffer
			
	while(  overLap.Offset < fileSize )
	{
		if( scanBufSize <= (fileSize - overLap.Offset ) )
		{
			ScanFileSize = scanBufSize;
		}
        else
		{
			ScanFileSize = fileSize - overLap.Offset;
		}
		
		//synchronous reading

		bResult = ReadFile(h, pBuf, ScanFileSize, &realReadIn,  &overLap) ;

		// if there was a problem, or sync read.. 
		if (!bResult) 
		{ 
			return sendTextOutput(pReq, "Failed to Read Log File to client!\n");
		
		} // end of read file

		if( realReadIn == 0)
		{
			overLap.Offset =  fileSize; 
		}
        else
		{
			overLap.Offset  =  overLap.Offset + ScanFileSize; 
		}
		
		//  write the content in buffer to the client

		if(  overLap.Offset  >= fileSize ) // end of the file
		{
			writeBufLen = ScanFileSize + (pBuf- pReq->_fileBuf) + footerLen ;

			if( writeBufLen <= DATA_BUF_SIZE ) 
				// whole file already in the buffer, add footer and write to client
			{
				memcpy( pBuf+ScanFileSize, SwFooter, footerLen);

				if (!(*pReq->_ecb->WriteClient)(pReq->_ecb->ConnID, pReq->_fileBuf, 
                                                &writeBufLen, 0)) {
					return sendTextOutput(pReq, "Failed to send Log File to client!\n");
				}
                else
				{
					if(pReq->_keepAlive)
					{
						return( HSE_STATUS_SUCCESS_AND_KEEP_CONN);
					}
                    else
					{
						 return(HSE_STATUS_SUCCESS);
					}
				}
			}
            else
			{	
				writeBufLen = ScanFileSize + (pBuf- pReq->_fileBuf);

				if(!(*pReq->_ecb->WriteClient)(pReq->_ecb->ConnID, pReq->_fileBuf, 
                                                &writeBufLen, HSE_IO_SYNC)) {
					return sendTextOutput(pReq, "Failed to send Log File to client!\n");
				}
				
				if (!(*pReq->_ecb->WriteClient)(pReq->_ecb->ConnID, SwFooter, 
                                                &footerLen, HSE_IO_SYNC)) {
					return sendTextOutput(pReq, "Failed to send Footer fot log file to client!\n");
				}
                else
				{	
					if(pReq->_keepAlive)
					{
						return( HSE_STATUS_SUCCESS_AND_KEEP_CONN);
					}
                    else
					{
						 return(HSE_STATUS_SUCCESS);
					}
				}

			} // end of whole file in the buffer

		}
        else   // not at end of file
		{
				writeBufLen = DATA_BUF_SIZE;

				if(!(*pReq->_ecb->WriteClient)(pReq->_ecb->ConnID, pReq->_fileBuf, 
                                                &writeBufLen, HSE_IO_SYNC )) {
					return sendTextOutput(pReq, "Failed to send log File to client!\n");
				}

		}

		if( bResult && ( realReadIn == 0)) //end of file
			break;

		pBuf = pReq->_fileBuf;
		scanBufSize = DATA_BUF_SIZE;

	} // end of read while

	// 
	// may never reach here

	if(pReq->_keepAlive)
	{
		return( HSE_STATUS_SUCCESS_AND_KEEP_CONN);
	}
    else
	{
		 return(HSE_STATUS_SUCCESS);
	}
}

//
// transmit file for custom AD root
//

BOOL 
startTransmitFileAd(
	PISAPIRequest	pReq
	)
{
	DWORD footerLen  = sizeof(SwFooter) - 1;
   
    // Fill in the TF structure

	LPHSE_TF_INFO	pTfinfo = &pReq->_transmitFileInfo;
    memset(pTfinfo, 0, sizeof(pReq->_transmitFileInfo));

	pTfinfo->pfnHseIO  = TransmitFileCompletionCallback;

    pTfinfo->pContext      = pReq;
    pTfinfo->hFile         = pReq->_reqFileHandle;
    pTfinfo->pszStatusCode = NULL;

	if( pReq->_useFileBuf ){

		pTfinfo->BytesToWrite  = pReq->_reqFileSize - pReq->_offSet;
		pTfinfo->Offset        = pReq->_offSet;
		pTfinfo->pHead         = pReq->_fileBuf;
		
	} 
    else
	{  
		pTfinfo->BytesToWrite	= pReq->_reqFileSize;
		pTfinfo->Offset			= 0;
		pTfinfo->pHead			= pReq->_headerStringBuffer;
	}

	pTfinfo->HeadLength    = pReq->_headerStringLength;
    pTfinfo->pTail         = SwFooter;
    pTfinfo->TailLength    = footerLen;

	if( pReq->_keepAlive != FALSE)
		pTfinfo->dwFlags = HSE_IO_ASYNC;
	else
		pTfinfo->dwFlags = HSE_IO_ASYNC | HSE_IO_DISCONNECT_AFTER_SEND;

    // Call the SSF
    return (*pReq->_ecb->ServerSupportFunction)(
                pReq->_ecb->ConnID,
                HSE_REQ_TRANSMIT_FILE,
                pTfinfo,
                NULL,
                NULL
                );
}

//
//
// 
DWORD transmitAndWriteFile(PISAPIRequest pReq, int lastAdId)
{

	HANDLE h = pReq->_reqFileHandle;

	DWORD footerLen  = sizeof(SwFooter) - 1;
	
    DWORD httpLen =0; 

	// variables for read file and search string 
	
	DWORD	fileSize = pReq->_reqFileSize;
	DWORD	ScanFileSize = 0;
	DWORD	realReadIn =0;
	DWORD	scanBufSize =0;
	DWORD   writeBufLen =0;
	BOOL	bResult = FALSE;
	DWORD	dwError;
	char	*pBuf = NULL;
	char	*p2;
    int     *searched4, *buf4;
    int     compareLen;
	

	OVERLAPPED overLap;

	overLap.Internal = 0;
	overLap.InternalHigh = 0; 
	overLap.Offset = 0; 
	overLap.OffsetHigh =0; 
	overLap.hEvent = pReq->hFileEvent;
	ResetEvent(overLap.hEvent);
	
	int i = 0;
	int j = 0;

	pBuf = pReq->_fileBuf + pReq->_headerStringLength; 

    // for the size of the first file read, i.e. read data into buffer
	scanBufSize = (DATA_BUF_SIZE - pReq->_headerStringLength);
					
	// read the file to the buffer
			
	while( overLap.Offset <= (fileSize -scanLen))
	{
		if((fileSize - overLap.Offset) >= scanBufSize)
		{
			ScanFileSize = scanBufSize;
		}
        else
		{
			ScanFileSize = fileSize - overLap.Offset;
		}

		bResult = ReadFile(h,pBuf, ScanFileSize , &realReadIn, &overLap) ;

		// if there was a problem, or the async. operation's still pending ... 
		if (!bResult) 
		{ 
				// deal with the error code 
			switch (dwError = GetLastError()) 
			{ 
				case ERROR_HANDLE_EOF: 
				{ 
					// we're reached the end of the file 
					// during the call to ReadFile 
					break;
					
				} 

				case ERROR_IO_PENDING: 
				{ 
					
					WaitForSingleObject(overLap.hEvent, INFINITE);

					// check on the results of the asynchronous read 

					bResult = GetOverlappedResult(h, &overLap, &realReadIn, FALSE) ; 

					// if there was a problem ... 
					if (!bResult) 
					{ 
						// deal with the error code 
						switch (dwError = GetLastError()) 
						{ 
							case ERROR_HANDLE_EOF: 
							{ 
								break;
							}
                            default:
							{
								return sendTextOutput(pReq, "Failed in ReadFile at CAD\n");
							}
						} // end case
					} 
					break;
				}
                default:
				{
					return sendTextOutput(pReq, "Failed in ReadFile at CAD2\n");
				} // end cases 
			} // end switch 
		} // end of read file
		
		
		// Now begin search the string in the buffer which contains 
        // characters just read from the file

		p2 = pBuf;
        i = 0;
        searched4 = (int*) scanString;
        compareLen = (int) ScanFileSize - scanLen;
        
        while (i < compareLen) {

            // see if the first character match
            if (*p2 != *scanString) {
                p2++;
                i++;        
                continue;
            }

            // see if the first 4 bytes match
            buf4 = (int*) p2;
            if (*searched4 == *buf4) { // we found a matched string

                if (0 != memcmp( p2, scanString, scanLen)) { 
                    i++;
                    p2++;
                    continue;
                } 

                if (j == 0)
                    pReq->_matchIndex = pReq->_headerStringLength + i;
                else
                    pReq->_matchIndex = i;

                // now do the string replacement
                CustomAdScan(pReq,lastAdId);
            
                // update pointers
                i += scanLen;
                p2 += scanLen;
                continue;
            }
            
            i++;
            p2++;
        }
                
		//  write the content in buffer to the client

		if( ScanFileSize + overLap.Offset >= fileSize ) // end of the file
		{
			writeBufLen = ScanFileSize + (pBuf- pReq->_fileBuf) + footerLen ;

			if( writeBufLen <= DATA_BUF_SIZE ) 
				// whole file already in the buffer, add footer and write to client
			{
				memcpy( pBuf+ScanFileSize, SwFooter, footerLen);

				if (!(*pReq->_ecb->WriteClient)(pReq->_ecb->ConnID, 
                                                pReq->_fileBuf, 
                                                &writeBufLen, 
                                                HSE_IO_SYNC)) 
                {
					return sendTextOutput(pReq, "Failed to sendFile to client at CAD!\n");
				}
                else
				{
					if(pReq->_keepAlive)
					{
						return( HSE_STATUS_SUCCESS_AND_KEEP_CONN);
					}
                    else
					{
						 return(HSE_STATUS_SUCCESS);
					}
				}
			}
            else
			{	
				writeBufLen = ScanFileSize + (pBuf- pReq->_fileBuf);

				if(!(*pReq->_ecb->WriteClient)(pReq->_ecb->ConnID, 
                                                pReq->_fileBuf, 
                                                &writeBufLen, 
                                                HSE_IO_SYNC)) 
                {
					return sendTextOutput(pReq, "Failed to sendFile to client at CAD!\n");
				}
				
				if (!(*pReq->_ecb->WriteClient)(pReq->_ecb->ConnID, 
                                                SwFooter, 
                                                &footerLen, 
                                                HSE_IO_SYNC)) 
                {
					return sendTextOutput(pReq, "Failed to send Footer to client!\n");
				}
                else
				{	
					if(pReq->_keepAlive)
					{
						return( HSE_STATUS_SUCCESS_AND_KEEP_CONN);
					}
                    else
					{
						 return(HSE_STATUS_SUCCESS);
					}
				}

			} // end of whole file in the buffer

		}else   // not at end of file
		{
				writeBufLen = DATA_BUF_SIZE - scanLen;

				if(!(*pReq->_ecb->WriteClient)(pReq->_ecb->ConnID, 
                                                pReq->_fileBuf, 
                                                &writeBufLen, 
                                                HSE_IO_SYNC )) 
                {
					return sendTextOutput(pReq, "Failed to sendFile to client at CAD\n!");
				}
		}

		overLap.Offset = overLap.Offset + (ScanFileSize - scanLen);

		pBuf = pReq->_fileBuf;
		scanBufSize = DATA_BUF_SIZE;
		
		j++;

	} // end of searching string while

    OutputDebugString("ERROR: cannot find matched string in the CD file!!!!!!!\n");

	// may never reach here

	if(pReq->_keepAlive)
	{
		return( HSE_STATUS_SUCCESS_AND_KEEP_CONN);
	}
    else
	{
		 return(HSE_STATUS_SUCCESS);
	}
}



//
//this function turns int to chars
//

int intToChars(char *pBuf, unsigned int inData)
{
	char *pTem, cTem;
	int  iTem;
	int   i = 0;

	if(inData < 10)
	{
		*pBuf = '0' + inData;
		return 1;
	}

	pTem = pBuf;

	// transfer digital to char from right to left
	while( inData > 0)
	{
		iTem = inData/10;

		*pTem = '0' + (inData - iTem*10);

		inData = iTem;
		i++;
		pTem++;
	}

	// reverse the string

	pTem--;

	while(pBuf < pTem)
	{
		cTem = *pBuf;
		*pBuf++ = *pTem;
		*pTem-- = cTem;
	}

	return(i);
}

//
//This function compose header string.
//
void composeHeaderString( PISAPIRequest *pReq, DWORD InnerContentLen)
{
	int		contentLen =0;
	int		temLen=0;
	char    *pHeaderString ;
	size_t  cookieStringLen = strlen((*pReq)->_cookie);
	size_t  remoteAdLen = strlen((*pReq)->_remoteAddr);
	size_t  serverSoftLen = constantVars.serverSoftLen;
	size_t  scriptNameLen = constantVars.scriptNameLen;
	size_t  queryStringLen;
	size_t  dataCpyLen = 5; //contentDataLen; //- constMagicOne;

	if( (*pReq)->_ecb->lpbData != NULL)
	{
		queryStringLen = strlen((char*)(*pReq)->_ecb->lpbData);
	}
    else		
	{
		queryStringLen = strlen((*pReq)->_queryString);
	}


	DWORD	textLen; // = pReq->cacheEntry->size();

	pHeaderString = (*pReq)->_headerStringBuffer;

	memset((*pReq)->_headerStringBuffer, ' ', sizeof((*pReq)->_headerStringBuffer));

	if( 0 == InnerContentLen)
	{
		textLen = (*pReq)->_reqFileSize;
	}
    else
	{
		textLen = InnerContentLen;
	}


	// fill in http header to pReq->_headerStringBuf

	contentLen =	SwHeader1Len + serverSoftLen + SwHeader2Len + remoteAdLen 
					+ SwHeader3Len + scriptNameLen + SwHeader4Len + queryStringLen 
					+ SwHeader5Len -constMagicOne + textLen + footerLen;

	if( FALSE != (*pReq)->_keepAlive)   // is keep alive?
	{
		if(!('\0'==(*pReq)->_cookie[0]))  // has cookie string?
		{

			memcpy(pHeaderString, HttpHeaderKA, HttpHeaderKALen);
			pHeaderString += HttpHeaderKALen;

			//transfer digital contentLen into chars
			dataCpyLen = intToChars( pHeaderString, (unsigned int)contentLen);

			pHeaderString += dataCpyLen;

			memcpy(pHeaderString, HttpHeaderCookie, HttpHeaderCookieLen);
			pHeaderString += HttpHeaderCookieLen;

			memcpy(pHeaderString, (*pReq)->_cookie, cookieStringLen);
			pHeaderString += cookieStringLen;
			
		}else
		{
			
			// transfer digital contentLen into chars
			memcpy(pHeaderString, HttpHeaderKA, HttpHeaderKALen);
			pHeaderString += HttpHeaderKALen;

			dataCpyLen = intToChars( pHeaderString, (unsigned int)contentLen);
			pHeaderString += dataCpyLen;

		}
	}else
	{
		if(!('\0'== (*pReq)->_cookie[0])) // has cookie string
		{
			
			// transfer digital contentLen into chars
			memcpy(pHeaderString, HttpHeaderNonKA, HttpHeaderNonKALen);

			pHeaderString += HttpHeaderNonKALen;

			dataCpyLen = intToChars( pHeaderString, (unsigned int)contentLen);
			pHeaderString += dataCpyLen;

			memcpy(pHeaderString, HttpHeaderCookie, HttpHeaderCookieLen);
			pHeaderString += HttpHeaderCookieLen;

			memcpy(pHeaderString, (*pReq)->_cookie, cookieStringLen);
			pHeaderString += cookieStringLen;
			
	
		}else
		{
			

			// transfer digital contentLen into chars
			memcpy(pHeaderString, HttpHeaderNonKA, HttpHeaderNonKALen);
			pHeaderString += HttpHeaderNonKALen;

			dataCpyLen = intToChars( pHeaderString, (unsigned int)contentLen);
			pHeaderString += dataCpyLen;
	
		}
	}
	
	memcpy(pHeaderString, HttpHeaderTail, HttpHeaderTailLen);
	pHeaderString += HttpHeaderTailLen;

	// fill in SwHeader to pReq->_headerStringBuffer

	memcpy(pHeaderString, SwHeader1, SwHeader1Len);
	pHeaderString += SwHeader1Len;

	//copy server software name
	memcpy(pHeaderString, constantVars.serverSoftware, serverSoftLen);
	pHeaderString += serverSoftLen;

	memcpy(pHeaderString, SwHeader2, SwHeader2Len);
	pHeaderString += SwHeader2Len;

	//copy remote address
	memcpy(pHeaderString, (*pReq)->_remoteAddr, remoteAdLen);
	pHeaderString += remoteAdLen;

	memcpy(pHeaderString, SwHeader3, SwHeader3Len);
	pHeaderString += SwHeader3Len;

	//copy script name
	memcpy(pHeaderString, constantVars.scriptName, scriptNameLen);
	pHeaderString += scriptNameLen;


	memcpy(pHeaderString, SwHeader4, SwHeader4Len);
	pHeaderString += SwHeader4Len;


	// copy query string

	if( (*pReq)->_ecb->lpbData != NULL)
	{
		memcpy(pHeaderString, (*pReq)->_ecb->lpbData, queryStringLen);
		
	}else
	{
		memcpy(pHeaderString, (*pReq)->_queryString, queryStringLen);
	}

	pHeaderString += queryStringLen;

	//copy WsTail

	memcpy(pHeaderString, SwHeader5, SwHeader5Len);


	(*pReq)->_headerStringLength = strlen((*pReq)->_headerStringBuffer);

	// return 0;
}



