#!/bin/bash


RULE="/etc/udev/rules.d/70-persistent-net.rules"

test -e $RULE || exit

MACS=$(grep eth $RULE | grep "ATTR{address}==" | awk -F',' '{print $4}' | awk -F'==' '{print $2}' | sed -e 's/"//g')

timestamp=$(date +%Y%m%d%H%M)
for mac in $MACS; do
	#echo $mac
	ip link | grep -q $mac || {
		date | tee -a /tmp/update_udev_rules_net.log
		echo "Cannot find corresponding NIC for the following line in $RULE, cleaning the file:" | tee -a /tmp/update_udev_rules_net.log
		grep $mac $RULE | tee -a /tmp/update_udev_rules_net.log

		# backup to /tmp
		cp -pv $RULE ${RULE}-${timestamp} && mv -v ${RULE}-${timestamp} /tmp/

		# clean the rules
		echo > $RULE
		# reboot so that the udev will regenerate the rules
		sleep 20
		reboot
	}
done
