#!/bin/bash

####vf pci slot on M7
# ens5f0 1f:01:0 1 2 3 4 5 6 7 ...  1f:10:0 1 2 3 4 5 6    127 vfs NUMA0
# ens5f1 1f:11:0 1 2 3 4 5 6 7 ...  20:00:0 1 2 3 4 5 6    127 vfs NUMA0
# ens29f0 ac:01:0 1 2 3 4 5 6 7 ...  ac:10:0 1 2 3 4 5 6    127 vfs NUMA1
# ens29f1 ac:11:0 1 2 3 4 5 6 7 ...  ad:00:0 1 2 3 4 5 6    127 vfs NUMA1

# Each run of this script, VFs of 4 tiles are updated.
# You need to update vfSlots, vfFunc and bus according to
# the NUMA which tile will be pinned.
# For example, appserver, batchserver, mailserver, infraserver,
# webserver of tile 1-4 should be pinned to NUMA0, then vfSlots,
# vfFunc, bus should be updated to:
# vfSlots=(10 11 12 13 14)
# vfFunc=(1 3 5 7 1 3 5 7 1 3 5 7 1 3 5 7 1 3 5 7)
# bus='31'
# for tilei in $(seq 1    4)

#VFs of dbserver is updated manually by choosing a VF from free
#VFs on the NUMA which it is pinned.

#tile 1~4 9~12       1f:01:0 1 2 3 ~ 1f:05:7
#tile 5~8 13~16      ac:01:0 1 2 3 ~ ac:05:7
#tile 17~20 25~28    1f:06:0 1 2 3 ~ 1f:0a:7
#tile 21~24 29~32    ac:06:0 1 2 3 ~ ac:0a:7
#tile 33~36          1f:0b:0 1 2 ~ 1f:0d:3
#tile 37~40          ac:0b:0 1 2 ~ ac:0d:3
#tile 41~44 49~52    1f:11:0 1 2 ~ 1f:15:7
#tile 45~48 53~56    ac:11:0 1 2 ~ ac:15:7
#tile 57~60 65~68    1f:16:4 5 6 ~ 1f:1a:7
#tile 61~64 69~72    ac:16:4 5 6 ~ ac:1a:7

#tile           1f:13:4 5 6 ~ 1f:15:7
#tile           ac:13:4 5 6 ~ ac:15:7
#tile 49 31:18:0 2 4 6 ~31:19:0
#tile 50 31:18:1 3, 31:19:1 b1:18:5 b1:18:7

vfSlots=(10 11 12 13 14)

#vfFunc=(0 2 4 6 0 2 4 6 0 2 4 6 0 2 4 6)
vfFunc=(0 1 2 3 4 5 6 7 0 1 2 3 4 5 6 7)

servers=(appserver batchserver mailserver infraserver webserver)

bus='1f' # 'ac' '4b' #'b1' #'ca'
sloti=0
funci=0

slen=$((${#servers[@]} - 1))


for tilei in $(seq 1    4)
do
        for servi in $(seq 0 $slen)
        do
        slot=${vfSlots[$sloti]}
        func=${vfFunc[$funci]}
        echo ${servers[$servi]}$tilei.xml
        echo "$bus 0x$slot 0x$func"

        #update pci slot
        sed -i "/<source>/,+2d" ${servers[$servi]}$tilei.xml
        sed -i "/mac address/a <source>\n   <address type='pci' domain='0x0000' bus='0x$bus' slot='0x$slot' function='0x$func'/>\n</source>" ${servers[$servi]}$tilei.xml
        #sed -i "s/type='direct'/type='hostdev' managed='yes'/"  ${servers[$servi]}$tilei.xml
        funci=$((funci + 1))
        if [ $funci -eq 8 -o $funci -eq 16 ];
        then
            sloti=$((sloti + 1))
            funci=0
        fi
        done
done


