#!/bin/bash

####vf pci slot on M6
# ens5f0 31:10:0 2 4 6 ...  31:1f:0 2 4   63vfs NUMA0
# ens5f1 31:10:1 3 5 7 ...  31:1f:1 3 5   63vfs NUMA0
# ens9f0 4b:10:0 2 4 6 ...  4b:1f:0 2 4   63vfs NUMA0
# ens9f1 4b:10:1 3 5 7 ...  4b:1f:1 3 5   63vfs NUMA0
# ens21f0 b1:10:0 2 4 6 ...  b1:1f:0 2 4   63vfs NUMA1
# ens21f1 b1:10:1 3 5 7 ...  b1:1f:1 3 5   63vfs NUMA1
# ens25f0 ca:10:0 2 4 6 ...  ca:1f:0 2 4   63vfs NUMA1
# ens25f1 ca:10:1 3 5 7 ...  ca:1f:0 2 4   63vfs NUMA1

# Each run of this script, VFs of 4 tiles are updated.
# You need to update vfSlots, vfFunc and bus according to
# the NUMA which tile will be pinned.
# For example, appserver, batchserver, mailserver, infraserver,
# webserver of tile 1-4 should be pinned to NUMA0, then vfSlots,
# vfFunc, bus should be updated to:
# vfSlots=(10 11 12 13 14) 
# vfFunc=(1 3 5 7 1 3 5 7 1 3 5 7 1 3 5 7 1 3 5 7)
# bus='31'
# for tilei in $(seq 1    4)

#VFs of dbserver is updated manually by choosing a VF from free
#VFs on the NUMA which it is pinned.

#tile 1~4   31:10:1 3 5 7 ~ 31:14:7
#tile 5~8   b1:10:1 3 5 7 ~ b1:14:7
#tile 9~12  31:10:0 2 4 6 ~ 31:14:6
#tile 13~16 b1:10:0 2 4 6 ~ b1:14:6
#tile 17~20 4b:10:0 2 4 6 ~ 4b:14:6
#tile 21~24 ca:10:0 2 4 6 ~ ca:14:6
#tile 25~28 4b:10:1 3 5 7 ~ 4b:14:7
#tile 29~32 ca:10:1 3 5 7 ~ ca:14:7
#tile 33~34 31:15:2 4 6 ~ 31:17:4
#tile 35~36 31:15:3 5 7 ~ 31:17:5
#tile 37~38 b1:15:2 4 6 ~ b1:17:4
#tile 39~40 b1:15:3 5 7 ~ b1:17:5
#tile 41~42 4b:15:2 4 6 ~ 4b:17:4
#tile 43~44 4b:15:3 5 7 ~ 4b:17:5
#tile 45~46 ca:15:2 4 6 ~ ca:17:4
#tile 47~48 ca:15:3 5 7 ~ ca:17:5
#tile 49 31:18:0 2 4 6 ~31:19:0
#tile 50 31:18:1 3, 31:19:1 b1:18:5 b1:18:7

vfSlots=(10 11 12 13 14) 

#vfFunc=(0 2 4 6 0 2 4 6 0 2 4 6 0 2 4 6) 
vfFunc=(1 3 5 7 1 3 5 7 1 3 5 7 1 3 5 7 1 3 5 7)

servers=(appserver batchserver mailserver infraserver webserver)

bus='31' # '4b' #'b1' #'ca' 
sloti=0
funci=0

slen=$((${#servers[@]} - 1))


for tilei in $(seq 1    4)
do
	for servi in $(seq 0 $slen)
	do 
	slot=${vfSlots[$sloti]}
	func=${vfFunc[$funci]}
	echo ${servers[$servi]}$tilei.xml
	echo "$bus 0x$slot 0x$func"

	#update pci slot
	sed -i "/<source>/,+2d" ${servers[$servi]}$tilei.xml
	sed -i "/mac address/a <source>\n   <address type='pci' domain='0x0000' bus='0x$bus' slot='0x$slot' function='0x$func'/>\n</source>" ${servers[$servi]}$tilei.xml
	#sed -i "s/type='direct'/type='hostdev' managed='yes'/"  ${servers[$servi]}$tilei.xml
	funci=$((funci + 1))
	if [ $funci -eq 4 -o $funci -eq 8 -o $funci -eq 12 -o $funci -eq 16 ];
	then
	    sloti=$((sloti + 1))
            funci=0
	fi
        done
done

