
#!/bin/bash

#cd /root
DATE=`date +%m%d%H%M`

#rm -rf data_collection$DATE
mkdir -p data_collection$DATE

#client configure
fn_getClientInfo()
{
   # for i in 30 40 
    for i in 88 110 132	
    do
        clientphydir=data_collection$DATE/PHYS/Clients/Client_phy$i/OS	
        mkdir -p $clientphydir/boot/grub/
        scp -p 192.1.1.$i:/boot/grub/grub.cfg $clientphydir/boot/grub/
        mkdir -p  $clientphydir/etc
        scp -p 192.1.1.$i:/etc/sysctl.conf $clientphydir/etc
        scp -p 192.1.1.$i:/etc/hostname $clientphydir/etc
        mkdir -p  $clientphydir/etc/sysconfig/network
        scp -p 192.1.1.$i:/etc/sysconfig/network/ifcfg* $clientphydir/etc/sysconfig/network
        mkdir -p  $clientphydir/etc/init.d/
        scp -pr 192.1.1.$i:/etc/init.d/* $clientphydir/etc/init.d
        scp -p 192.1.1.$i:/etc/bashrc $clientphydir/etc
        scp -p 192.1.1.$i:/etc/profile $clientphydir/etc
        mkdir -p  $clientphydir/proc
        ssh 192.1.1.$i "cat /proc/cpuinfo" > $clientphydir/proc/cpuinfo
        ssh 192.1.1.$i "cat /proc/devices" > $clientphydir/proc/devices
        ssh 192.1.1.$i "cat /proc/meminfo" > $clientphydir/proc/meminfo
        ssh 192.1.1.$i "cat /proc/modules" > $clientphydir/proc/modules
        ssh 192.1.1.$i "cat /proc/partitions" > $clientphydir/proc/partitions
        ssh 192.1.1.$i "cat /proc/swaps" > $clientphydir/proc/swaps
        ssh 192.1.1.$i "cat /proc/version" > $clientphydir/proc/version
        ssh 192.1.1.$i "cat /proc/cmdline" > $clientphydir/proc/cmdline
        mkdir -p  $clientphydir/var/log
        ssh 192.1.1.$i "dmesg" >  $clientphydir/var/log/dmesg.txt
        ssh 192.1.1.$i "brctl show" > $clientphydir/brctl-show.txt
        ssh 192.1.1.$i "chkconfig" > $clientphydir/chkconfig.txt
        ssh 192.1.1.$i "df" > $clientphydir/df.txt
        ssh 192.1.1.$i "ifconfig" > $clientphydir/ifconfig.txt
        ssh 192.1.1.$i "lspci" > $clientphydir/lspci.txt
        ssh 192.1.1.$i "lvdisplay" > $clientphydir/lvdisplay.txt
        ssh 192.1.1.$i "mount -l" > $clientphydir/mount.txt
        ssh 192.1.1.$i "rpm -qa|sort" > $clientphydir/rpmpkgs.txt
        ssh 192.1.1.$i "vgdisplay" > $clientphydir/vgdisplay.txt



	mkdir -p data_collection$DATE/PHYS/Clients/Client_phy$i/SOFTW
	clientphydir_soft=data_collection$DATE/PHYS/Clients/Client_phy$i/SOFTW
	ssh 192.1.1.$i " ps -eLlfww | grep -E 'qemu|PID' | grep -v grep" > $clientphydir_soft/running-vms.txt
	ssh 192.1.1.$i "virsh list |grep running" > $clientphydir_soft/virsh-list.txt


    done    
   i=110 
    clientvmdir=data_collection$DATE/PHYS/Clients/Client_phy$i
    vmnum=1
    vmend=9
    for((j=$vmnum;j<=$vmend;j++))
    do
		for k in $k 7
		do
			mkdir -p $clientvmdir/Tile$j/client$j
			mkdir -p $clientvmdir/Tile$j/client$j/OS


			mkdir -p $clientvmdir/Tile$j/client$j/SPECbatch
                        mkdir -p $clientvmdir/Tile$j/client$j/SPECimap
			mkdir -p $clientvmdir/Tile$j/client$j/SPECjAppServer2004
			mkdir -p $clientvmdir/Tile$j/client$j/SPECweb2005

			ssh 192.1.$j.$k "java -version" 1&> $clientvmdir/Tile$j/client$j/javaVersion.out

			mkdir -p $clientvmdir/Tile$j/client$j/OS/boot/grub/
			scp -p 192.1.$j.$k:/boot/grub/grub.conf $clientvmdir/Tile$j/client$j/OS/boot/grub/
			mkdir -p  $clientvmdir/Tile$j/client$j/OS/etc/iproute2
			mkdir -p  $clientvmdir/Tile$j/client$j/OS/etc/rc.d/init.d
			mkdir -p  $clientvmdir/Tile$j/client$j/OS/etc/rc.d/rc3.d
			scp -p 192.1.$j.$k:/etc/iproute2/* $clientvmdir/Tile$j/client$j/OS/etc/iproute2/
			scp -pr 192.1.$j.$k:/etc/rc.d/init.d/* $clientvmdir/Tile$j/client$j/OS/etc/rc.d/init.d
			scp -p 192.1.$j.$k:/etc/rc.d/rc3.d/* $clientvmdir/Tile$j/client$j/OS/etc/rc.d/rc3.d
			scp -p 192.1.$j.$k:/etc/fstab $clientvmdir/Tile$j/client$j/OS/etc
			scp -p 192.1.$j.$k:/etc/hosts $clientvmdir/Tile$j/client$j/OS/etc
			scp -p 192.1.$j.$k:/etc/inittab $clientvmdir/Tile$j/client$j/OS/etc
			scp -p 192.1.$j.$k:/etc/nsswitch.conf $clientvmdir/Tile$j/client$j/OS/etc
			scp -p 192.1.$j.$k:/etc/sysctl.conf $clientvmdir/Tile$j/client$j/OS/etc
			scp -p 192.1.$j.$k:/etc/rc.local $clientvmdir/Tile$j/client$j/OS/etc
			scp -p 192.1.$j.$k:/etc/bashrc $clientvmdir/Tile$j/client$j/OS/etc
			mkdir -p  $clientvmdir/Tile$j/client$j/OS/etc/sysconfig/network-scripts/
			scp -p 192.1.$j.$k:/etc/sysconfig/network-scripts/ifcfg* $clientvmdir/Tile$j/client$j/OS/etc/sysconfig/network-scripts/
			scp -p 192.1.$j.$k:/etc/sysconfig/network $clientvmdir/Tile$j/client$j/OS/etc/sysconfig
			mkdir -p  $clientvmdir/Tile$j/client$j/OS/proc
			ssh 192.1.$j.$k "cat /proc/cmdline" > $clientvmdir/Tile$j/client$j/OS/proc/cmdline
			ssh 192.1.$j.$k "cat /proc/cpuinfo" > $clientvmdir/Tile$j/client$j/OS/proc/cpuinfo
			ssh 192.1.$j.$k "cat /proc/devices" > $clientvmdir/Tile$j/client$j/OS/proc/devices
			ssh 192.1.$j.$k "cat /proc/meminfo" > $clientvmdir/Tile$j/client$j/OS/proc/meminfo
			ssh 192.1.$j.$k "cat /proc/modules" > $clientvmdir/Tile$j/client$j/OS/proc/modules
			ssh 192.1.$j.$k "cat /proc/mounts" > $clientvmdir/Tile$j/client$j/OS/proc/mounts 
			ssh 192.1.$j.$k "cat /proc/partitions" > $clientvmdir/Tile$j/client$j/OS/proc/partitions
			ssh 192.1.$j.$k "cat /proc/swaps" > $clientvmdir/Tile$j/client$j/OS/proc/swaps
			ssh 192.1.$j.$k "cat /proc/version" > $clientvmdir/Tile$j/client$j/OS/proc/version
			ssh 192.1.$j.$k "cat /etc/redhat-release" >  $clientvmdir/Tile$j/client$j/OS/etc/redhat-release
			ssh 192.1.$j.$k "sysctl -a" >  $clientvmdir/Tile$j/client$j/OS/sysctl.txt

			mkdir -p  $clientvmdir/Tile$j/client$j/OS/var/log
			ssh 192.1.$j.$k "dmesg" > $clientvmdir/Tile$j/client$j/OS/var/log/dmesg.txt
			ssh 192.1.$j.$k "chkconfig" > $clientvmdir/Tile$j/client$j/OS/chkconfig.txt
			ssh 192.1.$j.$k "df" > $clientvmdir/Tile$j/client$j/OS/df.txt
			ssh 192.1.$j.$k "ifconfig" > $clientvmdir/Tile$j/client$j/OS/ifconfig.txt
			ssh 192.1.$j.$k "lspci" > $clientvmdir/Tile$j/client$j/OS/lspci.txt
			ssh 192.1.$j.$k "mount -l" > $clientvmdir/Tile$j/client$j/OS/mount.txt
			ssh 192.1.$j.$k "rpm -qa|sort" > $clientvmdir/Tile$j/client$j/OS/rpmpkgs.txt

			
			scp 192.1.$j.$k:/opt/SPECbatch/Test.config							$clientvmdir/Tile$j/client$j/SPECbatch
			scp 192.1.$j.$k:/opt/SPECimap/IMAP_config.rc						$clientvmdir/Tile$j/client$j/SPECimap
			scp 192.1.$j.$k:/opt/SPECjAppServer2004/config/default.env			$clientvmdir/Tile$j/client$j/SPECjAppServer2004
			scp 192.1.$j.$k:/opt/SPECjAppServer2004/config/run.properties		$clientvmdir/Tile$j/client$j/SPECjAppServer2004
			scp 192.1.$j.$k:/opt/SPECweb2005/Test.config						$clientvmdir/Tile$j/client$j/SPECweb2005
			scp 192.1.$j.$k:/opt/SPECweb2005/SPECweb_Support.config				$clientvmdir/Tile$j/client$j/SPECweb2005     

			
		done


		for k in $k 8
                do


			mkdir -p $clientvmdir/Tile$j/wclient$j
                        mkdir -p $clientvmdir/Tile$j/wclient$j/OS


                        mkdir -p $clientvmdir/Tile$j/wclient$j/SPECbatch
                        mkdir -p $clientvmdir/Tile$j/wclient$j/SPECimap
                        mkdir -p $clientvmdir/Tile$j/wclient$j/SPECjAppServer2004
                        mkdir -p $clientvmdir/Tile$j/wclient$j/SPECweb2005

			ssh 192.1.$j.$k "java -version" 1&> $clientvmdir/Tile$j/wclient$j/javaVersion.out

                        mkdir -p $clientvmdir/Tile$j/wclient$j/OS/boot/grub/
                        scp -p 192.1.$j.$k:/boot/grub/grub.conf $clientvmdir/Tile$j/wclient$j/OS/boot/grub/
                        mkdir -p  $clientvmdir/Tile$j/wclient$j/OS/etc/iproute2
                        mkdir -p  $clientvmdir/Tile$j/wclient$j/OS/etc/rc.d/init.d
                        mkdir -p  $clientvmdir/Tile$j/wclient$j/OS/etc/rc.d/rc3.d
                        scp -p 192.1.$j.$k:/etc/iproute2/* $clientvmdir/Tile$j/wclient$j/OS/etc/iproute2/
                        scp -pr 192.1.$j.$k:/etc/rc.d/init.d/* $clientvmdir/Tile$j/wclient$j/OS/etc/rc.d/init.d
                        scp -p 192.1.$j.$k:/etc/rc.d/rc3.d/* $clientvmdir/Tile$j/wclient$j/OS/etc/rc.d/rc3.d
                        scp -p 192.1.$j.$k:/etc/fstab $clientvmdir/Tile$j/wclient$j/OS/etc
                        scp -p 192.1.$j.$k:/etc/hosts $clientvmdir/Tile$j/wclient$j/OS/etc
                        scp -p 192.1.$j.$k:/etc/inittab $clientvmdir/Tile$j/wclient$j/OS/etc
                        scp -p 192.1.$j.$k:/etc/nsswitch.conf $clientvmdir/Tile$j/wclient$j/OS/etc
                        scp -p 192.1.$j.$k:/etc/sysctl.conf $clientvmdir/Tile$j/wclient$j/OS/etc
                        scp -p 192.1.$j.$k:/etc/rc.local $clientvmdir/Tile$j/wclient$j/OS/etc
                        scp -p 192.1.$j.$k:/etc/bashrc $clientvmdir/Tile$j/wclient$j/OS/etc
                        mkdir -p  $clientvmdir/Tile$j/wclient$j/OS/etc/sysconfig/network-scripts/
                        scp -p 192.1.$j.$k:/etc/sysconfig/network-scripts/ifcfg* $clientvmdir/Tile$j/wclient$j/OS/etc/sysconfig/network-scripts/
                        scp -p 192.1.$j.$k:/etc/sysconfig/network $clientvmdir/Tile$j/wclient$j/OS/etc/sysconfig
                        mkdir -p  $clientvmdir/Tile$j/wclient$j/OS/proc
                        ssh 192.1.$j.$k "cat /proc/cmdline" > $clientvmdir/Tile$j/wclient$j/OS/proc/cmdline
                        ssh 192.1.$j.$k "cat /proc/cpuinfo" > $clientvmdir/Tile$j/wclient$j/OS/proc/cpuinfo
                        ssh 192.1.$j.$k "cat /proc/devices" > $clientvmdir/Tile$j/wclient$j/OS/proc/devices
                        ssh 192.1.$j.$k "cat /proc/meminfo" > $clientvmdir/Tile$j/wclient$j/OS/proc/meminfo
                        ssh 192.1.$j.$k "cat /proc/modules" > $clientvmdir/Tile$j/wclient$j/OS/proc/modules
                        ssh 192.1.$j.$k "cat /proc/mounts" > $clientvmdir/Tile$j/wclient$j/OS/proc/mounts
                        ssh 192.1.$j.$k "cat /proc/partitions" > $clientvmdir/Tile$j/wclient$j/OS/proc/partitions
                        ssh 192.1.$j.$k "cat /proc/swaps" > $clientvmdir/Tile$j/wclient$j/OS/proc/swaps
                        ssh 192.1.$j.$k "cat /proc/version" > $clientvmdir/Tile$j/wclient$j/OS/proc/version
			ssh 192.1.$j.$k "cat  /etc/redhat-release" > $clientvmdir/Tile$j/wclient$j/OS/etc/redhat-release
			ssh 192.1.$j.$k "sysctl -a" > $clientvmdir/Tile$j/wclient$j/OS/sysctl.txt
                        mkdir -p  $clientvmdir/Tile$j/wclient$j/OS/var/log
                        ssh 192.1.$j.$k "dmesg" > $clientvmdir/Tile$j/wclient$j/OS/var/log/dmesg.txt
                        ssh 192.1.$j.$k "chkconfig" > $clientvmdir/Tile$j/wclient$j/OS/chkconfig.txt
                        ssh 192.1.$j.$k "df" > $clientvmdir/Tile$j/wclient$j/OS/df.txt
                        ssh 192.1.$j.$k "ifconfig" > $clientvmdir/Tile$j/wclient$j/OS/ifconfig.txt
                        ssh 192.1.$j.$k "lspci" > $clientvmdir/Tile$j/wclient$j/OS/lspci.txt
                        ssh 192.1.$j.$k "mount -l" > $clientvmdir/Tile$j/wclient$j/OS/mount.txt
                        ssh 192.1.$j.$k "rpm -qa|sort" > $clientvmdir/Tile$j/wclient$j/OS/rpmpkgs.txt

                        scp 192.1.$j.$k:/opt/SPECbatch/Test.config                                                      $clientvmdir/Tile$j/wclient$j/SPECbatch
                        scp 192.1.$j.$k:/opt/SPECimap/IMAP_config.rc                                            $clientvmdir/Tile$j/wclient$j/SPECimap
                        scp 192.1.$j.$k:/opt/SPECjAppServer2004/config/default.env                      $clientvmdir/Tile$j/wclient$j/SPECjAppServer2004
                        scp 192.1.$j.$k:/opt/SPECjAppServer2004/config/run.properties           $clientvmdir/Tile$j/wclient$j/SPECjAppServer2004
                        scp 192.1.$j.$k:/opt/SPECweb2005/Test.config                                            $clientvmdir/Tile$j/wclient$j/SPECweb2005
                        scp 192.1.$j.$k:/opt/SPECweb2005/SPECweb_Support.config                         $clientvmdir/Tile$j/wclient$j/SPECweb2005



                done

		
    done
    #i=40 
    i=88 
    clientvmdir=data_collection$DATE/PHYS/Clients/Client_phy$i
    vmnum=10
    vmend=19
    for((j=$vmnum;j<=$vmend;j++))
    do
	   for k in $k 7
                do
			mkdir -p $clientvmdir/Tile$j/client$j
                        mkdir -p $clientvmdir/Tile$j/client$j/OS


                        mkdir -p $clientvmdir/Tile$j/client$j/SPECbatch
                        mkdir -p $clientvmdir/Tile$j/client$j/SPECimap
                        mkdir -p $clientvmdir/Tile$j/client$j/SPECjAppServer2004
                        mkdir -p $clientvmdir/Tile$j/client$j/SPECweb2005

			ssh 192.1.$j.$k "java -version" 1&> $clientvmdir/Tile$j/client$j/javaVersion.out

                        mkdir -p $clientvmdir/Tile$j/client$j/OS/boot/grub/
                        scp -p 192.1.$j.$k:/boot/grub/grub.conf $clientvmdir/Tile$j/client$j/OS/boot/grub/
                        mkdir -p  $clientvmdir/Tile$j/client$j/OS/etc/iproute2
                        mkdir -p  $clientvmdir/Tile$j/client$j/OS/etc/rc.d/init.d
                        mkdir -p  $clientvmdir/Tile$j/client$j/OS/etc/rc.d/rc3.d
                        scp -p 192.1.$j.$k:/etc/iproute2/* $clientvmdir/Tile$j/client$j/OS/etc/iproute2/
                        scp -pr 192.1.$j.$k:/etc/rc.d/init.d/* $clientvmdir/Tile$j/client$j/OS/etc/rc.d/init.d
                        scp -p 192.1.$j.$k:/etc/rc.d/rc3.d/* $clientvmdir/Tile$j/client$j/OS/etc/rc.d/rc3.d
                        scp -p 192.1.$j.$k:/etc/fstab $clientvmdir/Tile$j/client$j/OS/etc
                        scp -p 192.1.$j.$k:/etc/hosts $clientvmdir/Tile$j/client$j/OS/etc
                        scp -p 192.1.$j.$k:/etc/inittab $clientvmdir/Tile$j/client$j/OS/etc
                        scp -p 192.1.$j.$k:/etc/nsswitch.conf $clientvmdir/Tile$j/client$j/OS/etc
                        scp -p 192.1.$j.$k:/etc/sysctl.conf $clientvmdir/Tile$j/client$j/OS/etc
                        scp -p 192.1.$j.$k:/etc/rc.local $clientvmdir/Tile$j/client$j/OS/etc
                        scp -p 192.1.$j.$k:/etc/bashrc $clientvmdir/Tile$j/client$j/OS/etc
                        mkdir -p  $clientvmdir/Tile$j/client$j/OS/etc/sysconfig/network-scripts/
                        scp -p 192.1.$j.$k:/etc/sysconfig/network-scripts/ifcfg* $clientvmdir/Tile$j/client$j/OS/etc/sysconfig/network-scripts/
                        scp -p 192.1.$j.$k:/etc/sysconfig/network $clientvmdir/Tile$j/client$j/OS/etc/sysconfig
                        mkdir -p  $clientvmdir/Tile$j/client$j/OS/proc
                        ssh 192.1.$j.$k "cat /proc/cmdline" > $clientvmdir/Tile$j/client$j/OS/proc/cmdline
                        ssh 192.1.$j.$k "cat /proc/cpuinfo" > $clientvmdir/Tile$j/client$j/OS/proc/cpuinfo
                        ssh 192.1.$j.$k "cat /proc/devices" > $clientvmdir/Tile$j/client$j/OS/proc/devices
                        ssh 192.1.$j.$k "cat /proc/meminfo" > $clientvmdir/Tile$j/client$j/OS/proc/meminfo
                        ssh 192.1.$j.$k "cat /proc/modules" > $clientvmdir/Tile$j/client$j/OS/proc/modules
                        ssh 192.1.$j.$k "cat /proc/mounts" > $clientvmdir/Tile$j/client$j/OS/proc/mounts
                        ssh 192.1.$j.$k "cat /proc/partitions" > $clientvmdir/Tile$j/client$j/OS/proc/partitions
                        ssh 192.1.$j.$k "cat /proc/swaps" > $clientvmdir/Tile$j/client$j/OS/proc/swaps
                        ssh 192.1.$j.$k "cat /proc/version" > $clientvmdir/Tile$j/client$j/OS/proc/version
			ssh 192.1.$j.$k "cat  /etc/redhat-release" >  $clientvmdir/Tile$j/client$j/OS/etc/redhat-release
			ssh 192.1.$j.$k "sysctl -a" >  $clientvmdir/Tile$j/client$j/OS/sysctl.txt

                        mkdir -p  $clientvmdir/Tile$j/client$j/OS/var/log
                        ssh 192.1.$j.$k "dmesg" > $clientvmdir/Tile$j/client$j/OS/var/log/dmesg.txt
                        ssh 192.1.$j.$k "chkconfig" > $clientvmdir/Tile$j/client$j/OS/chkconfig.txt
                        ssh 192.1.$j.$k "df" > $clientvmdir/Tile$j/client$j/OS/df.txt
                        ssh 192.1.$j.$k "ifconfig" > $clientvmdir/Tile$j/client$j/OS/ifconfig.txt
                        ssh 192.1.$j.$k "lspci" > $clientvmdir/Tile$j/client$j/OS/lspci.txt
                        ssh 192.1.$j.$k "mount -l" > $clientvmdir/Tile$j/client$j/OS/mount.txt
                        ssh 192.1.$j.$k "rpm -qa|sort" > $clientvmdir/Tile$j/client$j/OS/rpmpkgs.txt
						

                        scp 192.1.$j.$k:/opt/SPECbatch/Test.config                                                      $clientvmdir/Tile$j/client$j/SPECbatch
                        scp 192.1.$j.$k:/opt/SPECimap/IMAP_config.rc                                            $clientvmdir/Tile$j/client$j/SPECimap
                        scp 192.1.$j.$k:/opt/SPECjAppServer2004/config/default.env                      $clientvmdir/Tile$j/client$j/SPECjAppServer2004
                        scp 192.1.$j.$k:/opt/SPECjAppServer2004/config/run.properties           $clientvmdir/Tile$j/client$j/SPECjAppServer2004
                        scp 192.1.$j.$k:/opt/SPECweb2005/Test.config                                            $clientvmdir/Tile$j/client$j/SPECweb2005
                        scp 192.1.$j.$k:/opt/SPECweb2005/SPECweb_Support.config                         $clientvmdir/Tile$j/client$j/SPECweb2005



                done


                for k in $k 8
                do


                        mkdir -p $clientvmdir/Tile$j/wclient$j
                        mkdir -p $clientvmdir/Tile$j/wclient$j/OS


                        mkdir -p $clientvmdir/Tile$j/wclient$j/SPECbatch
                        mkdir -p $clientvmdir/Tile$j/wclient$j/SPECimap
                        mkdir -p $clientvmdir/Tile$j/wclient$j/SPECjAppServer2004
                        mkdir -p $clientvmdir/Tile$j/wclient$j/SPECweb2005

			ssh 192.1.$j.$k "java -version" 1&> $clientvmdir/Tile$j/wclient$j/javaVersion.out

                        mkdir -p $clientvmdir/Tile$j/wclient$j/OS/boot/grub/
                        scp -p 192.1.$j.$k:/boot/grub/grub.conf $clientvmdir/Tile$j/wclient$j/OS/boot/grub/
                        mkdir -p  $clientvmdir/Tile$j/wclient$j/OS/etc/iproute2
                        mkdir -p  $clientvmdir/Tile$j/wclient$j/OS/etc/rc.d/init.d
                        mkdir -p  $clientvmdir/Tile$j/wclient$j/OS/etc/rc.d/rc3.d
                        scp -p 192.1.$j.$k:/etc/iproute2/* $clientvmdir/Tile$j/wclient$j/OS/etc/iproute2/
                        scp -pr 192.1.$j.$k:/etc/rc.d/init.d/* $clientvmdir/Tile$j/wclient$j/OS/etc/rc.d/init.d
                        scp -p 192.1.$j.$k:/etc/rc.d/rc3.d/* $clientvmdir/Tile$j/wclient$j/OS/etc/rc.d/rc3.d
                        scp -p 192.1.$j.$k:/etc/fstab $clientvmdir/Tile$j/wclient$j/OS/etc
                        scp -p 192.1.$j.$k:/etc/hosts $clientvmdir/Tile$j/wclient$j/OS/etc
                        scp -p 192.1.$j.$k:/etc/inittab $clientvmdir/Tile$j/wclient$j/OS/etc
						                      scp -p 192.1.$j.$k:/etc/nsswitch.conf $clientvmdir/Tile$j/wclient$j/OS/etc
                        scp -p 192.1.$j.$k:/etc/sysctl.conf $clientvmdir/Tile$j/wclient$j/OS/etc
                        scp -p 192.1.$j.$k:/etc/rc.local $clientvmdir/Tile$j/wclient$j/OS/etc
                        scp -p 192.1.$j.$k:/etc/bashrc $clientvmdir/Tile$j/wclient$j/OS/etc
                        mkdir -p  $clientvmdir/Tile$j/wclient$j/OS/etc/sysconfig/network-scripts/
                        scp -p 192.1.$j.$k:/etc/sysconfig/network-scripts/ifcfg* $clientvmdir/Tile$j/wclient$j/OS/etc/sysconfig/network-scripts/
                        scp -p 192.1.$j.$k:/etc/sysconfig/network $clientvmdir/Tile$j/wclient$j/OS/etc/sysconfig
                        mkdir -p  $clientvmdir/Tile$j/wclient$j/OS/proc
                        ssh 192.1.$j.$k "cat /proc/cmdline" > $clientvmdir/Tile$j/wclient$j/OS/proc/cmdline
                        ssh 192.1.$j.$k "cat /proc/cpuinfo" > $clientvmdir/Tile$j/wclient$j/OS/proc/cpuinfo
                        ssh 192.1.$j.$k "cat /proc/devices" > $clientvmdir/Tile$j/wclient$j/OS/proc/devices
                        ssh 192.1.$j.$k "cat /proc/meminfo" > $clientvmdir/Tile$j/wclient$j/OS/proc/meminfo
                        ssh 192.1.$j.$k "cat /proc/modules" > $clientvmdir/Tile$j/wclient$j/OS/proc/modules
                        ssh 192.1.$j.$k "cat /proc/mounts" > $clientvmdir/Tile$j/wclient$j/OS/proc/mounts
                        ssh 192.1.$j.$k "cat /proc/partitions" > $clientvmdir/Tile$j/wclient$j/OS/proc/partitions
                        ssh 192.1.$j.$k "cat /proc/swaps" > $clientvmdir/Tile$j/wclient$j/OS/proc/swaps
                        ssh 192.1.$j.$k "cat /proc/version" > $clientvmdir/Tile$j/wclient$j/OS/proc/version

			ssh 192.1.$j.$k "cat  /etc/redhat-release" > $clientvmdir/Tile$j/wclient$j/OS/etc/redhat-release
			ssh 192.1.$j.$k "sysctl -a" > $clientvmdir/Tile$j/wclient$j/OS/sysctl.txt


                        mkdir -p  $clientvmdir/Tile$j/wclient$j/OS/var/log
                        ssh 192.1.$j.$k "dmesg" > $clientvmdir/Tile$j/wclient$j/OS/var/log/dmesg.txt
                        ssh 192.1.$j.$k "chkconfig" > $clientvmdir/Tile$j/wclient$j/OS/chkconfig.txt
                        ssh 192.1.$j.$k "df" > $clientvmdir/Tile$j/wclient$j/OS/df.txt
                        ssh 192.1.$j.$k "ifconfig" > $clientvmdir/Tile$j/wclient$j/OS/ifconfig.txt
                        ssh 192.1.$j.$k "lspci" > $clientvmdir/Tile$j/wclient$j/OS/lspci.txt
                        ssh 192.1.$j.$k "mount -l" > $clientvmdir/Tile$j/wclient$j/OS/mount.txt
                        ssh 192.1.$j.$k "rpm -qa|sort" > $clientvmdir/Tile$j/wclient$j/OS/rpmpkgs.txt



                        scp 192.1.$j.$k:/opt/SPECbatch/Test.config                                                      $clientvmdir/Tile$j/wclient$j/SPECbatch
                        scp 192.1.$j.$k:/opt/SPECimap/IMAP_config.rc                                            $clientvmdir/Tile$j/wclient$j/SPECimap
                        scp 192.1.$j.$k:/opt/SPECjAppServer2004/config/default.env                      $clientvmdir/Tile$j/wclient$j/SPECjAppServer2004
                        scp 192.1.$j.$k:/opt/SPECjAppServer2004/config/run.properties           $clientvmdir/Tile$j/wclient$j/SPECjAppServer2004
                        scp 192.1.$j.$k:/opt/SPECweb2005/Test.config                                            $clientvmdir/Tile$j/wclient$j/SPECweb2005
                        scp 192.1.$j.$k:/opt/SPECweb2005/SPECweb_Support.config                         $clientvmdir/Tile$j/wclient$j/SPECweb2005


                done
    done
    
    i=132
    clientvmdir=data_collection$DATE/PHYS/Clients/Client_phy$i
    vmnum=20
    vmend=27
    for((j=$vmnum;j<=$vmend;j++))
    do
	   for k in $k 7
                do

                        mkdir -p $clientvmdir/Tile$j/client$j
                        mkdir -p $clientvmdir/Tile$j/client$j/OS


                        mkdir -p $clientvmdir/Tile$j/client$j/SPECbatch
                        mkdir -p $clientvmdir/Tile$j/client$j/SPECimap
                        mkdir -p $clientvmdir/Tile$j/client$j/SPECjAppServer2004
                        mkdir -p $clientvmdir/Tile$j/client$j/SPECweb2005

			ssh 192.1.$j.$k "java -version" 1&> $clientvmdir/Tile$j/client$j/javaVersion.out

                        mkdir -p $clientvmdir/Tile$j/client$j/OS/boot/grub/
                        scp -p 192.1.$j.$k:/boot/grub/grub.conf $clientvmdir/Tile$j/client$j/OS/boot/grub/
                        mkdir -p  $clientvmdir/Tile$j/client$j/OS/etc/iproute2
                        mkdir -p  $clientvmdir/Tile$j/client$j/OS/etc/rc.d/init.d
                        mkdir -p  $clientvmdir/Tile$j/client$j/OS/etc/rc.d/rc3.d
                        scp -p 192.1.$j.$k:/etc/iproute2/* $clientvmdir/Tile$j/client$j/OS/etc/iproute2/
                        scp -pr 192.1.$j.$k:/etc/rc.d/init.d/* $clientvmdir/Tile$j/client$j/OS/etc/rc.d/init.d
                        scp -p 192.1.$j.$k:/etc/rc.d/rc3.d/* $clientvmdir/Tile$j/client$j/OS/etc/rc.d/rc3.d
                        scp -p 192.1.$j.$k:/etc/fstab $clientvmdir/Tile$j/client$j/OS/etc
                        scp -p 192.1.$j.$k:/etc/hosts $clientvmdir/Tile$j/client$j/OS/etc
                        scp -p 192.1.$j.$k:/etc/inittab $clientvmdir/Tile$j/client$j/OS/etc
                        scp -p 192.1.$j.$k:/etc/nsswitch.conf $clientvmdir/Tile$j/client$j/OS/etc
                        scp -p 192.1.$j.$k:/etc/sysctl.conf $clientvmdir/Tile$j/client$j/OS/etc
                        scp -p 192.1.$j.$k:/etc/rc.local $clientvmdir/Tile$j/client$j/OS/etc
                        scp -p 192.1.$j.$k:/etc/bashrc $clientvmdir/Tile$j/client$j/OS/etc
                        mkdir -p  $clientvmdir/Tile$j/client$j/OS/etc/sysconfig/network-scripts/
                        scp -p 192.1.$j.$k:/etc/sysconfig/network-scripts/ifcfg* $clientvmdir/Tile$j/client$j/OS/etc/sysconfig/network-scripts/
                        scp -p 192.1.$j.$k:/etc/sysconfig/network $clientvmdir/Tile$j/client$j/OS/etc/sysconfig
                        mkdir -p  $clientvmdir/Tile$j/client$j/OS/proc
                        ssh 192.1.$j.$k "cat /proc/cmdline" > $clientvmdir/Tile$j/client$j/OS/proc/cmdline
                        ssh 192.1.$j.$k "cat /proc/cpuinfo" > $clientvmdir/Tile$j/client$j/OS/proc/cpuinfo
                        ssh 192.1.$j.$k "cat /proc/devices" > $clientvmdir/Tile$j/client$j/OS/proc/devices
                        ssh 192.1.$j.$k "cat /proc/meminfo" > $clientvmdir/Tile$j/client$j/OS/proc/meminfo
                        ssh 192.1.$j.$k "cat /proc/modules" > $clientvmdir/Tile$j/client$j/OS/proc/modules
                        ssh 192.1.$j.$k "cat /proc/mounts" > $clientvmdir/Tile$j/client$j/OS/proc/mounts
                        ssh 192.1.$j.$k "cat /proc/partitions" > $clientvmdir/Tile$j/client$j/OS/proc/partitions
                        ssh 192.1.$j.$k "cat /proc/swaps" > $clientvmdir/Tile$j/client$j/OS/proc/swaps
                        ssh 192.1.$j.$k "cat /proc/version" > $clientvmdir/Tile$j/client$j/OS/proc/version
			ssh 192.1.$j.$k "cat  /etc/redhat-release" >  $clientvmdir/Tile$j/client$j/OS/etc/redhat-release
			ssh 192.1.$j.$k "sysctl -a" >  $clientvmdir/Tile$j/client$j/OS/sysctl.txt

                        mkdir -p  $clientvmdir/Tile$j/client$j/OS/var/log
                        ssh 192.1.$j.$k "dmesg" > $clientvmdir/Tile$j/client$j/OS/var/log/dmesg.txt
                        ssh 192.1.$j.$k "chkconfig" > $clientvmdir/Tile$j/client$j/OS/chkconfig.txt
                        ssh 192.1.$j.$k "df" > $clientvmdir/Tile$j/client$j/OS/df.txt
                        ssh 192.1.$j.$k "ifconfig" > $clientvmdir/Tile$j/client$j/OS/ifconfig.txt
                        ssh 192.1.$j.$k "lspci" > $clientvmdir/Tile$j/client$j/OS/lspci.txt
                        ssh 192.1.$j.$k "mount -l" > $clientvmdir/Tile$j/client$j/OS/mount.txt
                        ssh 192.1.$j.$k "rpm -qa|sort" > $clientvmdir/Tile$j/client$j/OS/rpmpkgs.txt
						
                        scp 192.1.$j.$k:/opt/SPECbatch/Test.config                                                       $clientvmdir/Tile$j/client$j/SPECbatch
                        scp 192.1.$j.$k:/opt/SPECimap/IMAP_config.rc                                             $clientvmdir/Tile$j/client$j/SPECimap
                        scp 192.1.$j.$k:/opt/SPECjAppServer2004/config/default.env                       $clientvmdir/Tile$j/client$j/SPECjAppServer2004
                        scp 192.1.$j.$k:/opt/SPECjAppServer2004/config/run.properties            $clientvmdir/Tile$j/client$j/SPECjAppServer2004
                        scp 192.1.$j.$k:/opt/SPECweb2005/Test.config                                             $clientvmdir/Tile$j/client$j/SPECweb2005
                        scp 192.1.$j.$k:/opt/SPECweb2005/SPECweb_Support.config                          $clientvmdir/Tile$j/client$j/SPECweb2005


                done


                for k in $k 8
                do


                        mkdir -p $clientvmdir/Tile$j/wclient$j
                        mkdir -p $clientvmdir/Tile$j/wclient$j/OS


                        mkdir -p $clientvmdir/Tile$j/wclient$j/SPECbatch
                        mkdir -p $clientvmdir/Tile$j/wclient$j/SPECimap
                        mkdir -p $clientvmdir/Tile$j/wclient$j/SPECjAppServer2004
                        mkdir -p $clientvmdir/Tile$j/wclient$j/SPECweb2005

			ssh 192.1.$j.$k "java -version" 1&> $clientvmdir/Tile$j/wclient$j/javaVersion.out

                        mkdir -p $clientvmdir/Tile$j/wclient$j/OS/boot/grub/
                        scp -p 192.1.$j.$k:/boot/grub/grub.conf $clientvmdir/Tile$j/wclient$j/OS/boot/grub/
                        mkdir -p  $clientvmdir/Tile$j/wclient$j/OS/etc/iproute2
                        mkdir -p  $clientvmdir/Tile$j/wclient$j/OS/etc/rc.d/init.d
                        mkdir -p  $clientvmdir/Tile$j/wclient$j/OS/etc/rc.d/rc3.d
                        scp -p 192.1.$j.$k:/etc/iproute2/* $clientvmdir/Tile$j/wclient$j/OS/etc/iproute2/
                        scp -pr 192.1.$j.$k:/etc/rc.d/init.d/* $clientvmdir/Tile$j/wclient$j/OS/etc/rc.d/init.d
                        scp -p 192.1.$j.$k:/etc/rc.d/rc3.d/* $clientvmdir/Tile$j/wclient$j/OS/etc/rc.d/rc3.d
                        scp -p 192.1.$j.$k:/etc/fstab $clientvmdir/Tile$j/wclient$j/OS/etc
                        scp -p 192.1.$j.$k:/etc/hosts $clientvmdir/Tile$j/wclient$j/OS/etc
                        scp -p 192.1.$j.$k:/etc/inittab $clientvmdir/Tile$j/wclient$j/OS/etc
						                      scp -p 192.1.$j.$k:/etc/nsswitch.conf $clientvmdir/Tile$j/wclient$j/OS/etc
                        scp -p 192.1.$j.$k:/etc/sysctl.conf $clientvmdir/Tile$j/wclient$j/OS/etc
                        scp -p 192.1.$j.$k:/etc/rc.local $clientvmdir/Tile$j/wclient$j/OS/etc
                        scp -p 192.1.$j.$k:/etc/bashrc $clientvmdir/Tile$j/wclient$j/OS/etc
                        mkdir -p  $clientvmdir/Tile$j/wclient$j/OS/etc/sysconfig/network-scripts/
                        scp -p 192.1.$j.$k:/etc/sysconfig/network-scripts/ifcfg* $clientvmdir/Tile$j/wclient$j/OS/etc/sysconfig/network-scripts/
                        scp -p 192.1.$j.$k:/etc/sysconfig/network $clientvmdir/Tile$j/wclient$j/OS/etc/sysconfig
                        mkdir -p  $clientvmdir/Tile$j/wclient$j/OS/proc
                        ssh 192.1.$j.$k "cat /proc/cmdline" > $clientvmdir/Tile$j/wclient$j/OS/proc/cmdline
                        ssh 192.1.$j.$k "cat /proc/cpuinfo" > $clientvmdir/Tile$j/wclient$j/OS/proc/cpuinfo
                        ssh 192.1.$j.$k "cat /proc/devices" > $clientvmdir/Tile$j/wclient$j/OS/proc/devices
                        ssh 192.1.$j.$k "cat /proc/meminfo" > $clientvmdir/Tile$j/wclient$j/OS/proc/meminfo
                        ssh 192.1.$j.$k "cat /proc/modules" > $clientvmdir/Tile$j/wclient$j/OS/proc/modules
                        ssh 192.1.$j.$k "cat /proc/mounts" > $clientvmdir/Tile$j/wclient$j/OS/proc/mounts
                        ssh 192.1.$j.$k "cat /proc/partitions" > $clientvmdir/Tile$j/wclient$j/OS/proc/partitions
                        ssh 192.1.$j.$k "cat /proc/swaps" > $clientvmdir/Tile$j/wclient$j/OS/proc/swaps
                        ssh 192.1.$j.$k "cat /proc/version" > $clientvmdir/Tile$j/wclient$j/OS/proc/version
			ssh 192.1.$j.$k "cat  /etc/redhat-release" > $clientvmdir/Tile$j/wclient$j/OS/etc/redhat-release
			ssh 192.1.$j.$k "sysctl -a" > $clientvmdir/Tile$j/wclient$j/OS/sysctl.txt

                        mkdir -p  $clientvmdir/Tile$j/wclient$j/OS/var/log
                        ssh 192.1.$j.$k "dmesg" > $clientvmdir/Tile$j/wclient$j/OS/var/log/dmesg.txt
                        ssh 192.1.$j.$k "chkconfig" > $clientvmdir/Tile$j/wclient$j/OS/chkconfig.txt
                        ssh 192.1.$j.$k "df" > $clientvmdir/Tile$j/wclient$j/OS/df.txt
                        ssh 192.1.$j.$k "ifconfig" > $clientvmdir/Tile$j/wclient$j/OS/ifconfig.txt
                        ssh 192.1.$j.$k "lspci" > $clientvmdir/Tile$j/wclient$j/OS/lspci.txt
                        ssh 192.1.$j.$k "mount -l" > $clientvmdir/Tile$j/wclient$j/OS/mount.txt
                        ssh 192.1.$j.$k "rpm -qa|sort" > $clientvmdir/Tile$j/wclient$j/OS/rpmpkgs.txt



                        scp 192.1.$j.$k:/opt/SPECbatch/Test.config                                                      $clientvmdir/Tile$j/wclient$j/SPECbatch
                        scp 192.1.$j.$k:/opt/SPECimap/IMAP_config.rc                                            $clientvmdir/Tile$j/wclient$j/SPECimap
                        scp 192.1.$j.$k:/opt/SPECjAppServer2004/config/default.env                      $clientvmdir/Tile$j/wclient$j/SPECjAppServer2004
                        scp 192.1.$j.$k:/opt/SPECjAppServer2004/config/run.properties           $clientvmdir/Tile$j/wclient$j/SPECjAppServer2004
                        scp 192.1.$j.$k:/opt/SPECweb2005/Test.config                                            $clientvmdir/Tile$j/wclient$j/SPECweb2005
                        scp 192.1.$j.$k:/opt/SPECweb2005/SPECweb_Support.config                         $clientvmdir/Tile$j/wclient$j/SPECweb2005


                done

    done
                          
}

#SUT configure
fn_getSUTInfo()
{
    SUTphydir=data_collection$DATE/PHYS/SUT


    mkdir -p $SUTphydir/OS
    mkdir -p $SUTphydir/SOFTW
    mkdir -p $SUTphydir/Storage
    mkdir -p $SUTphydir/Network

#    mkdir -p $SUTphydir/createvm
    #cp /root/tools/2288HV3/vhost_xml/1-define.sh $SUTphydir/createvm/
    #cp /root/tools/2288HV3/vhost_xml/2-start.sh $SUTphydir/createvm/
#    mkdir -p $SUTphydir/vmconfig
#    for((l=1;l<=$1;l++))
#    do
#    rest=$[$l%4] 
#    if [ "$rest" -eq 1 ]; then
#	     for i in infra batch app mail web db; do  virsh dumpxml ${i}${l} > $SUTphydir/vmconfig/2288HV3-${i}-${l}.xml; done       
#    else
#	     for i in infra batch app mail web; do  virsh dumpxml ${i}${l} > $SUTphydir/vmconfig/2288HV3-${i}-${l}.xml; done
#    fi 
#cp -r /root/tools/2288HV3/vhost_xml/Tile$l/* $SUTphydir/vmconfig/Tile$l/
#    done
    mkdir -p $SUTphydir/OS/boot/grub/
    cp /boot/grub2/grub.cfg $SUTphydir/OS/boot/grub/
    mkdir -p  $SUTphydir/OS/etc
    cp /etc/sysctl.conf $SUTphydir/OS/etc
    cp /etc/hostname $SUTphydir/OS/etc
    mkdir -p  $SUTphydir/OS/etc/sysconfig/network
    cp /etc/sysconfig/network-scripts/ifcfg* $SUTphydir/OS/etc/sysconfig/network
    mkdir -p  $SUTphydir/OS/etc/init.d/
    cp -r /etc/init.d/* $SUTphydir/OS/etc/init.d
    cp /etc/bashrc $SUTphydir/OS/etc
    cp /etc/profile $SUTphydir/OS/etc
    du -a /etc | awk '{print $2}' > $SUTphydir/OS/etc/directorytree
    mkdir -p  $SUTphydir/OS/proc
    cat /proc/cmdline > $SUTphydir/OS/proc/cmdline
    cat /proc/cpuinfo > $SUTphydir/OS/proc/cpuinfo
    cat /proc/devices > $SUTphydir/OS/proc/devices
    cat /proc/meminfo > $SUTphydir/OS/proc/meminfo
    cat /proc/modules > $SUTphydir/OS/proc/modules
    cat /proc/partitions > $SUTphydir/OS/proc/partitions
    cat /proc/swaps  > $SUTphydir/OS/proc/swaps
    cat /proc/version > $SUTphydir/OS/proc/version

    mkdir -p  $SUTphydir/OS/var/log
    dmesg > $SUTphydir/OS/var/log/dmesg.txt
    chkconfig > $SUTphydir/OS/chkconfig.txt
    rpm -qa|sort > $SUTphydir/OS/rpmpkgs.txt
    lspci > $SUTphydir/OS/lspci.txt
    systemctl list-unit-files > $SUTphydir/OS/systemctl.txt


    brctl show > $SUTphydir/Network/brctl-show.txt
    ifconfig >  $SUTphydir/Network/ifconfig.txt
    route -n >  $SUTphydir/Network/route.txt


    lvdisplay > $SUTphydir/Storage/lvdisplay.txt
    df > $SUTphydir/Storage/df.txt
    mount -l > $SUTphydir/Storage/mount.txt
    vgdisplay > $SUTphydir/Storage/vgdisplay.txt
    scp -p 192.1.1.7:/opt/SPECvirt/3-setMTU.sh $SUTphydir/OS/setmtu.sh
    scp -p /mnt/sdc/xfb/5-perform/resetnice.sh $SUTphydir/OS/resetnice.sh

    virsh list |grep running  > $SUTphydir/SOFTW/virsh-list.txt
#    ps -ef | grep qemu-kvm > $SUTphydir/SOFTW/running-vms.txt
    ps -eLlfww | grep -E 'qemu|PID' | grep -v grep >$SUTphydir/SOFTW/running-vms.txt

    mkdir -p $SUTphydir/VM-xml/
#    scp -r /etc/libvirt/qemu/*xml $SUTphydir/SOFTW/VM-xml/

    for n in `virsh list --all |grep runn | awk '{print $2}'`
	do
		virsh dumpxml $n > $SUTphydir/VM-xml/$n.xml
	done


}
#SUT VM configure
fn_getSUTVMInfo()
{
    for((i=1;i<=$1;i++))
    do
        appsoftdir=data_collection$DATE/VIRT/Tile$i/app/SOFTW
        mkdir -p $appsoftdir
        mkdir -p $appsoftdir/AppSrv01
        mkdir -p $appsoftdir/AppSrv02
        mkdir -p $appsoftdir/SPECjAppServer2004/config
        mkdir -p $appsoftdir/WebSphere-setup
	ssh 192.1.$i.4 "/opt/IBM/WebSphere/AppServer/java_1.7_64/bin/java -version" 1&> $appsoftdir/javaVersion.out 


	scp -p 192.1.$i.4:/opt/IBM/WebSphere/AppServer/profiles/AppSrv01/config/cells/appserver${i}Node01Cell/nodes/appserver${i}Node01/node-metadata.properties $appsoftdir/AppSrv01
	scp -p 192.1.$i.4:/opt/IBM/WebSphere/AppServer/profiles/AppSrv01/config/cells/appserver${i}Node01Cell/nodes/appserver${i}Node01/resources.xml $appsoftdir/AppSrv01
	scp -p 192.1.$i.4:/opt/IBM/WebSphere/AppServer/profiles/AppSrv01/config/cells/appserver${i}Node01Cell/nodes/appserver${i}Node01/servers/server1/server.xml $appsoftdir/AppSrv01
	scp -p 192.1.$i.4:/opt/IBM/WebSphere/AppServer/profiles/AppSrv01/config/cells/appserver${i}Node01Cell/nodes/appserver${i}Node01/serverindex.xml $appsoftdir/AppSrv01
	scp -p 192.1.$i.4:/opt/IBM/WebSphere/AppServer/profiles/AppSrv01/config/cells/appserver${i}Node01Cell/nodes/appserver${i}Node01/servers/server1/sib-engines.xml $appsoftdir/AppSrv01
	scp -p 192.1.$i.4:/opt/IBM/WebSphere/AppServer/profiles/AppSrv02/config/cells/appserver${i}Node02Cell/nodes/appserver${i}Node02/node-metadata.properties $appsoftdir/AppSrv02 
	scp -p 192.1.$i.4:/opt/IBM/WebSphere/AppServer/profiles/AppSrv02/config/cells/appserver${i}Node02Cell/nodes/appserver${i}Node02/resources.xml $appsoftdir/AppSrv02 
	scp -p 192.1.$i.4:/opt/IBM/WebSphere/AppServer/profiles/AppSrv02/config/cells/appserver${i}Node02Cell/nodes/appserver${i}Node02/servers/server1/server.xml $appsoftdir/AppSrv02 
	scp -p 192.1.$i.4:/opt/IBM/WebSphere/AppServer/profiles/AppSrv02/config/cells/appserver${i}Node02Cell/nodes/appserver${i}Node02/serverindex.xml $appsoftdir/AppSrv02 
	scp -p 192.1.$i.4:/opt/IBM/WebSphere/AppServer/profiles/AppSrv02/config/cells/appserver${i}Node02Cell/nodes/appserver${i}Node02/servers/server1/sib-engines.xml $appsoftdir/AppSrv02 


	scp -p 192.1.$i.4:/opt/SPECjAppServer2004/config/agent.properties $appsoftdir/SPECjAppServer2004/config
	scp -p 192.1.$i.4:/opt/SPECjAppServer2004/config/charts.properties $appsoftdir/SPECjAppServer2004/config
	scp -p 192.1.$i.4:/opt/SPECjAppServer2004/config/corpdb.properties $appsoftdir/SPECjAppServer2004/config
	scp -p 192.1.$i.4:/opt/SPECjAppServer2004/config/websphere.env     $appsoftdir/SPECjAppServer2004/config
	scp -p 192.1.$i.4:/opt/SPECjAppServer2004/config/mfgdb.properties $appsoftdir/SPECjAppServer2004/config
	scp -p 192.1.$i.4:/opt/SPECjAppServer2004/config/ordsdb.properties $appsoftdir/SPECjAppServer2004/config
	scp -p 192.1.$i.4:/opt/SPECjAppServer2004/config/run.properties $appsoftdir/SPECjAppServer2004/config
	scp -p 192.1.$i.4:/opt/SPECjAppServer2004/config/suppdb.properties $appsoftdir/SPECjAppServer2004/config
	scp -p 192.1.$i.4:/opt/SPECjAppServer2004/config/utildb.properties $appsoftdir/SPECjAppServer2004/config
	scp -p 192.1.$i.4:/opt/SPECjAppServer2004/config/default.env $appsoftdir/SPECjAppServer2004/config

	scp -p 192.1.$i.4:/opt/IBM/WebSphere/specj04_setup.jacl  $appsoftdir/WebSphere-setup
	scp -p 192.1.$i.4:/opt/IBM/WebSphere/specj04_resource_scripts.jacl  $appsoftdir/WebSphere-setup
	scp -p 192.1.$i.4:/opt/IBM/WebSphere/SupplierEmulator.ear  $appsoftdir/WebSphere-setup
	scp -p 192.1.$i.4:/opt/IBM/WebSphere/SPECjAppServer.ear  $appsoftdir/WebSphere-setup

        
        batchsoftdir=data_collection$DATE/VIRT/Tile$i/batch/SOFTW
        mkdir -p $batchsoftdir
        mkdir -p $batchsoftdir/SPECbatch/cpu2006
	scp -p 192.1.$i.6:/opt/SPECbatch/Test.config $batchsoftdir/SPECbatch/cpu2006
	scp -p 192.1.$i.6:/opt/SPECbatch/virt_sc2013_run.sh  $batchsoftdir/SPECbatch/cpu2006
	scp -p 192.1.$i.6:/opt/SPECbatch/cpu2006-virt/config/cpu2006-virt.cfg $batchsoftdir/SPECbatch/cpu2006
	ssh 192.1.$i.6 "java -version" 1&> $batchsoftdir/javaVersion.out
        
        infrasoftdir=data_collection$DATE/VIRT/Tile$i/infra/SOFTW
        mkdir -p $infrasoftdir/httpd
        scp -p 192.1.$i.1:/etc/exports $infrasoftdir
        scp -p 192.1.$i.1:/etc/httpd/conf/httpd.conf $infrasoftdir
	ssh 192.1.$i.1 "java -version" 1&> $infrasoftdir/javaVersion.out
        ssh 192.1.$i.1 "httpd -V" >$infrasoftdir/httpd/httpdVersion.out
        ssh 192.1.$i.1 "sum /var/www/fcgi-bin/besim_fcgi.fcgi" > $infrasoftdir/sum.besim_fcgi
        ssh 192.1.$i.1 "ldd /var/www/fcgi-bin/besim_fcgi.fcgi" > $infrasoftdir/ldd.besim_fcgi
 
        mailsoftdir=data_collection$DATE/VIRT/Tile$i/mail/SOFTW
        mkdir -p $mailsoftdir/SPECimap
        scp 192.1.$i.3:/var/run/dovecot/dovecot.conf $mailsoftdir
        ssh 192.1.$i.3 "java -version" 1&> $mailsoftdir/javaVersion.out
        ssh 192.1.$i.3 "cd /opt/SPECimap/;tar cf - {IMAP_config.rc,IMAP_fixed.rc}" 2>/dev/null | tar xvf - -C $mailsoftdir/SPECimap
        ssh 192.1.$i.3 "dovecot --version" > $mailsoftdir/dovecotVersion.out
        ssh 192.1.$i.3 "dovecot --build-options" >> $mailsoftdir/dovecotVersion.out 

        websoftdir=data_collection$DATE/VIRT/Tile$i/web/SOFTW
        mkdir -p $websoftdir
        mkdir -p $websoftdir/SPECweb2005
        scp -p 192.1.$i.2:/opt/SPECweb2005/Test.config $websoftdir/SPECweb2005
        scp -p 192.1.$i.2:/opt/SPECweb2005/SPECweb_Support.config $websoftdir/SPECweb2005
        scp -p 192.1.$i.2:/etc/php.ini $websoftdir
        mkdir -p $websoftdir/nginx
        mkdir -p $websoftdir/nginx/conf.d
        ssh 192.1.$i.2 "nginx -V " 2>&1 | tee $websoftdir/nginx/nginxVersion
        scp -p 192.1.$i.2:/etc/nginx/nginx.conf $websoftdir/nginx/
        scp -p 192.1.$i.2:/etc/nginx/conf.d/default.conf $websoftdir/nginx/conf.d/
        scp -p 192.1.$i.2:/etc/nginx/conf.d/example_ssl.conf $websoftdir/nginx/conf.d/
        mkdir -p $websoftdir/php-fpm
        mkdir -p $websoftdir/php-fpm/php-fpm.d
        scp -p 192.1.$i.2:/etc/php-fpm.conf $websoftdir/php-fpm/
        scp -p 192.1.$i.2:/etc/php-fpm.d/www.conf $websoftdir/php-fpm/php-fpm.d/
        ssh 192.1.$i.2 "php-fpm -v" 1&> $websoftdir/php-fpm/php-fpmVersion 
	ssh 192.1.$i.2 "java -version" 1&> $websoftdir/javaVersion.out
        
        for((j=1;j<=6;j++))
        do	
            if [ $j == 1 ];then
                vmdir=data_collection$DATE/VIRT/Tile$i/infra/OS
            fi
            if [ $j == 2 ];then
                vmdir=data_collection$DATE/VIRT/Tile$i/web/OS
            fi
            if [ $j == 3 ];then
                vmdir=data_collection$DATE/VIRT/Tile$i/mail/OS
            fi
            if [ $j == 4 ];then
                vmdir=data_collection$DATE/VIRT/Tile$i/app/OS
            fi
            if [ $j == 5 ];then
	        continue
            fi
            if [ $j == 6 ];then
                vmdir=data_collection$DATE/VIRT/Tile$i/batch/OS
            fi
            mkdir -p  $vmdir/var/log
            ssh 192.1.$i.$j "dmesg" >  $vmdir/var/log/dmesg.txt
            mkdir -p $vmdir/boot/grub/
            scp -p 192.1.$i.$j:/boot/grub/grub.conf $vmdir/boot/grub/
            mkdir -p  $vmdir/etc/iproute2
            mkdir -p  $vmdir/etc/rc.d/init.d
            mkdir -p  $vmdir/etc/rc.d/rc3.d
            scp -p 192.1.$i.$j:/etc/iproute2/* $vmdir/etc/iproute2/
            scp -pr 192.1.$i.$j:/etc/rc.d/init.d/* $vmdir/etc/rc.d/init.d
            scp -p 192.1.$i.$j:/etc/rc.d/rc3.d/* $vmdir/etc/rc.d/rc3.d
            scp -p 192.1.$i.$j:/etc/fstab $vmdir/etc
            scp -p 192.1.$i.$j:/etc/hosts $vmdir/etc
            scp -p 192.1.$i.$j:/etc/inittab $vmdir/etc
            scp -p 192.1.$i.$j:/etc/nsswitch.conf $vmdir/etc
            scp -p 192.1.$i.$j:/etc/sysctl.conf $vmdir/etc
            scp -p 192.1.$i.$j:/etc/rc.local $vmdir/etc
            scp -p 192.1.$i.$j:/etc/bashrc $vmdir/etc
            mkdir -p  $vmdir/etc/sysconfig/network-scripts/
            scp -p 192.1.$i.$j:/etc/sysconfig/network-scripts/ifcfg* $vmdir/etc/sysconfig/network-scripts
            scp -p 192.1.$i.$j:/etc/sysconfig/network $vmdir/etc/sysconfig
	    mkdir -p $vmdir/etc/modprobe.d
	    scp -p 192.1.$i.$j:/etc/modprobe.d/ixgbevf.conf $vmdir/etc/modprobe.d/
            mkdir -p  $vmdir/proc
            ssh 192.1.$i.$j "cat /proc/cmdline" > $vmdir/proc/cmdline
            ssh 192.1.$i.$j "cat /proc/cpuinfo" > $vmdir/proc/cpuinfo
            ssh 192.1.$i.$j "cat /proc/devices" > $vmdir/proc/devices
            ssh 192.1.$i.$j "cat /proc/meminfo" > $vmdir/proc/meminfo
            ssh 192.1.$i.$j "cat /proc/modules" > $vmdir/proc/modules
            ssh 192.1.$i.$j "cat /proc/mounts" > $vmdir/proc/mounts
            ssh 192.1.$i.$j "cat /proc/partitions" > $vmdir/proc/partitions
            ssh 192.1.$i.$j "cat /proc/swaps" > $vmdir/proc/swaps
            #ssh 192.1.$i.$j "cat /proc/version" > $vmdir/proc/version
            ssh 192.1.$i.$j "chkconfig" > $vmdir/chkconfig.txt
            ssh 192.1.$i.$j "df" > $vmdir/df.txt
            ssh 192.1.$i.$j "ifconfig" > $vmdir/ifconfig.txt
            ssh 192.1.$i.$j "lspci" > $vmdir/lspci.txt
            ssh 192.1.$i.$j "mount -l" > $vmdir/mount.txt
	    ssh 192.1.$i.$j "cat /proc/version" >  $vmdir/proc/version
	    ssh 192.1.$i.$j "cat /etc/redhat-release" > $vmdir/etc/redhat-release
            ssh 192.1.$i.$j "sysctl -a" > $vmdir/sysctl.txt 

	   if [ $j == 1 ];then
		ssh 192.1.$i.1 "rpm -qa|sort" > $vmdir/rpmpkgs.txt
            fi
            if [ $j == 2 ];then
		ssh 192.1.$i.2 "rpm -qa|sort" > $vmdir/rpmpkgs.txt
            fi
            if [ $j == 3 ];then
		ssh 192.1.$i.3 "rpm -qa|sort" > $vmdir/rpmpkgs.txt
            fi
            if [ $j == 4 ];then
		ssh 192.1.$i.4 "rpm -qa|sort" > $vmdir/rpmpkgs.txt

            fi
            if [ $j == 5 ];then
                continue
            fi
            if [ $j == 6 ];then
		ssh 192.1.$i.6 "rpm -qa|sort" >  $vmdir/rpmpkgs.txt
            fi

            ssh 192.1.$i.$j "tuned-adm active" > $vmdir/tuned-adm-active.txt
	    mkdir -p  $vmdir/etc/security
	    scp -p 192.1.$i.$j:/etc/security/limits.conf  $vmdir/etc/security/
        done
    done
    for((i=1;i<=$1;))
    do
        dbsoftdir=data_collection$DATE/VIRT/Tile$i/db/SOFTW
        mkdir -p $dbsoftdir
	mkdir -p $dbsoftdir/schema
        scp -pr 192.1.$i.5:/opt/SPECjAppServer2004/schema/db2/* $dbsoftdir/schema/
        ssh  db2inst1@192.1.$i.5 "db2 get db cfg for specdb"> $dbsoftdir/db2.db.cfg
        ssh  db2inst1@192.1.$i.5 "db2 get dbm cfg" > $dbsoftdir/db2.dbm.cfg
        ssh  db2inst1@192.1.$i.5 "db2set" > $dbsoftdir/db2set.txt
        scp  -p 192.1.$i.5:/home/db2inst1/sqllib/db2nodes.cfg  $dbsoftdir/db2nodes.cfg
	ssh 192.1.$i.5 "java -version" 1&> $dbsoftdir/javaVersion.out
	scp -p 192.1.$i.5:/dbstore/tbautotune.sh $dbsoftdir/tune-restore.sh


	vmdir=data_collection$DATE/VIRT/Tile$i/db/OS
        mkdir -p  $vmdir/var/log
        ssh 192.1.$i.5 "dmesg" >  $vmdir/var/log/dmesg.txt
        mkdir -p $vmdir/boot/grub/
        scp -p 192.1.$i.5:/boot/grub/grub.conf $vmdir/boot/grub/
        mkdir -p  $vmdir/etc/iproute2
        mkdir -p  $vmdir/etc/rc.d/init.d
        mkdir -p  $vmdir/etc/rc.d/rc3.d
        scp -p 192.1.$i.5:/etc/iproute2/* $vmdir/etc/iproute2/
        scp -pr 192.1.$i.5:/etc/rc.d/init.d/* $vmdir/etc/rc.d/init.d
        scp -p 192.1.$i.5:/etc/rc.d/rc3.d/* $vmdir/etc/rc.d/rc3.d
        scp -p 192.1.$i.5:/etc/fstab $vmdir/etc
        scp -p 192.1.$i.5:/etc/hosts $vmdir/etc
        scp -p 192.1.$i.5:/etc/inittab $vmdir/etc
        scp -p 192.1.$i.5:/etc/nsswitch.conf $vmdir/etc
        scp -p 192.1.$i.5:/etc/sysctl.conf $vmdir/etc
        scp -p 192.1.$i.5:/etc/rc.local $vmdir/etc
        scp -p 192.1.$i.5:/etc/bashrc $vmdir/etc
        mkdir -p  $vmdir/etc/sysconfig/network-scripts/
        scp -p 192.1.$i.5:/etc/sysconfig/network-scripts/ifcfg* $vmdir/etc/sysconfig/network-scripts
        scp -p 192.1.$i.5:/etc/sysconfig/network $vmdir/etc/sysconfig
        mkdir -p $vmdir/etc/modprobe.d
        scp -p 192.1.$i.$j:/etc/modprobe.d/ixgbevf.conf $vmdir/etc/modprobe.d/
        mkdir -p  $vmdir/proc
        ssh 192.1.$i.5 "cat /proc/cmdline" > $vmdir/proc/cmdline
        ssh 192.1.$i.5 "cat /proc/cpuinfo" > $vmdir/proc/cpuinfo
        ssh 192.1.$i.5 "cat /proc/devices" > $vmdir/proc/devices
        ssh 192.1.$i.5 "cat /proc/meminfo" > $vmdir/proc/meminfo
        ssh 192.1.$i.5 "cat /proc/modules" > $vmdir/proc/modules
        ssh 192.1.$i.5 "cat /proc/mounts" > $vmdir/proc/mounts
        ssh 192.1.$i.5 "cat /proc/partitions" > $vmdir/proc/partitions
        ssh 192.1.$i.5 "cat /proc/swaps" > $vmdir/proc/swaps
        ssh 192.1.$i.5 "cat /proc/version" > $vmdir/proc/version
	ssh 192.1.$i.5 "cat /etc/redhat-release" > $vmdir/etc/redhat-release
	ssh 192.1.$i.5 "sysctl -a" > $vmdir/sysctl.txt

        ssh 192.1.$i.5 "chkconfig" > $vmdir/chkconfig.txt
        ssh 192.1.$i.5 "df" > $vmdir/df.txt
        ssh 192.1.$i.5 "ifconfig" > $vmdir/ifconfig.txt
        ssh 192.1.$i.5 "lspci" > $vmdir/lspci.txt
        ssh 192.1.$i.5 "mount -l" > $vmdir/mount.txt
        ssh 192.1.$i.5  "rpm -qa|sort" > $vmdir/rpmpkgs.txt
        mkdir -p  $vmdir/etc/security
	scp -p 192.1.$i.5:/etc/security/limits.conf  $vmdir/etc/security/

        i=$((i+4))
    done
}

fn_main()
{
    date > data_collection$DATE/data-collection-start.txt
    
    mkdir -p data_collection$DATE/Collection_scripts
    cp -p collect-data.sh data_collection$DATE/Collection_scripts
    fn_getClientInfo
    fn_getSUTInfo 27 
    fn_getSUTVMInfo 27
    date > data_collection$DATE/data-collection-end.txt

}
fn_main

