#
# $Id: collect_data_kvm.sh 15 2011-04-18 12:06:42Z robert.wen@hp.com $
#
# data collection script for SPECvirt_sc2013 under KVM
#
# TODO:
# handle physical client with no vclient with a graceful way
#
set -x

OUTPUT_DIR=/tmp/data-collection
CONFIG=/opt/SPECvirt/collect_data.cfg
#DC_SCRIPT="/opt/SPECvirt/collect_data_kvm.sh"
DC_SCRIPT=$0


# temp settings
SCRIPT_REMOTE=/tmp/collect_data_kvm.sh
BASEDIR_SYS=/tmp/data-collection-sys
BASEDIR_SW=/tmp/data-collection-sw

if echo "$0" | grep -q '^\/.*'
then
    SCRIPT_LOCAL="$0"
else
    SCRIPT_LOCAL="$(pwd)/$0"
fi

sanity_check()
{
    data_collect_log "Checking hostname..." 3
    ping_host "sut"

    for client in $(gen_list $PHYCLIENT_LIST)
    do
        ping_host "phyclient${client}"
    done

    for tile in $(seq $TILE_LIST)
    do
        ping_host "client${tile}" 
        ping_host "wclient${tile}" 

        vmlist="appserver batchserver infraserver mailserver webserver"
        rest=$[$tile%4]
        if [ "$rest" -eq 1 ]; then
            vmlist="$vmlist dbserver"
        fi

        for host in $vmlist
        do
            ping_host "${host}${tile}"
        done
    done

    return 0;
}

ping_host()
{
    local host="$1"
    echo ${host}
    if ! ping -w2 -c1 ${host} &>/dev/null
    then
        data_collect_log "${host} not pingable. Please check /etc/hosts!" 2
        exit 2
    fi
}

#
# not used yet
#
setup_host_key()
{
    local CLIENT="$1"
    local PASS="$2"

    expect <<ENDEXP
spawn ssh-copy-id -i /root/.ssh/id_rsa.pub root@${CLIENT}
expect "*?assword:*"
send -- "${PASS}\r"
send -- "\r"
expect eof
ENDEXP
}

#
# this will setup the key auth
#
prepare_run_env()
{
    setup_host_key sut

    for client in $(gen_list $PHYCLIENT_LIST)
    do
        setup_host_key "phyclient${client}"
    done

    for tile in $(seq $TILE_LIST)
    do
        setup_host_key "client${tile}" 

        vmlist="appserver batchserver infraserver mailserver webserver"
        rest=$[$tile%4]
        if [ "$rest" -eq 1 ]; then
            vmlist="$vmlist dbserver"
        fi

        for host in $vmlist
        do
            setup_host_key "${host}${tile}"
        done
    done
echo "hi"
}

build_dir_tree()
{
    while read DIR
    do
        mkdir -p $DIR
    done <<ENDLINE
./VIRT
./PHYS
./PHYS/SUT
./PHYS/SUT/vm-xml
./PHYS/Clients
./Collection_scripts
ENDLINE
}

data_collect_log()
{
    local text="$1"
    local class="$2"
    shift 2

    if [ "$class" = "2" ]
    then
        echo "$text" 1>&2
    elif [ "$class" = "3" ]
    then
        echo $* "$text"
    fi

    echo "$(date "+%b %d %Y %T") $text" >> $OUTPUT_DIR/data-collection.log
}

gen_list()
{
    local IFS=","
    local LIST="$1"

    for i in $LIST
    do
        if echo $i | grep -q '^[0-9]*-[0-9]*$'
        then
            seq ${i%-*} ${i#*-}
        else
            echo $i
        fi
    done
}

collect_proc_info()
{
    local procfile="$1"
    if [ ! -e "$procfile" ]
    then
        return 1
    fi

    local DIR=$(dirname $procfile)
    local FILE=$(basename $procfile)

    DIR=${DIR#/}
    mkdir -p "$DIR" &>/dev/null

    if [ $? -ne 0 ]
    then
        return 1
    fi

    cat $procfile > "$DIR/$FILE"
}

collect_sys_info_sut()
{
#
    mkdir OS SOFTW Storage Network
# hw and device info
     
    lspci > OS/lspci.txt


# os info
#    hostname > hostname.txt

# network
    ifconfig > Network/ifconfig.txt
    route -n > Network/route.txt
    brctl show > Network/brctl.txt 

# storage and filesystem
    collect_proc_info "/proc/partitions"
    vgdisplay -v > Storage/vgdisplay.txt 2>/dev/null
    lvdisplay > Storage/lvdisplay.txt 2>/dev/null
    mount > Storage/mount.txt
    df > Storage/df.txt

# packages and service
    rpm -qa > OS/rpmpkgs.txt
    systemctl list-unit-files > OS/systemctl.list-unit-files.txt
    chkconfig -list >OS/chkconfig.txt
    #tuned-adm active > tuned-adm.txt
# runtime info
    ps -eLlf | grep qemu-system > SOFTW/running-vms.txt
    virsh list > SOFTW/virsh-list.txt

# proc info
    collect_proc_info "/proc/cpuinfo"
    collect_proc_info "/proc/devices"
    collect_proc_info "/proc/meminfo"
    collect_proc_info "/proc/modules"
    collect_proc_info "/proc/swaps"
    collect_proc_info "/proc/version"
    collect_proc_info "/proc/cmdline"

#/usr/lib/systemd/system/multi-user.target.wants \
#/etc/libvirt/qemu/sv13-*  \
# other static configuration and logs
    find /etc/fstab \
/etc/SuSE-release \
/etc/iproute2 \
/etc/hosts \
/etc/inittab \
/etc/sysctl.conf \
/usr/lib/sysctl.d/specvirt.conf	\
/etc/nsswitch.conf \
/etc/kvm \
/etc/sysconfig/network/ifcfg-* \
/etc/modprobe.d/ixgbe.conf \
/etc/modprobe.d/blacklist.conf \
/etc/security/limits.conf \
/etc/rc.d/boot.local \
/etc/rc.d/init.d \
/etc/rc.d/rc3.d \
/opt/common_scripts/ostune_misc.sh	\
/opt/common_scripts/update_udev_rules_net.sh \
/var/log/dmesg \
/boot/grub*/grub.{conf,cfg}	\
/etc/bashrc		\
/etc/exports		\
/etc/rc.d/rc.local	\
/etc/tune-profiles/active-profile	\
2>/dev/null | cpio -o 2>/dev/null | cpio -idm --no-absolute-filenames &>/dev/null
mv var opt etc boot proc usr OS/
# clear zero size file
find . -size 0 -exec rm -f {} \;

}

collect_sys_info_phylient()
{
    mkdir OS SOFTW
# hw and device info
     
    lspci > OS/lspci.txt


# os info
#    hostname > hostname.txt

# network
    ifconfig > OS/ifconfig.txt
    route -n > OS/route.txt
    brctl show > OS/brctl.txt 

# storage and filesystem
    collect_proc_info "/proc/partitions"
    vgdisplay -v > OS/vgdisplay.txt 2>/dev/null
    lvdisplay > OS/lvdisplay.txt 2>/dev/null
    mount > OS/mount.txt
    df > OS/df.txt

# packages and service
    rpm -qa > OS/rpmpkgs.txt
    #systemctl list-unit-files > OS/systemctl.txt
    systemctl list-unit-files > OS/systemctl.list-unit-files.txt
    chkconfig -list >OS/chkconfig.txt
    #tuned-adm active > tuned-adm.txt
# runtime info
    ps -eLlf | grep qemu-system > SOFTW/running-vms.txt
    virsh list > SOFTW/virsh-list.txt

# proc info
    collect_proc_info "/proc/cpuinfo"
    collect_proc_info "/proc/devices"
    collect_proc_info "/proc/meminfo"
    collect_proc_info "/proc/modules"
    collect_proc_info "/proc/swaps"
    collect_proc_info "/proc/version"
    collect_proc_info "/proc/cmdline"

#/usr/lib/systemd/system/multi-user.target.wants \
#/etc/libvirt/qemu/sv13-*  \
# other static configuration and logs
    find /etc/fstab \
/etc/SuSE-release \
/etc/iproute2 \
/etc/hosts \
/etc/inittab \
/etc/sysctl.conf \
/usr/lib/sysctl.d/specvirt.conf	\
/etc/nsswitch.conf \
/etc/kvm \
/etc/sysconfig/network/ifcfg-* \
/etc/modprobe.d/ixgbe.conf \
/etc/security/limits.conf \
/etc/rc.d/init.d \
/etc/rc.d/rc3.d \
/opt/common_scripts/ostune_misc.sh	\
/opt/common_scripts/update_udev_rules_net.sh \
/var/log/dmesg \
/boot/grub*/grub.{conf,cfg}	\
/etc/bashrc		\
/etc/exports		\
/etc/rc.d/rc.local	\
/etc/tune-profiles/active-profile	\
2>/dev/null | cpio -o 2>/dev/null | cpio -idm --no-absolute-filenames &>/dev/null
mv opt etc boot proc usr var OS/
# clear zero size file
find . -size 0 -exec rm -f {} \;

}

collect_sys_info_vm()
{

# hw and device info
    lspci > lspci.txt

# os info
#    hostname > hostname.txt

# network
    ifconfig > ifconfig.txt
    route -n > route.txt
    #brctl show > brctl.txt 

# storage and filesystem
    collect_proc_info "/proc/partitions"
    vgdisplay -v >vgdisplay.txt 2>/dev/null
    lvdisplay > lvdisplay.txt 2>/dev/null
    mount > mount.txt
    df > df.txt

# packages and service
    rpm -qa > rpmpkgs.txt
    chkconfig --list > chkconfig.txt
    #tuned-adm active > tuned-adm.txt
# runtime info
    #ps axlf | grep qemu-system > running-vms.txt
    #virsh list > virsh-list.txt

# proc info
    collect_proc_info "/proc/cpuinfo"
    collect_proc_info "/proc/meminfo"
    collect_proc_info "/proc/modules"
    collect_proc_info "/proc/swaps"
    collect_proc_info "/proc/version"
    collect_proc_info "/proc/cmdline"

# other static configuration and logs
    find /etc/fstab \
/etc/redhat-release \
/etc/iproute2 \
/etc/hosts \
/etc/inittab \
/etc/sysctl.conf \
/etc/nsswitch.conf \
/etc/kvm \
/etc/modprobe.d/ixgbevf.conf \
/etc/sysconfig/network-scripts/ifcfg-* \
/etc/security/limits.conf \
/etc/rc.d/init.d \
/etc/rc.d/rc3.d \
/opt/common_scripts/ostune_misc.sh	\
/opt/common_scripts/update_udev_rules_net.sh \
/var/log/dmesg \
/boot/grub*/grub.conf	\
/etc/bashrc		\
/etc/exports		\
/etc/rc.d/rc.local	\
/etc/tune-profiles/active-profile	\
2>/dev/null | cpio -o 2>/dev/null | cpio -idm --no-absolute-filenames &>/dev/null

# clear zero size file
find . -size 0 -exec rm -f {} \;

}

collect_client_soft_info_vm()
{
mkdir SPECbatch SPECimap SPECjAppServer2004 SPECweb2005
cp -pv /opt/SPECbatch/Test.config $BASEDIR_SW/SPECbatch
cp -pv /opt/SPECimap/IMAP_config.rc $BASEDIR_SW/SPECimap
cp -pv /opt/SPECjAppServer2004/config/run.properties $BASEDIR_SW/SPECjAppServer2004
cp -pv /opt/SPECjAppServer2004/config/default.env $BASEDIR_SW/SPECjAppServer2004
cp -pv /opt/SPECweb2005/SPECweb_Support.config $BASEDIR_SW/SPECweb2005
cp -pv /opt/SPECweb2005/Test.config $BASEDIR_SW/SPECweb2005;
}
collect_remote_client_software_config()
{
    local host="$1"

    scp -pq $SCRIPT_LOCAL $host:$SCRIPT_REMOTE
    ssh $host sh $SCRIPT_REMOTE clientsoftware
    ssh $host tar -cz /tmp/data-collection-sw 2>/dev/null | tar -xz 2>/dev/null
    mv tmp/data-collection-sw/* .
    rm -fr tmp
}
collect_remote_vm_sys_info()
{
    local host="$1"

    scp -pq $SCRIPT_LOCAL $host:$SCRIPT_REMOTE
    ssh $host sh $SCRIPT_REMOTE sysinfo_vm
    ssh $host tar -cz /tmp/data-collection-sys 2>/dev/null | tar -xz 2>/dev/null
    mv tmp/data-collection-sys/* .
    rm -fr tmp
}

collect_remote_sys_info()
{
    local host="$1"

    scp -pq $SCRIPT_LOCAL $host:$SCRIPT_REMOTE
    ssh $host sh $SCRIPT_REMOTE sysinfo_sut
    ssh $host tar -cz /tmp/data-collection-sys 2>/dev/null | tar -xz 2>/dev/null
    mv tmp/data-collection-sys/* .
    rm -fr tmp
}

collect_remote_sys_info_phyclient()
{
    local host="$1"

    scp -pq $SCRIPT_LOCAL $host:$SCRIPT_REMOTE
    ssh $host sh $SCRIPT_REMOTE sysinfo_phyclient
    ssh $host tar -cz /tmp/data-collection-sys 2>/dev/null | tar -xz 2>/dev/null
    mv tmp/data-collection-sys/* .
    rm -fr tmp
}

collect_SUT()
{
    cd SUT
    data_collect_log "Collecting SUT info..." 3
    data_collect_log "Entering $(pwd)..."

    collect_remote_sys_info "sut"

    cd ..
}

collect_clients()
{
    cd Clients
    data_collect_log "Collecting physical clients info..." 3
    data_collect_log "Entering $(pwd)..."

    for client in $(gen_list $PHYCLIENT_LIST)
    do
        dir="Client${client}"
        mkdir $dir && cd $dir
        mkdir vm-xml
		
        data_collect_log "Collecting $dir..." 
        collect_remote_sys_info_phyclient "phyclient${client}" &
       #cd ..
    #done

    wait

    data_collect_log "Collecting virtual clients info..." 3
    if [ ${client} = "1" ]; then
        startno=1
        endno=$phy01
    else  
        startno=$(($phy01+1))
        endno=$phy02   
    fi
    for vclient in $(seq $startno $endno)
    do
   #       for i in clt clt-web; do ssh phyclient1 "virsh dumpxml sv13-${i}-01 > /tmp/sv13-${i}-01.xml";done
   #        scp -p phyclient1:/tmp/*01.xml ./vm-xml/
   #       for i in clt clt-web; do ssh phyclient1 "rm -rf /tmp/sv13-${i}-01.xml";done

      
       if [ ${vclient} -lt $(($phy01+1))]
       then
         if [ ${vclient} -lt 10 ] 
         then
         for i in clt clt-web; do ssh phyclient1 "virsh dumpxml sv13-${i}-0${vclient} > /tmp/sv13-${i}-0${vclient}.xml";done
         scp -p phyclient1:/tmp/*0${vclient}.xml ./vm-xml/
         for i in clt clt-web; do ssh phyclient1 "rm -rf /tmp/sv13-${i}-0${vclient}.xml";done
         else
         for i in clt clt-web; do ssh phyclient1 "virsh dumpxml sv13-${i}-${vclient} > /tmp/sv13-${i}-${vclient}.xml";done
         scp -p phyclient1:/tmp/*${vclient}.xml ./vm-xml/
         for i in clt clt-web; do ssh phyclient1 "rm -rf /tmp/sv13-${i}-${vclient}.xml";done
         fi
       else
         if [ ${vclient} -lt 10 ]
         then
         for i in clt clt-web; do ssh phyclient2 "virsh dumpxml sv13-${i}-0${vclient} > /tmp/sv13-${i}-0${vclient}.xml";done
         scp -p phyclient2:/tmp/*0${vclient}.xml ./vm-xml/
         for i in clt clt-web; do ssh phyclient2 "rm -rf /tmp/sv13-${i}-0${vclient}.xml";done
         else
         for i in clt clt-web; do ssh phyclient2 "virsh dumpxml sv13-${i}-${vclient} > /tmp/sv13-${i}-${vclient}.xml";done
         scp -p phyclient2:/tmp/*${vclient}.xml ./vm-xml/
         for i in clt clt-web; do ssh phyclient2 "rm -rf /tmp/sv13-${i}-${vclient}.xml";done
         fi
      fi

        dir="Tile${vclient}"
        mkdir $dir && cd $dir
        
        dir1="client${vclient}"   
        mkdir $dir1 && cd $dir1
        mkdir OS && cd OS 
        data_collect_log "Collecting $dir..."
        collect_remote_vm_sys_info "client${vclient}" &
        cd ../
	collect_remote_client_software_config "client${vclient}" &
        cd ../

        dir2="wclient${vclient}"
        mkdir $dir2 && cd $dir2
        mkdir OS && cd OS
        data_collect_log "Collecting $dir..."
        collect_remote_vm_sys_info "wclient${vclient}" &
	cd ../
        collect_remote_client_software_config "wclient${vclient}" &
        cd ../../
    done
        cd ../   
    done
    #wait

   # data_collect_log "Linking virtual clients to physical clients..." 3
   # for client in $(gen_list $PHYCLIENT_LIST)
   # do
   #     dir="Client${client}"
   #     cd $dir
   #     for x in ${VCLIENT_LIST[$client]}
   #     do
   #         ln -s ../client${x} vclient${x}
   #         ln -s ../wclient${x} vwclient${x}
   #     done
   #     cd ..
   #done

    cd ../
}

collect_physical_configuration()
{
    cd PHYS
    data_collect_log "Entering $(pwd)..."

    collect_SUT
   collect_clients

    cd ..
}

collect_local_software_config()
{
    local type="$1"

    case $type in

        "appserver")
#	    mkdir {glassfish,tomcat,SPECjAppServer2004,SPECjAppServer2004/config}
	    mkdir {AppSrv01,AppSrv02,WebSphere-setup,SPECjAppServer2004,SPECjAppServer2004/config}
#	    mkdir {AppSrv01,AppSrv02,WebSphere-setup}
WAS_DIR1="/opt/IBM/WebSphere/AppServer/profiles/AppSrv01/config/cells/appserverNode01Cell/nodes/appserverNode01"
WAS_DIR2="/opt/IBM/WebSphere/AppServer/profiles/AppSrv02/config/cells/appserverNode02Cell/nodes/appserverNode02"
cp -pv $WAS_DIR1/servers/server1/sib-engines.xml $BASEDIR_SW/AppSrv01
cp -pv $WAS_DIR1/servers/server1/server.xml $BASEDIR_SW/AppSrv01
cp -pv $WAS_DIR2/servers/server1/server.xml $BASEDIR_SW/AppSrv02
cp -pv /opt/IBM/WebSphere/AppServer/profiles/AppSrv01/config/cells/appserverNode01Cell/security.xml $BASEDIR_SW/AppSrv01
cp -pv /opt/IBM/WebSphere/AppServer/profiles/AppSrv02/config/cells/appserverNode02Cell/security.xml $BASEDIR_SW/AppSrv02

cp -pv $WAS_DIR1/serverindex.xml $BASEDIR_SW/AppSrv01
cp -pv $WAS_DIR1/resources.xml $BASEDIR_SW/AppSrv01
cp -pv $WAS_DIR1/node-metadata.properties $BASEDIR_SW/AppSrv01

cp -pv $WAS_DIR2/serverindex.xml $BASEDIR_SW/AppSrv02
cp -pv $WAS_DIR2/resources.xml $BASEDIR_SW/AppSrv02
cp -pv $WAS_DIR2/node-metadata.properties $BASEDIR_SW/AppSrv02

cp -pv /opt/WebSphere-setup/* $BASEDIR_SW/WebSphere-setup

            java -version 2> javaVersion.out

#            curl -s --connect-timeout 10 -m 20  http://localhost:8080 | grep 'Apache Tomcat' > tomcat/TomcatVersion.out
#            /opt/glassfish/bin/asadmin --passwordfile /opt/SPECjAppServer2004/config/passwordfile version > glassfish/GlassFishVersion.out

#            pushd /opt/glassfish/glassfish/domains/
#            tar cf -	\
#spec2004-1/{config,autodeploy}  \
#2> /dev/null | tar xf - -C $BASEDIR_SW/glassfish &>/dev/null

#	    pushd $BASEDIR_SW/glassfish/spec2004-1
#	    find ./ -name "*SPECjAppServer_ItemBrowserSes_*" | xargs rm -rf - 
#	    find ./ -name \"*.dat*\" | xargs rm -rf -
#	    rm -f config/*com_sun_appserv_pid
#	    rm -f config/.*com_sun_appserv_pid

#            pushd /opt/tomcat
#            tar cf -	\
#{conf,webapps/Emulator.war}	\
#2> /dev/null | tar xf - -C $BASEDIR_SW/tomcat &>/dev/null

#	    cp -v /opt/SPECjAppServer2004/config/{run.properties,glassfish.env} $BASEDIR_SW/SPECjAppServer2004/config
	    cp -pv /opt/SPECjAppServer2004/config/{*.properties,default.env} $BASEDIR_SW/SPECjAppServer2004/config
        ;;

        "dbserver")
mkdir schema
cp -pv /home/db2inst1/sqllib/db2nodes.cfg .
cp -pv /home/db2inst1/sqllib/profile.env .
cp -pv /home/db2inst1/db2set .
cp -pv /home/db2inst1/db2.dbm.cfg .
cp -pv /home/db2inst1/db2.db.cfg .
cp -prv /opt/SPECjAppServer2004/schema/db2  $BASEDIR_SW/schema
#            psql --version > psql-Version.txt
#            cp -p /var/lib/pgsql/9.2/data/postgresql.conf .
#	    pushd /opt/SPECjAppServer2004/
	
#            tar cf -	\
#schema/postgresql bin/glassfish  \
#2> /dev/null | tar xf - -C $BASEDIR_SW &>/dev/null
        ;;

        "batchserver")
            java -version 2> javaVersion.out
            java -jar /opt/SPECpoll/pollme.jar -v > SPECpollVersion.out

	    mkdir -p SPECbatch/cpu2006
	    cp -pv /opt/SPECbatch/cpu2006-virt/{virt_sc2013_run.sh,config/cpu2006-virt.cfg} SPECbatch/cpu2006/
	    cp -pv /opt/SPECbatch/Test.config SPECbatch/cpu2006/

            #touch emptyfile

            find 	\
2>/dev/null | cpio -o 2>/dev/null | cpio -idm --no-absolute-filenames &>/dev/null
        ;;

        "infraserver")
#            sum /var/www/fcgi-bin/besim_fcgi.fcgi > sum.besim_fcgi
#            ldd /var/www/fcgi-bin/besim_fcgi.fcgi > ldd.besim_fcgi

            find /etc/httpd/conf \
/etc/httpd/conf.d 	\
2>/dev/null | cpio -o 2>/dev/null | cpio -idm --no-absolute-filenames &>/dev/null
            httpd -V > etc/httpd/httpdVersion.out

        ;;

        "mailserver")
            find  \
/etc/dovecot \
/etc/init.d/dovecot 	\
2>/dev/null | cpio -o 2>/dev/null | cpio -idm --no-absolute-filenames &>/dev/null
            dovecot --version > etc/dovecotVersion.out
            dovecot --build-options >> etc/dovecotVersion.out
            rm -rf  etc/dovecot/conf.d 
	    mkdir SPECimap
	    cp -pv /opt/SPECimap/IMAP_config.rc SPECimap/
	    cp -pv /opt/SPECimap/IMAP_fixed.rc SPECimap/

        ;;

        "webserver")
            php --info > phpinfo.out 2>/dev/null
            grep -i "^[ ]*DocumentRoot" /etc/httpd/conf/httpd.conf |tr -d '\"' |xargs lsattr -R - 2>/dev/null  |grep support |grep -v dir000 > lsattr.out

            #find /etc/httpd/conf \
#/etc/httpd/conf.d \
	    cp -pv /etc/php.ini .
/var/www/html/support/init_vars.php	\
2>/dev/null | cpio -o 2>/dev/null | cpio -idm --no-absolute-filenames &>/dev/null
           # httpd -V > etc/httpd/httpdVersion.out
	    cp -pv /var/www/html/support/init_vars.php .

	    mkdir SPECweb2005
	    cp -pv /opt/SPECweb2005/Test.config SPECweb2005/
	    cp -pv /opt/SPECweb2005/SPECweb_Support.config SPECweb2005/

            mkdir nginx
            mkdir nginx/conf.d
	    nginx -V 2>&1 |tee nginx/nginxVersion.out
            cp -pv /etc/nginx/nginx.conf nginx/
	    cp -pv /etc/nginx/conf.d/default.conf nginx/conf.d/
	    cp -pv /etc/nginx/conf.d/example_ssl.conf nginx/conf.d/
            mkdir php-fpm
            mkdir php-fpm/php-fpm.d
	    php-fpm -v > php-fpm/php-fpmVersion.out
	    cp -pv /etc/php-fpm.conf php-fpm/
	    cp -pv /etc/php-fpm.d/www.conf php-fpm/php-fpm.d/	
        ;;

    esac
}

collect_remote_software_config()
{
    local host="$1"
    local type="$2"

    scp -pq $SCRIPT_LOCAL $host:$SCRIPT_REMOTE
    ssh $host sh $SCRIPT_REMOTE "software" $type
    ssh $host tar -cz /tmp/data-collection-sw 2>/dev/null | tar -xz 2>/dev/null
    mv tmp/data-collection-sw/* .
    rm -fr tmp
}

collect_software_config()
{
    local type="$1"
    local tile="$2"
    local host="${type}${tile}"

    data_collect_log "Collecting software configuration on ${host}..."
    mkdir SOFTW && cd SOFTW
    collect_remote_software_config "$host" "$type" &
    cd ..
}

collect_vm_config()
{
    local host="$1"

    data_collect_log "Collecting vm configuration on ${host}..."
    mkdir OS && cd OS
    collect_remote_vm_sys_info "$host" &
    cd ..
}


collect_one_tile()
{
    local tile="$1"
    local host=""

    #vmbase="sv13-infsrv- sv13-bchsrv- sv13-appsrv- sv13-malsrv- sv13-websrv-"
    vmlist="app batch infra mail web"
    rest=$[$tile%4]
    if [ "$rest" -eq 1 ]; then
        vmlist="$vmlist db"
	#vmbase="$vmbase sv13-dbssrv-"
    fi

    for host in $vmlist
    do
        mkdir $host && cd $host
        #collect KVM xml for tile
        if [ ${tile} -lt 10 ]
	then
	   # scp -p sut:/etc/libvirt/qemu/*0${tile}*.xml ../
	   #ssh sut "for i in infsrv bchsrv appsrv malsrv websrv dbssrv; do virsh dumpxml sv13-{i}-0${tile} > /tmp/test/sv13-${i}-0${tile}.xml;done"
	   #ssh sut "for i in ${vmbase}; do virsh dumpxml sv13-infsrv-01 > /tmp/test/sv13-infsrv-01.xml;done"
	   if [ "$rest" -eq 1 ]; then
	     for i in infsrv bchsrv appsrv malsrv websrv dbssrv; do ssh sut "virsh dumpxml sv13-${i}-0${tile} > /tmp/sv13-${i}-0${tile}.xml";done
	     scp -p sut:/tmp/*0${tile}.xml ../../../PHYS/SUT/vm-xml/
	     for i in infsrv bchsrv appsrv malsrv websrv dbssrv; do ssh sut "rm -rf /tmp/sv13-${i}-0${tile}.xml";done 
	   else
	     for i in infsrv bchsrv appsrv malsrv websrv; do ssh sut "virsh dumpxml sv13-${i}-0${tile} > /tmp/sv13-${i}-0${tile}.xml";done
             scp -p sut:/tmp/*0${tile}.xml ../../../PHYS/SUT/vm-xml/
             for i in infsrv bchsrv appsrv malsrv websrv; do ssh sut "rm -rf /tmp/sv13-${i}-0${tile}.xml";done
	   fi 
	else
	    #scp -p sut:/etc/libvirt/qemu/*${tile}*.xml ../
           #ssh sut "for i in ${vmbase}; do virsh dumpxml sv13-infsrv-01 > /tmp/test/sv13-infsrv-01.xml;done"
	   if [ "$rest" -eq 1 ]; then
	     for i in infsrv bchsrv appsrv malsrv websrv dbssrv; do ssh sut "virsh dumpxml sv13-${i}-${tile} > /tmp/sv13-${i}-${tile}.xml";done
	     scp -p sut:/tmp/*${tile}.xml ../../../PHYS/SUT/vm-xml/
	     for i in infsrv bchsrv appsrv malsrv websrv dbssrv; do ssh sut "rm -rf /tmp/sv13-${i}-${tile}.xml";done 
	   else
	     for i in infsrv bchsrv appsrv malsrv websrv; do ssh sut "virsh dumpxml sv13-${i}-${tile} > /tmp/sv13-${i}-${tile}.xml";done
             scp -p sut:/tmp/*${tile}.xml ../../../PHYS/SUT/vm-xml/
             for i in infsrv bchsrv appsrv malsrv websrv; do ssh sut "rm -rf /tmp/sv13-${i}-${tile}.xml";done
	   fi 
	fi

        data_collect_log "Collecting ${host}server in tile${tile}..."

        collect_software_config "${host}server" "$tile"
        collect_vm_config "${host}server${tile}"

        cd ..
    done

    # per tile wait
    #wait
}

collect_virtual_configuration()
{
    cd VIRT
    data_collect_log "Entering $(pwd)..."

    for tile in $(seq $TILE_LIST)
    do
        mkdir "Tile${tile}" && cd "Tile${tile}"
        data_collect_log "Collecting tile${tile}..." 3
        data_collect_log "Entering $(pwd)..."
        collect_one_tile "${tile}"
        cd ..
    done

    cd ..
}

collect_support_files()
{
	cd Collection_scripts
	cp $DC_SCRIPT ./
#	scp -r appserver1:/opt/SPECjAppServer2004/bin/glassfish ./
cp /opt/SPECvirt/collect_data_kvm.sh ./

	cd ..
}


#################################################################
# main routine starts here
#

if [ "$1" = "sysinfo" ]
then
    rm -fr $BASEDIR_SYS 2>/dev/null && mkdir $BASEDIR_SYS 2>/dev/null && cd $BASEDIR_SYS
    collect_sys_info
elif [ "$1" = "sysinfo_sut" ]
then
    rm -fr $BASEDIR_SYS 2>/dev/null && mkdir $BASEDIR_SYS 2>/dev/null && cd $BASEDIR_SYS
    collect_sys_info_sut
elif [ "$1" = "sysinfo_phyclient" ]
then
    rm -fr $BASEDIR_SYS 2>/dev/null && mkdir $BASEDIR_SYS 2>/dev/null && cd $BASEDIR_SYS
    collect_sys_info_phylient
elif [ "$1" = "clientsoftware" ]
then
    rm -fr $BASEDIR_SW 2>/dev/null && mkdir $BASEDIR_SW 2>/dev/null && cd $BASEDIR_SW
    collect_client_soft_info_vm
elif [ "$1" = "sysinfo_vm" ]
then
    rm -fr $BASEDIR_SYS 2>/dev/null && mkdir $BASEDIR_SYS 2>/dev/null && cd $BASEDIR_SYS
    collect_sys_info_vm
elif [ "$1" = "software" ]
then
    rm -fr $BASEDIR_SW 2>/dev/null && mkdir $BASEDIR_SW 2>/dev/null && cd $BASEDIR_SW
    collect_local_software_config "$2"
elif [ "$1" = "prepare" ]
then
    prepare_run_env
else

    if [ -r "$CONFIG" ]
    then
        source $CONFIG
    else
        data_collect_log "Config $CONFIG not readable, please check!" 2
        exit 1
    fi

    rm -fr $OUTPUT_DIR 2>/dev/null && mkdir $OUTPUT_DIR 2>/dev/null && cd $OUTPUT_DIR
    sanity_check

    build_dir_tree

    date > Data-Collection-Start.txt

    collect_support_files

    collect_physical_configuration

    collect_virtual_configuration

    # final wait
    wait

    # Remove the obsolete files
    pwd
    cd $OUTPUT_DIR
    find ./ -name "*.bak*" | xargs rm -rfv -
    find ./ -name "*.orig*" | xargs rm -rfv -
    find ./ -name "*_sc2010*" | xargs rm -rfv -
    find ./ -name "*.rpmsave*" | xargs rm -rfv -
    find ./ -name "*.rpmnew*" | xargs rm -rfv -
    find ./ -name "*before*" | xargs rm -rfv -

    date > Data-Collection-End.txt

    data_collect_log "Data has been collected under $OUTPUT_DIR" 3

    mv data-collection.log /tmp/

    exit 0
fi

