# DB2 Auto Configurator Example
#
# Using this command can help you tune DB2 automatically for your environment
#
# 1. Manually adjust your log file locations
# 2. Specify the values that is needed for DB2 Auto Configurator 
#
# 
# Example:
# 
# db2 autoconfigure using mem_percent 80 workload_type simple num_stmts 60 tpm 2000 is_populated yes 
#                   num_local_apps 0 num_remote_apps 65 isolation rs bp_resizeable yes apply db and dbm
# 
# 	mem_percent - the percentage of system memory you would like to use for bufferpool memeory. 
# 	
# 	Workload_type - for our purpose, WebSphere generally uses simple SQLs.
# 	
# 	num_stmts - number of statements involved in the workload
# 	
# 	tpm - estminate the transaction per minute that you want DB2 to handle
# 	
# 	is_populated - is the database populated with data?
# 	
# 	num_local_apps - number of applications connecting locally. If you setup is a two tier config with WebSphere on a separate machine, then enter '0'
# 	
# 	num_remote_app - number of applications that will connect to DB2 remotely. This number should be the summation of all the connection pool sizes from WebSphere. For SpecJappServer, it is the size of Connection Pool size of SPECDB + SPECUTIL. If it is a WebSphere cluster, multiply it by the number of WebSphere nodes.
# 	
# 	isolation - specify the highlest isolation level your Application demands. For SpecJAppServer, it's 'rs'
# 	
# 	bp_resizable - bufferpool resizable or not. Generally is 'yes'
# 	
# 	apply db and dbm - apply the settings on your behalf.
# 	
# 	SpecJappServer Sample - I have a dedicated DB2 machine that is in a 2-tier setup separated from the WebSphere machine. 
# 	- use 80% of the memory as my buffer pool. 
#	- SpecJ has about 60 statements, 
#	- simple workload, 
#       - tpm is dictated by Injection Rate, so my guess it will hit 2000 max for my work on this machine. 
#	- Data is already loaded. I have 65 connections coming in from Websphere, 
#	- most of the beans require isolation level rs.

db2 connect to specdb
db2 autoconfigure using mem_percent 80 workload_type simple num_stmts 60 tpm 2000 is_populated yes num_local_apps 0 num_remote_apps 200 isolation rs bp_resizeable yes apply db and dbm
db2 terminate
