#! /bin/bash
num_tiles=116
tile_num_pad=3
sut=vq-host
prefix=vq-
SSH_OPTIONS="-o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no"
echo "Gathering VM data..."
if [ -e ~/README-VM-notes.txt ]; then
    cp -p ~/README-VM-notes.txt .
fi
cat_files='proc/cpuinfo proc/devices proc/meminfo proc/modules proc/partitions proc/swaps proc/mounts proc/version proc/cmdline'
tar_files='boot/grub/grub.conf boot/efi/EFI/redhat/grub.conf etc/fstab etc/hosts etc/inittab etc/iproute2 etc/nsswitch.conf etc/sysctl.conf usr/lib/sysctl.d/*specvirt.conf etc/security/limits* etc/modprobe* etc/rc.d/rc3.d/ etc/rc.d/rc.local etc/rc.d/init.d/ etc/tune-profiles/active-profile etc/tuned/active_profile sbin/ifup-local var/log/dmesg'
mkdir -p guest-xml-config
pushd guest-xml-config >/dev/null
for tile in `seq 1 $num_tiles`; do
    zpt=`printf "%0${tile_num_pad}d" $tile`
    scp -p $SSH_OPTIONS ${sut}:/autobench/logs/specvirt*/config/libvirt.guest.before.001/*t${zpt}.xml .
done
popd >/dev/null

for tile in `seq 1 $num_tiles`; do
    zpt=`printf "%0${tile_num_pad}d" $tile`
    mkdir -p Tile$tile
    pushd Tile$tile >/dev/null
    for vmtype in web app db batch infra mail; do
        if [ "$vmtype" = "db" ]; then
            if [ "$(($tile%4))" != 1 ]; then
                continue
            fi
        fi
        echo "  VM is tile $tile $vmtype"
        mkdir -p $vmtype/OS
        pushd $vmtype/OS >/dev/null
        ssh $SSH_OPTIONS ${prefix}${vmtype}t${zpt} "cd /; tar chf - $tar_files" | tar xf -
        mkdir -p proc
        for file in $cat_files; do
            ssh $SSH_OPTIONS ${prefix}${vmtype}t${zpt} "cat /$file" >$file
        done
        ssh $SSH_OPTIONS ${prefix}${vmtype}t${zpt} ifconfig -a >ifconfig.txt
        ssh $SSH_OPTIONS ${prefix}${vmtype}t${zpt} chkconfig --list &>chkconfig.txt
        if grep -q list-unit-files chkconfig.txt; then
            ssh $SSH_OPTIONS ${prefix}${vmtype}t${zpt} systemctl list-unit-files >systemctl.list-unit-files.txt
        fi
        ssh $SSH_OPTIONS ${prefix}${vmtype}t${zpt} mount -l >mount.txt
        ssh $SSH_OPTIONS ${prefix}${vmtype}t${zpt} df >df.txt
        ssh $SSH_OPTIONS ${prefix}${vmtype}t${zpt} lspci >lspci.txt
        ssh $SSH_OPTIONS ${prefix}${vmtype}t${zpt} rpm -qa >rpmpkgs.txt
        scp -p $SSH_OPTIONS ${prefix}${vmtype}t${zpt}:/autobench/logs/specvirt*/benchmark/ulimits.txt .
        popd >/dev/null

        mkdir -p $vmtype/SOFTW
        pushd $vmtype/SOFTW >/dev/null
        case $vmtype in
            "web")
                ssh $SSH_OPTIONS ${prefix}${vmtype}t${zpt} 'nginx -V 2>&1' >nginx-verion.txt
                mkdir -p etc
                scp -pr $SSH_OPTIONS ${prefix}${vmtype}t${zpt}:/etc/nginx etc/
                scp -pr $SSH_OPTIONS ${prefix}${vmtype}t${zpt}:/etc/php-fpm* etc/
                mkdir -p php
                scp -pr $SSH_OPTIONS ${prefix}${vmtype}t${zpt}:/etc/php.ini php/
                scp -pr $SSH_OPTIONS ${prefix}${vmtype}t${zpt}:/etc/php.d php/
            ;;
            "app")
                ssh $SSH_OPTIONS ${prefix}${vmtype}t${zpt} '/opt/IBM/WebSphere/AppServer/bin/versionInfo.sh' >WebSphere-versionInfo.txt
                mkdir WebSphere-setup
                scp -p $SSH_OPTIONS ${prefix}${vmtype}t${zpt}:/autobench/sources/ibm-specj-deploy-kit-1.08/*.jacl WebSphere-setup/
                ear_files=$(ssh $SSH_OPTIONS ${prefix}${vmtype}t${zpt} 'find /opt/IBM/WebSphere/AppServer/profiles -type f -name \*.ear')
                for ear in $ear_files; do
                    scp -p $SSH_OPTIONS ${prefix}${vmtype}t${zpt}:$ear WebSphere-setup/
                done
                scp -pr $SSH_OPTIONS ${prefix}${vmtype}t${zpt}:/autobench/logs/specvirt*/benchmark/WebSphere-config .
            ;;
            "db")
                scp -p $SSH_OPTIONS ${prefix}${vmtype}t${zpt}:/home/db2inst1/sqllib/db2nodes.cfg .
                scp -p $SSH_OPTIONS ${prefix}${vmtype}t${zpt}:/home/db2inst1/sqllib/profile.env .
                scp -p $SSH_OPTIONS ${prefix}${vmtype}t${zpt}:/autobench/logs/specvirt*/benchmark/db2* .
                mkdir -p schema
                scp -p $SSH_OPTIONS ${prefix}${vmtype}t${zpt}:/autobench/sources/SPECvirt_sc2013/SPECjAppServer2004/schema/db2/* schema/
rm -f schema/*.bat
            ;;
            "infra")
                scp -p $SSH_OPTIONS ${prefix}${vmtype}t${zpt}:/etc/exports ../OS/etc/exports
                mkdir -p httpd
                scp -pr $SSH_OPTIONS ${prefix}${vmtype}t${zpt}:/etc/httpd/conf httpd/
                scp -pr $SSH_OPTIONS ${prefix}${vmtype}t${zpt}:/etc/httpd/conf.d httpd/
            ;;
            "mail")
                ssh $SSH_OPTIONS ${prefix}${vmtype}t${zpt} '/autobench/sources/SPECvirt_sc2013/SPECimap/dovecot/dist/sbin/dovecot --version 2>&1' >dovecot-verion.txt
                scp -p $SSH_OPTIONS ${prefix}${vmtype}t${zpt}:/autobench/sources/SPECvirt_sc2013/SPECimap/dovecot/dist/etc/dovecot/dovecot.conf .
            ;;
        esac
        popd >/dev/null
    done
    popd >/dev/null
done
