#! /bin/bash
prefix=vq-
client_vm_topology="vn-ct01:vq-vct001,vq-vct010,vq-vct019,vq-vct028,vq-vct037,vq-vct046,vq-vct055,vq-vct064,vq-vct073,vq-vct082,vq-vct091,vq-vct100,vq-vct109::vn-ct02:vq-vct002,vq-vct011,vq-vct020,vq-vct029,vq-vct038,vq-vct047,vq-vct056,vq-vct065,vq-vct074,vq-vct083,vq-vct092,vq-vct101,vq-vct110::vn-ct03:vq-vct003,vq-vct012,vq-vct021,vq-vct030,vq-vct039,vq-vct048,vq-vct057,vq-vct066,vq-vct075,vq-vct084,vq-vct093,vq-vct102,vq-vct111::vn-ct04:vq-vct004,vq-vct013,vq-vct022,vq-vct031,vq-vct040,vq-vct049,vq-vct058,vq-vct067,vq-vct076,vq-vct085,vq-vct094,vq-vct103,vq-vct112::vn-ct05:vq-master,vq-vct005,vq-vct014,vq-vct023,vq-vct032,vq-vct041,vq-vct050,vq-vct059,vq-vct068,vq-vct077,vq-vct086,vq-vct095,vq-vct104::vn-ct06:vq-vct006,vq-vct015,vq-vct024,vq-vct033,vq-vct042,vq-vct051,vq-vct060,vq-vct069,vq-vct078,vq-vct087,vq-vct096,vq-vct105,vq-vct113::vn-ct08:vq-vct007,vq-vct016,vq-vct025,vq-vct034,vq-vct043,vq-vct052,vq-vct061,vq-vct070,vq-vct079,vq-vct088,vq-vct097,vq-vct106,vq-vct114::vn-ct09:vq-vct008,vq-vct017,vq-vct026,vq-vct035,vq-vct044,vq-vct053,vq-vct062,vq-vct071,vq-vct080,vq-vct089,vq-vct098,vq-vct107,vq-vct115::vn-ct10:vq-vct009,vq-vct018,vq-vct027,vq-vct036,vq-vct045,vq-vct054,vq-vct063,vq-vct072,vq-vct081,vq-vct090,vq-vct099,vq-vct108,vq-vct116::vq-master"
SSH_OPTIONS="-o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no"
echo "Gathering client data..."
cat_files='proc/cpuinfo proc/devices proc/meminfo proc/modules proc/partitions proc/swaps'
tar_files='boot/grub/grub.conf boot/efi/EFI/redhat/grub.conf etc/fstab etc/hosts etc/inittab etc/iproute2 etc/nsswitch.conf etc/rc.local etc/sysctl.conf usr/lib/sysctl.d/*specvirt.conf etc/rc.d/rc3.d/ etc/rc.d/init.d/ var/log/dmesg etc/kvm/vm-scripts/ etc/kvm/*ifup*'

client_number=0
for phys_client_and_vms in ${client_vm_topology//::/ }; do
    phys_client=`echo $phys_client_and_vms | awk -F: '{print $1}'`
    echo "phys_client is $phys_client"
    ((client_number++))
    mkdir -p Client${client_number}
    pushd Client${client_number} >/dev/null
    mkdir OS
    pushd OS >/dev/null
    ssh $SSH_OPTIONS $phys_client "cd /; tar chf - $tar_files" | tar xf -
    mkdir -p proc
    for file in $cat_files; do
        ssh $SSH_OPTIONS $phys_client "cat /$file" >$file
    done
    ssh $SSH_OPTIONS $phys_client ifconfig -a >ifconfig.txt
    ssh $SSH_OPTIONS $phys_client brctl show >brctl-show.txt
    ssh $SSH_OPTIONS $phys_client chkconfig --list &>chkconfig.txt
    if grep -q list-unit-files chkconfig.txt; then
        ssh $SSH_OPTIONS $phys_client systemctl list-unit-files >systemctl.list-unit-files.txt
    fi
    ssh $SSH_OPTIONS $phys_client mount -l >mount.txt
    ssh $SSH_OPTIONS $phys_client df >df.txt
    ssh $SSH_OPTIONS $phys_client lspci >lspci.txt
    ssh $SSH_OPTIONS $phys_client rpm -qa >rpmpkgs.txt
    ssh $SSH_OPTIONS $phys_client vgdisplay >vgdisplay.txt
    ssh $SSH_OPTIONS $phys_client lvdisplay >lvdisplay.txt
    ssh $SSH_OPTIONS $phys_client "ps axlfww | grep -E 'qemu|COMMAND' | grep -v grep" >running-vms.txt
    ssh $SSH_OPTIONS $phys_client "virsh --readonly list" >virsh-list.txt
    scp -p $SSH_OPTIONS $phys_client:/autobench/logs/specvirt*/benchmark/ulimits.txt .
    if [ ! -e ulimits.txt ]; then
        ssh $SSH_OPTIONS $phys_client "ulimit -a" >ulimits.txt
    fi
    popd >/dev/null
    vm_clients=`echo $phys_client_and_vms | sed -e s/^${phys_client}':*'//`
    if [ -n "$vm_clients" ]; then
        mkdir -p guest-xml-config
        pushd guest-xml-config >/dev/null
        for vm_client in ${vm_clients//,/ }; do
            scp -p $SSH_OPTIONS ${phys_client}:/autobench/logs/null-bench*/config/libvirt.guest.before.001/${vm_client}.xml .
        done
        popd >/dev/null

        for vm_client in ${vm_clients//,/ }; do
            echo "  vm_client is $vm_client"
            tile_num=`echo $vm_client | sed -e 's/.*t0*\([0-9]\+\)$/\1/'`
            if [ "$tile_num" != "$vm_client" ]; then
                mkdir -p Tile${tile_num}
                pushd Tile${tile_num} >/dev/null
            else
                mkdir -p ${vm_client#$prefix}
                pushd ${vm_client#$prefix} >/dev/null
            fi
            mkdir OS
            pushd OS >/dev/nell
            ssh $SSH_OPTIONS $vm_client "cd /; tar chf - $tar_files" | tar xf -
            mkdir proc
            for file in $cat_files; do
                ssh $SSH_OPTIONS $vm_client cat /$file >$file
            done
            ssh $SSH_OPTIONS $vm_client ifconfig -a >ifconfig.txt
            ssh $SSH_OPTIONS $vm_client chkconfig --list &>chkconfig.txt
            if grep -q list-unit-files chkconfig.txt; then
                ssh $SSH_OPTIONS $vm_client systemctl list-unit-files >systemctl.list-unit-files.txt
            fi
            ssh $SSH_OPTIONS $vm_client mount -l >mount.txt
            ssh $SSH_OPTIONS $vm_client df >df.txt
            ssh $SSH_OPTIONS $vm_client lspci >lspci.txt
            ssh $SSH_OPTIONS $vm_client rpm -qa >rpmpkgs.txt
            scp -p $SSH_OPTIONS $vm_client:/autobench/logs/specvirt*/benchmark/ulimits.txt .
            popd >/dev/null
            mkdir -p SPECjAppServer2004
            scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECjAppServer2004-prime/config/appsserver SPECjAppServer2004/
            scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECjAppServer2004-prime/config/run.properties SPECjAppServer2004/
            scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECjAppServer2004-prime/config/default.env SPECjAppServer2004/
            mkdir SPECweb2005
            scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECweb2005-prime/Test.config SPECweb2005/
            scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECweb2005-prime/SPECweb_Support.config SPECweb2005/
            mkdir SPECimap
            scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECimap-prime/IMAP_config.rc SPECimap/
            mkdir SPECbatch
            scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECbatch-prime/Test.config SPECbatch/
            popd >/dev/null
        done
    fi
    popd >/dev/null
done
