#!/bin/bash

#cd /root
rm -rf data_collection
mkdir -p data_collection

#client configure
fn_getClientInfo()
{
   i=30
    clientphydir=data_collection/PHYS/Clients/Client1
        mkdir -p  $clientphydir/OS $clientphydir/SOFTW
        mkdir -p $clientphydir/OS/vm-xml  
        for((l=1;l<=15;l++))
        do
        ssh 192.1.1.$i "virsh dumpxml client${l}" > $clientphydir/OS/vm-xml/client${l}.xml;
        done

         mkdir -p $clientphydir/OS/boot/grub2
        scp -p 192.1.1.$i:/boot/grub/menu.lst $clientphydir/OS/boot/grub2
      
        mkdir -p  $clientphydir/OS/etc 
        scp -p 192.1.1.$i:/etc/sysctl.conf $clientphydir/OS/etc
        scp -p 192.1.1.$i:/etc/fstab $clientphydir/OS/etc
        scp -p 192.1.1.$i:/etc/hosts $clientphydir/OS/etc
        scp -p 192.1.1.$i:/etc/inittab $clientphydir/OS/etc
        scp -pr 192.1.1.$i:/etc/iproute2 $clientphydir/OS/etc
        scp -p 192.1.1.$i:/etc/nsswitch.conf $clientphydir/OS/etc
        scp -p 192.1.1.$i:/etc/issue $clientphydir/OS/etc
        mkdir -p  $clientphydir/OS/etc/rc.d
        scp -pr 192.1.1.$i:/etc/rc.d/rc3.d $clientphydir/OS/etc/rc.d
        scp -pr 192.1.1.$i:/etc/rc.d/init.d $clientphydir/OS/etc/rc.d
        scp -pr 192.1.1.$i:/etc/init.d/* $clientphydir/OS/etc/rc.d
        mkdir -p $clientphydir/OS/etc/security
        scp -p 192.1.1.$i:/etc/security/limits.conf $clientphydir/OS/etc/security  
        mkdir -p  $clientphydir/OS/proc
        ssh 192.1.1.$i "cat /proc/cmdline" > $clientphydir/OS/proc/cmdline
        ssh 192.1.1.$i "cat /proc/cpuinfo" > $clientphydir/OS/proc/cpuinfo
        ssh 192.1.1.$i "cat /proc/devices" > $clientphydir/OS/proc/devices
        ssh 192.1.1.$i "cat /proc/meminfo" > $clientphydir/OS/proc/meminfo
        ssh 192.1.1.$i "cat /proc/modules" > $clientphydir/OS/proc/modules
        ssh 192.1.1.$i "cat /proc/partitions" > $clientphydir/OS/proc/partitions
        ssh 192.1.1.$i "cat /proc/swaps" > $clientphydir/OS/proc/swaps
        ssh 192.1.1.$i "cat /proc/version" > $clientphydir/OS/proc/version
        ssh 192.1.1.$i "brctl show" > $clientphydir/OS/brctl-show.txt
        ssh 192.1.1.$i "chkconfig" > $clientphydir/OS/chkconfig.txt
        ssh 192.1.1.$i "df" > $clientphydir/OS/df.txt
        ssh 192.1.1.$i "ifconfig" > $clientphydir/OS/ifconfig.txt
        ssh 192.1.1.$i "lspci" > $clientphydir/OS/lspci.txt
        ssh 192.1.1.$i "lvdisplay" > $clientphydir/OS/lvdisplay.txt
        ssh 192.1.1.$i "mount" > $clientphydir/OS/mount.txt
        ssh 192.1.1.$i "rpm -qa" > $clientphydir/OS/rpmpkgs.txt
        ssh 192.1.1.$i "vgdisplay" > $clientphydir/OS/vgdisplay.txt
        ssh 192.1.1.$i "virsh list --all" > $clientphydir/SOFTW/virsh-list.txt 
    vmnum=1
    vmend=15
    for((j=$vmnum;j<=$vmend;j++))
    do
        clientvmdir=$clientphydir/Tile$j
        mkdir -p $clientvmdir/OS $clientvmdir/SPECbatch $clientvmdir/SPECimap $clientvmdir/SPECjAppServer2004 $clientvmdir/SPECweb2005 
        mkdir -p $clientvmdir/OS/boot/grub/
        scp -p 192.1.$j.7:/boot/grub/grub.conf $clientvmdir/OS/boot/grub/
        mkdir -p  $clientvmdir/OS/etc
        mkdir -p  $clientvmdir/OS/etc/iproute2
        mkdir -p  $clientvmdir/OS/etc/rc.d/init.d
        mkdir -p  $clientvmdir/OS/etc/rc.d/rc3.d
        scp -pr 192.1.$j.7:/etc/iproute2/* $clientvmdir/OS/etc/iproute2/
        scp -pr 192.1.$j.7:/etc/rc.d/init.d/* $clientvmdir/OS/etc/rc.d/init.d
        scp -pr 192.1.$j.7:/etc/rc.d/rc3.d/* $clientvmdir/OS/etc/rc.d/rc3.d
        scp -p 192.1.$j.7:/etc/fstab $clientvmdir/OS/etc
        scp -p 192.1.$j.7:/etc/hosts $clientvmdir/OS/etc
        scp -p 192.1.$j.7:/etc/inittab $clientvmdir/OS/etc
        scp -p 192.1.$j.7:/etc/exports $clientvmdir/OS/etc
        scp -p 192.1.$j.7:/etc/nsswitch.conf $clientvmdir/OS/etc
        scp -p 192.1.$j.7:/etc/sysctl.conf $clientvmdir/OS/etc
        scp -p 192.1.$j.7:/etc/rc.local $clientvmdir/OS/etc
        scp -p 192.1.$j.7:/etc/bashrc $clientvmdir/OS/etc
        scp -p 192.1.$j.7:/etc/redhat-release $clientvmdir/OS/etc
        mkdir -p $clientvmdir/OS/etc/security
        scp -p 192.1.$j.7:/etc/security/limits.conf $clientvmdir/OS/etc/security
        mkdir -p $clientvmdir/OS/etc/modprobe.d/
        scp -p 192.1.$j.7:/etc/modprobe.d/ixgbevf.conf $clientvmdir/OS/etc/modprobe.d/   
        mkdir -p  $clientvmdir/OS/etc/sysconfig/network-scripts/
        scp -p 192.1.$j.7:/etc/sysconfig/network-scripts/ifcfg* $clientvmdir/OS/etc/sysconfig/network-scripts/
        scp -p 192.1.$j.7:/etc/sysconfig/network $clientvmdir/OS/etc/sysconfig
        mkdir -p  $clientvmdir/OS/proc
        ssh 192.1.$j.7 "cat /proc/cmdline" > $clientvmdir/OS/proc/cmdline
        ssh 192.1.$j.7 "cat /proc/cpuinfo" > $clientvmdir/OS/proc/cpuinfo
        ssh 192.1.$j.7 "cat /proc/devices" > $clientvmdir/OS/proc/devices
        ssh 192.1.$j.7 "cat /proc/meminfo" > $clientvmdir/OS/proc/meminfo
        ssh 192.1.$j.7 "cat /proc/modules" > $clientvmdir/OS/proc/modules
        ssh 192.1.$j.7 "cat /proc/mounts" > $clientvmdir/OS/proc/mounts 
        ssh 192.1.$j.7 "cat /proc/partitions" > $clientvmdir/OS/proc/partitions
        ssh 192.1.$j.7 "cat /proc/swaps" > $clientvmdir/OS/proc/swaps
        ssh 192.1.$j.7 "cat /proc/version" > $clientvmdir/OS/proc/version
        mkdir -p  $clientvmdir/OS/var/log
        scp -p 192.1.$j.7:/var/log/dmesg $clientvmdir/OS/var/log/
        ssh 192.1.$j.7 "chkconfig" > $clientvmdir/OS/chkconfig.txt
        ssh 192.1.$j.7 "df" > $clientvmdir/OS/df.txt
        ssh 192.1.$j.7 "ifconfig" > $clientvmdir/OS/ifconfig.txt
        ssh 192.1.$j.7 "lspci" > $clientvmdir/OS/lspci.txt
        ssh 192.1.$j.7 "lvdisplay" > $clientvmdir/OS/lvdisplay.txt 2>/dev/null
        ssh 192.1.$j.7 "vgdisplay" > $clientvmdir/OS/vgdisplay.txt 2>/dev/null
        ssh 192.1.$j.7 "mount" > $clientvmdir/OS/mount.txt
        ssh 192.1.$j.7 "route -n" > $clientvmdir/OS/route.txt
        ssh 192.1.$j.7 "rpm -qa" > $clientvmdir/OS/rpmpkgs.txt

        scp -p 192.1.$j.7:/opt/SPECbatch/Test.config $clientvmdir/SPECbatch 
        scp -p 192.1.$j.7:/opt/SPECimap/IMAP_config.rc $clientvmdir/SPECimap
        scp -p 192.1.$j.7:/opt/SPECjAppServer2004/config/run.properties $clientvmdir/SPECjAppServer2004
        scp -p 192.1.$j.7:/opt/SPECjAppServer2004/config/default.env $clientvmdir/SPECjAppServer2004
        scp -p 192.1.$j.7:/opt/SPECweb2005/SPECweb_Support.config $clientvmdir/SPECweb2005
        scp -p 192.1.$j.7:/opt/SPECweb2005/Test.config $clientvmdir/SPECweb2005
    done
 i=40
    clientphydir=data_collection/PHYS/Clients/Client2
        mkdir -p  $clientphydir/OS $clientphydir/SOFTW
        mkdir -p $clientphydir/OS/vm-xml
        for((l=16;l<=31;l++))
        do
        ssh 192.1.1.$i "virsh dumpxml client${l}" > $clientphydir/OS/vm-xml/client${l}.xml;
        done

        mkdir -p $clientphydir/OS/boot/grub2
        scp -p 192.1.1.$i:/boot/grub/menu.lst $clientphydir/OS/boot/grub2

        mkdir -p  $clientphydir/OS/etc
        scp -p 192.1.1.$i:/etc/sysctl.conf $clientphydir/OS/etc
        scp -p 192.1.1.$i:/etc/fstab $clientphydir/OS/etc
        scp -p 192.1.1.$i:/etc/hosts $clientphydir/OS/etc
        scp -p 192.1.1.$i:/etc/inittab $clientphydir/OS/etc
        scp -pr 192.1.1.$i:/etc/iproute2 $clientphydir/OS/etc
        scp -p 192.1.1.$i:/etc/nsswitch.conf $clientphydir/OS/etc
        scp -p 192.1.1.$i:/etc/issue $clientphydir/OS/etc
        mkdir -p  $clientphydir/OS/etc/rc.d
        scp -pr 192.1.1.$i:/etc/rc.d/rc3.d $clientphydir/OS/etc/rc.d
        scp -pr 192.1.1.$i:/etc/rc.d/init.d $clientphydir/OS/etc/rc.d
        scp -pr 192.1.1.$i:/etc/init.d/* $clientphydir/OS/etc/rc.d
        mkdir -p $clientphydir/OS/etc/security
        scp -p 192.1.1.$i:/etc/security/limits.conf $clientphydir/OS/etc/security
        mkdir -p  $clientphydir/OS/proc
        ssh 192.1.1.$i "cat /proc/cmdline" > $clientphydir/OS/proc/cmdline
        ssh 192.1.1.$i "cat /proc/cpuinfo" > $clientphydir/OS/proc/cpuinfo
        ssh 192.1.1.$i "cat /proc/devices" > $clientphydir/OS/proc/devices
        ssh 192.1.1.$i "cat /proc/meminfo" > $clientphydir/OS/proc/meminfo
        ssh 192.1.1.$i "cat /proc/modules" > $clientphydir/OS/proc/modules
        ssh 192.1.1.$i "cat /proc/partitions" > $clientphydir/OS/proc/partitions
        ssh 192.1.1.$i "cat /proc/swaps" > $clientphydir/OS/proc/swaps
        ssh 192.1.1.$i "cat /proc/version" > $clientphydir/OS/proc/version
        ssh 192.1.1.$i "brctl show" > $clientphydir/OS/brctl-show.txt
        ssh 192.1.1.$i "chkconfig" > $clientphydir/OS/chkconfig.txt
        ssh 192.1.1.$i "df" > $clientphydir/OS/df.txt
        ssh 192.1.1.$i "ifconfig" > $clientphydir/OS/ifconfig.txt
        ssh 192.1.1.$i "lspci" > $clientphydir/OS/lspci.txt
        ssh 192.1.1.$i "lvdisplay" > $clientphydir/OS/lvdisplay.txt
        ssh 192.1.1.$i "mount" > $clientphydir/OS/mount.txt
        ssh 192.1.1.$i "rpm -qa" > $clientphydir/OS/rpmpkgs.txt
        ssh 192.1.1.$i "vgdisplay" > $clientphydir/OS/vgdisplay.txt
        ssh 192.1.1.$i "virsh list --all" > $clientphydir/SOFTW/virsh-list.txt
    vmnum=16
    vmend=31
    for((j=$vmnum;j<=$vmend;j++))
    do
        clientvmdir=$clientphydir/Tile$j
        mkdir -p $clientvmdir/OS $clientvmdir/SPECbatch $clientvmdir/SPECimap $clientvmdir/SPECjAppServer2004 $clientvmdir/SPECweb2005
        mkdir -p $clientvmdir/OS/boot/grub/
        scp -p 192.1.$j.7:/boot/grub/grub.conf $clientvmdir/OS/boot/grub/
        mkdir -p  $clientvmdir/OS/etc
        mkdir -p  $clientvmdir/OS/etc/iproute2
        mkdir -p  $clientvmdir/OS/etc/rc.d/init.d
        mkdir -p  $clientvmdir/OS/etc/rc.d/rc3.d
        scp -pr 192.1.$j.7:/etc/iproute2/* $clientvmdir/OS/etc/iproute2/
        scp -pr 192.1.$j.7:/etc/rc.d/init.d/* $clientvmdir/OS/etc/rc.d/init.d
        scp -pr 192.1.$j.7:/etc/rc.d/rc3.d/* $clientvmdir/OS/etc/rc.d/rc3.d
        scp -p 192.1.$j.7:/etc/fstab $clientvmdir/OS/etc
        scp -p 192.1.$j.7:/etc/hosts $clientvmdir/OS/etc
        scp -p 192.1.$j.7:/etc/inittab $clientvmdir/OS/etc
        scp -p 192.1.$j.7:/etc/exports $clientvmdir/OS/etc
        scp -p 192.1.$j.7:/etc/nsswitch.conf $clientvmdir/OS/etc
        scp -p 192.1.$j.7:/etc/sysctl.conf $clientvmdir/OS/etc
        scp -p 192.1.$j.7:/etc/rc.local $clientvmdir/OS/etc
        scp -p 192.1.$j.7:/etc/bashrc $clientvmdir/OS/etc
        scp -p 192.1.$j.7:/etc/redhat-release $clientvmdir/OS/etc
        mkdir -p $clientvmdir/OS/etc/security
        scp -p 192.1.$j.7:/etc/security/limits.conf $clientvmdir/OS/etc/security
        mkdir -p $clientvmdir/OS/etc/modprobe.d/
        scp -p 192.1.$j.7:/etc/modprobe.d/ixgbevf.conf $clientvmdir/OS/etc/modprobe.d/
        mkdir -p  $clientvmdir/OS/etc/sysconfig/network-scripts/
        scp -p 192.1.$j.7:/etc/sysconfig/network-scripts/ifcfg* $clientvmdir/OS/etc/sysconfig/network-scripts/
        scp -p 192.1.$j.7:/etc/sysconfig/network $clientvmdir/OS/etc/sysconfig
        mkdir -p  $clientvmdir/OS/proc
        ssh 192.1.$j.7 "cat /proc/cmdline" > $clientvmdir/OS/proc/cmdline
        ssh 192.1.$j.7 "cat /proc/cpuinfo" > $clientvmdir/OS/proc/cpuinfo
        ssh 192.1.$j.7 "cat /proc/devices" > $clientvmdir/OS/proc/devices
        ssh 192.1.$j.7 "cat /proc/meminfo" > $clientvmdir/OS/proc/meminfo
        ssh 192.1.$j.7 "cat /proc/modules" > $clientvmdir/OS/proc/modules
        ssh 192.1.$j.7 "cat /proc/mounts" > $clientvmdir/OS/proc/mounts
        ssh 192.1.$j.7 "cat /proc/partitions" > $clientvmdir/OS/proc/partitions
        ssh 192.1.$j.7 "cat /proc/swaps" > $clientvmdir/OS/proc/swaps
        ssh 192.1.$j.7 "cat /proc/version" > $clientvmdir/OS/proc/version
        mkdir -p  $clientvmdir/OS/var/log
        scp -p 192.1.$j.7:/var/log/dmesg $clientvmdir/OS/var/log/
        ssh 192.1.$j.7 "chkconfig" > $clientvmdir/OS/chkconfig.txt
        ssh 192.1.$j.7 "df" > $clientvmdir/OS/df.txt
        ssh 192.1.$j.7 "ifconfig" > $clientvmdir/OS/ifconfig.txt
        ssh 192.1.$j.7 "lspci" > $clientvmdir/OS/lspci.txt
        ssh 192.1.$j.7 "lvdisplay" > $clientvmdir/OS/lvdisplay.txt 2>/dev/null
        ssh 192.1.$j.7 "vgdisplay" > $clientvmdir/OS/vgdisplay.txt 2>/dev/null
        ssh 192.1.$j.7 "mount" > $clientvmdir/OS/mount.txt
        ssh 192.1.$j.7 "route -n" > $clientvmdir/OS/route.txt
        ssh 192.1.$j.7 "rpm -qa" > $clientvmdir/OS/rpmpkgs.txt

        scp -p 192.1.$j.7:/opt/SPECbatch/Test.config $clientvmdir/SPECbatch
        scp -p 192.1.$j.7:/opt/SPECimap/IMAP_config.rc $clientvmdir/SPECimap
        scp -p 192.1.$j.7:/opt/SPECjAppServer2004/config/run.properties $clientvmdir/SPECjAppServer2004
        scp -p 192.1.$j.7:/opt/SPECjAppServer2004/config/default.env $clientvmdir/SPECjAppServer2004
        scp -p 192.1.$j.7:/opt/SPECweb2005/SPECweb_Support.config $clientvmdir/SPECweb2005
        scp -p 192.1.$j.7:/opt/SPECweb2005/Test.config $clientvmdir/SPECweb2005
    done

i=50
    clientphydir=data_collection/PHYS/Clients/Client3
        mkdir -p  $clientphydir/OS $clientphydir/SOFTW
        mkdir -p $clientphydir/OS/vm-xml
        for((l=32;l<=47;l++))
        do
        ssh 192.1.1.$i "virsh dumpxml client${l}" > $clientphydir/OS/vm-xml/client${l}.xml;
        done

        mkdir -p $clientphydir/OS/boot/grub2
        scp -p 192.1.1.$i:/boot/grub/menu.lst $clientphydir/OS/boot/grub2

        mkdir -p  $clientphydir/OS/etc
        scp -p 192.1.1.$i:/etc/sysctl.conf $clientphydir/OS/etc
        scp -p 192.1.1.$i:/etc/fstab $clientphydir/OS/etc
        scp -p 192.1.1.$i:/etc/hosts $clientphydir/OS/etc
        scp -p 192.1.1.$i:/etc/inittab $clientphydir/OS/etc
        scp -pr 192.1.1.$i:/etc/iproute2 $clientphydir/OS/etc
        scp -p 192.1.1.$i:/etc/nsswitch.conf $clientphydir/OS/etc
        scp -p 192.1.1.$i:/etc/issue $clientphydir/OS/etc
        mkdir -p  $clientphydir/OS/etc/rc.d
        scp -pr 192.1.1.$i:/etc/rc.d/rc3.d $clientphydir/OS/etc/rc.d
        scp -pr 192.1.1.$i:/etc/rc.d/init.d $clientphydir/OS/etc/rc.d
        scp -pr 192.1.1.$i:/etc/init.d/* $clientphydir/OS/etc/rc.d
        mkdir -p $clientphydir/OS/etc/security
        scp -p 192.1.1.$i:/etc/security/limits.conf $clientphydir/OS/etc/security
        mkdir -p  $clientphydir/OS/proc
        ssh 192.1.1.$i "cat /proc/cmdline" > $clientphydir/OS/proc/cmdline
        ssh 192.1.1.$i "cat /proc/cpuinfo" > $clientphydir/OS/proc/cpuinfo
        ssh 192.1.1.$i "cat /proc/devices" > $clientphydir/OS/proc/devices
        ssh 192.1.1.$i "cat /proc/meminfo" > $clientphydir/OS/proc/meminfo
        ssh 192.1.1.$i "cat /proc/modules" > $clientphydir/OS/proc/modules
        ssh 192.1.1.$i "cat /proc/partitions" > $clientphydir/OS/proc/partitions
        ssh 192.1.1.$i "cat /proc/swaps" > $clientphydir/OS/proc/swaps
        ssh 192.1.1.$i "cat /proc/version" > $clientphydir/OS/proc/version
        ssh 192.1.1.$i "brctl show" > $clientphydir/OS/brctl-show.txt
        ssh 192.1.1.$i "chkconfig" > $clientphydir/OS/chkconfig.txt
        ssh 192.1.1.$i "df" > $clientphydir/OS/df.txt
        ssh 192.1.1.$i "ifconfig" > $clientphydir/OS/ifconfig.txt
        ssh 192.1.1.$i "lspci" > $clientphydir/OS/lspci.txt
        ssh 192.1.1.$i "lvdisplay" > $clientphydir/OS/lvdisplay.txt
        ssh 192.1.1.$i "mount" > $clientphydir/OS/mount.txt
        ssh 192.1.1.$i "rpm -qa" > $clientphydir/OS/rpmpkgs.txt
        ssh 192.1.1.$i "vgdisplay" > $clientphydir/OS/vgdisplay.txt
        ssh 192.1.1.$i "virsh list --all" > $clientphydir/SOFTW/virsh-list.txt
    vmnum=32
    vmend=47
    for((j=$vmnum;j<=$vmend;j++))
    do
        clientvmdir=$clientphydir/Tile$j
        mkdir -p $clientvmdir/OS $clientvmdir/SPECbatch $clientvmdir/SPECimap $clientvmdir/SPECjAppServer2004 $clientvmdir/SPECweb2005
        mkdir -p $clientvmdir/OS/boot/grub/
        scp -p 192.1.$j.7:/boot/grub/grub.conf $clientvmdir/OS/boot/grub/
        mkdir -p  $clientvmdir/OS/etc
        mkdir -p  $clientvmdir/OS/etc/iproute2
        mkdir -p  $clientvmdir/OS/etc/rc.d/init.d
        mkdir -p  $clientvmdir/OS/etc/rc.d/rc3.d
        scp -pr 192.1.$j.7:/etc/iproute2/* $clientvmdir/OS/etc/iproute2/
        scp -pr 192.1.$j.7:/etc/rc.d/init.d/* $clientvmdir/OS/etc/rc.d/init.d
        scp -pr 192.1.$j.7:/etc/rc.d/rc3.d/* $clientvmdir/OS/etc/rc.d/rc3.d
        scp -p 192.1.$j.7:/etc/fstab $clientvmdir/OS/etc
        scp -p 192.1.$j.7:/etc/hosts $clientvmdir/OS/etc
        scp -p 192.1.$j.7:/etc/inittab $clientvmdir/OS/etc
        scp -p 192.1.$j.7:/etc/exports $clientvmdir/OS/etc
        scp -p 192.1.$j.7:/etc/nsswitch.conf $clientvmdir/OS/etc
        scp -p 192.1.$j.7:/etc/sysctl.conf $clientvmdir/OS/etc
        scp -p 192.1.$j.7:/etc/rc.local $clientvmdir/OS/etc
        scp -p 192.1.$j.7:/etc/bashrc $clientvmdir/OS/etc
        scp -p 192.1.$j.7:/etc/redhat-release $clientvmdir/OS/etc
        mkdir -p $clientvmdir/OS/etc/security
        scp -p 192.1.$j.7:/etc/security/limits.conf $clientvmdir/OS/etc/security
        mkdir -p $clientvmdir/OS/etc/modprobe.d/
        scp -p 192.1.$j.7:/etc/modprobe.d/ixgbevf.conf $clientvmdir/OS/etc/modprobe.d/
        mkdir -p  $clientvmdir/OS/etc/sysconfig/network-scripts/
        scp -p 192.1.$j.7:/etc/sysconfig/network-scripts/ifcfg* $clientvmdir/OS/etc/sysconfig/network-scripts/
        scp -p 192.1.$j.7:/etc/sysconfig/network $clientvmdir/OS/etc/sysconfig
        mkdir -p  $clientvmdir/OS/proc
        ssh 192.1.$j.7 "cat /proc/cmdline" > $clientvmdir/OS/proc/cmdline
        ssh 192.1.$j.7 "cat /proc/cpuinfo" > $clientvmdir/OS/proc/cpuinfo
        ssh 192.1.$j.7 "cat /proc/devices" > $clientvmdir/OS/proc/devices
        ssh 192.1.$j.7 "cat /proc/meminfo" > $clientvmdir/OS/proc/meminfo
        ssh 192.1.$j.7 "cat /proc/modules" > $clientvmdir/OS/proc/modules
        ssh 192.1.$j.7 "cat /proc/mounts" > $clientvmdir/OS/proc/mounts
        ssh 192.1.$j.7 "cat /proc/partitions" > $clientvmdir/OS/proc/partitions
        ssh 192.1.$j.7 "cat /proc/swaps" > $clientvmdir/OS/proc/swaps
        ssh 192.1.$j.7 "cat /proc/version" > $clientvmdir/OS/proc/version
        mkdir -p  $clientvmdir/OS/var/log
        scp -p 192.1.$j.7:/var/log/dmesg $clientvmdir/OS/var/log/
        ssh 192.1.$j.7 "chkconfig" > $clientvmdir/OS/chkconfig.txt
        ssh 192.1.$j.7 "df" > $clientvmdir/OS/df.txt
        ssh 192.1.$j.7 "ifconfig" > $clientvmdir/OS/ifconfig.txt
        ssh 192.1.$j.7 "lspci" > $clientvmdir/OS/lspci.txt
        ssh 192.1.$j.7 "lvdisplay" > $clientvmdir/OS/lvdisplay.txt 2>/dev/null
        ssh 192.1.$j.7 "vgdisplay" > $clientvmdir/OS/vgdisplay.txt 2>/dev/null
        ssh 192.1.$j.7 "mount" > $clientvmdir/OS/mount.txt
        ssh 192.1.$j.7 "route -n" > $clientvmdir/OS/route.txt
        ssh 192.1.$j.7 "rpm -qa" > $clientvmdir/OS/rpmpkgs.txt

        scp -p 192.1.$j.7:/opt/SPECbatch/Test.config $clientvmdir/SPECbatch
        scp -p 192.1.$j.7:/opt/SPECimap/IMAP_config.rc $clientvmdir/SPECimap
        scp -p 192.1.$j.7:/opt/SPECjAppServer2004/config/run.properties $clientvmdir/SPECjAppServer2004
        scp -p 192.1.$j.7:/opt/SPECjAppServer2004/config/default.env $clientvmdir/SPECjAppServer2004
        scp -p 192.1.$j.7:/opt/SPECweb2005/SPECweb_Support.config $clientvmdir/SPECweb2005
        scp -p 192.1.$j.7:/opt/SPECweb2005/Test.config $clientvmdir/SPECweb2005
    done
                          
}

#SUT configure
fn_getSUTInfo()
{
    SUTphydir=data_collection/PHYS/SUT
    mkdir -p $SUTphydir/OS $SUTphydir/SOFTW $SUTphydir/Storage $SUTphydir/Network $SUTphydir/vm-xml 
    for((l=1;l<=$1;l++))
    do
    rest=$[$l%4] 
    if [ "$rest" -eq 1 ]; then
	     for i in infraserver batchserver appserver mailserver webserver dbserver; do  virsh dumpxml ${i}${l} > $SUTphydir/vm-xml/5885HV3-${i}-${l}.xml; done       
    else
	     for i in infraserver batchserver appserver mailserver webserver; do  virsh dumpxml ${i}${l} > $SUTphydir/vm-xml/5885HV3-${i}-${l}.xml; done
    fi
    done

    lspci > $SUTphydir/OS/lspci.txt
    rpm -qa > $SUTphydir/OS/rpmpkgs.txt
    chkconfig > $SUTphydir/OS/chkconfig.txt
    systemctl  list-unit-files > $SUTphydir/OS/systemctl.list-unit-files.txt
    scp -p 192.1.1.7:/opt/SPECvirt/3-setMTU.sh $SUTphydir/OS/setMTU.sh
    cp -p /home/tools/207bak/0-sh/1-kaijiqidong-client2/2-reload-ixgbe.sh $SUTphydir/OS/reload-ixgbe.sh

    mkdir -p  $SUTphydir/OS/boot/grub2
    cp -p /boot/grub2/grub.cfg $SUTphydir/OS/boot/grub2 
    
    mkdir -p  $SUTphydir/OS/etc
    cp -p /etc/sysctl.conf $SUTphydir/OS/etc
    cp -p /etc/fstab $SUTphydir/OS/etc
    cp -p /etc/hosts $SUTphydir/OS/etc
    cp -p /etc/inittab $SUTphydir/OS/etc
    cp -p /etc/exports $SUTphydir/OS/etc
    cp -p /etc/bashrc $SUTphydir/OS/etc
    cp -pr /etc/iproute2 $SUTphydir/OS/etc
    cp -p /etc/nsswitch.conf $SUTphydir/OS/etc
    mkdir -p  $SUTphydir/OS/etc/security
    cp -p /etc/security/limits.conf $SUTphydir/OS/etc/security
    cp -p /etc/rc.local $SUTphydir/OS/etc
    cp -p /etc/redhat-release $SUTphydir/OS/etc
    mkdir -p  $SUTphydir/OS/etc/rc.d
    cp -pr /etc/rc.d/rc3.d/ $SUTphydir/OS/etc/rc.d
    cp -pr /etc/rc.d/init.d/ $SUTphydir/OS/etc/rc.d
    mkdir -p  $SUTphydir/OS/etc/tuned
    cp -p /etc/tuned/active_profile $SUTphydir/OS/etc/tuned  
    
    mkdir -p  $SUTphydir/OS/var/log
    cp -p /var/log/dmesg $SUTphydir/OS/var/log    
 
    mkdir -p  $SUTphydir/OS/proc
    cat /proc/cmdline > $SUTphydir/OS/proc/cmdline
    cat /proc/cpuinfo > $SUTphydir/OS/proc/cpuinfo
    cat /proc/devices > $SUTphydir/OS/proc/devices
    cat /proc/meminfo > $SUTphydir/OS/proc/meminfo
    cat /proc/modules > $SUTphydir/OS/proc/modules
    cat /proc/partitions > $SUTphydir/OS/proc/partitions
    cat /proc/swaps  > $SUTphydir/OS/proc/swaps
    cat /proc/mounts  > $SUTphydir/OS/proc/mounts
    cat /proc/version  > $SUTphydir/OS/proc/version
    
    brctl show > $SUTphydir/Network/brctl-show.txt
    ifconfig > $SUTphydir/Network/ifconfig.txt
    route -n > $SUTphydir/Network/route.txt
   
    lvdisplay > $SUTphydir/Storage/lvdisplay.txt 2>/dev/null
    vgdisplay > $SUTphydir/Storage/vgdisplay.txt 2>/dev/null
    mount > $SUTphydir/Storage/mount.txt
    df > $SUTphydir/Storage/df.txt
    
    virsh list > $SUTphydir/SOFTW/virsh-list.txt
    ps -efl | grep qemu-kvm > $SUTphydir/SOFTW/running-vms.txt
}
#SUT VM configure
fn_getSUTVMInfo()
{
    for((i=1;i<=$1;i++))
    do
        appsoftdir=data_collection/VIRT/Tile$i/app/SOFTW
        mkdir -p $appsoftdir
        mkdir -p $appsoftdir/AppSrv01
        mkdir -p $appsoftdir/AppSrv02
        mkdir -p $appsoftdir/SPECjAppServer2004/config
        mkdir -p $appsoftdir/WebSphere-setup
	ssh 192.1.$i.4 "/opt/IBM/WebSphere/AppServer/java_1.7_64/bin/java -version" 1&> $appsoftdir/javaVersion.out 


	scp -p 192.1.$i.4:/opt/IBM/WebSphere/AppServer/profiles/AppSrv01/config/cells/appserver${i}Node01Cell/nodes/appserver${i}Node01/node-metadata.properties $appsoftdir/AppSrv01
	scp -p 192.1.$i.4:/opt/IBM/WebSphere/AppServer/profiles/AppSrv01/config/cells/appserver${i}Node01Cell/nodes/appserver${i}Node01/resources.xml $appsoftdir/AppSrv01
	scp -p 192.1.$i.4:/opt/IBM/WebSphere/AppServer/profiles/AppSrv01/config/cells/appserver${i}Node01Cell/nodes/appserver${i}Node01/servers/server1/server.xml $appsoftdir/AppSrv01
	scp -p 192.1.$i.4:/opt/IBM/WebSphere/AppServer/profiles/AppSrv01/config/cells/appserver${i}Node01Cell/nodes/appserver${i}Node01/serverindex.xml $appsoftdir/AppSrv01
	scp -p 192.1.$i.4:/opt/IBM/WebSphere/AppServer/profiles/AppSrv01/config/cells/appserver${i}Node01Cell/nodes/appserver${i}Node01/servers/server1/sib-engines.xml $appsoftdir/AppSrv01
	scp -p 192.1.$i.4:/opt/IBM/WebSphere/AppServer/profiles/AppSrv02/config/cells/appserver${i}Node02Cell/nodes/appserver${i}Node02/node-metadata.properties $appsoftdir/AppSrv02 
	scp -p 192.1.$i.4:/opt/IBM/WebSphere/AppServer/profiles/AppSrv02/config/cells/appserver${i}Node02Cell/nodes/appserver${i}Node02/resources.xml $appsoftdir/AppSrv02 
	scp -p 192.1.$i.4:/opt/IBM/WebSphere/AppServer/profiles/AppSrv02/config/cells/appserver${i}Node02Cell/nodes/appserver${i}Node02/servers/server1/server.xml $appsoftdir/AppSrv02 
	scp -p 192.1.$i.4:/opt/IBM/WebSphere/AppServer/profiles/AppSrv02/config/cells/appserver${i}Node02Cell/nodes/appserver${i}Node02/serverindex.xml $appsoftdir/AppSrv02 
	scp -p 192.1.$i.4:/opt/IBM/WebSphere/AppServer/profiles/AppSrv02/config/cells/appserver${i}Node02Cell/nodes/appserver${i}Node02/servers/server1/sib-engines.xml $appsoftdir/AppSrv02 


	scp -p 192.1.$i.4:/opt/SPECjAppServer2004/config/agent.properties $appsoftdir/SPECjAppServer2004/config
	scp -p 192.1.$i.4:/opt/SPECjAppServer2004/config/charts.properties $appsoftdir/SPECjAppServer2004/config
	scp -p 192.1.$i.4:/opt/SPECjAppServer2004/config/corpdb.properties $appsoftdir/SPECjAppServer2004/config
	scp -p 192.1.$i.4:/opt/SPECjAppServer2004/config/websphere.env     $appsoftdir/SPECjAppServer2004/config
	scp -p 192.1.$i.4:/opt/SPECjAppServer2004/config/mfgdb.properties $appsoftdir/SPECjAppServer2004/config
	scp -p 192.1.$i.4:/opt/SPECjAppServer2004/config/ordsdb.properties $appsoftdir/SPECjAppServer2004/config
	scp -p 192.1.$i.4:/opt/SPECjAppServer2004/config/run.properties $appsoftdir/SPECjAppServer2004/config
	scp -p 192.1.$i.4:/opt/SPECjAppServer2004/config/suppdb.properties $appsoftdir/SPECjAppServer2004/config
	scp -p 192.1.$i.4:/opt/SPECjAppServer2004/config/utildb.properties $appsoftdir/SPECjAppServer2004/config

	scp -p 192.1.$i.4:/opt/IBM/WebSphere/specj04_setup.jacl  $appsoftdir/WebSphere-setup
	scp -p 192.1.$i.4:/opt/IBM/WebSphere/specj04_resource_scripts.jacl  $appsoftdir/WebSphere-setup
	scp -p 192.1.$i.4:/opt/IBM/WebSphere/SupplierEmulator.ear  $appsoftdir/WebSphere-setup
	scp -p 192.1.$i.4:/opt/IBM/WebSphere/SPECjAppServer.ear  $appsoftdir/WebSphere-setup

        
        batchsoftdir=data_collection/VIRT/Tile$i/batch/SOFTW
        mkdir -p $batchsoftdir
        mkdir -p $batchsoftdir/SPECbatch/cpu2006
	scp -p 192.1.$i.6:/opt/SPECbatch/Test.config $batchsoftdir/SPECbatch/cpu2006
	scp -p 192.1.$i.6:/opt/SPECbatch/virt_sc2013_run.sh  $batchsoftdir/SPECbatch/cpu2006
	scp -p 192.1.$i.6:/opt/SPECbatch/cpu2006-virt/config/cpu2006-virt.cfg $batchsoftdir/SPECbatch/cpu2006
	ssh 192.1.$i.6 "java -version" 1&> $batchsoftdir/javaVersion.out
        
        infrasoftdir=data_collection/VIRT/Tile$i/infra/SOFTW
        mkdir -p $infrasoftdir
        mkdir -p $infrasoftdir/httpd
        scp -p 192.1.$i.1:/etc/httpd/conf/httpd.conf $infrasoftdir
        ssh 192.1.$i.1 "java -version" 1&> $infrasoftdir/javaVersion.out
        ssh 192.1.$i.1 "httpd -V" >$infrasoftdir/httpd/httpdVersion.out

        mailsoftdir=data_collection/VIRT/Tile$i/mail/SOFTW
        mkdir -p $mailsoftdir
        mkdir -p $mailsoftdir/SPECimap
        scp 192.1.$i.3:/var/run/dovecot/dovecot.conf $mailsoftdir
        ssh 192.1.$i.3 "java -version" 1&> $mailsoftdir/javaVersion.out
        ssh 192.1.$i.3 "cd /opt/SPECimap/;tar cf - {IMAP_config.rc,IMAP_fixed.rc}" 2>/dev/null | tar xvf - -C $mailsoftdir/SPECimap
        ssh 192.1.$i.3 "dovecot --version" > $mailsoftdir/dovecotVersion.out
        ssh 192.1.$i.3 "dovecot --build-options" >> $mailsoftdir/dovecotVersion.out

        websoftdir=data_collection/VIRT/Tile$i/web/SOFTW
        mkdir -p $websoftdir
        mkdir -p $websoftdir/SPECweb2005
        scp -p 192.1.$i.2:/opt/SPECweb2005/Test.config $websoftdir/SPECweb2005
        scp -p 192.1.$i.2:/opt/SPECweb2005/SPECweb_Support.config $websoftdir/SPECweb2005
        scp -p 192.1.$i.2:/etc/php.ini $websoftdir
        mkdir -p $websoftdir/nginx
        mkdir -p $websoftdir/nginx/conf.d
        ssh 192.1.$i.2 "nginx -V " 2>&1 | tee $websoftdir/nginx/nginxVersion
        scp -p 192.1.$i.2:/etc/nginx/nginx.conf $websoftdir/nginx/
        scp -p 192.1.$i.2:/etc/nginx/conf.d/default.conf $websoftdir/nginx/conf.d/
        scp -p 192.1.$i.2:/etc/nginx/conf.d/example_ssl.conf $websoftdir/nginx/conf.d/
        mkdir -p $websoftdir/php-fpm
        mkdir -p $websoftdir/php-fpm/php-fpm.d
        scp -p 192.1.$i.2:/etc/php-fpm.conf $websoftdir/php-fpm/
        scp -p 192.1.$i.2:/etc/php-fpm.d/www.conf $websoftdir/php-fpm/php-fpm.d/
        ssh 192.1.$i.2 "php-fpm -v" 1&> $websoftdir/php-fpm/php-fpmVersion 
	ssh 192.1.$i.2 "java -version" 1&> $websoftdir/javaVersion.out
        
        for((j=1;j<=6;j++))
        do	
            if [ $j == 1 ];then
                vmdir=data_collection/VIRT/Tile$i/infra/OS
            fi
            if [ $j == 2 ];then
                
                vmdir=data_collection/VIRT/Tile$i/web/OS
            fi
            if [ $j == 3 ];then
                vmdir=data_collection/VIRT/Tile$i/mail/OS
            fi
            if [ $j == 4 ];then
                vmdir=data_collection/VIRT/Tile$i/app/OS
            fi
            if [ $j == 5 ];then
	        continue
            fi
            if [ $j == 6 ];then
                vmdir=data_collection/VIRT/Tile$i/batch/OS
            fi
            mkdir -p $vmdir/boot/grub/
            scp -p 192.1.$i.$j:/boot/grub/grub.conf $vmdir/boot/grub/
            mkdir -p  $vmdir/etc/iproute2
            mkdir -p  $vmdir/etc/rc.d/init.d
            mkdir -p  $vmdir/etc/rc.d/rc3.d
            scp -p 192.1.$i.$j:/etc/iproute2/* $vmdir/etc/iproute2/
            scp -pr 192.1.$i.$j:/etc/rc.d/init.d/* $vmdir/etc/rc.d/init.d
            scp -p 192.1.$i.$j:/etc/rc.d/rc3.d/* $vmdir/etc/rc.d/rc3.d
            scp -p 192.1.$i.$j:/etc/fstab $vmdir/etc
            scp -p 192.1.$i.$j:/etc/hosts $vmdir/etc
            scp -p 192.1.$i.$j:/etc/inittab $vmdir/etc
            scp -p 192.1.$i.$j:/etc/nsswitch.conf $vmdir/etc
            scp -p 192.1.$i.$j:/etc/sysctl.conf $vmdir/etc
            scp -p 192.1.$i.$j:/etc/rc.local $vmdir/etc
            scp -p 192.1.$i.$j:/etc/bashrc $vmdir/etc
            scp -p 192.1.$i.$j:/etc/exports $vmdir/etc
            scp -p 192.1.$i.$j:/etc/redhat-release $vmdir/etc
            mkdir -p  $vmdir/etc/sysconfig/network-scripts/
            scp -p 192.1.$i.$j:/etc/sysconfig/network-scripts/ifcfg* $vmdir/etc/sysconfig/network-scripts
            scp -p 192.1.$i.$j:/etc/sysconfig/network $vmdir/etc/sysconfig
	    mkdir -p $vmdir/etc/modprobe.d
	    scp -p 192.1.$i.$j:/etc/modprobe.d/ixgbevf.conf $vmdir/etc/modprobe.d/
            mkdir -p  $vmdir/proc
            ssh 192.1.$i.$j "cat /proc/cmdline" > $vmdir/proc/cmdline
            ssh 192.1.$i.$j "cat /proc/cpuinfo" > $vmdir/proc/cpuinfo
            ssh 192.1.$i.$j "cat /proc/devices" > $vmdir/proc/devices
            ssh 192.1.$i.$j "cat /proc/meminfo" > $vmdir/proc/meminfo
            ssh 192.1.$i.$j "cat /proc/modules" > $vmdir/proc/modules
            ssh 192.1.$i.$j "cat /proc/mounts" > $vmdir/proc/mounts
            ssh 192.1.$i.$j "cat /proc/partitions" > $vmdir/proc/partitions
            ssh 192.1.$i.$j "cat /proc/swaps" > $vmdir/proc/swaps
            ssh 192.1.$i.$j "cat /proc/version" > $vmdir/proc/version
            ssh 192.1.$i.$j "chkconfig" > $vmdir/chkconfig.txt
            ssh 192.1.$i.$j "df" > $vmdir/df.txt
            ssh 192.1.$i.$j "ifconfig" > $vmdir/ifconfig.txt
            ssh 192.1.$i.$j "lspci" > $vmdir/lspci.txt
            ssh 192.1.$i.$j "mount" > $vmdir/mount.txt
            ssh 192.1.$i.$j "rpm -qa" > $vmdir/rpmpkgs.txt
            ssh 192.1.$i.$j "tuned-adm active" > $vmdir/tuned-adm-active.txt
	    mkdir -p  $vmdir/etc/security
	    scp -p 192.1.$i.$j:/etc/security/limits.conf  $vmdir/etc/security/
        done
    done
    for((i=1;i<=$1;))
    do
        dbsoftdir=data_collection/VIRT/Tile$i/db/SOFTW
        mkdir -p $dbsoftdir
	mkdir -p $dbsoftdir/schema
	#scp -r 192.1.$i.5:/opt/SUNWjAppServer2004/schema/mysql*/* $dbsoftdir/schema/
        scp -pr 192.1.$i.5:/opt/SPECjAppServer2004/schema/db2/* $dbsoftdir/schema/
        ssh  db2inst1@192.1.$i.5 "db2 get db cfg for specdb"> $dbsoftdir/db2.db.cfg
        ssh  db2inst1@192.1.$i.5 "db2 get dbm cfg" > $dbsoftdir/db2.dbm.cfg
        ssh  db2inst1@192.1.$i.5 "db2set" > $dbsoftdir/db2set
        scp  -p 192.1.$i.5:/home/db2inst1/sqllib/db2nodes.cfg  $dbsoftdir/db2nodes.cfg
	ssh 192.1.$i.5 "java -version" 1&> $dbsoftdir/javaVersion.out


	vmdir=data_collection/VIRT/Tile$i/db/OS
        mkdir -p $vmdir/boot/grub/
        scp -p 192.1.$i.5:/boot/grub/grub.conf $vmdir/boot/grub/
        mkdir -p  $vmdir/etc/iproute2
        mkdir -p  $vmdir/etc/rc.d/init.d
        mkdir -p  $vmdir/etc/rc.d/rc3.d
        scp -p 192.1.$i.5:/etc/iproute2/* $vmdir/etc/iproute2/
        scp -pr 192.1.$i.5:/etc/rc.d/init.d/* $vmdir/etc/rc.d/init.d
        scp -p 192.1.$i.5:/etc/rc.d/rc3.d/* $vmdir/etc/rc.d/rc3.d
        scp -p 192.1.$i.5:/etc/fstab $vmdir/etc
        scp -p 192.1.$i.5:/etc/hosts $vmdir/etc
        scp -p 192.1.$i.5:/etc/inittab $vmdir/etc
        scp -p 192.1.$i.5:/etc/nsswitch.conf $vmdir/etc
        scp -p 192.1.$i.5:/etc/sysctl.conf $vmdir/etc
        scp -p 192.1.$i.5:/etc/rc.local $vmdir/etc
        scp -p 192.1.$i.5:/etc/bashrc $vmdir/etc
        scp -p 192.1.$i.$j:/etc/exports $vmdir/etc
        scp -p 192.1.$i.$j:/etc/redhat-release $vmdir/etc
        mkdir -p  $vmdir/etc/sysconfig/network-scripts/
        scp -p 192.1.$i.5:/etc/sysconfig/network-scripts/ifcfg* $vmdir/etc/sysconfig/network-scripts
        scp -p 192.1.$i.5:/etc/sysconfig/network $vmdir/etc/sysconfig
        mkdir -p $vmdir/etc/modprobe.d
        scp -p 192.1.$i.$j:/etc/modprobe.d/ixgbevf.conf $vmdir/etc/modprobe.d/
        mkdir -p  $vmdir/proc
        ssh 192.1.$i.5 "cat /proc/cmdline" > $vmdir/proc/cmdline
        ssh 192.1.$i.5 "cat /proc/cpuinfo" > $vmdir/proc/cpuinfo
        ssh 192.1.$i.5 "cat /proc/devices" > $vmdir/proc/devices
        ssh 192.1.$i.5 "cat /proc/meminfo" > $vmdir/proc/meminfo
        ssh 192.1.$i.5 "cat /proc/modules" > $vmdir/proc/modules
        ssh 192.1.$i.5 "cat /proc/mounts" > $vmdir/proc/mounts
        ssh 192.1.$i.5 "cat /proc/partitions" > $vmdir/proc/partitions
        ssh 192.1.$i.5 "cat /proc/swaps" > $vmdir/proc/swaps
        ssh 192.1.$i.5 "cat /proc/version" > $vmdir/proc/version
        ssh 192.1.$i.5 "chkconfig" > $vmdir/chkconfig.txt
        ssh 192.1.$i.5 "df" > $vmdir/df.txt
        ssh 192.1.$i.5 "ifconfig" > $vmdir/ifconfig.txt
        ssh 192.1.$i.5 "lspci" > $vmdir/lspci.txt
        ssh 192.1.$i.5 "mount" > $vmdir/mount.txt
        ssh 192.1.$i.5 "rpm -qa" > $vmdir/rpmpkgs.txt
        ssh 192.1.$i.5 "tuned-adm active" > $vmdir/tuned-adm-active.txt
        mkdir -p  $vmdir/etc/security
	scp -p 192.1.$i.5:/etc/security/limits.conf  $vmdir/etc/security/

        i=$((i+4))
    done
}

fn_main()
{
    date > data_collection/data-collection-start.txt

    mkdir -p data_collection/Collection_scripts
    cp -p collect-data.sh data_collection/Collection_scripts
    fn_getClientInfo
    fn_getSUTInfo 47
    fn_getSUTVMInfo 47
    date > data_collection/data-collection-end.txt

}
fn_main
