#! /bin/bash

# Set the nice value for SPECvirt VMs.

# These are the default renice values the script will set for the
# SPECvirt VMs.  If you want different values, you can either edit this file
# to change the defaults, or you can override any of the values on the
# command line when you run this script, e.g.,
# renice.sh app=-16 web=10
app='-19'
db='-16'
web='0'
infra='19'
mail='19'
batch='19'

# Set any of these values if you want a separate renice value for the
# I/O thread (main qemu orocess) af any of the VMs.
app_io=''
db_io=''
web_io=''
infra_io=''
mail_io=''
batch_io=''

# Process command line arguments.
for arg; do
	case "$arg" in
		*=*)
			# Variable setting
			export "$arg"
		;;
		-*)
			# Option
		;;
		*)
			# Anything else
		;;
	esac
done

# Must use "ps -eL" to get the process IDs of all the threads for a VM.
# Renicing just the main qemu process does not propigate the renice value down
# to its VCPU threads.

renice   $app `ps -eL -o tid,cmd | grep 'qemu.*appt'   | grep -v grep | awk '{print $1}'`
renice    $db `ps -eL -o tid,cmd | grep 'qemu.*dbt'    | grep -v grep | awk '{print $1}'`
renice   $web `ps -eL -o tid,cmd | grep 'qemu.*webt'   | grep -v grep | awk '{print $1}'`
renice $infra `ps -eL -o tid,cmd | grep 'qemu.*infrat' | grep -v grep | awk '{print $1}'`
renice  $mail `ps -eL -o tid,cmd | grep 'qemu.*mailt'  | grep -v grep | awk '{print $1}'`
renice $batch `ps -eL -o tid,cmd | grep 'qemu.*batcht' | grep -v grep | awk '{print $1}'`

function get_io_thread_pids {
	local vm_type=$1

	# The libvirt XML for the running VMs has the PID of the main quemu
	# thread and the PIDs of all the VCPUs, but not the PID of the I/O
	# thread.  To get the list of I/O thread PIDs, get the list of all the
	# PIDs for the VM type and remove any PIDs found in the VMs XML files.
	VM_PIDS=`ps -eL -o tid,cmd | grep 'qemu.*'$vm_type | grep -v grep | awk '{print $1}'`
	VM_PIDS=`echo " "$VM_PIDS" "`
	VM_PIDS=${VM_PIDS// /  }
	VM_MAIN_AND_VCPU_PIDS=`grep pid= /var/run/libvirt/qemu/*$vm_type*.xml | sed -e "s/.*pid='\([0-9]\+\)'.*/\1/"`
	for PID in $VM_MAIN_AND_VCPU_PIDS; do
		VM_PIDS=${VM_PIDS/ $PID /}
	done
	echo $VM_PIDS
}


if [ -n "$app_io" ]; then
	IO_PIDS=`get_io_thread_pids appt`
	if [ -n "$IO_PIDS" ]; then
		renice   $app_io $IO_PIDS
	fi
fi
if [ -n "$db_io" ]; then
	IO_PIDS=`get_io_thread_pids dbt`
	if [ -n "$IO_PIDS" ]; then
		renice    $db_io $IO_PIDS
	fi
fi
if [ -n "$web_io" ]; then
	IO_PIDS=`get_io_thread_pids webt`
	if [ -n "$IO_PIDS" ]; then
		renice   $web_io $IO_PIDS
	fi
fi
if [ -n "$infra_io" ]; then
	IO_PIDS=`get_io_thread_pids infrat`
	if [ -n "$IO_PIDS" ]; then
		renice $infra_io $IO_PIDS
	fi
fi
if [ -n "$mail_io" ]; then
	IO_PIDS=`get_io_thread_pids mailt`
	if [ -n "$IO_PIDS" ]; then
		renice  $mail_io $IO_PIDS
	fi
fi
if [ -n "$batch_io" ]; then
	IO_PIDS=`get_io_thread_pids batcht`
	if [ -n "$IO_PIDS" ]; then
		renice $batch_io $IO_PIDS
	fi
fi

# Now display the current renice values in a human readable form.
ps -eL -o pid,nice,cmd | grep 'qemu.*appt'   | grep -v grep | awk '{print $1,$2,$5}'
ps -eL -o pid,nice,cmd | grep 'qemu.*dbt'    | grep -v grep | awk '{print $1,$2,$5}'
ps -eL -o pid,nice,cmd | grep 'qemu.*webt'   | grep -v grep | awk '{print $1,$2,$5}'
ps -eL -o pid,nice,cmd | grep 'qemu.*infrat' | grep -v grep | awk '{print $1,$2,$5}'
ps -eL -o pid,nice,cmd | grep 'qemu.*mailt'  | grep -v grep | awk '{print $1,$2,$5}'
ps -eL -o pid,nice,cmd | grep 'qemu.*batcht' | grep -v grep | awk '{print $1,$2,$5}'
