#! /bin/bash
prefix=vs-
client_vm_topology="vn-ct01:vs-vct01,vs-vct09,vs-vct17,vs-vct25,vs-vct33,vs-vct41,vs-vct49,vs-vct57,vs-vct65,vs-vct73,vs-vct81::vn-ct02:vs-vct02,vs-vct10,vs-vct18,vs-vct26,vs-vct34,vs-vct42,vs-vct50,vs-vct58,vs-vct66,vs-vct74,vs-vct82::vn-ct03:vs-vct03,vs-vct11,vs-vct19,vs-vct27,vs-vct35,vs-vct43,vs-vct51,vs-vct59,vs-vct67,vs-vct75,vs-vct83::vn-ct04:vs-vct04,vs-vct12,vs-vct20,vs-vct28,vs-vct36,vs-vct44,vs-vct52,vs-vct60,vs-vct68,vs-vct76,vs-vct84::vn-ct05:vs-vct05,vs-vct13,vs-vct21,vs-vct29,vs-vct37,vs-vct45,vs-vct53,vs-vct61,vs-vct69,vs-vct77,vs-vct85::vn-ct06:vs-vct06,vs-vct14,vs-vct22,vs-vct30,vs-vct38,vs-vct46,vs-vct54,vs-vct62,vs-vct70,vs-vct78,vs-vct86::vn-ct07:vs-vct07,vs-vct15,vs-vct23,vs-vct31,vs-vct39,vs-vct47,vs-vct55,vs-vct63,vs-vct71,vs-vct79,vs-vct87::vn-ct08:vs-master,vs-vct08,vs-vct16,vs-vct24,vs-vct32,vs-vct40,vs-vct48,vs-vct56,vs-vct64,vs-vct72,vs-vct80,vs-vct88"
SSH_OPTIONS="-o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no"
echo "Gathering client data..."
cat_files='proc/cpuinfo proc/devices proc/meminfo proc/modules proc/partitions proc/swaps'
tar_files='boot/grub/grub.conf boot/efi/EFI/redhat/grub.conf etc/fstab etc/hosts etc/inittab etc/iproute2 etc/nsswitch.conf etc/rc.local etc/sysctl.conf usr/lib/sysctl.d/*specvirt.conf etc/rc.d/rc3.d/ etc/rc.d/init.d/ var/log/dmesg etc/kvm/vm-scripts/ etc/kvm/*ifup*'

for phys_client_and_vms in ${client_vm_topology//::/ }; do
    phys_client=`echo $phys_client_and_vms | awk -F: '{print $1}'`
    echo "phys_client is $phys_client"
    mkdir -p $phys_client
    pushd $phys_client >/dev/null
    mkdir OS
    pushd OS >/dev/null
    ssh $SSH_OPTIONS $phys_client "cd /; tar chf - $tar_files" | tar xf -
    mkdir -p proc
    for file in $cat_files; do
        ssh $SSH_OPTIONS $phys_client "cat /$file" >$file
    done
    ssh $SSH_OPTIONS $phys_client ifconfig -a >ifconfig.txt
    ssh $SSH_OPTIONS $phys_client brctl show >brctl-show.txt
    ssh $SSH_OPTIONS $phys_client chkconfig --list >chkconfig.txt
    ssh $SSH_OPTIONS $phys_client mount -l >mount.txt
    ssh $SSH_OPTIONS $phys_client df >df.txt
    ssh $SSH_OPTIONS $phys_client lspci >lspci.txt
    ssh $SSH_OPTIONS $phys_client rpm -qa >rpmpkgs.txt
    ssh $SSH_OPTIONS $phys_client vgdisplay >vgdisplay.txt
    ssh $SSH_OPTIONS $phys_client lvdisplay >lvdisplay.txt
    ssh $SSH_OPTIONS $phys_client "ps aux | grep qemu-kvm | grep -v grep" >running-vms.txt
    ssh $SSH_OPTIONS $phys_client "virsh list" >virsh-list.txt
    popd >/dev/null
    vm_clients=`echo $phys_client_and_vms | sed -e s/^${phys_client}':*'//`
    if [ -n "$vm_clients" ]; then
        mkdir -p guest-xml-config
        pushd guest-xml-config >/dev/null
        for vm_client in ${vm_clients//,/ }; do
            scp -p $SSH_OPTIONS ${phys_client}:/autobench/logs/null-bench*/config/libvirt.guest.before.001/${vm_client}.xml .
        done
        popd >/dev/null

        for vm_client in ${vm_clients//,/ }; do
            echo "  vm_client is $vm_client"
            zpt=`echo $vm_client | sed -e 's/.*t\([0-9]\+\)$/\1/'`
            if [ "$zpt" != "$vm_client" ]; then
                mkdir -p tile${zpt}
                pushd tile${zpt} >/dev/null
            else
                mkdir -p ${vm_client#$prefix}
                pushd ${vm_client#$prefix} >/dev/null
            fi
            mkdir OS
            pushd OS >/dev/nell
            ssh $SSH_OPTIONS $vm_client "cd /; tar chf - $tar_files" | tar xf -
            mkdir proc
            for file in $cat_files; do
                ssh $SSH_OPTIONS $vm_client cat /$file >$file
            done
            ssh $SSH_OPTIONS $vm_client ifconfig -a >ifconfig.txt
            ssh $SSH_OPTIONS $vm_client chkconfig --list >chkconfig.txt
            ssh $SSH_OPTIONS $vm_client mount -l >mount.txt
            ssh $SSH_OPTIONS $vm_client df >df.txt
            ssh $SSH_OPTIONS $vm_client lspci >lspci.txt
            ssh $SSH_OPTIONS $vm_client rpm -qa >rpmpkgs.txt
            popd >/dev/null
            mkdir VM
            pushd VM >/dev/null
            mkdir -p SPECjAppServer2004/config
            scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECjAppServer2004-prime/config/appsserver SPECjAppServer2004/config/
            scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECjAppServer2004-prime/config/run.properties SPECjAppServer2004/config/
            scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECjAppServer2004-prime/config/default.env SPECjAppServer2004/config/
            mkdir SPECweb2005
            scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECweb2005-prime/Test.config SPECweb2005/
            scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECweb2005-prime/SPECweb_Support.config SPECweb2005/
            mkdir SPECimap
            scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECimap-prime/IMAP_config.rc SPECimap/
            scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECimap-prime/IMAP_fixed.rc SPECimap/
            scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECimap-prime/IMAP_sysinfo.rc SPECimap/
            mkdir SPECbatch
            scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECbatch-prime/Test.config SPECbatch/
            popd >/dev/null
            popd >/dev/null
        done
    fi
    popd >/dev/null
done
