#! /bin/bash
prefix=vs-
client_vm_topology="vn-ct03:vs-master,vs-vct37,vs-vct38,vs-vct39,vs-vct40,vs-vct41,vs-vct42,vs-vct43,vs-vct44,vs-vct45,vs-vct46,vs-vct47::vn-ct04:vs-vct01,vs-vct04,vs-vct07,vs-vct10,vs-vct13,vs-vct16,vs-vct19,vs-vct22,vs-vct25,vs-vct28,vs-vct31,vs-vct34::vn-ct05:vs-vct02,vs-vct05,vs-vct08,vs-vct11,vs-vct14,vs-vct17,vs-vct20,vs-vct23,vs-vct26,vs-vct29,vs-vct32,vs-vct35::vn-ct06:vs-vct03,vs-vct06,vs-vct09,vs-vct12,vs-vct15,vs-vct18,vs-vct21,vs-vct24,vs-vct27,vs-vct30,vs-vct33,vs-vct36"
SSH_OPTIONS="-o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no"
echo "Gathering client data..."
cat_files='proc/cpuinfo proc/devices proc/meminfo proc/modules proc/partitions proc/swaps'
tar_files='boot/grub/grub.conf boot/efi/EFI/redhat/grub.conf etc/fstab etc/hosts etc/inittab etc/iproute2 etc/nsswitch.conf etc/rc.local etc/sysctl.conf usr/lib/sysctl.d/*specvirt.conf etc/rc.d/rc3.d/ etc/rc.d/init.d/ var/log/dmesg etc/kvm/vm-scripts/ etc/kvm/*ifup*'

for phys_client_and_vms in ${client_vm_topology//::/ }; do
    phys_client=`echo $phys_client_and_vms | awk -F: '{print $1}'`
    echo "phys_client is $phys_client"
    mkdir -p $phys_client
    pushd $phys_client >/dev/null
    ssh $SSH_OPTIONS $phys_client "cd /; tar chf - $tar_files" | tar xf -
    mkdir -p proc
    for file in $cat_files; do
        ssh $SSH_OPTIONS $phys_client "cat /$file" >$file
    done
    ssh $SSH_OPTIONS $phys_client ifconfig -a >ifconfig.txt
    ssh $SSH_OPTIONS $phys_client brctl show >brctl-show.txt
    ssh $SSH_OPTIONS $phys_client chkconfig --list >chkconfig.txt
    ssh $SSH_OPTIONS $phys_client mount -l >mount.txt
    ssh $SSH_OPTIONS $phys_client df >df.txt
    ssh $SSH_OPTIONS $phys_client lspci >lspci.txt
    ssh $SSH_OPTIONS $phys_client rpm -qa >rpmpkgs.txt
    ssh $SSH_OPTIONS $phys_client vgdisplay >vgdisplay.txt
    ssh $SSH_OPTIONS $phys_client lvdisplay >lvdisplay.txt
    ssh $SSH_OPTIONS $phys_client "ps aux | grep qemu-kvm | grep -v grep" >running-vms.txt
    ssh $SSH_OPTIONS $phys_client "virsh list" >virsh-list.txt
    vm_clients=`echo $phys_client_and_vms | sed -e s/^${phys_client}':*'//`
    if [ -n "$vm_clients" ]; then
        mkdir -p guest-xml-config
        pushd guest-xml-config >/dev/null
        for vm_client in ${vm_clients//,/ }; do
            scp -p $SSH_OPTIONS ${phys_client}:/autobench/logs/null-bench*/config/libvirt.guest.before.001/${vm_client}.xml .
        done
        popd >/dev/null

        for vm_client in ${vm_clients//,/ }; do
            echo "  vm_client is $vm_client"
            zpt=`echo $vm_client | sed -e 's/.*t\([0-9]\+\)$/\1/'`
            mkdir -p tile${zpt}
            pushd tile${zpt} >/dev/null
            ssh $SSH_OPTIONS $vm_client "cd /; tar chf - $tar_files" | tar xf -
            mkdir proc
            for file in $cat_files; do
                ssh $SSH_OPTIONS $vm_client cat /$file >$file
            done
            ssh $SSH_OPTIONS $vm_client ifconfig -a >ifconfig.txt
            ssh $SSH_OPTIONS $vm_client chkconfig --list >chkconfig.txt
            ssh $SSH_OPTIONS $vm_client mount -l >mount.txt
            ssh $SSH_OPTIONS $vm_client df >df.txt
            ssh $SSH_OPTIONS $vm_client lspci >lspci.txt
            ssh $SSH_OPTIONS $vm_client rpm -qa >rpmpkgs.txt
            mkdir -p SPECjAppServer2004/config
            scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECjAppServer2004-prime/config/appsserver SPECjAppServer2004/config/
            scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECjAppServer2004-prime/config/run.properties SPECjAppServer2004/config/
            scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECjAppServer2004-prime/config/default.env SPECjAppServer2004/config/
            mkdir SPECweb2005
            scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECweb2005-prime/Test.config SPECweb2005/
            scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECweb2005-prime/SPECweb_Support.config SPECweb2005/
            mkdir SPECimap
            scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECimap-prime/IMAP_config.rc SPECimap/
            scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECimap-prime/IMAP_fixed.rc SPECimap/
            scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECimap-prime/IMAP_sysinfo.rc SPECimap/
            mkdir SPECbatch
            scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECbatch-prime/Test.config SPECbatch/
            popd >/dev/null
        done
    fi
    popd >/dev/null
done
