#! /bin/bash

# Set the nice value for SPECvirt VMs.

# These are the default renice values the script will set for the
# SPECvirt VMs.  If you want different values, you can either edit this file
# to change the defaults, or you can override any of the values on the
# command line when you run this script, e.g.,
# renice.sh app=-16 web=10
app='-19'
db='-16'
web='0'
infra='19'
mail='19'
batch='19'

# Process command line arguments.
for arg; do
	case "$arg" in
		*=*)
			# Varialbe setting
			export "$arg"
		;;
		-*)
			# Option
		;;
		*)
			# Anything else
		;;
	esac
done

# Must use "ps -eL" to get the process IDs of all the threads for a VM.
# Renicing just the main qemu process does not propigate the renice value down
# to its VCPU threads.

renice   $app `ps -eL -o tid,cmd | grep   appt | grep -v grep | awk '{print $1}'`
renice    $db `ps -eL -o tid,cmd | grep    dbt | grep -v grep | awk '{print $1}'`
renice   $web `ps -eL -o tid,cmd | grep   webt | grep -v grep | awk '{print $1}'`
renice $infra `ps -eL -o tid,cmd | grep infrat | grep -v grep | awk '{print $1}'`
renice  $mail `ps -eL -o tid,cmd | grep  mailt | grep -v grep | awk '{print $1}'`
renice $batch `ps -eL -o tid,cmd | grep batcht | grep -v grep | awk '{print $1}'`

# Now display the current renice values in a human readable form.
ps -eL -o pid,nice,cmd | grep 'qemu.*appt'   | grep -v grep | awk '{print $1,$2,$5}'
ps -eL -o pid,nice,cmd | grep 'qemu.*dbt'    | grep -v grep | awk '{print $1,$2,$5}'
ps -eL -o pid,nice,cmd | grep 'qemu.*webt'   | grep -v grep | awk '{print $1,$2,$5}'
ps -eL -o pid,nice,cmd | grep 'qemu.*infrat' | grep -v grep | awk '{print $1,$2,$5}'
ps -eL -o pid,nice,cmd | grep 'qemu.*mailt'  | grep -v grep | awk '{print $1,$2,$5}'
ps -eL -o pid,nice,cmd | grep 'qemu.*batcht' | grep -v grep | awk '{print $1,$2,$5}'
