#! /bin/bash

# This script can be called with a vm= parameter
# or it can be symlinked by a script that has the name of the VM.

etc_kvm_dir="/etc/kvm"
vm=""

for arg; do export "$arg"; done

if [ -z "$vm" ]; then
	vm=${0##*/}
	vm=${vm%.*}
fi

etc_kvm_dir=${etc_kvm_dir%/}	# Strip off any trailing slash.
mac_to_vm_file="$etc_kvm_dir/mac-to-vm.txt"

# Get the SRIOV PCI device for the VM from the VM's libvirt definition.
# RHEL 6 format
PCI_CFG=$(virsh dumpxml $vm | grep 'address domain')
if [ -z "$PCI_CFG" ]; then
	# Try RHEL 7 format
	PCI_CFG=$(virsh dumpxml $vm | grep "address type='pci' domain='0x0000' bus='0x[^0]\{2\}")
fi
if [ -n "$PCI_CFG" ]; then
	BUS=$(echo $PCI_CFG|sed -e 's/.*bus='"'"'0x\([0-9a-fA-F]\+\)'"'"'.*/\1/')
	SLOT=$(echo $PCI_CFG|sed -e 's/.*slot='"'"'0x\([0-9a-fA-F]\+\)'"'"'.*/\1/')
	FUNCTION=$(echo $PCI_CFG|sed -e 's/.*function='"'"'0x\([0-9a-fA-F]\+\)'"'"'.*/\1/')

	# Get the VM's MAC address from the mac-to-vm.txt file.
	MAC=$(grep $vm $mac_to_vm_file | cut -d, -f1)

	# Set the MAC address on the VM's VF.
	$etc_kvm_dir/set-vf-mac.sh pci=$BUS:$SLOT.$FUNCTION mac=$MAC
else
	echo "$vm does not appear to be configured for SR-IOV."
	echo 'Using the normal "virsh start" to start the VM.'
fi

#Now start the VM.
echo "virsh start $vm"
virsh start $vm

