#!/bin/bash
. /etc/kvm/kvm_vars.sh
for arg ; do export "$arg" ; done
if [ -z "$num" ]; then
    echo "You must specify which client to start with the \"num=\" parameter."
    exit 1
fi
cpus=${cpus:-2}
mem=${mem:-3584}
start_vm_num=${start_vm_num:-${vms_to_start%% *}}
start_vm_num=${start_vm_num:-1}
num_bridges=${num_bridges:-$(ifconfig |grep ^br[1-9] | wc -l)}
prefix=vw-vct
decnum=`printf "%02d" $num`
hexnum=`printf "%02x" $num`
name=${prefix}$decnum
echo "Starting $name"
dev1=/var/lib/libvirt/images/nfs/${prefix}${decnum}-1.img
vnc_port="61${decnum}"
monitor_port="130${decnum}"
serial_port="140${decnum}"
macaddr="00:50:58:63:00:${hexnum}"
bridge_id=$(( (num-start_vm_num)%num_bridges + 1 ))
echo "  bridge_id is $bridge_id"
qemu=/usr/libexec/qemu-kvm
first_cpu=$(( (num-start_vm_num) % 8 ))
cpu_set=`cat /sys/devices/system/cpu/cpu${first_cpu}/topology/thread_siblings_list`
echo "  binding to cpus: $cpu_set"
launch="numactl --physcpubind=$cpu_set"
$launch $qemu\
    -name $name\
    -drive file=$dev1,if=virtio,boot=on,cache=writeback\
    -net nic,model=virtio,vlan=0,macaddr=$macaddr\
    -net tap,vlan=0,ifname=vct${decnum},script=/etc/kvm/qemu-ifup-br$bridge_id\
    -m $mem\
    -no-kvm-pit-reinjection\
    -vnc :$vnc_port\
    -cpu qemu64,+x2apic -smp $cpus\
    -monitor telnet::$monitor_port,server,nowait\
    -serial telnet::$serial_port,server,nowait\
    -daemonize
