#!/bin/bash
num=99
hexnum=`printf "%02x" $num`
num=97
cpus=${cpus:-2}
mem=${mem:-3072}
num_bridges=${num_bridges:-$(ifconfig |grep ^br[1-9] | wc -l)}
prefix=vg-vct
decnum=`printf "%02d" $num`
name=vg-master
echo "Starting $name"
dev1=/var/lib/libvirt/images/nfs/vg-master.img
vnc_port="61${decnum}"
monitor_port="130${decnum}"
serial_port="140${decnum}"
macaddr="00:50:58:79:00:${hexnum}"
bridge_id=$(( (num-1)%num_bridges + 1 ))
echo "  bridge_id is $bridge_id"
qemu=/usr/libexec/qemu-kvm
first_cpu=$(( ($num -1) % 8 ))
cpu_set=`cat /sys/devices/system/cpu/cpu${first_cpu}/topology/thread_siblings_list`
# echo "  binding to cpus: $cpu_set"
# launch="numactl --physcpubind=$cpu_set"
$launch $qemu\
    -name $name\
    -drive file=$dev1,if=virtio,boot=on,cache=none,aio=native\
    -net nic,model=virtio,vlan=0,macaddr=$macaddr\
    -net tap,vlan=0,ifname=vct${decnum},script=/etc/kvm/qemu-ifup-br$bridge_id\
    -m $mem\
    -vnc :$vnc_port\
    -cpu qemu64,+x2apic -smp $cpus\
    -monitor telnet::$monitor_port,server,nowait\
    -serial telnet::$serial_port,server,nowait\
    -daemonize
