#!/bin/bash
# this script assumes you are in the System_Under_Test directory already

. /root/specvirt_vars.sh

sut=${prefix}${host}
cp_files="proc/cpuinfo proc/devices proc/meminfo proc/modules proc/partitions proc/swaps proc/mounts proc/version proc/cmdline"
tar_files="boot/grub/grub.conf etc/fstab etc/hosts etc/inittab etc/iproute2 etc/nsswitch.conf etc/sysctl.conf etc/security/limits* etc/modprobe* etc/rc.local /etc/cgconfig.conf etc/rc.d/rc3.d/ etc/rc.d/init.d/ var/log/dmesg etc/kvm/vm-scripts/*t??.sh etc/kvm/*ifup*"
ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no $sut "cd /; tar chf - $tar_files" | tar xf -
mkdir proc

for file in $cp_files; do
    ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no $sut cat /$file >./$file
done
ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no $sut ifconfig -a >ifconfig.txt
ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no $sut brctl show >brctl-show.txt
ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no $sut chkconfig --list >chkconfig.txt
ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no $sut mount -l >mount.txt
ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no $sut df >df.txt
ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no $sut lspci >lspci.txt
ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no $sut rpm -qa >rpmpkgs.txt
ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no $sut vgdisplay >vgdisplay.txt
ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no $sut lvdisplay >lvdisplay.txt
ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no $sut "ps axlf | grep qemu-kvm | grep -v grep" >running-vms.txt
ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no $sut "virsh list" >virsh-list.txt
