#!/bin/bash
# this script assumes you are in the Clients directory already

. /root/specvirt_vars.sh

client_vm_topology="$2"

cp_files="proc/cpuinfo proc/devices proc/meminfo proc/modules proc/partitions proc/swaps"
tar_files="boot/grub/grub.conf etc/fstab etc/hosts etc/inittab etc/iproute2 etc/nsswitch.conf etc/rc.local etc/sysctl.conf etc/rc.d/rc3.d/ etc/rc.d/init.d/ var/log/dmesg etc/kvm/vm-scripts/ etc/kvm/*ifup*"

for phys_client_and_vms in `echo $client_vm_topology | sed -e s/"::"/"  "/g`; do
    phys_client=`echo $phys_client_and_vms | awk -F: '{print $1}'`
    echo "phys_client is $phys_client"
    mkdir -p $phys_client
    pushd $phys_client
    ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no $phys_client "cd /; tar chf - $tar_files" | tar xf -
    mkdir -p proc
    for file in $cp_files; do
        echo ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no $phys_client cat /$file 
        ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no $phys_client cat /$file >./$file
    done
    ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no $phys_client ifconfig -a >ifconfig.txt
    ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no $phys_client brctl show >brctl-show.txt
    ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no $phys_client chkconfig --list >chkconfig.txt
    ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no $phys_client mount -l >mount.txt
    ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no $phys_client df >df.txt
    ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no $phys_client lspci >lspci.txt
    ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no $phys_client rpm -qa >rpmpkgs.txt
    ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no $phys_client vgdisplay >vgdisplay.txt
    ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no $phys_client lvdisplay >lvdisplay.txt
    ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no $phys_client "ps aux | grep qemu-kvm | grep -v grep" >running-vms.txt
    ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no $phys_client "virsh list" >virsh-list.txt
    vm_clients=`echo $phys_client_and_vms | sed -e s/"^${phys_client}:"//`
    for vm_client in `echo $vm_clients | sed -e s/","/" "/g`; do
	echo "  vm_client is $vm_client"
	zpt=`echo $vm_client | sed -e s/"^${prefix}${client}t"//`
	mkdir -p tile${zpt}
	pushd tile${zpt}
	ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no $vm_client "cd /; tar chf - $tar_files" | tar xf -
	mkdir ./proc
	for file in $cp_files; do
 	    ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no $vm_client cat /$file >./$file
	done
	ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no  $vm_client ifconfig -a >ifconfig.txt
	ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no  $vm_client chkconfig --list >chkconfig.txt
	ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no  $vm_client mount -l >mount.txt
	ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no  $vm_client df >df.txt
	ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no  $vm_client lspci >lspci.txt
	ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no  $vm_client rpm -qa >rpmpkgs.txt
	popd >/dev/null
    done
    popd >/dev/null
done




