#!/bin/bash
num=19
echo num is $num
prefix=vg-vct
decnum=`printf "%02d" $num`
hexnum=`printf "%02x" $num`
name=${prefix}$decnum
dev1=/var/lib/libvirt/images/nfs/${prefix}${decnum}-1.img
vnc_port="61${decnum}"
monitor_port="130${decnum}"
serial_port="140${decnum}"
macaddr="00:50:58:79:00:${hexnum}"
num_bridges=3
bridge_id=`echo "($num -1)% $num_bridges + 1" | bc`
echo bridge_id is $bridge_id
cpus=2
mem=2816
qemu=/usr/libexec/qemu-kvm
first_cpu=`echo "(($num -1)% 8)" | bc`
cpu_set=`cat /sys/devices/system/cpu/cpu${first_cpu}/topology/thread_siblings_list`
echo binding to cpus: $cpu_set
launch="numactl --physcpubind=$cpu_set"
$launch $qemu\
    -name $name\
    -drive file=$dev1,if=virtio,boot=on,cache=writeback\
    -net nic,model=virtio,vlan=0,macaddr=$macaddr\
    -net tap,vlan=0,ifname=vct${decnum},script=/etc/kvm/qemu-ifup-br$bridge_id\
    -m $mem\
    -vnc :$vnc_port\
    -cpu qemu64,+x2apic -smp $cpus\
    -monitor telnet::$monitor_port,server,nowait\
    -serial telnet::$serial_port,server,nowait\
    -daemonize
