/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.common.qos.messaging;

import com.sun.jbi.common.descriptor.EndpointInfo;
import com.sun.jbi.common.qos.I18n;
import com.sun.jbi.common.qos.ServiceQuality;
import com.sun.jbi.common.qos.messaging.MessagingChannel;
import com.sun.jbi.common.qos.redelivery.Redelivery;
import com.sun.jbi.common.qos.redelivery.RedeliveryConfig;
import com.sun.jbi.common.qos.redelivery.RedeliveryStatus;
import com.sun.jbi.common.qos.redelivery.Redirect;
import com.sun.jbi.common.util.Util;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseMessagingChannel
implements MessagingChannel {
    private static final String LOOPBACK_ENDPOINT_NAME = "redeliveryLoopback";
    private static final long ASYNC_SEND = Long.MIN_VALUE;
    private static final int INFINITE_RETRIES = -1;
    private Calendar mCal = Calendar.getInstance();
    private ComponentContext mCtx;
    private DeliveryChannel mChannel;
    private Map<EndpointInfo, Set<ServiceQuality>> mQualities;
    private Map<String, RedeliveryStatus> mStatusMap;
    private Logger mLogger;
    private Timer mTimer;
    private ServiceEndpoint mLoopbackEndpt;

    public BaseMessagingChannel(ComponentContext ctx) throws MessagingException {
        this.mCtx = ctx;
        this.mChannel = this.mCtx.getDeliveryChannel();
        this.mQualities = new HashMap<EndpointInfo, Set<ServiceQuality>>();
        this.mStatusMap = Collections.synchronizedMap(new HashMap());
        this.mLogger = Util.getLogger((ComponentContext)this.mCtx, (String)MessagingChannel.class.getName());
        this.mTimer = new Timer(this.mCtx.getComponentName() + "-MessagingChannelTimer");
        try {
            this.mLoopbackEndpt = this.mCtx.activateEndpoint(new QName("http://www.sun.com/jbi/qos/redelivery", this.mCtx.getComponentName()), LOOPBACK_ENDPOINT_NAME);
        }
        catch (JBIException jbi) {
            String msg = I18n.loc("QOS-6006: Failed to activate redelivery endpoint: {0}", jbi.getMessage());
            this.mLogger.log(Level.WARNING, msg, jbi);
            throw new MessagingException(msg, (Throwable)jbi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServiceQualityToEndpoint(EndpointInfo endpoint, ServiceQuality ... qos) {
        if (endpoint != null && qos != null) {
            Map<EndpointInfo, Set<ServiceQuality>> map = this.mQualities;
            synchronized (map) {
                Set<ServiceQuality> set = this.mQualities.get(endpoint);
                if (set == null) {
                    set = new HashSet<ServiceQuality>();
                    this.mQualities.put(endpoint, set);
                }
                for (ServiceQuality sq : qos) {
                    set.add(sq);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServiceQualityFromEndpoint(EndpointInfo endpoint, ServiceQuality ... qos) {
        Map<EndpointInfo, Set<ServiceQuality>> map = this.mQualities;
        synchronized (map) {
            Set<ServiceQuality> set = this.mQualities.get(endpoint);
            if (set != null) {
                for (ServiceQuality sq : qos) {
                    set.remove(sq);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ServiceQuality> getServiceQualitiesForEndpoint(EndpointInfo endpoint) {
        Set<ServiceQuality> set = null;
        Map<EndpointInfo, Set<ServiceQuality>> map = this.mQualities;
        synchronized (map) {
            set = this.mQualities.get(endpoint);
        }
        return set != null ? new ArrayList<ServiceQuality>(set) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ServiceQuality> T getServiceQuality(EndpointInfo endpoint, Class<T> qosType) {
        Set<ServiceQuality> set = null;
        Map<EndpointInfo, Set<ServiceQuality>> map = this.mQualities;
        synchronized (map) {
            set = this.mQualities.get(endpoint);
        }
        if (set != null && qosType != null) {
            for (ServiceQuality sq : set) {
                if (!qosType.isInstance(sq)) continue;
                return (T)sq;
            }
        }
        return null;
    }

    public MessageExchange accept() throws MessagingException {
        return this.processIncomingRedelivery(this.mChannel.accept());
    }

    public MessageExchange accept(long wait) throws MessagingException {
        return this.processIncomingRedelivery(this.mChannel.accept(wait));
    }

    public void close() throws MessagingException {
        this.mChannel.close();
    }

    public MessageExchangeFactory createExchangeFactory() {
        return this.mChannel.createExchangeFactory();
    }

    public MessageExchangeFactory createExchangeFactory(QName arg0) {
        return this.mChannel.createExchangeFactory(arg0);
    }

    public MessageExchangeFactory createExchangeFactory(ServiceEndpoint arg0) {
        return this.mChannel.createExchangeFactory(arg0);
    }

    public MessageExchangeFactory createExchangeFactoryForService(QName arg0) {
        return this.mChannel.createExchangeFactoryForService(arg0);
    }

    public void send(MessageExchange msg) throws MessagingException {
        SendTask task = this.processOutgoingRedelivery(msg, Long.MIN_VALUE);
        if (task == null) {
            this.mChannel.send(msg);
        } else {
            this.mTimer.schedule((TimerTask)task, task.getDelay());
        }
    }

    public boolean sendSync(MessageExchange msg) throws MessagingException {
        return this.sendSync(msg, 0L);
    }

    public boolean sendSync(MessageExchange msg, long wait) throws MessagingException {
        SendTask task = this.processOutgoingRedelivery(msg, wait);
        if (task == null) {
            boolean sent = this.mChannel.sendSync(msg, wait);
            if (!this.mLoopbackEndpt.equals(msg.getEndpoint())) {
                this.processIncomingRedelivery(msg);
            }
            return sent;
        }
        this.mTimer.schedule((TimerTask)task, task.getDelay());
        return true;
    }

    protected MessageExchange processIncomingRedelivery(MessageExchange msg) throws MessagingException {
        String guid = Redelivery.getUniqueId(msg);
        if (!Util.isEmpty((String)guid)) {
            RedeliveryStatus status = Redelivery.getRedeliveryStatus(msg);
            RedeliveryConfig config = this.getRedeliveryConfig(msg);
            if (config != null && status != null) {
                if (this.mLoopbackEndpt.equals(msg.getEndpoint())) {
                    return this.processLoopbackMessage(guid, msg, config, status);
                }
                if (ExchangeStatus.ERROR.equals(msg.getStatus())) {
                    Redelivery.setRedeliveryStatus(msg, msg.getError());
                    status = Redelivery.getRedeliveryStatus(msg);
                    if (status.hasFailed()) {
                        this.mStatusMap.remove(guid);
                    } else {
                        this.mStatusMap.put(guid, status);
                    }
                } else if (!msg.getRole().equals(MessageExchange.Role.PROVIDER)) {
                    this.mStatusMap.remove(guid);
                }
            }
        }
        return msg;
    }

    protected MessageExchange processLoopbackMessage(String guid, MessageExchange msg, RedeliveryConfig config, RedeliveryStatus status) throws MessagingException {
        String err = null;
        ExchangeStatus exchangeStatus = ExchangeStatus.ERROR;
        switch (config.getFailure()) {
            case delete: {
                if (!(msg instanceof InOnly)) break;
                err = I18n.loc("QOS-6009: Redelivery attempts exhausted, delete message: {0}", msg.getExchangeId());
                exchangeStatus = ExchangeStatus.DONE;
                break;
            }
            case suspend: {
                if (!(msg instanceof InOnly) && !(msg instanceof InOut)) break;
                err = I18n.loc("QOS-6008: Redelivery attempts exhausted, suspend message: {0}", msg.getExchangeId());
                break;
            }
            case error: {
                if (!(msg instanceof InOnly) && !(msg instanceof InOut)) break;
                err = I18n.loc("QOS-6019: Redelivery attempts exhausted, send aborted for message exchange: {0}", msg.getExchangeId());
                break;
            }
            default: {
                err = I18n.loc("QOS-6007: Unsupported failure option {0} for exchange: {1}", String.valueOf((Object)config.getFailure()), msg.getExchangeId());
                this.mLogger.warning(err);
                throw new MessagingException(err);
            }
        }
        if (err == null) {
            throw this.unsupportedRedeliveryPattern(msg);
        }
        if (MessageExchange.Role.PROVIDER.equals(msg.getRole())) {
            if (this.mLogger.isLoggable(Level.FINER)) {
                this.mLogger.finer(err);
            }
            Exception ex = new Exception(err);
            Redelivery.setRedeliveryStatus(msg, ex);
            msg.setStatus(exchangeStatus);
            if (exchangeStatus.equals(ExchangeStatus.ERROR)) {
                msg.setError(ex);
            }
            this.mChannel.send(msg);
            return this.accept();
        }
        this.mStatusMap.remove(guid);
        return msg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected SendTask processOutgoingRedelivery(MessageExchange msg, long wait) throws MessagingException {
        String guid = Redelivery.getUniqueId(msg);
        if (Util.isEmpty((String)guid)) return null;
        RedeliveryConfig config = this.getRedeliveryConfig(msg);
        if (config == null) {
            return null;
        }
        long ts = this.mCal.getTimeInMillis();
        RedeliveryStatus status = this.mStatusMap.get(guid);
        if (status != null) {
            boolean infiniteRetries;
            long lastRetryTime = status.getLastRetryTime();
            boolean bl = infiniteRetries = -1 == config.getMaxRetries();
            if (status.getRemainingRetries() > 0 || infiniteRetries) {
                int remaining;
                int attempts = status.getTotalRetries();
                int n = remaining = infiniteRetries ? Integer.MAX_VALUE : status.getRemainingRetries() - 1;
                if (infiniteRetries && attempts == Integer.MAX_VALUE) {
                    attempts = 0;
                    this.log().warning(I18n.loc("QOS-6056: Message Exchange {0} has been sent unsuccessfully {1} times; resetting redelivery counter.", msg.getExchangeId(), String.valueOf(Integer.MAX_VALUE)));
                }
                Redelivery.setRedeliveryStatus(msg, ts, attempts + 1, remaining, status.getError(), false);
                if (config.getRetryInterval() <= 0L) return null;
                long elapsed = ts - lastRetryTime;
                if (config.getRetryInterval() <= elapsed) return null;
                return new SendTask(this, msg, wait, config.getRetryInterval() - elapsed);
            }
            if (!msg.getRole().equals(MessageExchange.Role.CONSUMER)) return null;
            Redelivery.setRedeliveryStatus(msg, status.getLastRetryTime(), status.getTotalRetries(), status.getRemainingRetries(), status.getError(), true);
            switch (config.getFailure()) {
                case redirect: {
                    if (!(msg instanceof InOnly)) throw this.unsupportedRedeliveryPattern(msg);
                    Redirect redirect = config.getRedirect();
                    if (redirect != null) {
                        ServiceEndpoint endpt = this.mCtx.getEndpoint(redirect.getEndpoint().getServiceName(), redirect.getEndpoint().getEndpointName());
                        if (endpt == null) {
                            String err = I18n.loc("QOS-6001: Redelivery to error endpoint aborted, endpoint not active.", new Object[0]);
                            this.log().warning(err);
                            throw new MessagingException(err);
                        }
                        Redelivery.setEndpoint(msg, msg.getEndpoint());
                        msg.setEndpoint(endpt);
                        if (redirect.getOperation() == null) return null;
                        msg.setOperation(redirect.getOperation());
                        return null;
                    }
                    String err = I18n.loc("QOS-6002: Redelivery to error endpoint aborted, no configured endpoint.", new Object[0]);
                    this.log().warning(err);
                    throw new MessagingException(err);
                }
                case suspend: 
                case error: {
                    if (!(msg instanceof InOnly) && !(msg instanceof InOut)) throw this.unsupportedRedeliveryPattern(msg);
                    this.prepareLoopback(guid, msg);
                    return null;
                }
                case delete: {
                    if (!(msg instanceof InOnly)) throw this.unsupportedRedeliveryPattern(msg);
                    this.prepareLoopback(guid, msg);
                    return null;
                }
            }
            return null;
        } else {
            if (config == null) return null;
            Redelivery.setRedeliveryStatus(msg, ts, 0, config.getMaxRetries(), null, false);
            status = Redelivery.getRedeliveryStatus(msg);
            this.mStatusMap.put(guid, status);
        }
        return null;
    }

    protected void prepareLoopback(String guid, MessageExchange msg) throws MessagingException {
        if (ExchangeStatus.ACTIVE.equals(msg.getStatus())) {
            Redelivery.setEndpoint(msg, msg.getEndpoint());
            msg.setEndpoint(this.mLoopbackEndpt);
        }
    }

    private MessagingException unsupportedRedeliveryPattern(MessageExchange msg) {
        String pattern = msg instanceof InOut ? "InOut" : (msg instanceof InOnly ? "InOnly" : msg.getClass().getSimpleName());
        String err = I18n.loc("QOS-6010: Invalid redelivery configuration: {0} not supported!", pattern);
        this.mLogger.warning(err);
        return new MessagingException(err);
    }

    protected RedeliveryConfig getRedeliveryConfig(MessageExchange msg) {
        if (msg != null) {
            ServiceEndpoint endpt = Redelivery.getEndpoint(msg);
            EndpointInfo info = new EndpointInfo(false, endpt.getEndpointName(), null, endpt.getServiceName(), null);
            return this.getServiceQuality(info, RedeliveryConfig.class);
        }
        return null;
    }

    protected Logger log() {
        return this.mLogger;
    }

    private DeliveryChannel getDC() {
        return this.mChannel;
    }

    private static class SendTask
    extends TimerTask {
        private final BaseMessagingChannel mBaseChannel;
        private final MessageExchange mMessage;
        private final long mWait;
        private final long mDelay;

        public SendTask(BaseMessagingChannel channel, MessageExchange msg, long wait, long delay) {
            this.mBaseChannel = channel;
            this.mMessage = msg;
            this.mWait = wait;
            this.mDelay = delay;
        }

        public void run() {
            boolean done = false;
            while (!done) {
                try {
                    if (this.mWait == Long.MIN_VALUE) {
                        this.mBaseChannel.getDC().send(this.mMessage);
                    } else if (this.mWait > 0L) {
                        this.mBaseChannel.getDC().sendSync(this.mMessage, this.mWait);
                    } else {
                        this.mBaseChannel.getDC().sendSync(this.mMessage);
                    }
                    done = true;
                }
                catch (MessagingException me) {
                    this.mBaseChannel.log().log(Level.FINE, I18n.loc("QOS-6020: Attempting redelivery for {0}, send failed: {1}", this.mMessage.getExchangeId(), me.getMessage()), me);
                    done = this.updateStatus(this.mMessage);
                }
            }
        }

        protected boolean updateStatus(MessageExchange msg) {
            RedeliveryConfig config;
            String guid = Redelivery.getUniqueId(msg);
            if (!Util.isEmpty((String)guid) && (config = this.mBaseChannel.getRedeliveryConfig(msg)) != null) {
                long ts = this.mBaseChannel.mCal.getTimeInMillis();
                RedeliveryStatus status = (RedeliveryStatus)this.mBaseChannel.mStatusMap.get(guid);
                if (status != null) {
                    long lastRetryTime = status.getLastRetryTime();
                    if (status.getRemainingRetries() > 0) {
                        Redelivery.setRedeliveryStatus(msg, ts, status.getTotalRetries() + 1, status.getRemainingRetries() - 1, status.getError(), false);
                        if (config.getRetryInterval() > 0L) {
                            long elapsed = ts - lastRetryTime;
                            if (config.getRetryInterval() > elapsed) {
                                try {
                                    Thread.sleep(config.getRetryInterval() - elapsed);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                return false;
                            }
                        } else {
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        public long getDelay() {
            return this.mDelay;
        }
    }
}

