/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.util.soap;

import com.sun.logging.LogDomains;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointMetaData {
    protected static final Logger logger = LogDomains.getLogger((String)"javax.enterprise.system");
    private Definition def = null;
    private QName serviceName = null;
    private String epName = null;
    private String operationName;
    private OperationMetaData[] opmds = null;

    public EndpointMetaData(Definition def, QName serviceName, String epName) {
        this.def = def;
        this.serviceName = serviceName;
        this.epName = epName;
    }

    public EndpointMetaData(URL wsdlLocation, QName serviceName, String epName) {
        this.def = this.readWSDLDefinition(wsdlLocation);
        this.serviceName = serviceName;
        this.epName = epName;
    }

    private Definition readWSDLDefinition(URL wsdlLocation) {
        try {
            WSDLFactory mFactory = WSDLFactory.newInstance();
            WSDLReader mReader = mFactory.newWSDLReader();
            return mReader.readWSDL(wsdlLocation.toURI().toString());
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
    }

    public EndpointMetaData(Definition def) {
        this.def = def;
    }

    public void resolve() {
        Binding binding;
        Operation[] ops;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Resolving the WSDL for : " + this.serviceName + " : " + this.epName);
        }
        if ((ops = EndpointMetaData.getOperations(binding = EndpointMetaData.getBinding(this.def, this.serviceName, this.epName))).length < 1) {
            throw new RuntimeException("WSDL operation not resolved");
        }
        if (ops.length == 1) {
            this.operationName = ops[0].getName();
        }
        this.opmds = new OperationMetaData[ops.length];
        int i = 0;
        for (Operation op : ops) {
            Message input = null;
            OperationMetaData md = new OperationMetaData();
            BindingOperation bindingOp = this.getBindingOperation(op, binding);
            if (op.getInput() != null) {
                input = op.getInput().getMessage();
                md.setInputMessage(input);
                md.setOperationInputName(op.getInput().getName());
                md.setInputPartBindings(this.getPartBindings(bindingOp.getBindingInput().getExtensibilityElements(), input));
            }
            Set s = this.getInputPartNames(input);
            md.setOperationName(op.getName());
            md.setInputParameters(s);
            if (op.getOutput() != null) {
                md.setOperationOutputName(op.getOutput().getName());
                md.setOutputMessage(op.getOutput().getMessage());
                md.setOutputPartBindings(this.getPartBindings(bindingOp.getBindingOutput().getExtensibilityElements(), op.getOutput().getMessage()));
            }
            md.setBindingStyle(this.getStyleFor(op, binding));
            md.setFaults(op.getFaults());
            this.opmds[i++] = md;
        }
    }

    private void setPartBinding(int[] partBindings, List<String> orderedParts, ExtensibilityElement extElem) {
        int index;
        MIMEContent mimeContent;
        String part;
        if (extElem instanceof SOAPBody) {
            SOAPBody body = (SOAPBody)extElem;
            List parts = body.getParts();
            if (parts != null) {
                for (String part2 : parts) {
                    int index2 = orderedParts.indexOf(part2);
                    if (index2 == -1) continue;
                    partBindings[index2] = 0;
                }
            }
        } else if (extElem instanceof SOAPHeader) {
            int index3;
            SOAPHeader header = (SOAPHeader)extElem;
            String part3 = header.getPart();
            if (part3 != null && (index3 = orderedParts.indexOf(part3)) != -1) {
                partBindings[index3] = 1;
            }
        } else if (extElem instanceof MIMEContent && (part = (mimeContent = (MIMEContent)extElem).getPart()) != null && (index = orderedParts.indexOf(part)) != -1) {
            partBindings[index] = 2;
        }
    }

    private int[] getPartBindings(List<ExtensibilityElement> extensibleElems, Message message) {
        ArrayList<String> orderedParts = new ArrayList<String>();
        for (Part p : message.getOrderedParts(null)) {
            orderedParts.add(p.getName());
        }
        int[] partBindings = new int[orderedParts.size()];
        for (ExtensibilityElement extElem : extensibleElems) {
            if (extElem instanceof MIMEMultipartRelated) {
                MIMEMultipartRelated mpr = (MIMEMultipartRelated)extElem;
                for (MIMEPart mp : mpr.getMIMEParts()) {
                    for (ExtensibilityElement mpe : mp.getExtensibilityElements()) {
                        this.setPartBinding(partBindings, orderedParts, mpe);
                    }
                }
                continue;
            }
            this.setPartBinding(partBindings, orderedParts, extElem);
        }
        if (logger.isLoggable(Level.FINE)) {
            for (int i = 0; i < partBindings.length; ++i) {
                logger.log(Level.FINE, "PartName = " + (String)orderedParts.get(i) + ", PartBinding : " + partBindings[i]);
            }
        }
        return partBindings;
    }

    private BindingOperation getBindingOperation(Operation interfaceOperation, Binding binding) {
        String inputMsgName = interfaceOperation.getInput() != null ? interfaceOperation.getInput().getName() : null;
        String outputMsgName = interfaceOperation.getOutput() != null ? interfaceOperation.getOutput().getName() : null;
        BindingOperation bindingOperation = binding.getBindingOperation(interfaceOperation.getName(), inputMsgName, outputMsgName);
        if (bindingOperation == null) {
            bindingOperation = binding.getBindingOperation(interfaceOperation.getName(), null, null);
        }
        return bindingOperation;
    }

    private String getStyleFor(Operation interfaceOperation, Binding binding) {
        String style = null;
        BindingOperation bindingOperation = this.getBindingOperation(interfaceOperation, binding);
        if (bindingOperation != null && (style = this.getStyleFor(bindingOperation)) == null) {
            style = this.getStyleFor(binding);
        }
        return style;
    }

    private String getStyleFor(Binding binding) {
        String sty = null;
        List extList = binding.getExtensibilityElements();
        if (extList != null) {
            for (int i = 0; i < extList.size(); ++i) {
                if (!(extList.get(i) instanceof SOAPBinding)) continue;
                SOAPBinding sb = (SOAPBinding)extList.get(i);
                sty = sb.getStyle();
                break;
            }
        }
        return sty;
    }

    private String getStyleFor(BindingOperation bo) {
        String style = null;
        List extList = bo.getExtensibilityElements();
        if (extList != null) {
            for (int i = 0; i < extList.size(); ++i) {
                if (!(extList.get(i) instanceof SOAPOperation)) continue;
                SOAPOperation sa = (SOAPOperation)extList.get(i);
                style = sa.getStyle();
                break;
            }
        }
        return style;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public String getOperationName(SOAPMessage soapMsg) {
        if (this.operationName != null) {
            return this.operationName;
        }
        ArrayList nodeNames = new ArrayList();
        try {
            javax.xml.soap.SOAPBody soapBody = soapMsg.getSOAPBody();
            NodeList nl = soapBody.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                String nodeName;
                Node n = nl.item(i);
                if (1 != n.getNodeType() || (nodeName = n.getLocalName()) == null) continue;
                return nodeName;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (OperationMetaData om : this.opmds) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Matching for" + om.getOperationName());
            }
            Set inputs = om.getInputParameters();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Inputs" + inputs);
                logger.finest("Nodes" + nodeNames);
            }
            if (!inputs.containsAll(nodeNames)) continue;
            return om.getOperationName();
        }
        return null;
    }

    public Definition getDefinition() {
        return this.def;
    }

    private Set getInputPartNames(Message msg) {
        HashSet<String> set = new HashSet<String>();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Getting input parameters for: " + msg);
        }
        if (msg != null) {
            Iterator bodyIterator = null;
            Map msgParts = msg.getParts();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Message Parts are: " + msgParts);
            }
            if (msgParts != null) {
                bodyIterator = msgParts.keySet().iterator();
            }
            while (bodyIterator != null && bodyIterator.hasNext()) {
                String bodyPart = (String)bodyIterator.next();
                Part part = msg.getPart(bodyPart);
                if (part == null) {
                    throw new IllegalStateException("WSDL error");
                }
                QName typeQName = part.getTypeName();
                QName elemQName = part.getElementName();
                if (typeQName != null) {
                    set.add(part.getName());
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine("Added partName: " + part.getName());
                    continue;
                }
                if (elemQName == null) continue;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Added root node: " + elemQName.getLocalPart());
                    logger.fine("Part name is : " + part.getName());
                }
                set.add(elemQName.getLocalPart());
            }
        }
        return set;
    }

    public Message getOutputMessage(String operationName) {
        for (OperationMetaData om : this.opmds) {
            if (!operationName.equals(om.getOperationName())) continue;
            return om.getOutputMessage();
        }
        return null;
    }

    private boolean isSimpleType(Part part) {
        String s;
        QName parttype = part.getTypeName();
        return parttype != null && (s = parttype.getNamespaceURI()) != null && s.trim().equals("http://www.w3.org/2001/XMLSchema");
    }

    private String fixNull(String s) {
        return s == null ? "" : s;
    }

    private boolean match(QName qName, String localName, String nsUri) {
        if (qName == null) {
            return false;
        }
        String qLocalName = this.fixNull(qName.getLocalPart());
        String qNsUri = this.fixNull(qName.getNamespaceURI());
        localName = this.fixNull(localName);
        nsUri = this.fixNull(nsUri);
        return qLocalName.equals(localName) && qNsUri.equals(nsUri);
    }

    public Fault getFault(String operationName, String faultDetailElementName, String faultDetailNsUri) {
        for (OperationMetaData om : this.opmds) {
            if (!operationName.equals(om.getOperationName())) continue;
            Map<String, Object> m = om.getFaults();
            for (String s : m.keySet()) {
                Fault fault = (Fault)m.get(s);
                Message msg = fault.getMessage();
                List orderedParts = msg.getOrderedParts(null);
                for (Part p : orderedParts) {
                    if (this.match(p.getElementName(), faultDetailElementName, faultDetailNsUri)) {
                        return fault;
                    }
                    if (this.match(p.getTypeName(), faultDetailElementName, faultDetailNsUri)) {
                        return fault;
                    }
                    if (!this.isSimpleType(p) || faultDetailElementName != null) continue;
                    return fault;
                }
            }
        }
        return null;
    }

    public String getOperationOutputName(String operationName) {
        for (OperationMetaData om : this.opmds) {
            if (!operationName.equals(om.getOperationName())) continue;
            return om.getOperationOutputName();
        }
        return null;
    }

    public Message getInputMessage(String operationName) {
        for (OperationMetaData om : this.opmds) {
            if (!operationName.equals(om.getOperationName())) continue;
            return om.getInputMessage();
        }
        return null;
    }

    public int[] getInputPartBindings(String operationName) {
        for (OperationMetaData om : this.opmds) {
            if (!operationName.equals(om.getOperationName())) continue;
            return om.getInputPartBindings();
        }
        return null;
    }

    public int[] getOutputPartBindings(String operationName) {
        for (OperationMetaData om : this.opmds) {
            if (!operationName.equals(om.getOperationName())) continue;
            return om.getOutputPartBindings();
        }
        return null;
    }

    public String getOperationInputName(String operationName) {
        for (OperationMetaData om : this.opmds) {
            if (!operationName.equals(om.getOperationName())) continue;
            return om.getOperationInputName();
        }
        return null;
    }

    public String getBindingStyle(String operationName) {
        for (OperationMetaData om : this.opmds) {
            if (!operationName.equals(om.getOperationName())) continue;
            return om.getBindingStyle();
        }
        return null;
    }

    public static Operation[] getOperations(Binding binding) {
        List l;
        PortType pt;
        if (binding != null && (pt = binding.getPortType()) != null && (l = pt.getOperations()) != null && l.size() > 0) {
            return l.toArray(new Operation[0]);
        }
        return null;
    }

    public static Binding getBinding(Definition def, QName serviceName, String endpointName) {
        Object location = null;
        Service svc = def.getService(serviceName);
        if (svc == null) {
            return null;
        }
        Port port = svc.getPort(QName.valueOf(endpointName).getLocalPart());
        if (port == null) {
            return null;
        }
        return port.getBinding();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OperationMetaData {
        private String operationName;
        private String operationInputName;
        private String operationOutputName;
        private Set inputParams;
        private Message outputMessage;
        private Message inputMessage;
        private String bindingStyle;
        private Map<String, Object> faults;
        private int[] inputPartBindings;
        private int[] outputPartBindings;

        private OperationMetaData() {
        }

        void setOperationName(String name) {
            this.operationName = name;
        }

        void setInputParameters(Set params) {
            this.inputParams = params;
        }

        String getOperationName() {
            return this.operationName;
        }

        Set getInputParameters() {
            return this.inputParams;
        }

        Message getOutputMessage() {
            return this.outputMessage;
        }

        void setOutputMessage(Message outputMessage) {
            this.outputMessage = outputMessage;
        }

        public String getOperationOutputName() {
            return this.operationOutputName;
        }

        public void setOperationOutputName(String operationOutputName) {
            this.operationOutputName = operationOutputName;
        }

        String getBindingStyle() {
            return this.bindingStyle;
        }

        void setBindingStyle(String bindingStyle) {
            this.bindingStyle = bindingStyle;
        }

        public Message getInputMessage() {
            return this.inputMessage;
        }

        public void setInputMessage(Message inputMessage) {
            this.inputMessage = inputMessage;
        }

        public String getOperationInputName() {
            return this.operationInputName;
        }

        public void setOperationInputName(String operationInputName) {
            this.operationInputName = operationInputName;
        }

        public Map<String, Object> getFaults() {
            return this.faults;
        }

        public void setFaults(Map<String, Object> faults) {
            this.faults = faults == null ? new HashMap() : faults;
        }

        public int[] getInputPartBindings() {
            return this.inputPartBindings;
        }

        private void setInputPartBindings(int[] inputPartBindings) {
            this.inputPartBindings = inputPartBindings;
        }

        public int[] getOutputPartBindings() {
            return this.outputPartBindings;
        }

        public void setOutputPartBindings(int[] outputPartBindings) {
            this.outputPartBindings = outputPartBindings;
        }
    }
}

