/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.message;

import com.sun.jbi.management.message.JBITask;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JBITaskUtils {
    private static Schema schema = null;

    public static Document parse(String elementString) throws SAXException {
        try {
            if (!elementString.startsWith("<?xml")) {
                int pos = elementString.indexOf(62);
                elementString = elementString.substring(0, pos) + " xmlns='" + "http://java.sun.com/xml/ns/jbi/management-message" + "'>" + elementString.substring(pos + 1);
            }
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(elementString));
            return documentBuilder.parse(is);
        }
        catch (ParserConfigurationException pce) {
            throw new SAXException("Unexpected parse configuration exception", pce);
        }
        catch (IOException ioe) {
            throw new SAXException("Unexpected IO exception", ioe);
        }
    }

    public static void validate(String elementString) throws SAXException {
        JBITaskUtils.validate(JBITaskUtils.parse(elementString));
    }

    public static void validate(Document document) throws SAXException {
        try {
            Validator validator = schema.newValidator();
            validator.validate(new DOMSource(document));
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unexpected IO exception", ioe);
        }
    }

    static {
        InputStream in = null;
        try {
            in = JBITask.class.getResourceAsStream("managementMessage.xsd");
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schema = schemaFactory.newSchema(new StreamSource(in));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error building schema validator", e);
        }
    }
}

