/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.message;

import com.sun.jbi.management.message.AbstractJBITaskMessageBuilder;
import com.sun.jbi.management.message.ComponentTaskResult;
import com.sun.jbi.management.message.ComponentTaskResultDetails;
import com.sun.jbi.management.message.ExceptionInfo;
import com.sun.jbi.management.message.JBIMessageException;
import com.sun.jbi.management.message.MessageLocalizationInfo;
import com.sun.jbi.management.message.TaskResultDetails;
import com.sun.jbi.util.JBIUtils;

public class DefaultJBITaskMessageBuilder
extends AbstractJBITaskMessageBuilder {
    protected String createComponentMessage(ComponentTaskResult componentTaskResult) throws JBIMessageException {
        StringBuffer buffer = new StringBuffer();
        this.populate(buffer, componentTaskResult);
        return buffer.toString();
    }

    private void populate(StringBuffer buffer, ComponentTaskResult ctr) throws JBIMessageException {
        ctr.validate();
        buffer.append("<");
        buffer.append("component-task-result");
        buffer.append(">\n");
        buffer.append("  <");
        buffer.append("component-name");
        buffer.append(">");
        buffer.append(JBIUtils.escape(ctr.getComponentName()));
        buffer.append("</");
        buffer.append("component-name");
        buffer.append(">\n");
        this.populate(buffer, ctr.getDetails());
        buffer.append("</");
        buffer.append("component-task-result");
        buffer.append(">");
    }

    private void populate(StringBuffer buffer, ComponentTaskResultDetails ctrd) {
        ctrd.validate();
        buffer.append("  <");
        buffer.append("component-task-result-details");
        buffer.append(">\n");
        this.populate(buffer, ctrd.getDetails());
        buffer.append("  </");
        buffer.append("component-task-result-details");
        buffer.append(">\n");
    }

    private void populate(StringBuffer buffer, TaskResultDetails trd) {
        trd.validate();
        buffer.append("  <");
        buffer.append("task-result-details");
        buffer.append(">\n");
        buffer.append("    <");
        buffer.append("task-id");
        buffer.append(">");
        buffer.append(trd.getTaskId());
        buffer.append("</");
        buffer.append("task-id");
        buffer.append(">\n");
        buffer.append("    <");
        buffer.append("task-result");
        buffer.append(">");
        buffer.append(trd.isSuccessfulResult() ? "SUCCESS" : "FAILED");
        buffer.append("</");
        buffer.append("task-result");
        buffer.append(">\n");
        if (trd.getMessageType() != 0) {
            buffer.append("    <");
            buffer.append("message-type");
            buffer.append(">");
            buffer.append(trd.getMessageTypeString());
            buffer.append("</");
            buffer.append("message-type");
            buffer.append(">\n");
        }
        if (trd.getMessages() != null && trd.getMessages().size() != 0) {
            buffer.append("    <");
            buffer.append("task-status-msg");
            buffer.append(">\n");
            for (MessageLocalizationInfo messageLocalization : trd.getMessages()) {
                this.populate(buffer, messageLocalization);
            }
            buffer.append("    </");
            buffer.append("task-status-msg");
            buffer.append(">\n");
        }
        if (trd.getExceptions() != null && trd.getExceptions().size() != 0) {
            for (ExceptionInfo exceptionInfo : trd.getExceptions()) {
                this.populate(buffer, exceptionInfo);
            }
        }
        buffer.append("  </");
        buffer.append("task-result-details");
        buffer.append(">\n");
    }

    private void populate(StringBuffer buffer, MessageLocalizationInfo mli) {
        mli.validate();
        buffer.append("      <");
        buffer.append("msg-loc-info");
        buffer.append(">\n");
        buffer.append("        <");
        buffer.append("loc-token");
        buffer.append(">");
        buffer.append(JBIUtils.escape(mli.getToken()));
        buffer.append("</");
        buffer.append("loc-token");
        buffer.append(">\n");
        buffer.append("        <");
        buffer.append("loc-message");
        buffer.append(">");
        buffer.append(JBIUtils.escape(mli.getMessage()));
        buffer.append("</");
        buffer.append("loc-message");
        buffer.append(">\n");
        Object[] parameters = mli.getParameters();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                String parameter = "";
                if (parameters[i] != null) {
                    parameter = parameters[i].toString();
                }
                buffer.append("        <");
                buffer.append("loc-param");
                buffer.append(">");
                buffer.append(JBIUtils.escape(parameter));
                buffer.append("</");
                buffer.append("loc-param");
                buffer.append(">\n");
            }
        }
        buffer.append("      </");
        buffer.append("msg-loc-info");
        buffer.append(">\n");
    }

    private void populate(StringBuffer buffer, ExceptionInfo ei) {
        ei.validate();
        buffer.append("    <");
        buffer.append("exception-info");
        buffer.append(">\n");
        buffer.append("      <");
        buffer.append("nesting-level");
        buffer.append(">");
        buffer.append(ei.getNestingLevel());
        buffer.append("</");
        buffer.append("nesting-level");
        buffer.append(">\n");
        this.populate(buffer, ei.getMessageLocalization());
        buffer.append("      <");
        buffer.append("stack-trace");
        buffer.append(">\n");
        for (Throwable t = ei.getException(); t != null; t = t.getCause()) {
            buffer.append('\n');
            buffer.append(JBIUtils.escape(JBIUtils.stringStackTrace(t)));
        }
        buffer.append("      </");
        buffer.append("stack-trace");
        buffer.append(">\n");
        buffer.append("    </");
        buffer.append("exception-info");
        buffer.append(">\n");
    }
}

