/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.embedded;

import com.sun.enterprise.web.connector.grizzly.GrizzlyHttpProtocol;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.jbi.httpsoapbc.HttpSoapBindingLifeCycle;
import com.sun.jbi.httpsoapbc.embedded.BCCoyoteRequest;
import com.sun.jbi.httpsoapbc.embedded.BCCoyoteResponse;
import com.sun.jbi.httpsoapbc.embedded.LinkedListThrottlePipeline;
import org.apache.catalina.Connector;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.coyote.tomcat5.CoyoteConnector;

public class BCCoyoteConnector
extends CoyoteConnector {
    private static final String USE_COYOTE_CONNECTOR = "com.sun.enterprise.web.connector.useCoyoteConnector";
    private static final String GRIZZLY_CONNECTOR = "com.sun.enterprise.web.connector.grizzly.GrizzlyHttpProtocol";
    protected boolean recycleObjects;
    protected int maxAcceptWorkerThreads;
    protected int maxReadWorkerThreads;
    protected int processorWorkerThreadsTimeout;
    protected int minProcessorWorkerThreadsIncrement;
    protected int minAcceptQueueLength;
    protected int minReadQueueLength;
    protected int minProcessorQueueLength;
    protected boolean useDirectByteBuffer;
    private int keepAliveTimeoutInSeconds;
    private int keepAliveThreadCount;
    private boolean chunkingDisabled;
    private int maxPendingCount = 4096;
    public int selectorReadThreadsCount = 0;
    private int maxQueueSizeInBytes = -1;
    private HttpSoapBindingLifeCycle lifeCycle;

    public BCCoyoteConnector(HttpSoapBindingLifeCycle lifeCycle) {
        boolean coyoteOn = false;
        if (System.getProperty(USE_COYOTE_CONNECTOR) != null) {
            coyoteOn = Boolean.valueOf(System.getProperty(USE_COYOTE_CONNECTOR));
        }
        if (!coyoteOn) {
            this.setProtocolHandlerClassName(GRIZZLY_CONNECTOR);
        }
        this.lifeCycle = lifeCycle;
    }

    public void setChunkingDisabled(boolean chunkingDisabled) {
        this.chunkingDisabled = chunkingDisabled;
    }

    public boolean isChunkingDisabled() {
        return this.chunkingDisabled;
    }

    public Request createRequest() {
        BCCoyoteRequest request = new BCCoyoteRequest();
        request.setConnector((Connector)this);
        return request;
    }

    public Response createResponse() {
        BCCoyoteResponse response = new BCCoyoteResponse(this.isChunkingDisabled());
        response.setConnector((Connector)this);
        return response;
    }

    public int getKeepAliveTimeoutInSeconds() {
        return this.keepAliveTimeoutInSeconds;
    }

    public void setKeepAliveTimeoutInSeconds(int timeout) {
        this.keepAliveTimeoutInSeconds = timeout;
        this.setProperty("keepAliveTimeoutInSeconds", String.valueOf(timeout));
    }

    public int getKeepAliveThreadCount() {
        return this.keepAliveThreadCount;
    }

    public void setKeepAliveThreadCount(int threadCount) {
        this.keepAliveThreadCount = threadCount;
        this.setProperty("keepAliveThreadCount", String.valueOf(threadCount));
    }

    public void setMaxPendingConnection(int maxPendingCount) {
        this.maxPendingCount = maxPendingCount;
        this.setProperty("maxPendingConnection", String.valueOf(maxPendingCount));
    }

    public int getMaxPendingConnection() {
        return this.maxPendingCount;
    }

    public void setRecycleObjects(boolean recycleObjects) {
        this.recycleObjects = recycleObjects;
        this.setProperty("recycleObjects", String.valueOf(recycleObjects));
    }

    public boolean getRecycleObjects() {
        return this.recycleObjects;
    }

    public void setMaxReadWorkerThreads(int maxReadWorkerThreads) {
        this.maxReadWorkerThreads = maxReadWorkerThreads;
        this.setProperty("maxReadWorkerThreads", String.valueOf(maxReadWorkerThreads));
    }

    public int getMaxReadWorkerThreads() {
        return this.maxReadWorkerThreads;
    }

    public void setMaxAcceptWorkerThreads(int maxAcceptWorkerThreads) {
        this.maxAcceptWorkerThreads = maxAcceptWorkerThreads;
        this.setProperty("maxAcceptWorkerThreads", String.valueOf(maxAcceptWorkerThreads));
    }

    public int getMaxAcceptWorkerThreads() {
        return this.maxAcceptWorkerThreads;
    }

    public void setMinAcceptQueueLength(int minAcceptQueueLength) {
        this.minAcceptQueueLength = minAcceptQueueLength;
        this.setProperty("minAcceptQueueLength", String.valueOf(minAcceptQueueLength));
    }

    public int getMinAcceptQueueLength() {
        return this.minAcceptQueueLength;
    }

    public void setMinReadQueueLength(int minReadQueueLength) {
        this.minReadQueueLength = minReadQueueLength;
        this.setProperty("minReadQueueLength", String.valueOf(minReadQueueLength));
    }

    public int getMinReadQueueLength() {
        return this.minReadQueueLength;
    }

    public void setMinProcessorQueueLength(int minProcessorQueueLength) {
        this.minProcessorQueueLength = minProcessorQueueLength;
        this.setProperty("minProcessorQueueLength", String.valueOf(minProcessorQueueLength));
    }

    public int getMinProcessorQueueLength() {
        return this.minProcessorQueueLength;
    }

    public void setUseDirectByteBuffer(boolean useDirectByteBuffer) {
        this.useDirectByteBuffer = useDirectByteBuffer;
        this.setProperty("useDirectByteBuffer", String.valueOf(useDirectByteBuffer));
    }

    public boolean getUseDirectByteBuffer() {
        return this.useDirectByteBuffer;
    }

    public void setProcessorWorkerThreadsTimeout(int timeout) {
        this.processorWorkerThreadsTimeout = timeout;
        this.setProperty("processorWorkerThreadsTimeout", String.valueOf(timeout));
    }

    public int getProcessorWorkerThreadsTimeout() {
        return this.processorWorkerThreadsTimeout;
    }

    public void setProcessorWorkerThreadsIncrement(int increment) {
        this.minProcessorWorkerThreadsIncrement = increment;
        this.setProperty("processorThreadsIncrement", String.valueOf(increment));
    }

    public int getMinProcessorWorkerThreadsIncrement() {
        return this.minProcessorWorkerThreadsIncrement;
    }

    public void setSelectorReadThreadsCount(int selectorReadThreadsCount) {
        this.setProperty("selectorReadThreadsCount", String.valueOf(selectorReadThreadsCount));
    }

    public void start() throws LifecycleException {
        super.start();
        GrizzlyHttpProtocol protocolHandler = (GrizzlyHttpProtocol)this.getProtocolHandler();
        SelectorThread selThread = protocolHandler.selectorThread();
        if (selThread.getProcessorPipeline() instanceof LinkedListThrottlePipeline) {
            LinkedListThrottlePipeline pipeline = (LinkedListThrottlePipeline)selThread.getProcessorPipeline();
            pipeline.setHttpSoapBindingLifeCycle(this.lifeCycle);
        }
    }

    public void stop() throws LifecycleException {
        GrizzlyHttpProtocol protocolHandler = (GrizzlyHttpProtocol)this.getProtocolHandler();
        SelectorThread selThread = protocolHandler.selectorThread();
        if (selThread.getProcessorPipeline() instanceof LinkedListThrottlePipeline) {
            LinkedListThrottlePipeline pipeline = (LinkedListThrottlePipeline)selThread.getProcessorPipeline();
            pipeline.cleanup();
        }
        super.stop();
    }
}

