/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.validator.soapvalidators;

import com.sun.jbi.internationalization.Messages;
import com.sun.jbi.wsdlvalidator.ValidationException;
import com.sun.jbi.wsdlvalidator.Validator;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;

public class HttpSoapBindingValidator
implements Validator {
    private static final Messages mMessages = Messages.getMessages(HttpSoapBindingValidator.class);

    public void validate(ExtensibilityElement element) throws ValidationException {
        SOAPBinding binding = (SOAPBinding)element;
        String transportURI = binding.getTransportURI();
        if (transportURI == null) {
            throw new ValidationException(mMessages.getString("HTTPBC-E00281.Transport_URI_required"));
        }
        if (!transportURI.equals("http://schemas.xmlsoap.org/soap/http")) {
            throw new ValidationException(mMessages.getString("HTTPBC-E00282.Unsupported_transport", (Object)transportURI));
        }
        String style = binding.getStyle();
        if (style != null && !style.equals("rpc") && !style.equals("document")) {
            throw new ValidationException(mMessages.getString("HTTPBC-E00283.Unsupported_style_attribute", new Object[]{"<soap:binding>", style}));
        }
    }
}

