/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.servletsupport;

import com.sun.jbi.httpsoapbc.Normalizer;
import com.sun.jbi.httpsoapbc.OperationMetaData;
import com.sun.jbi.httpsoapbc.SoapNormalizer;
import com.sun.jbi.internationalization.Messages;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;

public class HttpServletNormalizer
implements Normalizer {
    private static final Messages mMessages = Messages.getMessages(HttpServletNormalizer.class);
    private static final Logger mLogger = Messages.getLogger(HttpServletNormalizer.class);
    static MessageFactory factory = null;
    SoapNormalizer soapNormalizer = new SoapNormalizer();

    public SOAPMessage toSOAPMessage(Object inputToNormalize) throws MessagingException {
        SOAPMessage msg = null;
        try {
            HttpServletRequest request = (HttpServletRequest)inputToNormalize;
            ServletInputStream is = request.getInputStream();
            MimeHeaders headers = HttpServletNormalizer.getHeaders(request);
            msg = factory.createMessage(headers, (InputStream)is);
        }
        catch (Exception ex) {
            throw new MessagingException(mMessages.getString("HTTPBC-E00603.Exception_normalize"), (Throwable)ex);
        }
        return msg;
    }

    public NormalizedMessage normalize(Object inputToNormalize, MessageExchange messageExchange, OperationMetaData operationMetaData, MessageContext context) throws MessagingException {
        NormalizedMessage result = null;
        try {
            SOAPMessage soapInputToNormalize = (SOAPMessage)inputToNormalize;
            result = this.soapNormalizer.normalize(soapInputToNormalize, messageExchange, operationMetaData, true, context);
        }
        catch (Exception ex) {
            throw new MessagingException(mMessages.getString("HTTPBC-E00603.Exception_normalize"), ex.getCause() != null ? ex.getCause() : ex);
        }
        return result;
    }

    static MimeHeaders getHeaders(HttpServletRequest req) {
        Enumeration headerEnum = req.getHeaderNames();
        MimeHeaders headers = new MimeHeaders();
        while (headerEnum.hasMoreElements()) {
            String headerName = (String)headerEnum.nextElement();
            String headerValue = req.getHeader(headerName);
            StringTokenizer values = new StringTokenizer(headerValue, ",");
            while (values.hasMoreTokens()) {
                headers.addHeader(headerName, values.nextToken().trim());
            }
        }
        return headers;
    }

    static {
        try {
            factory = MessageFactory.newInstance();
        }
        catch (Exception ex) {
            mLogger.log(Level.SEVERE, "Failed to initialize SOAP message factory. Can not convert incoming requests.");
        }
    }
}

