/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.security.am.impl;

import com.iplanet.am.util.SystemProperties;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.jbi.httpsoapbc.configuration.RuntimeConfiguration;
import com.sun.jbi.httpsoapbc.configuration.RuntimeConfigurationMBean;
import com.sun.jbi.httpsoapbc.security.api.CredentialValidationException;
import com.sun.jbi.httpsoapbc.security.api.CredentialValidator;
import com.sun.jbi.httpsoapbc.util.AlertsUtil;
import com.sun.jbi.internationalization.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeChangeNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

public class SunAccessManagerCredentialValidator
implements CredentialValidator {
    private static final Messages mMessages = Messages.getMessages(SunAccessManagerCredentialValidator.class);
    private static final Logger mLog = Messages.getLogger(SunAccessManagerCredentialValidator.class);
    private RuntimeConfigurationMBean rtc;
    private String orgName;
    private String authModulendexName;
    private boolean isInitialized = false;
    private NotificationListener listener = new NotificationListener(){

        public void handleNotification(Notification notification, Object obj) {
            AttributeChangeNotification attrNotif;
            String attrName;
            if (notification instanceof AttributeChangeNotification && (attrName = (attrNotif = (AttributeChangeNotification)notification).getAttributeName()).equals("AMConfigDirectory")) {
                String newVal = (String)attrNotif.getNewValue();
                try {
                    SunAccessManagerCredentialValidator.this.initializeAM(newVal);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    };

    public SunAccessManagerCredentialValidator(RuntimeConfigurationMBean rtc) {
        this.rtc = rtc;
        ((RuntimeConfiguration)rtc).addNotificationListener(this.listener, null, null);
        this.orgName = "dc=sun,dc=com";
        this.authModulendexName = "DataStore";
    }

    public synchronized Subject validateCredential(String id, char[] password) throws CredentialValidationException {
        if (!this.isInitialized) {
            String amconfigFileDir = this.rtc.getAMConfigDirectory();
            if (amconfigFileDir == null || amconfigFileDir.length() == 0) {
                throw new CredentialValidationException(mMessages.getString("HTTPBC-E01029.Invalid_access_manager_config_dir_undefined"));
            }
            this.initializeAM(amconfigFileDir);
            this.isInitialized = true;
        }
        String aOrgName = this.collectAttributes(id, "dc", this.orgName);
        AuthContext authCtx = null;
        Subject subject = null;
        try {
            authCtx = new AuthContext(aOrgName);
            authCtx.login(AuthContext.IndexType.MODULE_INSTANCE, this.authModulendexName);
        }
        catch (AuthLoginException le) {
            throw new CredentialValidationException(le.getMessage(), le);
        }
        Callback[] callbacks = null;
        while (authCtx.hasMoreRequirements()) {
            callbacks = authCtx.getRequirements();
            if (callbacks != null) {
                for (int i = 0; i < callbacks.length; ++i) {
                    if (callbacks[i] instanceof NameCallback) {
                        ((NameCallback)callbacks[i]).setName(id);
                        continue;
                    }
                    if (callbacks[i] instanceof PasswordCallback) {
                        ((PasswordCallback)callbacks[i]).setPassword(password);
                        continue;
                    }
                    throw new CredentialValidationException(mMessages.getString("HTTPBC-E01030.Unsupported_access_manager_callback"));
                }
            }
            authCtx.submitRequirements(callbacks);
        }
        if (authCtx.getStatus() != AuthContext.Status.SUCCESS) {
            throw new CredentialValidationException(authCtx.getErrorMessage(), authCtx.getLoginException());
        }
        subject = authCtx.getSubject();
        return subject;
    }

    private String collectAttributes(String str, String attributeName, String defaultValue) {
        StringBuffer attributes = new StringBuffer();
        if (str != null && attributeName != null) {
            String attributePattern = attributeName + "=";
            StringTokenizer tokenizer = new StringTokenizer(str, ",", false);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                if (!token.startsWith(attributePattern)) continue;
                attributes.append(token);
                if (!tokenizer.hasMoreTokens()) continue;
                attributes.append(',');
            }
        }
        return attributes.length() > 0 ? attributes.toString() : defaultValue;
    }

    private synchronized void initializeAM(String amConfigDir) throws CredentialValidationException {
        String amconfigFile = new StringBuffer(amConfigDir).append(File.separatorChar).append("AMConfig.properties").toString();
        if (!new File(amconfigFile).exists()) {
            String error = mMessages.getString("HTTPBC-E01041.Access_manager_config_props_file_not_found", new Object[]{"AMConfig.properties", amConfigDir});
            mLog.log(Level.WARNING, error);
            AlertsUtil.getAlerter().warning(error, "sun-http-binding", null, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E01041");
            throw new CredentialValidationException(error);
        }
        this.resetAM();
        Properties props = new Properties();
        try {
            FileInputStream fis = new FileInputStream(amconfigFile);
            props.load(fis);
        }
        catch (IOException e) {
            String error = mMessages.getString("HTTPBC-E01028.Failed_load_access_manager_config_props", new Object[]{amConfigDir, e.getLocalizedMessage()});
            mLog.log(Level.WARNING, error, e);
            AlertsUtil.getAlerter().warning(error, "sun-http-binding", null, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E01028");
            throw new CredentialValidationException(error, e);
        }
        SystemProperties.initializeProperties((Properties)props);
        SystemProperties.initializeProperties((String)"com.iplanet.am.serverMode", (String)"false");
    }

    private void resetAM() {
        Properties existingProps = new Properties(SystemProperties.getAll());
        Enumeration<?> propsEnum = existingProps.propertyNames();
        while (propsEnum.hasMoreElements()) {
            String propName = (String)propsEnum.nextElement();
            SystemProperties.initializeProperties((String)propName, (String)"");
        }
    }
}

