/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.embedded;

import com.sun.enterprise.web.connector.grizzly.AsyncExecutor;
import com.sun.enterprise.web.connector.grizzly.AsyncFilter;
import com.sun.enterprise.web.connector.grizzly.AsyncHandler;
import com.sun.enterprise.web.connector.grizzly.AsyncTask;
import com.sun.enterprise.web.connector.grizzly.DefaultProcessorTask;
import com.sun.enterprise.web.connector.grizzly.Task;
import com.sun.jbi.internationalization.Messages;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.coyote.Request;

public class JBIGrizzlyAsyncFilter
implements AsyncFilter {
    private static final Logger logger = Messages.getLogger(JBIGrizzlyAsyncFilter.class);
    private static Map requestToTask = new ConcurrentHashMap();
    private static Queue respondSynchronously = new ConcurrentLinkedQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doFilter(AsyncExecutor asyncExecutor) {
        boolean continueSynchronously = false;
        AsyncTask asyncProcessorTask = asyncExecutor.getAsyncTask();
        DefaultProcessorTask defaultProcTask = (DefaultProcessorTask)asyncProcessorTask.getProcessorTask();
        Request req = defaultProcTask.getRequest();
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "doFilter on request " + req.toString() + ", asyncProcessorTask " + asyncProcessorTask.toString());
        }
        requestToTask.put(req, asyncProcessorTask);
        try {
            boolean wasPresent;
            asyncProcessorTask.getProcessorTask().invokeAdapter();
            continueSynchronously = wasPresent = respondSynchronously.remove(asyncProcessorTask);
        }
        catch (RuntimeException ex) {
            logger.log(Level.WARNING, "HTTPBC-W00641.Adapter_invoke_exception", ex);
            respondSynchronously.remove(asyncProcessorTask);
            continueSynchronously = true;
        }
        finally {
            requestToTask.remove(req);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Continue synchronously flag set to " + continueSynchronously);
        }
        return continueSynchronously;
    }

    public static void finishResponseSynchronously(AsyncTask asyncProcessorTask) {
        if (asyncProcessorTask != null) {
            DefaultProcessorTask task = (DefaultProcessorTask)asyncProcessorTask.getProcessorTask();
            AsyncHandler asyncHandler = task.getAsyncHandler();
            asyncHandler.removeFromInterruptedQueue(asyncProcessorTask);
            respondSynchronously.add(asyncProcessorTask);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Marking exchange as synchronous");
            }
        }
    }

    public static void finishResponse(AsyncTask asyncProcessorTask) {
        if (asyncProcessorTask != null) {
            DefaultProcessorTask task = (DefaultProcessorTask)asyncProcessorTask.getProcessorTask();
            if (task != null) {
                AsyncHandler asyncHandler = task.getAsyncHandler();
                if (asyncHandler != null) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "Finish response for asyncProcessorTask " + asyncProcessorTask.toString());
                    }
                    asyncHandler.handle((Task)asyncProcessorTask);
                } else {
                    logger.log(Level.SEVERE, "HTTPBC-E00642.No_response_handler_for_request");
                }
            } else {
                logger.log(Level.WARNING, "HTTPBC-W00642.No_correlating_request_for_response");
            }
        } else {
            logger.log(Level.WARNING, "HTTPBC-W00643.Null_response");
        }
    }

    public static AsyncTask removeTaskMapping(Request request) {
        return (AsyncTask)requestToTask.remove(request);
    }
}

