/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc;

import com.sun.jbi.httpsoapbc.AbstractEndpoint;
import com.sun.jbi.httpsoapbc.HttpSoapBindingDeployer;
import com.sun.jbi.httpsoapbc.HttpSpiContainerImpl;
import com.sun.jbi.httpsoapbc.OperationMetaData;
import com.sun.jbi.httpsoapbc.security.api.EndpointSecurityConfig;
import com.sun.jbi.httpsoapbc.security.api.EndpointSecurityManager;
import com.sun.jbi.httpsoapbc.security.http.impl.BasicAuthenticator;
import com.sun.jbi.httpsoapbc.security.impl.CredentialValidatorManager;
import com.sun.jbi.internationalization.Messages;
import com.sun.xml.ws.api.server.Container;
import java.io.File;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.security.auth.Subject;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Dispatch;
import javax.xml.ws.RespectBindingFeature;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.soap.MTOMFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpSoapEndpoint
extends AbstractEndpoint {
    private static final Messages mMessages = Messages.getMessages(HttpSoapBindingDeployer.class);
    private transient Logger mLogger = Messages.getLogger(this.getClass());
    private Service mService;
    private Subject mSubject;
    private Dispatch mDispatch;

    public HttpSoapEndpoint(Definition def, QName serviceName, String endpointName, QName interfaceName, boolean isProvider, String wsdlPath, EndpointSecurityConfig securityConfig, String serviceUnitID, String serviceUnitRootPath, CredentialValidatorManager cvm) {
        super(def, serviceName, endpointName, interfaceName, isProvider, wsdlPath, securityConfig, serviceUnitID, serviceUnitRootPath, cvm);
    }

    @Override
    public void init() throws Exception {
        String location = this.getEndpointUrl(this.getPort());
        if (this.mIsInbound) {
            String hostname = new URL(location).getHost();
            if (!InetAddress.getLocalHost().getCanonicalHostName().equals(hostname)) {
                throw new Exception(mMessages.getString("HTTPBC-E00298.Invalid_host_name", new Object[]{hostname, location, this.mWsdlPath}));
            }
        }
        if ("REPLACE_WITH_ACTUAL_URL".equals(location)) {
            return;
        }
        this.setEndpointUrl(new URL(location));
        this.initSecuritySupport();
        BindingOperation[] bos = null;
        Definition currentDef = null;
        bos = this.getOperations(this.getServiceDescriptor(), this.getServiceName().toString(), this.getEndpointName());
        currentDef = this.getServiceDescriptor();
        if (bos == null) {
            String exMsg = mMessages.getString("HTTPBC-E00353.Endpoint_no_operation", new Object[]{this.getEndpointName()});
            throw new Exception(exMsg);
        }
        LinkedHashMap<String, OperationMetaData> operationNameToMeta = new LinkedHashMap<String, OperationMetaData>();
        for (int operationCount = 0; operationCount < bos.length; ++operationCount) {
            String exMsg;
            Output outMsg;
            OperationMetaData meta = new OperationMetaData();
            BindingOperation bo = bos[operationCount];
            String operationName = bo.getName();
            meta.setOperationName(operationName);
            String soapAction = this.getSoapAction(bo);
            if (soapAction == null) {
                if (this.mLogger.isLoggable(Level.FINE)) {
                    this.mLogger.log(Level.FINE, "SOAP action is not set in the wsdl for operation " + operationName);
                }
                meta.setSoapActionURL("");
            } else {
                if (this.mLogger.isLoggable(Level.FINE)) {
                    this.mLogger.log(Level.FINE, "SOAP action is: " + soapAction);
                }
                meta.setSoapActionURL(soapAction);
            }
            Input inMsg = bo.getOperation().getInput();
            if (inMsg != null) {
                if (inMsg.getMessage() == null) {
                    String exMsg2 = mMessages.getString("HTTPBC-E00354.Operation_no_message", new Object[]{inMsg.getName(), bo.getOperation().getName(), this.getEndpointName()});
                    throw new Exception(exMsg2);
                }
                QName n = inMsg.getMessage().getQName();
                meta.setInMsgName(inMsg.getName());
                meta.setInMsgQName(n);
                meta.setInputMessage(inMsg.getMessage());
            }
            if ((outMsg = bo.getOperation().getOutput()) != null) {
                if (outMsg.getMessage() == null) {
                    String exMsg3 = mMessages.getString("HTTPBC-E00354.Operation_no_message", new Object[]{outMsg.getName(), bo.getOperation().getName(), this.getEndpointName()});
                    throw new Exception(exMsg3);
                }
                QName n = outMsg.getMessage().getQName();
                meta.setOutMsgName(outMsg.getName());
                meta.setOutMsgQName(n);
                meta.setOutputMessage(outMsg.getMessage());
            }
            BindingInput inputBinding = bo.getBindingInput();
            meta.setBindingInput(inputBinding);
            if (inputBinding != null) {
                meta.setInputSoapBody(this.getSoapBody(inputBinding));
            }
            BindingOutput outputBinding = bo.getBindingOutput();
            meta.setBindingOutput(outputBinding);
            if (outputBinding != null) {
                meta.setOutputSoapBody(this.getSoapBody(outputBinding));
            }
            if (inputBinding != null) {
                meta.setInputSoapHeaders(this.getSoapHeaders(inputBinding));
            }
            if (outputBinding != null) {
                meta.setOutputSoapHeaders(this.getSoapHeaders(outputBinding));
            }
            boolean isDocument = true;
            String style = this.getSoapOpStyle(bo);
            if (style != null) {
                isDocument = !style.equalsIgnoreCase("rpc");
            } else {
                Binding binding = null;
                binding = this.getBinding(this.getServiceDescriptor(), this.getServiceName().toString(), this.getEndpointName());
                if (binding == null) {
                    exMsg = mMessages.getString("HTTPBC-E00355.Endpoint_no_binding", new Object[]{this.getEndpointName()});
                    throw new Exception(exMsg);
                }
                isDocument = this.isDocumentMode(binding);
            }
            if (this.mLogger.isLoggable(Level.FINE)) {
                this.mLogger.log(Level.FINE, "isDocumentMode " + isDocument + " for endpoint " + this.getEndpointName() + " operation " + operationName);
            }
            meta.setIsDocumentMode(isDocument);
            Map m = bo.getOperation().getFaults();
            if (m != null) {
                meta.setFaults(m);
            }
            meta.setFullDefinition(currentDef);
            if (bo.getOperation().getStyle() == null) {
                exMsg = mMessages.getString("HTTPBC-E00356.Operation_no_mep", new Object[]{operationName});
                throw new Exception(exMsg);
            }
            String mep = this.determineMEP(bo);
            meta.setMessageExchangePattern(mep);
            Set partNames = this.getInputPartNames(meta);
            meta.setCachedInputPartNames(partNames);
            operationNameToMeta.put(operationName, meta);
        }
        this.setOperationNameToMetaData(operationNameToMeta);
        Set duplicates = this.getDuplicateSoapActions(operationNameToMeta);
        Collection metas = operationNameToMeta.values();
        for (OperationMetaData currMeta : metas) {
            String currSoapAction = currMeta.getSoapActionURL();
            String currOperation = currMeta.getOperationName();
            if (duplicates.contains(currSoapAction)) {
                if (this.mLogger.isLoggable(Level.FINE)) {
                    this.mLogger.log(Level.FINE, "soap actions for operation " + currOperation + " are not unique (" + currSoapAction + "), disabling use of soap action as hints");
                }
                currMeta.setUseSoapAction(false);
            } else {
                if (this.mLogger.isLoggable(Level.FINE)) {
                    this.mLogger.log(Level.FINE, "using soap action  (" + currSoapAction + ") as hints for operation " + currOperation);
                }
                currMeta.setUseSoapAction(true);
            }
            boolean isUnique = true;
            if (currMeta.isDocumentMode()) {
                for (OperationMetaData compareMeta : metas) {
                    if (compareMeta == currMeta) continue;
                    Set compare = compareMeta.getCachedInputPartNames();
                    Set current = currMeta.getCachedInputPartNames();
                    if (compare.size() != current.size() || !compare.containsAll(current)) continue;
                    isUnique = false;
                    if (!this.mLogger.isLoggable(Level.FINE)) break;
                    this.mLogger.log(Level.FINE, "The message signature for operation " + currOperation + " is not unique within the binding and will not be used as a factor to resolve operations for incoming messages");
                    break;
                }
            }
            currMeta.setUseMsgAsID(isUnique);
        }
    }

    @Override
    public void activate(ComponentContext context) throws JBIException {
        if (!this.isInbound()) {
            try {
                QName fullServiceName = this.getServiceName();
                String endpointName = this.getEndpointName();
                ServiceEndpoint endpointReference = context.activateEndpoint(fullServiceName, endpointName);
                this.setEndpointReference(endpointReference);
                File f = this.getOriginalWSDL();
                URL wsdlURL = f.toURL();
                this.mService = this.createService(wsdlURL, fullServiceName);
                this.mDispatch = this.createDispatch();
                if (this.mLogger.isLoggable(Level.FINE)) {
                    this.mLogger.log(Level.FINE, "Endpoint " + this.getUniqueName() + " activated");
                }
            }
            catch (Exception me) {
                String text = mMessages.getString("HTTPBC-E00301.Endpoint_activate_failed", new Object[]{this.getUniqueName(), me.getMessage()});
                this.mLogger.log(Level.SEVERE, text, me);
                throw new JBIException(text, (Throwable)me);
            }
        }
    }

    @Override
    public void deactivate(ComponentContext context) throws JBIException {
        if (!this.isInbound()) {
            ServiceEndpoint endpointReference = this.getEndpointReference();
            if (endpointReference != null) {
                context.deactivateEndpoint(endpointReference);
            }
            if (this.securityEnabled && this.basicAuthCredentials != null) {
                BasicAuthenticator.unregisterEndPointCredentials(this, this.basicAuthCredentials);
            }
            if (this.mLogger.isLoggable(Level.FINE)) {
                this.mLogger.log(Level.FINE, "Endpoint " + this.getUniqueName() + " activated");
            }
        }
    }

    public String getSoapAction(BindingOperation bo) {
        Iterator extIter;
        if (bo == null) {
            return null;
        }
        List extElems = bo.getExtensibilityElements();
        String soapAction = null;
        Iterator iterator = extIter = extElems == null ? null : extElems.iterator();
        while (extIter != null && extIter.hasNext()) {
            ExtensibilityElement ee = (ExtensibilityElement)extIter.next();
            if (!SOAPOperation.class.isInstance(ee)) continue;
            SOAPOperation oper = (SOAPOperation)ee;
            soapAction = oper.getSoapActionURI();
        }
        return soapAction;
    }

    public String getSoapOpStyle(BindingOperation bo) {
        Iterator extIter;
        if (bo == null) {
            return null;
        }
        List extElems = bo.getExtensibilityElements();
        String soapOpStyle = null;
        Iterator iterator = extIter = extElems == null ? null : extElems.iterator();
        while (extIter != null && extIter.hasNext()) {
            ExtensibilityElement ee = (ExtensibilityElement)extIter.next();
            if (!SOAPOperation.class.isInstance(ee)) continue;
            SOAPOperation oper = (SOAPOperation)ee;
            soapOpStyle = oper.getStyle();
        }
        return soapOpStyle;
    }

    public SOAPBody getSoapBody(BindingInput bi) {
        if (bi == null) {
            throw new IllegalArgumentException(mMessages.getString("HTTPBC-E00357.BindingInput_null"));
        }
        return this.getSoapBody0(bi.getExtensibilityElements());
    }

    private SOAPBody getSoapBody0(List extElems) {
        Iterator extIter;
        Iterator iterator = extIter = extElems == null ? null : extElems.iterator();
        while (extIter != null && extIter.hasNext()) {
            ExtensibilityElement ee = (ExtensibilityElement)extIter.next();
            if (!SOAPBody.class.isInstance(ee)) continue;
            SOAPBody body = (SOAPBody)ee;
            return body;
        }
        return null;
    }

    public SOAPBody getSoapBody(BindingOutput bo) {
        if (bo == null) {
            throw new IllegalArgumentException(mMessages.getString("HTTPBC-E00358.BindingOutput_null"));
        }
        return this.getSoapBody0(bo.getExtensibilityElements());
    }

    public List getSoapHeaders(BindingInput bi) {
        if (bi == null) {
            throw new IllegalArgumentException(mMessages.getString("HTTPBC-E00358.BindingOutput_null"));
        }
        return this.getSoapHeaders0(bi.getExtensibilityElements());
    }

    public List getSoapHeaders(BindingOutput bo) {
        if (bo == null) {
            throw new IllegalArgumentException(mMessages.getString("HTTPBC-E00358.BindingOutput_null"));
        }
        return this.getSoapHeaders0(bo.getExtensibilityElements());
    }

    public List getSoapHeaders0(List extElems) {
        Iterator extIter;
        ArrayList<SOAPHeader> headers = new ArrayList<SOAPHeader>();
        Iterator iterator = extIter = extElems == null ? null : extElems.iterator();
        while (extIter != null && extIter.hasNext()) {
            ExtensibilityElement ee = (ExtensibilityElement)extIter.next();
            if (!SOAPHeader.class.isInstance(ee)) continue;
            SOAPHeader header = (SOAPHeader)ee;
            headers.add(header);
        }
        return headers;
    }

    public String getEndpointUrl(Port port) {
        String location = null;
        if (port != null) {
            Iterator extIter;
            List extElems = port.getExtensibilityElements();
            Iterator iterator = extIter = extElems == null ? null : extElems.iterator();
            while (extIter != null && extIter.hasNext()) {
                ExtensibilityElement ee = (ExtensibilityElement)extIter.next();
                if (!SOAPAddress.class.isInstance(ee)) continue;
                SOAPAddress addr = (SOAPAddress)ee;
                location = addr.getLocationURI();
            }
        }
        return location;
    }

    public boolean isDocumentMode(Binding binding) {
        Iterator extIter;
        List extElems = binding.getExtensibilityElements();
        Iterator iterator = extIter = extElems == null ? null : extElems.iterator();
        while (extIter != null && extIter.hasNext()) {
            ExtensibilityElement ee = (ExtensibilityElement)extIter.next();
            if (!SOAPBinding.class.isInstance(ee)) continue;
            SOAPBinding soapBinding = (SOAPBinding)ee;
            return soapBinding.getStyle() == null ? true : "document".equalsIgnoreCase(soapBinding.getStyle());
        }
        return true;
    }

    private Set getDuplicateSoapActions(Map map) {
        Collection c = map.values();
        Iterator iter = c.iterator();
        HashSet<String> seen = new HashSet<String>();
        HashSet<String> duplicates = new HashSet<String>();
        while (iter.hasNext()) {
            OperationMetaData meta = (OperationMetaData)iter.next();
            String s = meta.getSoapActionURL();
            if (s == null) continue;
            if (seen.contains(s)) {
                duplicates.add(s);
                continue;
            }
            seen.add(s);
        }
        return duplicates;
    }

    private Set getInputPartNames(OperationMetaData meta) {
        HashSet<QName> set = new HashSet<QName>();
        Message msg = meta.getInputMessage();
        if (msg != null) {
            SOAPBody bodyBinding = meta.getInputSoapBody();
            List bodyParts = null;
            if (bodyBinding != null) {
                bodyParts = bodyBinding.getParts();
            }
            Iterator<Object> bodyIterator = null;
            if (bodyParts != null && bodyParts.size() > 0) {
                bodyIterator = bodyParts.iterator();
            } else {
                Map msgParts = msg.getParts();
                if (msgParts != null) {
                    bodyIterator = msgParts.keySet().iterator();
                }
            }
            while (bodyIterator != null && bodyIterator.hasNext()) {
                String bodyPart = (String)bodyIterator.next();
                Part part = msg.getPart(bodyPart);
                if (part == null) {
                    String err = mMessages.getString("HTTPBC-E00352.Part_not_in_message", new Object[]{bodyPart, msg.getQName().toString()});
                    throw new IllegalStateException(err);
                }
                QName typeQName = part.getTypeName();
                QName elemQName = part.getElementName();
                if (typeQName != null) {
                    set.add(new QName(part.getName()));
                    continue;
                }
                if (elemQName != null) {
                    set.add(elemQName);
                    continue;
                }
                this.mLogger.log(Level.SEVERE, "HTTPBC-E00351.Part_neither_element_or_type", bodyPart);
            }
        }
        return set;
    }

    private Service createService(URL wsdlURL, QName fullServiceName) throws Exception {
        Class<?> initParamsClass;
        Class<?> wsServiceClass;
        Service service;
        block8: {
            service = null;
            wsServiceClass = null;
            initParamsClass = null;
            try {
                wsServiceClass = Class.forName("com.sun.xml.ws.api.WSService", true, Thread.currentThread().getContextClassLoader());
                initParamsClass = Class.forName("com.sun.xml.ws.api.WSService$InitParams", true, Thread.currentThread().getContextClassLoader());
            }
            catch (Exception e) {
                if (!this.mLogger.isLoggable(Level.WARNING)) break block8;
                this.mLogger.log(Level.WARNING, mMessages.getString("HTTPBC-W00364.Metro_updates_not_available"));
            }
        }
        if (wsServiceClass != null && initParamsClass != null) {
            try {
                Object initParamsInstance = initParamsClass.newInstance();
                Class[] args = new Class[]{Container.class};
                Method methodToInvoke = initParamsClass.getMethod("setContainer", args);
                if (methodToInvoke == null) {
                    throw new Exception(mMessages.getString("HTTPBC-W00365.Failed_to_find_method_in_InitParams"));
                }
                Object[] params = new Object[]{new HttpSpiContainerImpl(this)};
                methodToInvoke.invoke(initParamsInstance, params);
                args = new Class[]{URL.class, QName.class, initParamsClass};
                methodToInvoke = wsServiceClass.getMethod("create", args);
                if (methodToInvoke == null) {
                    throw new Exception(mMessages.getString("HTTPBC-W00366.Failed_to_find_method_in_WSService"));
                }
                params = new Object[]{wsdlURL, fullServiceName, initParamsInstance};
                service = (Service)methodToInvoke.invoke(null, params);
            }
            catch (Exception e) {
                throw new Exception(mMessages.getString("HTTPBC-E00363.Cannot_create_service_object", (Object)e.getMessage()));
            }
        } else {
            service = Service.create((URL)wsdlURL, (QName)fullServiceName);
        }
        return service;
    }

    private Dispatch<SOAPMessage> createDispatch() {
        QName fullServiceName = this.getServiceName();
        String endpointName = this.getEndpointName();
        QName qualifiedEndpointName = new QName(fullServiceName.getNamespaceURI(), endpointName);
        Dispatch dispatch = this.mService.createDispatch(qualifiedEndpointName, SOAPMessage.class, Service.Mode.MESSAGE, new WebServiceFeature[]{new RespectBindingFeature(true), new AddressingFeature(true), new MTOMFeature(true)});
        return dispatch;
    }

    public Dispatch<SOAPMessage> createDispatch(String soapActionURL) {
        String url;
        if (this.mDispatch == null) {
            this.mDispatch = this.createDispatch();
        }
        if (soapActionURL == null) {
            soapActionURL = "";
        }
        this.mDispatch.getRequestContext().put("javax.xml.ws.soap.http.soapaction.use", true);
        if (soapActionURL.length() > 0) {
            this.mDispatch.getRequestContext().put("javax.xml.ws.soap.http.soapaction.uri", "\"" + soapActionURL + "\"");
        } else {
            this.mDispatch.getRequestContext().put("javax.xml.ws.soap.http.soapaction.uri", soapActionURL);
        }
        String string = url = this.isDynamicEPR() ? this.getDynamicEPRUrl().toString() : this.getEndpointUrl().toString();
        if (this.mLogger.isLoggable(Level.FINE)) {
            this.mLogger.log(Level.FINE, "Calling destination URL: " + url);
        }
        this.mDispatch.getRequestContext().put("javax.xml.ws.service.endpoint.address", url);
        return this.mDispatch;
    }

    @Override
    public EndpointSecurityManager getEndpointSecurityManager() {
        return BasicAuthenticator.getEndpointSecurityManager();
    }

    @Override
    public void setSubject(Subject subject) {
        this.mSubject = subject;
    }

    @Override
    public Subject getSubject() {
        return this.mSubject;
    }
}

