/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.common.qos.config;

import com.sun.jbi.common.qos.I18n;
import com.sun.jbi.common.qos.config.AppPersistenceParser;
import com.sun.jbi.common.qos.config.ComponentConfig;
import com.sun.jbi.common.qos.config.Property;
import com.sun.jbi.common.util.Util;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.jbi.management.DeploymentException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigPersistence {
    private static SAXParserFactory mFactory = SAXParserFactory.newInstance();
    private static Logger mLogger = Logger.getLogger(ConfigPersistence.class.getName());
    public static final String CONFIG_PERSISTENCE_FILE = "config.properties";
    public static final String APPLICATION_PERSISTENCE_FILE = "config-app-persistence.xml";

    public static void loadApplicationConfig(ComponentConfig config, String workspaceRoot) throws DeploymentException {
        ConfigPersistence.loadApplicationConfig(config, workspaceRoot, APPLICATION_PERSISTENCE_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadApplicationConfig(ComponentConfig config, String workspaceRoot, String filename) throws DeploymentException {
        if (config != null && !Util.isEmpty((String)workspaceRoot) && !Util.isEmpty((String)filename) && (config.supportsAppConfigs() || config.supportsAppVars())) {
            File file = new File(workspaceRoot, filename);
            if (file == null || !file.exists()) {
                mLogger.warning(I18n.loc("QOS-6053: Component Application Configuration file {0} does not exist!", file));
                return;
            }
            try {
                SAXParser parser = mFactory.newSAXParser();
                AppPersistenceParser apParser = new AppPersistenceParser(config);
                Class<ConfigPersistence> clazz = ConfigPersistence.class;
                synchronized (ConfigPersistence.class) {
                    parser.parse(new InputSource(new FileInputStream(file)), (DefaultHandler)((Object)apParser));
                    // ** MonitorExit[var6_8] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                String msg = I18n.loc("QOS-6054: Failed to load application configuration {0}: {1}", file, e.getMessage());
                mLogger.warning(msg);
                throw new DeploymentException(msg, (Throwable)e);
            }
        }
        {
            return;
        }
    }

    public static void loadConfig(ComponentConfig config, String workspaceRoot) throws DeploymentException {
        ConfigPersistence.loadConfig(config, workspaceRoot, CONFIG_PERSISTENCE_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadConfig(ComponentConfig config, String workspaceRoot, String filename) throws DeploymentException {
        if (Util.isEmpty((String)workspaceRoot) || Util.isEmpty((String)filename)) return;
        Properties props = new Properties();
        File file = new File(workspaceRoot, filename);
        if (file == null || !file.exists()) {
            mLogger.warning(I18n.loc("QOS-6029: Component Configuration file {0} does not exist!", file));
            return;
        }
        try {
            Class<ConfigPersistence> clazz = ConfigPersistence.class;
            synchronized (ConfigPersistence.class) {
                FileInputStream is = new FileInputStream(file);
                props.load(is);
                ((InputStream)is).close();
                // ** MonitorExit[var5_5] (shouldn't be in output)
            }
        }
        catch (IOException ex) {
            String msg = I18n.loc("QOS-6016: Failed to load configuration {0}: {1}", file, ex.getMessage());
            mLogger.warning(msg);
            throw new DeploymentException(msg, (Throwable)ex);
        }
        {
            ConfigPersistence.toConfig(config, props);
            return;
        }
    }

    public static void persistApplicationConfig(ComponentConfig config, String workspaceRoot) throws DeploymentException {
        ConfigPersistence.persistApplicationConfig(config, workspaceRoot, APPLICATION_PERSISTENCE_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void persistApplicationConfig(ComponentConfig config, String workspaceRoot, String filename) throws DeploymentException {
        if (config != null && !Util.isEmpty((String)workspaceRoot) && !Util.isEmpty((String)filename) && (config.supportsAppConfigs() || config.supportsAppVars())) {
            try {
                String xml = AppPersistenceParser.toAppXml(config);
                Class<ConfigPersistence> clazz = ConfigPersistence.class;
                synchronized (ConfigPersistence.class) {
                    BufferedWriter wr = new BufferedWriter(new FileWriter(new File(workspaceRoot, filename)));
                    wr.write(xml);
                    wr.flush();
                    wr.close();
                    // ** MonitorExit[var4_5] (shouldn't be in output)
                }
            }
            catch (IOException ex) {
                String msg = I18n.loc("QOS-6055: Failed to persist application configuration settings to file {0}: {1}", String.valueOf(filename), ex.getMessage());
                mLogger.warning(msg);
                throw new DeploymentException(msg, (Throwable)ex);
            }
        }
        {
            return;
        }
    }

    public static void persistConfig(ComponentConfig config, String workspaceRoot) throws DeploymentException {
        ConfigPersistence.persistConfig(config, workspaceRoot, CONFIG_PERSISTENCE_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void persistConfig(ComponentConfig config, String workspaceRoot, String filename) throws DeploymentException {
        if (config != null && !Util.isEmpty((String)workspaceRoot) && !Util.isEmpty((String)filename)) {
            try {
                Properties props = ConfigPersistence.toProperties(config);
                Class<ConfigPersistence> clazz = ConfigPersistence.class;
                synchronized (ConfigPersistence.class) {
                    FileOutputStream os = new FileOutputStream(new File(workspaceRoot, filename));
                    props.store(os, null);
                    ((OutputStream)os).close();
                    // ** MonitorExit[var4_5] (shouldn't be in output)
                }
            }
            catch (IOException ex) {
                String msg = I18n.loc("QOS-6017: Failed to persist configuration settings to file {0}: {1}", String.valueOf(filename), ex.getMessage());
                mLogger.warning(msg);
                throw new DeploymentException(msg, (Throwable)ex);
            }
        }
        {
            return;
        }
    }

    static void toConfig(ComponentConfig config, Properties props) {
        if (props != null) {
            TreeSet<Object> keySet = new TreeSet<Object>(props.keySet());
            for (Object e : keySet) {
                String key = (String)e;
                int ix = key.lastIndexOf(".");
                if (ix > 0) {
                    try {
                        int index = Integer.parseInt(key.substring(ix + 1));
                        Property p = config.getProperty(key.substring(0, ix));
                        p.insertValue(props.getProperty(key), index);
                        config.addProperty(p);
                    }
                    catch (NumberFormatException nfe) {
                        config.addProperty(new Property(key, props.getProperty(key)));
                    }
                    continue;
                }
                config.addProperty(new Property(key, props.getProperty(key)));
            }
        }
    }

    static Properties toProperties(ComponentConfig config) {
        Properties props = new Properties();
        if (config != null) {
            Set<Property> set = config.propertySet();
            String val = null;
            for (Property p : set) {
                if (p.count() > 1) {
                    List<String> values = p.values();
                    int n = values.size();
                    for (int i = 0; i < n; ++i) {
                        val = values.get(i);
                        if (val == null) continue;
                        props.setProperty(p.getName() + "." + i, val);
                    }
                    continue;
                }
                val = p.getValue();
                if (val == null) continue;
                props.setProperty(p.getName(), val);
            }
        }
        return props;
    }
}

