/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.util;

import com.sun.jbi.management.message.JBIMessageException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JBIUtils {
    public static List createSafeList(final Class clazz, final boolean nullsAllowed, final boolean dupsAllowed) {
        return new ArrayList(){

            public boolean add(Object element) {
                if (element == null && !nullsAllowed) {
                    throw new IllegalArgumentException("Cannot add null element to list");
                }
                if (element != null && !clazz.isAssignableFrom(element.getClass())) {
                    throw new ClassCastException("Incompatible types. Got: " + element.getClass().getName() + ", expected: " + clazz.getName());
                }
                if (!dupsAllowed && super.contains(element)) {
                    throw new IllegalArgumentException("Element already in list: " + element);
                }
                return super.add(element);
            }
        };
    }

    public static void validateCollection(Collection collection, Class clazz) throws IllegalArgumentException {
        if (collection == null) {
            throw new JBIMessageException("List cannot be null");
        }
        for (Object o : collection) {
            if (o == null) {
                throw new IllegalArgumentException("Element cannot be null");
            }
            if (clazz.isAssignableFrom(o.getClass())) continue;
            throw new JBIMessageException("List can only contain elements of class " + clazz.getName());
        }
    }

    public static String escape(String text) {
        if (text == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        char[] chars = text.toCharArray();
        block5: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '<': {
                    buffer.append("&lt;");
                    continue block5;
                }
                case '>': {
                    buffer.append("&gt;");
                    continue block5;
                }
                case '&': {
                    buffer.append("&amp;");
                    continue block5;
                }
                default: {
                    buffer.append(chars[i]);
                }
            }
        }
        return buffer.toString();
    }

    public static String stringStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        return sw.toString();
    }
}

