/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.util;

import java.util.LinkedList;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;

public class TransformerPool {
    private static final TransformerFactory cTransformerFact = TransformerFactory.newInstance();
    private final LinkedList<Transformer> mTransformers = new LinkedList();

    public TransformerPool() {
    }

    public TransformerPool(int size) throws TransformerConfigurationException {
        this();
        for (int i = 0; i < size; ++i) {
            this.mTransformers.addFirst(cTransformerFact.newTransformer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transformer retrieve() throws TransformerConfigurationException {
        Transformer transformer = null;
        TransformerPool transformerPool = this;
        synchronized (transformerPool) {
            transformer = !this.mTransformers.isEmpty() ? this.mTransformers.removeFirst() : cTransformerFact.newTransformer();
        }
        return transformer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean relinquish(Transformer transformer) {
        boolean success = false;
        if (transformer != null) {
            TransformerPool transformerPool = this;
            synchronized (transformerPool) {
                if (!this.mTransformers.contains(transformer)) {
                    this.mTransformers.addFirst(transformer);
                    success = true;
                }
            }
        }
        return success;
    }
}

