/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.jaxwssupport;

import com.sun.jbi.common.qos.redelivery.Redelivery;
import com.sun.jbi.common.qos.redelivery.RedeliveryConfig;
import com.sun.jbi.common.qos.redelivery.RedeliveryStatus;
import com.sun.jbi.httpsoapbc.Denormalizer;
import com.sun.jbi.httpsoapbc.Endpoint;
import com.sun.jbi.httpsoapbc.HttpSoapBindingLifeCycle;
import com.sun.jbi.httpsoapbc.HttpSoapComponentContext;
import com.sun.jbi.httpsoapbc.InboundMessageProcessor;
import com.sun.jbi.httpsoapbc.MessageExchangeSupport;
import com.sun.jbi.httpsoapbc.Normalizer;
import com.sun.jbi.httpsoapbc.OperationMetaData;
import com.sun.jbi.httpsoapbc.ReplyListener;
import com.sun.jbi.httpsoapbc.jaxwssupport.JAXWSDenormalizer;
import com.sun.jbi.httpsoapbc.jaxwssupport.JAXWSNormalizer;
import com.sun.jbi.httpsoapbc.util.DebugLog;
import com.sun.jbi.httpsoapbc.util.TransactionsUtil;
import com.sun.jbi.internationalization.Messages;
import com.sun.jbi.nms.exchange.ExchangePattern;
import com.sun.xml.ws.api.server.AsyncProvider;
import com.sun.xml.ws.api.server.AsyncProviderCallback;
import com.sun.xml.wss.SubjectAccessor;
import com.sun.xml.wss.XWSSecurityException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.security.auth.Subject;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.RespectBinding;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceProvider;
import javax.xml.ws.handler.MessageContext;
import net.java.hulp.measure.Probe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RespectBinding
@WebServiceProvider
@ServiceMode(value=Service.Mode.MESSAGE)
public class AsyncJBIProvider
implements AsyncProvider<SOAPMessage>,
ReplyListener {
    private static final Messages mMessages = Messages.getMessages(AsyncJBIProvider.class);
    private static final Logger mLogger = Messages.getLogger(AsyncJBIProvider.class);
    private Endpoint targetEndpoint;
    private HttpSoapBindingLifeCycle lifeCycle = null;
    private ReplyListener replyListener;
    private Probe mFromInvokeToSendResponse = null;
    Map exchangeIDToContext = Collections.synchronizedMap(new HashMap());
    private static ThreadLocal processorSupport = new ThreadLocal();

    public AsyncJBIProvider(Endpoint endpoint) {
        this.targetEndpoint = endpoint;
        this.lifeCycle = (HttpSoapBindingLifeCycle)HttpSoapComponentContext.getInstance().getAssociatedLifeCycle();
        this.replyListener = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(SOAPMessage request, AsyncProviderCallback asyncProviderCallback, WebServiceContext webserviceContext) {
        block13: {
            this.mFromInvokeToSendResponse = Probe.fine(this.getClass(), (String)this.targetEndpoint.getUniqueName(), (String)"processSOAPRequest");
            MessageContext context = webserviceContext.getMessageContext();
            if (mLogger.isLoggable(Level.FINE)) {
                String service = String.valueOf(context.get((Object)"javax.xml.ws.wsdl.service"));
                String port = String.valueOf(context.get((Object)"javax.xml.ws.wsdl.port"));
                String op = String.valueOf(context.get((Object)"javax.xml.ws.wsdl.operation"));
                mLogger.log(Level.FINE, "Processing SOAPMessage received in AsyncProvider. [Service: " + service + "] [Port: " + port + "] [Operation: " + op + "]");
            }
            Transaction suspendedTransaction = null;
            try {
                suspendedTransaction = TransactionsUtil.suspendTransaction();
                this.targetEndpoint.setSubject(this.readSubject(webserviceContext));
                InboundMessageProcessor anInboundProcessor = new InboundMessageProcessor(this.getProcessorSupport().normalizer, this);
                anInboundProcessor.setInput(request);
                if (suspendedTransaction != null) {
                    anInboundProcessor.setTransaction(suspendedTransaction);
                }
                anInboundProcessor.setTargetEndpoint(this.targetEndpoint);
                anInboundProcessor.setMessageContext(context);
                Probe soapToNMRMeasurement = Probe.fine(this.getClass(), (String)this.targetEndpoint.getUniqueName(), (String)"soapToNMRSend");
                anInboundProcessor.setMeasurement(soapToNMRMeasurement);
                String exchangeID = anInboundProcessor.execute(asyncProviderCallback);
                if (suspendedTransaction == null) break block13;
                if (mLogger.isLoggable(Level.FINEST)) {
                    mLogger.log(Level.FINEST, "Transaction suspended.. wait for reply notification.");
                }
                AsyncProviderCallback asyncProviderCallback2 = asyncProviderCallback;
                synchronized (asyncProviderCallback2) {
                    asyncProviderCallback.wait();
                }
                if (mLogger.isLoggable(Level.FINEST)) {
                    mLogger.log(Level.FINEST, "Received reply notification.. resuming transaction");
                }
                TransactionsUtil.resumeTransaction(suspendedTransaction);
            }
            catch (XWSSecurityException e) {
                String errmsg = mMessages.getString("HTTPBC-E00682.Failed_Acquire_Subject", new Object[]{webserviceContext});
                mLogger.log(Level.SEVERE, errmsg, e);
                if (suspendedTransaction != null) {
                    this.setTransactionRollbackOnly(suspendedTransaction, false);
                }
                asyncProviderCallback.sendError((Throwable)e);
            }
            catch (SystemException e) {
                asyncProviderCallback.sendError((Throwable)e);
            }
            catch (Exception e) {
                if (suspendedTransaction != null) {
                    this.setTransactionRollbackOnly(suspendedTransaction, false);
                }
                asyncProviderCallback.sendError((Throwable)e);
            }
        }
    }

    private Subject readSubject(WebServiceContext webserviceContext) throws XWSSecurityException {
        return SubjectAccessor.getRequesterSubject((Object)webserviceContext);
    }

    @Override
    public void setMessageExchangeId(String messageExchangeId, Object clientContext) {
        this.exchangeIDToContext.put(messageExchangeId, clientContext);
    }

    @Override
    public void removeMessageExchangeId(String messageExchangeId) {
        this.exchangeIDToContext.remove(messageExchangeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReply(MessageExchange exchange) throws MessagingException {
        block49: {
            SOAPMessage response = null;
            Object outMsg = null;
            MessageExchangeSupport.removeReplyListener(exchange.getExchangeId());
            AsyncProviderCallback asyncProviderCallback = (AsyncProviderCallback)this.exchangeIDToContext.remove(exchange.getExchangeId());
            Probe denormalizationMeasurement = null;
            Transaction transaction = (Transaction)exchange.getProperty("javax.jbi.transaction.jta");
            try {
                if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
                    InOut inout;
                    if (ExchangePattern.isInOut((MessageExchange)exchange)) {
                        String operation;
                        Map nameToMeta;
                        OperationMetaData operationMetaData;
                        inout = (InOut)exchange;
                        NormalizedMessage outMsgOrFault = inout.getOutMessage();
                        if (outMsgOrFault == null) {
                            Fault aFault = exchange.getFault();
                            outMsgOrFault = aFault;
                        }
                        if (mLogger.isLoggable(Level.FINE)) {
                            if (outMsgOrFault != null) {
                                DebugLog.debugLog(mLogger, Level.FINE, "Denormalizing received msg", outMsgOrFault.getContent());
                            } else {
                                mLogger.log(Level.FINE, "Message received is empty.");
                            }
                        }
                        if ((operationMetaData = (OperationMetaData)(nameToMeta = this.targetEndpoint.getOperationNameToMetaData()).get(operation = exchange.getOperation().getLocalPart())) == null) {
                            throw new MessagingException(mMessages.getString("HTTPBC-E00667.No_opmeta_for_operation", (Object)exchange.getOperation()));
                        }
                        Denormalizer denormalizer = this.getProcessorSupport().denormalizer;
                        denormalizationMeasurement = Probe.info(this.getClass(), (String)this.targetEndpoint.getUniqueName(), (String)"Denormalization");
                        response = (SOAPMessage)denormalizer.denormalize(outMsgOrFault, exchange, response, operationMetaData);
                    } else if (ExchangePattern.isInOnly((MessageExchange)exchange)) {
                        response = null;
                    }
                    if (mLogger.isLoggable(Level.FINE)) {
                        mLogger.log(Level.FINE, "Calling back JAX-WS asynchronously to proceed with response");
                    }
                    if (this.mFromInvokeToSendResponse != null) {
                        this.mFromInvokeToSendResponse.end();
                    }
                    if (transaction != null) {
                        inout = asyncProviderCallback;
                        synchronized (inout) {
                            asyncProviderCallback.notify();
                        }
                    }
                    asyncProviderCallback.send(response);
                    break block49;
                }
                if (exchange.getStatus() == ExchangeStatus.DONE) {
                    if (!ExchangePattern.isInOnly((MessageExchange)exchange)) break block49;
                    if (transaction != null) {
                        AsyncProviderCallback inout = asyncProviderCallback;
                        synchronized (inout) {
                            asyncProviderCallback.notify();
                        }
                    }
                    asyncProviderCallback.send(null);
                    break block49;
                }
                if (exchange.getStatus() != ExchangeStatus.ERROR) break block49;
                RedeliveryConfig redeliveryConfig = this.targetEndpoint.getRedeliveryConfiguration();
                Exception errorDetail = null;
                errorDetail = exchange.getError() != null ? exchange.getError() : new Exception("Provider for " + this.targetEndpoint.getServiceName() + " " + this.targetEndpoint.getEndpointName() + " responded with an error status.");
                if (mLogger.isLoggable(Level.FINE)) {
                    mLogger.log(Level.FINE, "Sending error back to the client via AsyncProviderCallback. Error detail is: " + errorDetail);
                }
                if (ExchangePattern.isInOut((MessageExchange)exchange)) {
                    RedeliveryConfig.Failure onFailureOption;
                    Denormalizer denormalizer = this.getProcessorSupport().denormalizer;
                    RedeliveryConfig.Failure failure = onFailureOption = redeliveryConfig != null ? redeliveryConfig.getFailure() : null;
                    if (redeliveryConfig != null && (onFailureOption == RedeliveryConfig.Failure.suspend || onFailureOption == RedeliveryConfig.Failure.error)) {
                        String faultDetail = this.getRedeliveryFaultDetail(exchange, redeliveryConfig);
                        response = (SOAPMessage)denormalizer.denormalizeError(exchange, faultDetail);
                    } else {
                        response = (SOAPMessage)denormalizer.denormalizeError(exchange, response);
                    }
                    if (transaction != null) {
                        if (mLogger.isLoggable(Level.FINE)) {
                            mLogger.log(Level.FINE, "Transaction is not null, about to rollback the transaction...");
                        }
                        this.setTransactionRollbackOnly(transaction, true);
                        AsyncProviderCallback asyncProviderCallback2 = asyncProviderCallback;
                        synchronized (asyncProviderCallback2) {
                            asyncProviderCallback.notify();
                        }
                    }
                    if (mLogger.isLoggable(Level.FINE)) {
                        mLogger.log(Level.FINE, "About to send a fault back to the client via AsyncProviderCallback");
                    }
                    asyncProviderCallback.send((Object)response);
                    break block49;
                }
                if (ExchangePattern.isInOnly((MessageExchange)exchange)) {
                    asyncProviderCallback.send(null);
                }
            }
            catch (MessagingException e) {
                if (mLogger.isLoggable(Level.WARNING)) {
                    mLogger.log(Level.WARNING, mMessages.getString("HTTPBC-E00799.Denormalize_fail"), e);
                }
                if (transaction != null) {
                    this.setTransactionRollbackOnly(transaction, true);
                    AsyncProviderCallback asyncProviderCallback3 = asyncProviderCallback;
                    synchronized (asyncProviderCallback3) {
                        asyncProviderCallback.notify();
                    }
                }
                asyncProviderCallback.sendError((Throwable)e);
                throw e;
            }
            catch (Exception e) {
                if (mLogger.isLoggable(Level.WARNING)) {
                    mLogger.log(Level.WARNING, mMessages.getString("HTTPBC-E00800.Failed_to_process_reply_from_jbi"), e);
                }
                if (transaction != null) {
                    this.setTransactionRollbackOnly(transaction, true);
                    AsyncProviderCallback asyncProviderCallback4 = asyncProviderCallback;
                    synchronized (asyncProviderCallback4) {
                        asyncProviderCallback.notify();
                    }
                }
                asyncProviderCallback.sendError((Throwable)e);
                throw new MessagingException(mMessages.getString("HTTPBC-E00800.Failed_to_process_reply_from_jbi"), (Throwable)e);
            }
            finally {
                if (denormalizationMeasurement != null) {
                    denormalizationMeasurement.end();
                }
                this.targetEndpoint.decrementPendingExchangeReplies();
                if (mLogger.isLoggable(Level.FINEST)) {
                    mLogger.log(Level.FINEST, "Decremented pending message exchange replies; endpoint '" + this.targetEndpoint.getUniqueName() + "'");
                }
            }
        }
    }

    String getRedeliveryFaultDetail(MessageExchange exchange, RedeliveryConfig redeliveryConfig) {
        StringBuffer faultDetail = new StringBuffer();
        RedeliveryStatus redeliveryStatus = Redelivery.getRedeliveryStatus((MessageExchange)exchange);
        Exception lastError = redeliveryStatus.getError();
        if (redeliveryConfig != null) {
            RedeliveryConfig.Failure onFailureOption = redeliveryConfig.getFailure();
            faultDetail.append("Maximum redelivery attempts has been exhausted yet the exchange error persisted. ");
            switch (onFailureOption) {
                case suspend: {
                    faultDetail.append("Endpoint with service name '" + this.targetEndpoint.getServiceName() + "' and endpoint name '" + this.targetEndpoint.getEndpointName() + "' will be suspended per the redelivery on-failure option.");
                }
                case redirect: {
                    if (!ExchangePattern.isInOnly((MessageExchange)exchange)) break;
                    faultDetail.append("The attempt to route the exchange to the error endpoint specified in redelivery configuration also failed.");
                    break;
                }
                case delete: {
                    if (!ExchangePattern.isInOnly((MessageExchange)exchange)) break;
                    faultDetail.append("The request message will be silently deleted.");
                    break;
                }
                case error: {
                    faultDetail.append("Error causing the last redelivery attempt to fail is: " + lastError.getMessage());
                    break;
                }
            }
        }
        return faultDetail.toString();
    }

    public SOAPMessage soapActionHeaderWorkaround(SOAPMessage request, WebServiceContext webserviceContext) {
        try {
            MessageContext messageContext = webserviceContext.getMessageContext();
            Map headers = (Map)messageContext.get((Object)"javax.xml.ws.http.request.headers");
            List soapActionHeaders = (List)headers.get("SOAPAction".toLowerCase());
            if (soapActionHeaders != null) {
                request.getMimeHeaders().setHeader("SOAPAction", (String)soapActionHeaders.get(0));
                request.saveChanges();
            }
        }
        catch (Exception ex) {
            mLogger.log(Level.SEVERE, "Unable to migrate SOAPAction URI from MessageContext to SOAPMessage", ex);
        }
        return request;
    }

    ProcessorSupport getProcessorSupport() throws MessagingException {
        ProcessorSupport currentProcSupport = (ProcessorSupport)processorSupport.get();
        if (currentProcSupport == null) {
            currentProcSupport = new ProcessorSupport();
            currentProcSupport.normalizer = new JAXWSNormalizer();
            currentProcSupport.denormalizer = new JAXWSDenormalizer();
            currentProcSupport.inboundProcessor = new InboundMessageProcessor(currentProcSupport.normalizer, this.replyListener);
            processorSupport.set(currentProcSupport);
        }
        return currentProcSupport;
    }

    private void setTransactionRollbackOnly(Transaction transaction, boolean suspend) {
        boolean txResumed = false;
        if (transaction != null) {
            txResumed = TransactionsUtil.resumeTransaction(transaction);
        }
        if (txResumed) {
            if (mLogger.isLoggable(Level.FINEST)) {
                mLogger.log(Level.FINEST, "Calling setRollbackOnly on transaction [" + transaction + "]");
            }
            TransactionsUtil.setRollbackOnlyOnTransaction(transaction);
            if (suspend) {
                try {
                    TransactionsUtil.suspendTransaction();
                }
                catch (SystemException se) {
                    // empty catch block
                }
            }
        }
    }

    static class ProcessorSupport {
        Normalizer normalizer;
        Denormalizer denormalizer;
        InboundMessageProcessor inboundProcessor;

        ProcessorSupport() {
        }
    }
}

