/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc;

import com.sun.jbi.httpsoapbc.AbstractEndpoint;
import com.sun.jbi.httpsoapbc.HttpSoapBindingDeployer;
import com.sun.jbi.httpsoapbc.OperationMetaData;
import com.sun.jbi.httpsoapbc.security.api.EndpointSecurityConfig;
import com.sun.jbi.httpsoapbc.security.api.EndpointSecurityManager;
import com.sun.jbi.httpsoapbc.security.http.impl.BasicAuthenticator;
import com.sun.jbi.httpsoapbc.security.impl.CredentialValidatorManager;
import com.sun.jbi.internationalization.Messages;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.security.auth.Subject;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.http.HTTPOperation;
import javax.wsdl.extensions.http.HTTPUrlEncoded;
import javax.wsdl.extensions.http.HTTPUrlReplacement;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.xml.namespace.QName;

public class HttpEndpoint
extends AbstractEndpoint {
    public static final String HTTP_BINDING_VERB_GET = "GET";
    public static final String HTTP_BINDING_VERB_POST = "POST";
    private static final Messages mMessages = Messages.getMessages(HttpSoapBindingDeployer.class);
    private transient Logger mLogger = Messages.getLogger(this.getClass());
    private String mHttpBindingVerb;
    private Subject mSubject;

    public HttpEndpoint(Definition def, QName serviceName, String endpointName, QName interfaceName, boolean isProvider, String wsdlPath, EndpointSecurityConfig securityConfig, String serviceUnitID, String serviceUnitRootPath, CredentialValidatorManager cvm) {
        super(def, serviceName, endpointName, interfaceName, isProvider, wsdlPath, securityConfig, serviceUnitID, serviceUnitRootPath, cvm);
    }

    public void init() throws Exception {
        String adrLocation = this.getHttpAddressLocation(this.getPort());
        if (this.mIsInbound) {
            String hostname = new URL(adrLocation).getHost();
            if (!InetAddress.getLocalHost().getCanonicalHostName().equals(hostname)) {
                throw new Exception(mMessages.getString("HTTPBC-E00298.Invalid_host_name", new Object[]{hostname, adrLocation, this.mWsdlPath}));
            }
        }
        URL url = new URL(adrLocation);
        this.setEndpointUrl(url);
        this.initSecuritySupport();
        Binding binding = null;
        BindingOperation[] bos = null;
        Definition currentDef = this.getServiceDescriptor();
        binding = this.getBinding(this.getServiceDescriptor(), this.getServiceName().toString(), this.getEndpointName());
        bos = this.getOperations(this.getServiceDescriptor(), this.getServiceName().toString(), this.getEndpointName());
        if (binding == null) {
            String exMsg = mMessages.getString("HttpSoapBindingDeployer.Missing_wsdl_binding_for_endpoint", new Object[]{this.getEndpointName()});
            throw new Exception(exMsg);
        }
        HTTPBinding httpBinding = this.getHTTPBinding(binding);
        String bindingVerb = httpBinding.getVerb();
        this.setHttpBindingVerb(bindingVerb);
        if (bos == null) {
            String exMsg = mMessages.getString("HttpSoapBindingDeployer.Missing_operation_for_endpoint_during_deployment", new Object[]{this.getEndpointName()});
            throw new Exception(exMsg);
        }
        LinkedHashMap<String, OperationMetaData> operationNameToMeta = new LinkedHashMap<String, OperationMetaData>();
        for (int operationCount = 0; operationCount < bos.length; ++operationCount) {
            Map m;
            Output opOutput;
            OperationMetaData meta = new OperationMetaData();
            BindingOperation bo = bos[operationCount];
            String operationName = bo.getName();
            meta.setOperationName(operationName);
            String opLocation = this.getHttpOperationLocation(bo);
            if (this.mLogger.isLoggable(Level.FINE)) {
                this.mLogger.log(Level.FINE, "The location attribute on <http:operation> element is " + opLocation);
            }
            meta.setHttpOperationLocation(opLocation);
            Input opInput = bo.getOperation().getInput();
            if (opInput != null) {
                if (opInput.getMessage() == null) {
                    String exMsg = mMessages.getString("HttpSoapBindingDeployer.Message_could_not_be_found_for_operation_input", new Object[]{opInput.getName(), bo.getOperation().getName(), this.getEndpointName()});
                    throw new Exception(exMsg);
                }
                QName n = opInput.getMessage().getQName();
                meta.setInMsgName(opInput.getName());
                meta.setInMsgQName(n);
                meta.setInputMessage(opInput.getMessage());
                List partList = opInput.getMessage().getOrderedParts(null);
                ArrayList<String> partNameList = new ArrayList<String>();
                for (int i = 0; i < partList.size(); ++i) {
                    partNameList.add(((Part)partList.get(i)).getName());
                }
                meta.setCachedInputPartNameList(partNameList);
            }
            if ((opOutput = bo.getOperation().getOutput()) != null) {
                if (opOutput.getMessage() == null) {
                    String exMsg = mMessages.getString("HttpSoapBindingDeployer.Message_could_not_be_found_for_operation_output", new Object[]{opOutput.getName(), bo.getOperation().getName(), this.getEndpointName()});
                    throw new Exception(exMsg);
                }
                QName n = opOutput.getMessage().getQName();
                meta.setOutMsgName(opOutput.getName());
                meta.setOutMsgQName(n);
                meta.setOutputMessage(opOutput.getMessage());
            }
            BindingInput bindingInput = bo.getBindingInput();
            meta.setBindingInput(bindingInput);
            if (bindingInput != null) {
                meta.setHttpUrlEncoding(this.getHttpUrlEncoding(bindingInput));
                meta.setInputMimeContents(this.getMimeContent(bindingInput));
            }
            BindingOutput bindingOutput = bo.getBindingOutput();
            meta.setBindingOutput(bindingOutput);
            if (bindingOutput != null) {
                meta.setOutputMimeContents(this.getMimeContent(bindingOutput));
            }
            if ((m = bo.getOperation().getFaults()) != null) {
                meta.setFaults(m);
            }
            meta.setFullDefinition(currentDef);
            String mep = this.determineMEP(bo);
            meta.setMessageExchangePattern(mep);
            operationNameToMeta.put(operationName, meta);
        }
        this.setOperationNameToMetaData(operationNameToMeta);
    }

    public void activate(ComponentContext context) throws JBIException {
        if (!this.isInbound()) {
            try {
                QName fullServiceName = this.getServiceName();
                String endpointName = this.getEndpointName();
                ServiceEndpoint endpointReference = context.activateEndpoint(fullServiceName, endpointName);
                this.setEndpointReference(endpointReference);
                if (this.mLogger.isLoggable(Level.FINE)) {
                    this.mLogger.log(Level.FINE, "Activated outbound endpoint " + this.getUniqueName());
                }
            }
            catch (JBIException me) {
                String text = mMessages.getString("HTTPBC-E00301.Endpoint_activate_failed", new Object[]{this.getUniqueName(), me.getMessage()});
                this.mLogger.log(Level.SEVERE, text, me);
            }
        }
    }

    public void deactivate(ComponentContext context) throws JBIException {
        if (!this.isInbound()) {
            ServiceEndpoint endpointReference = this.getEndpointReference();
            if (endpointReference != null) {
                context.deactivateEndpoint(endpointReference);
            }
            if (this.mLogger.isLoggable(Level.FINE)) {
                this.mLogger.log(Level.FINE, "Activated outbound endpoint " + this.getUniqueName());
            }
        }
    }

    public String getHttpBindingVerb() {
        return this.mHttpBindingVerb;
    }

    public void setHttpBindingVerb(String httpBindingVerb) {
        this.mHttpBindingVerb = httpBindingVerb;
    }

    public String getHttpAddressLocation(Port port) {
        String location = null;
        if (port != null) {
            Iterator extIter;
            List extElems = port.getExtensibilityElements();
            Iterator iterator = extIter = extElems == null ? null : extElems.iterator();
            while (extIter != null && extIter.hasNext()) {
                ExtensibilityElement ee = (ExtensibilityElement)extIter.next();
                if (!HTTPAddress.class.isInstance(ee)) continue;
                HTTPAddress addr = (HTTPAddress)ee;
                location = addr.getLocationURI();
                break;
            }
        }
        return location;
    }

    public String getHttpOperationLocation(BindingOperation bo) {
        Iterator extIter;
        if (bo == null) {
            return null;
        }
        List extElems = bo.getExtensibilityElements();
        String opLoc = null;
        Iterator iterator = extIter = extElems == null ? null : extElems.iterator();
        while (extIter != null && extIter.hasNext()) {
            ExtensibilityElement ee = (ExtensibilityElement)extIter.next();
            if (!HTTPOperation.class.isInstance(ee)) continue;
            HTTPOperation oper = (HTTPOperation)ee;
            opLoc = oper.getLocationURI();
            break;
        }
        return opLoc;
    }

    public String getHttpUrlEncoding(BindingInput bindingInput) {
        Iterator extIter;
        if (bindingInput == null) {
            return null;
        }
        List extElems = bindingInput.getExtensibilityElements();
        Iterator iterator = extIter = extElems == null ? null : extElems.iterator();
        while (extIter != null && extIter.hasNext()) {
            ExtensibilityElement ee = (ExtensibilityElement)extIter.next();
            if (HTTPUrlEncoded.class.isInstance(ee)) {
                return "urlEncoded";
            }
            if (!HTTPUrlReplacement.class.isInstance(ee)) continue;
            return "urlReplacement";
        }
        return "unspecified";
    }

    public List getMimeContent(BindingInput bindingInput) {
        Iterator extIter;
        ArrayList<ExtensibilityElement> mcList = new ArrayList<ExtensibilityElement>();
        if (bindingInput == null) {
            return mcList;
        }
        List extElems = bindingInput.getExtensibilityElements();
        Iterator iterator = extIter = extElems == null ? null : extElems.iterator();
        while (extIter != null && extIter.hasNext()) {
            ExtensibilityElement ee = (ExtensibilityElement)extIter.next();
            if (!MIMEContent.class.isInstance(ee)) continue;
            mcList.add(ee);
        }
        return mcList;
    }

    public List getMimeContent(BindingOutput bindingOutput) {
        Iterator extIter;
        ArrayList<ExtensibilityElement> mcList = new ArrayList<ExtensibilityElement>();
        if (bindingOutput == null) {
            return mcList;
        }
        List extElems = bindingOutput.getExtensibilityElements();
        Iterator iterator = extIter = extElems == null ? null : extElems.iterator();
        while (extIter != null && extIter.hasNext()) {
            ExtensibilityElement ee = (ExtensibilityElement)extIter.next();
            if (!MIMEContent.class.isInstance(ee)) continue;
            mcList.add(ee);
        }
        return mcList;
    }

    public HTTPBinding getHTTPBinding(Binding binding) {
        HTTPBinding httpBinding = null;
        if (binding != null) {
            Iterator extIter;
            List extElems = binding.getExtensibilityElements();
            Iterator iterator = extIter = extElems == null ? null : extElems.iterator();
            while (extIter != null && extIter.hasNext()) {
                ExtensibilityElement ee = (ExtensibilityElement)extIter.next();
                if (!HTTPBinding.class.isInstance(ee)) continue;
                httpBinding = (HTTPBinding)ee;
                break;
            }
        }
        return httpBinding;
    }

    public EndpointSecurityManager getEndpointSecurityManager() {
        return BasicAuthenticator.getEndpointSecurityManager();
    }

    public void setSubject(Subject subject) {
        this.mSubject = subject;
    }

    public Subject getSubject() {
        return this.mSubject;
    }
}

