/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.common.descriptor;

import com.sun.jbi.common.descriptor.JbiDescriptor;
import com.sun.jbi.common.descriptor.ServiceUnit;
import com.sun.jbi.common.descriptor.model.Services;
import com.sun.jbi.common.descriptor.parsers.EndpointParser;
import com.sun.jbi.common.util.I18n;
import com.sun.jbi.common.xml.StackableParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.management.DeploymentException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ServicesDescriptor
extends JbiDescriptor {
    private static SAXParserFactory mFactory = SAXParserFactory.newInstance();
    private static Logger mLogger = Logger.getLogger(ServicesDescriptor.class.getName());

    public static Services parse(InputSource source) throws DeploymentException {
        try {
            StackableParser root = StackableParser.createRootParser();
            EndpointParser suParser = new EndpointParser();
            root.declareStackableParser(suParser, "http://java.sun.com/xml/ns/jbi", "provides", "consumes");
            SAXParser parser = mFactory.newSAXParser();
            parser.parse(source, (DefaultHandler)root);
            return new Services(suParser.getProvInfo(), suParser.getConsInfo());
        }
        catch (ParserConfigurationException pce) {
            throw ServicesDescriptor.error(I18n.loc("UTIL-6001: Failed to obtain SAX parser: {0}", pce.getMessage()), pce);
        }
        catch (SAXException se) {
            throw ServicesDescriptor.error(I18n.loc("UTIL-6002: ailed to parse service unit descriptor: {0}", se.getMessage()), se);
        }
        catch (IOException ioe) {
            throw ServicesDescriptor.error(I18n.loc("UTIL-6003: Unexpected I/O error parsing service unit descriptor: {0}", ioe.getMessage()), ioe);
        }
    }

    public static ServiceUnit parse(String serviceUnitName, String serviceUnitRootPath) throws DeploymentException {
        try {
            File jbiDescriptorFile = new File(serviceUnitRootPath + File.separator + "META-INF", "jbi.xml");
            if (!jbiDescriptorFile.exists()) {
                throw ServicesDescriptor.error(I18n.loc("UTIL-6004: Descriptor file does not exist: {0}", jbiDescriptorFile.getAbsolutePath()), null);
            }
            return new ServiceUnit(serviceUnitName, serviceUnitRootPath, ServicesDescriptor.parse(new InputSource(new FileInputStream(jbiDescriptorFile))));
        }
        catch (FileNotFoundException fnfe) {
            throw ServicesDescriptor.error(I18n.loc("UTIL-6005: Service unit descriptor not found: {0}", fnfe.getMessage()), fnfe);
        }
    }

    private static DeploymentException error(String message, Exception thrown) {
        if (thrown == null) {
            mLogger.warning(message);
            return new DeploymentException(message);
        }
        mLogger.log(Level.WARNING, message, thrown);
        return new DeploymentException(message, (Throwable)thrown);
    }
}

