/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.eManager.provider;

import com.sun.jbi.eManager.provider.EndpointStatus;
import com.sun.jbi.eManager.provider.EndpointStatusImpl;
import com.sun.jbi.eManager.provider.PerformanceMeasurement;
import com.sun.jbi.eManager.provider.StatusProviderMBean;
import com.sun.jbi.eManager.provider.StatusReporting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;

public class StatusProvider
implements StatusReporting,
StatusProviderMBean {
    String shortDisplayName;
    protected Map endpointStatusMap = Collections.synchronizedMap(new HashMap());
    protected List provisioningEndpoints = Collections.synchronizedList(new ArrayList());
    protected List consumingEndpoints = Collections.synchronizedList(new ArrayList());
    protected volatile String[] performanceMeasurementCategories = new String[0];
    protected PerformanceMeasurement performanceMeasurementCallback = null;

    public StatusProvider(String aShortDisplayName) {
        this.shortDisplayName = aShortDisplayName;
    }

    public String getShortDisplayName() {
        return this.shortDisplayName;
    }

    public static ObjectName constructObjectName(String componentType, String componentName) throws MalformedObjectNameException, NullPointerException {
        ObjectName objectName = null;
        String objectNameString = null;
        String type = null;
        if (componentType != null) {
            if (componentType.equals("Binding") || componentType.equals("bindingComponents")) {
                type = "bindingComponents";
            } else if (componentType.equals("Engine") || componentType.equals("engineComponents")) {
                type = "serviceEngines";
            } else if (componentType.equals("Namespace") || componentType.equals("sharedLibraries")) {
                type = "sharedLibraries";
            } else if (componentType.equals("serviceAssemblies") || componentType.equals("Deployment")) {
                type = "serviceAssemblies";
            }
        }
        if (type != null && componentName != null) {
            objectNameString = "com.sun.ebi:ServiceType=Status,InstallationType=" + type + ",IdentificationName=" + componentName;
            objectName = new ObjectName(objectNameString);
        }
        return objectName;
    }

    public String[] getConsumingEndpoints() {
        return this.consumingEndpoints.toArray(new String[0]);
    }

    public String[] getProvisioningEndpoints() {
        return this.provisioningEndpoints.toArray(new String[0]);
    }

    public Long getTotalDone() {
        long received = this.getTotalReceivedDones();
        long sent = this.getTotalSentDones();
        return received + sent;
    }

    public Long getTotalErrors() {
        long received = this.getTotalReceivedErrors();
        long sent = this.getTotalSentErrors();
        return received + sent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getTotalReceivedDones() {
        long total = 0L;
        Iterator valueIter = this.endpointStatusMap.values().iterator();
        Map map = this.endpointStatusMap;
        synchronized (map) {
            while (valueIter.hasNext()) {
                EndpointStatus value = (EndpointStatus)valueIter.next();
                total += value.getReceivedDones();
            }
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getTotalReceivedErrors() {
        long total = 0L;
        Iterator valueIter = this.endpointStatusMap.values().iterator();
        Map map = this.endpointStatusMap;
        synchronized (map) {
            while (valueIter.hasNext()) {
                EndpointStatus value = (EndpointStatus)valueIter.next();
                total += value.getReceivedErrors();
            }
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getTotalReceivedReplies() {
        long total = 0L;
        Iterator valueIter = this.endpointStatusMap.values().iterator();
        Map map = this.endpointStatusMap;
        synchronized (map) {
            while (valueIter.hasNext()) {
                EndpointStatus value = (EndpointStatus)valueIter.next();
                total += value.getReceivedReplies();
            }
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getTotalReceivedRequests() {
        long total = 0L;
        Iterator valueIter = this.endpointStatusMap.values().iterator();
        Map map = this.endpointStatusMap;
        synchronized (map) {
            while (valueIter.hasNext()) {
                EndpointStatus value = (EndpointStatus)valueIter.next();
                total += value.getReceivedRequests();
            }
        }
        return total;
    }

    public Long getTotalReplies() {
        long received = this.getTotalReceivedReplies();
        long sent = this.getTotalSentReplies();
        return received + sent;
    }

    public Long getTotalRequests() {
        long received = this.getTotalReceivedRequests();
        long sent = this.getTotalSentRequests();
        return received + sent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getTotalSentDones() {
        long total = 0L;
        Iterator valueIter = this.endpointStatusMap.values().iterator();
        Map map = this.endpointStatusMap;
        synchronized (map) {
            while (valueIter.hasNext()) {
                EndpointStatus value = (EndpointStatus)valueIter.next();
                total += value.getSentDones();
            }
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getTotalSentErrors() {
        long total = 0L;
        Iterator valueIter = this.endpointStatusMap.values().iterator();
        Map map = this.endpointStatusMap;
        synchronized (map) {
            while (valueIter.hasNext()) {
                EndpointStatus value = (EndpointStatus)valueIter.next();
                total += value.getSentErrors();
            }
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getTotalSentReplies() {
        long total = 0L;
        Iterator valueIter = this.endpointStatusMap.values().iterator();
        Map map = this.endpointStatusMap;
        synchronized (map) {
            while (valueIter.hasNext()) {
                EndpointStatus value = (EndpointStatus)valueIter.next();
                total += value.getSentReplies();
            }
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getTotalSentRequests() {
        long total = 0L;
        Iterator valueIter = this.endpointStatusMap.values().iterator();
        Map map = this.endpointStatusMap;
        synchronized (map) {
            while (valueIter.hasNext()) {
                EndpointStatus value = (EndpointStatus)valueIter.next();
                total += value.getSentRequests();
            }
        }
        return total;
    }

    public Long getSentRequests(String endpoint) {
        EndpointStatus stat = this.getEndpointStatus(endpoint);
        return stat == null ? 0L : stat.getSentRequests();
    }

    public Long getSentReplies(String endpoint) {
        EndpointStatus stat = this.getEndpointStatus(endpoint);
        if (stat == null) {
            return 0L;
        }
        return stat.getSentReplies();
    }

    public Long getSentErrors(String endpoint) {
        EndpointStatus stat = this.getEndpointStatus(endpoint);
        return stat == null ? 0L : stat.getSentErrors();
    }

    public Long getSentDones(String endpoint) {
        EndpointStatus stat = this.getEndpointStatus(endpoint);
        return stat == null ? 0L : stat.getSentDones();
    }

    public Long getReceivedRequests(String endpoint) {
        EndpointStatus stat = this.getEndpointStatus(endpoint);
        return stat == null ? 0L : stat.getReceivedRequests();
    }

    public Long getReceivedReplies(String endpoint) {
        EndpointStatus stat = this.getEndpointStatus(endpoint);
        return stat == null ? 0L : stat.getReceivedReplies();
    }

    public Long getReceivedErrors(String endpoint) {
        EndpointStatus stat = this.getEndpointStatus(endpoint);
        return stat == null ? 0L : stat.getReceivedErrors();
    }

    public Long getReceivedDones(String endpoint) {
        EndpointStatus stat = this.getEndpointStatus(endpoint);
        return stat == null ? 0L : stat.getReceivedDones();
    }

    public EndpointStatus getEndpointStatus(String endpoint) {
        return (EndpointStatus)this.endpointStatusMap.get(endpoint);
    }

    public void addConsumingEndpoints(String[] consumingEndpts) {
        for (int epCount = 0; epCount < consumingEndpts.length; ++epCount) {
            this.endpointStatusMap.put(consumingEndpts[epCount], new EndpointStatusImpl());
        }
        this.consumingEndpoints.addAll(Arrays.asList(consumingEndpts));
    }

    public void addConsumingEndpoint(String consumingEndpoint) {
        if (!this.consumingEndpoints.contains(consumingEndpoint)) {
            this.endpointStatusMap.put(consumingEndpoint, new EndpointStatusImpl());
            this.consumingEndpoints.add(consumingEndpoint);
        }
    }

    public void removeConsumingEndpoints(String[] consumingEndpts) {
        this.consumingEndpoints.removeAll(Arrays.asList(consumingEndpts));
        for (int epCount = 0; epCount < consumingEndpts.length; ++epCount) {
            this.endpointStatusMap.remove(consumingEndpts[epCount]);
        }
    }

    public void addProvisioningEndpoints(String[] provEndpoints) {
        for (int epCount = 0; epCount < provEndpoints.length; ++epCount) {
            this.endpointStatusMap.put(provEndpoints[epCount], new EndpointStatusImpl());
        }
        this.provisioningEndpoints.addAll(Arrays.asList(provEndpoints));
    }

    public void addProvisioningEndpoint(String provisioningEndpoint) {
        if (!this.provisioningEndpoints.contains(provisioningEndpoint)) {
            this.endpointStatusMap.put(provisioningEndpoint, new EndpointStatusImpl());
            this.provisioningEndpoints.add(provisioningEndpoint);
        }
    }

    public void removeProvisioningEndpoints(String[] provisioningEndpts) {
        this.provisioningEndpoints.removeAll(Arrays.asList(provisioningEndpts));
        for (int epCount = 0; epCount < provisioningEndpts.length; ++epCount) {
            this.endpointStatusMap.remove(provisioningEndpts[epCount]);
        }
    }

    public TabularData getPerformanceInstrumentationMeasurement(String endpoint) throws OpenDataException, MBeanException {
        if (this.performanceMeasurementCallback == null) {
            throw new MBeanException(new Exception("measurement not supported for " + this.shortDisplayName));
        }
        if (this.endpointStatusMap.containsKey(endpoint)) {
            return this.performanceMeasurementCallback.getPerformanceInstrumentationMeasurement(endpoint);
        }
        throw new MBeanException(new Exception(endpoint + " not found"));
    }

    public void clearPeformaceInstrumentationMeasurement(String endpoint) throws MBeanException {
        if (this.performanceMeasurementCallback == null) {
            throw new MBeanException(new Exception("measurement not supported for " + this.shortDisplayName));
        }
        if (!this.endpointStatusMap.containsKey(endpoint)) {
            throw new MBeanException(new Exception(endpoint));
        }
        this.performanceMeasurementCallback.clearPeformaceInstrumentationMeasurement(endpoint);
    }

    public String[] getPerformanceMeasurementCategories() {
        return this.performanceMeasurementCategories;
    }

    public void setPerformanceMeasurementCategories(String[] categories) {
        this.performanceMeasurementCategories = categories;
    }

    public void setPeformanceMeasurementCallback(PerformanceMeasurement callback) {
        this.performanceMeasurementCallback = callback;
    }

    public String getWSDLDefinition(String endpoint) throws MBeanException {
        if (this.endpointStatusMap.get(endpoint) == null) {
            throw new MBeanException(new Exception("Unable to locate an activated endpoint with unique name: " + endpoint));
        }
        EndpointStatus status = (EndpointStatus)this.endpointStatusMap.get(endpoint);
        return status.getWSDLDefinition();
    }

    public String getWSDLImportedResource(String endpoint, String targetNamespace) throws MBeanException {
        if (this.endpointStatusMap.get(endpoint) == null) {
            throw new MBeanException(new Exception("Unable to locate an activated endpoint with unique name: " + endpoint));
        }
        EndpointStatus status = (EndpointStatus)this.endpointStatusMap.get(endpoint);
        return status.getWSDLImportedResource(targetNamespace);
    }
}

