/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.alerter;

import com.sun.jbi.alerter.Alerter;
import com.sun.jbi.alerter.EventDataConverter;
import com.sun.jbi.alerter.EventFactory;
import com.sun.jbi.alerter.NotificationEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;

public class AlerterImpl
implements Alerter {
    public static final String PROCESSING = "PROCESSING";
    public static final String STOPPED = "STOPPED";
    public static final String RUNNING = "RUNNING";
    public static final String STOPPING = "STOPPING";
    public static final String REMOVED = "REMOVED";
    public static final String SHUTTING_DOWN = "SHUTTINGDOWN";
    public static final String SHUTDOWN = "SHUTDOWN";
    public static final String UNKNOWN = "UNKNOWN";
    public static final String UP = "UP";
    public static final String CONNECTING = "CONNECTING";
    public static final String CONNECTED = "CONNECTED";
    public static final String DOWN = "DOWN";
    private String[] severityStrings = new String[]{"FATAL", "CRITICAL", "MAJOR", "MINOR", "WARNING", "INFO"};
    private MBeanServer mMBeanServer = null;
    private ObjectName mObjectName = null;
    private static Logger mLogger = Logger.getLogger(AlerterImpl.class.getName());
    private EventFactory eventFactory;
    private ResourceBundle mBundle;

    public AlerterImpl() {
        this.loadBundle("com.sun.jbi.alerter");
        try {
            this.mObjectName = new ObjectName("EventManagement:name=EventForwarderMBean");
        }
        catch (MalformedObjectNameException ex) {
            Object[] args = new String[]{this.mObjectName.toString()};
            mLogger.severe(this.getMessage("Object.Name.is.Invalid", args));
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        ArrayList<MBeanServer> mbeanservers = MBeanServerFactory.findMBeanServer(null);
        if (mbeanservers.size() > 0) {
            this.mMBeanServer = (MBeanServer)mbeanservers.get(0);
        }
    }

    public void fatal(String msg, String componentName, String deploymentName, String serverType, String componentType, int componentState, String eventType, String messageCode) {
        this.sendAlert(msg, 0, componentName, deploymentName, serverType, componentType, componentState, eventType, messageCode);
    }

    public void critical(String msg, String componentName, String deploymentName, String serverType, String componentType, int componentState, String eventType, String messageCode) {
        this.sendAlert(msg, 1, componentName, deploymentName, serverType, componentType, componentState, eventType, messageCode);
    }

    public void major(String msg, String componentName, String deploymentName, String serverType, String componentType, int componentState, String eventType, String messageCode) {
        this.sendAlert(msg, 2, componentName, deploymentName, serverType, componentType, componentState, eventType, messageCode);
    }

    public void minor(String msg, String componentName, String deploymentName, String serverType, String componentType, int componentState, String eventType, String messageCode) {
        this.sendAlert(msg, 3, componentName, deploymentName, serverType, componentType, componentState, eventType, messageCode);
    }

    public void warning(String msg, String componentName, String deploymentName, String serverType, String componentType, int componentState, String eventType, String messageCode) {
        this.sendAlert(msg, 4, componentName, deploymentName, serverType, componentType, componentState, eventType, messageCode);
    }

    public void info(String msg, String componentName, String deploymentName, String serverType, String componentType, int componentState, String eventType, String messageCode) {
        this.sendAlert(msg, 5, componentName, deploymentName, serverType, componentType, componentState, eventType, messageCode);
    }

    public void custom(String eventType, int severity, String msg, String componentName, String deploymentName, String serverType, String componentType, int componentState, String messageCode) {
        this.sendCustomAlert(msg, severity, eventType, componentName, deploymentName, serverType, componentType, componentState, messageCode);
    }

    public void sendAlert(String msg, int severity, String componentName, String deploymentName, String serverType, String componentType, int componentState, String eventType, String messageCode) {
        if (this.mMBeanServer == null) {
            return;
        }
        if (!this.mMBeanServer.isRegistered(this.mObjectName)) {
            return;
        }
        try {
            NotificationEvent event = this.createEventObject(msg, severity, componentName, deploymentName, serverType, componentType, componentState, eventType, messageCode);
            EventDataConverter converter = new EventDataConverter();
            CompositeData eventData = converter.getEventCompositeData(event, "");
            String[] paramsSig = new String[]{"javax.management.openmbean.CompositeData"};
            Object[] params = new Object[]{eventData};
            this.mMBeanServer.invoke(this.mObjectName, "forwardEvent", params, paramsSig);
        }
        catch (InstanceNotFoundException e) {
            Object[] args = new String[]{this.mObjectName.toString()};
            mLogger.severe(this.getMessage("Mbean.Instance.not.found", args));
        }
        catch (Exception e) {
            Object[] args = new String[]{e.getMessage()};
            mLogger.severe(this.getMessage("Send.Alert.Failed", args));
        }
    }

    public void sendCustomAlert(String msg, int severity, String eventType, String componentName, String deploymentName, String serverType, String componentType, int componentState, String messageCode) {
        if (this.mMBeanServer == null) {
            return;
        }
        if (!this.mMBeanServer.isRegistered(this.mObjectName)) {
            return;
        }
        try {
            NotificationEvent event = this.createEventObject(msg, severity, componentName, deploymentName, serverType, componentType, componentState, "Alert", messageCode);
            EventDataConverter converter = new EventDataConverter();
            CompositeData eventData = converter.getEventCompositeData(event, "");
            String[] paramsSig = new String[]{"javax.management.openmbean.CompositeData"};
            Object[] params = new Object[]{eventData};
            this.mMBeanServer.invoke(this.mObjectName, "forwardEvent", params, paramsSig);
        }
        catch (InstanceNotFoundException e) {
            Object[] args = new String[]{this.mObjectName.toString()};
            mLogger.severe(this.getMessage("Mbean.Instance.not.found", args));
        }
        catch (Exception e) {
            Object[] args = new String[]{e.getMessage()};
            mLogger.severe(this.getMessage("Send.Custom.Alert.Failed", args));
        }
    }

    private Integer getSeverityValue(String severity) throws Exception {
        int len = this.severityStrings.length;
        for (int lIndex = 0; lIndex < len; ++lIndex) {
            if (!severity.toUpperCase().equals(this.severityStrings[lIndex])) continue;
            return new Integer(lIndex);
        }
        return new Integer(5);
    }

    private String mapState(String state) {
        String mappedState = UNKNOWN;
        if (RUNNING.equalsIgnoreCase(state) || UP.equalsIgnoreCase(state) || CONNECTING.equalsIgnoreCase(state) || PROCESSING.equalsIgnoreCase(state)) {
            mappedState = RUNNING;
        } else if (STOPPED.equalsIgnoreCase(state) || STOPPING.equalsIgnoreCase(state) || DOWN.equalsIgnoreCase(state)) {
            mappedState = STOPPED;
        }
        return mappedState;
    }

    private int mapOpState(String state) {
        int mappedState = 0;
        if (RUNNING.equalsIgnoreCase(state) || UP.equalsIgnoreCase(state) || CONNECTING.equalsIgnoreCase(state) || PROCESSING.equalsIgnoreCase(state)) {
            mappedState = 7;
        } else if (STOPPED.equalsIgnoreCase(state) || STOPPING.equalsIgnoreCase(state) || DOWN.equalsIgnoreCase(state)) {
            mappedState = 6;
        } else if (SHUTTING_DOWN.equalsIgnoreCase(state) || SHUTDOWN.equalsIgnoreCase(state)) {
            mappedState = 9;
        }
        return mappedState;
    }

    private NotificationEvent createEventObject(String msg, int severity, String componentName, String deploymentName, String serverType, String componentType, int status, String eventType, String messageCode) {
        if (this.eventFactory == null) {
            this.eventFactory = new EventFactory();
        }
        String physicalHostName = this.getPhysicalHostName();
        NotificationEvent event = this.eventFactory.getNotificationEvent(physicalHostName, deploymentName, null, physicalHostName, serverType, physicalHostName, componentType, null, componentName, eventType, severity, status, messageCode, new String[]{physicalHostName, null, null, null, null, null}, msg);
        event.setTimeStamp(Calendar.getInstance().getTime().getTime());
        return event;
    }

    private String getPhysicalHostName() {
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        if (hostName == null) {
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e1) {
                e1.printStackTrace();
            }
        }
        if (hostName == null) {
            hostName = "127.0.0.1";
        }
        return hostName;
    }

    private void loadBundle(String packageName) {
        String bundleBaseName = packageName + ".bundle";
        ResourceBundle resBundle = null;
        try {
            resBundle = ResourceBundle.getBundle(bundleBaseName);
        }
        catch (MissingResourceException ex) {
            try {
                resBundle = ResourceBundle.getBundle(bundleBaseName, new Locale(""));
            }
            catch (Exception anyEx) {
                mLogger.finer(anyEx.getMessage());
            }
        }
        if (resBundle != null) {
            this.mBundle = resBundle;
        }
    }

    private String getMessage(String aI18NKey, Object[] aArgs) {
        String i18nMessage = "";
        if (this.mBundle != null) {
            String msgCode = this.mBundle.getString(aI18NKey + ".ID");
            i18nMessage = this.mBundle.getString(aI18NKey);
            i18nMessage = msgCode + " : " + i18nMessage;
        }
        if (aArgs != null && i18nMessage != null && i18nMessage.length() > 0) {
            try {
                MessageFormat mf = new MessageFormat(i18nMessage);
                String formattedI18NMsg = mf.format(aArgs);
                return formattedI18NMsg;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return i18nMessage;
    }
}

