/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hulp.measure;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.sf.hulp.measure.Measurement;

public class ItfMeasurement
implements InvocationHandler {
    private Object m_target;
    private String m_name;

    private ItfMeasurement(Object target) {
        this.m_target = target;
        this.m_name = target.getClass().getName();
    }

    public static Object getItfMeasurement(Object implementation, Class interface_) {
        if (!Measurement.isInstalled()) {
            return implementation;
        }
        return Proxy.newProxyInstance(implementation.getClass().getClassLoader(), new Class[]{interface_}, (InvocationHandler)new ItfMeasurement(implementation));
    }

    public Object invoke(Object proxy, Method method_, Object[] args) throws Throwable {
        Object ret = null;
        Measurement measurement = Measurement.begin(this.m_name, method_.getName());
        try {
            ret = method_.invoke(this.m_target, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        finally {
            measurement.end();
        }
        return ret;
    }
}

