/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.bridge;

import com.sun.enterprise.jbi.serviceengine.ServiceEngineException;
import com.sun.enterprise.jbi.serviceengine.bridge.transport.JBIAdapter;
import com.sun.enterprise.jbi.serviceengine.core.EndpointRegistry;
import com.sun.enterprise.jbi.serviceengine.core.ServiceEngineEndpoint;
import com.sun.enterprise.webservice.EjbRuntimeEndpointInfo;
import com.sun.enterprise.webservice.JAXWSAdapterRegistry;
import com.sun.enterprise.webservice.WebServiceEjbEndpointRegistry;
import com.sun.logging.LogDomains;
import com.sun.xml.ws.api.server.Adapter;
import com.sun.xml.ws.api.server.DocumentAddressResolver;
import com.sun.xml.ws.api.server.SDDocument;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.MessageExchange;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class JBIAdapterBuilder {
    private EndpointRegistry endpointRegistry = EndpointRegistry.getInstance();
    private final Logger logger = LogDomains.getLogger((String)"javax.enterprise.system");

    JBIAdapterBuilder() {
    }

    public JBIAdapter createAdapter(QName service, String endpointName, MessageExchange me) throws ServiceEngineException {
        ServiceEngineEndpoint endpt = this.endpointRegistry.get(service, endpointName);
        if (endpt != null) {
            return this.createWSAdapter(endpt, me);
        }
        throw new ServiceEngineException("Endpoint " + endpointName + "not deployed in JBI");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JBIAdapter createWSAdapter(ServiceEngineEndpoint endpt, MessageExchange me) {
        try {
            EjbRuntimeEndpointInfo ejbEndPtInfo = null;
            if (endpt.isImplementedByEJB()) {
                ejbEndPtInfo = WebServiceEjbEndpointRegistry.getRegistry().getEjbWebServiceEndpoint(endpt.getURI(), "POST", null);
                Adapter adapter = (Adapter)ejbEndPtInfo.prepareInvocation(true);
                endpt.setWsep(adapter.getEndpoint());
            } else {
                String url = endpt.getURI();
                String contextRoot = endpt.getContextRoot();
                Adapter adapter = JAXWSAdapterRegistry.getInstance().getAdapter(contextRoot, url, url);
                if (adapter != null) {
                    endpt.setWsep(adapter.getEndpoint());
                }
            }
            this.logger.log(Level.FINE, "Successfully created JBIAdapter for endpoint:" + endpt.getWsep());
            if (endpt.getWsdlDocument() == null) {
                SDDocument sdDocument;
                SDDocument sDDocument = sdDocument = endpt.getWsep().getServiceDefinition().getPrimary();
                synchronized (sDDocument) {
                    if (endpt.getWsdlDocument() == null) {
                        Document doc = this.getWSDLDocument(sdDocument);
                        endpt.setWsdlDocument(doc);
                    }
                }
            }
            return new JBIAdapter(endpt.getWsep(), endpt, me, endpt.getClassLoader(), ejbEndPtInfo);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Exception in creating JBIAdapter:" + e.getMessage(), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document getWSDLDocument(SDDocument document) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        document.writeTo(null, this.getResolver(), (OutputStream)baos);
        baos.flush();
        ByteArrayInputStream in = new ByteArrayInputStream(baos.toByteArray());
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder db = factory.newDocumentBuilder();
            Document document2 = db.parse(in, document.getURL().toString());
            return document2;
        }
        finally {
            ((InputStream)in).close();
            baos.close();
        }
    }

    private DocumentAddressResolver getResolver() {
        return new DocumentAddressResolver(){

            public String getRelativeAddressFor(SDDocument current, SDDocument referenced) {
                JBIAdapterBuilder.this.logger.log(Level.FINE, "Current SDDocument URL = " + current.getURL() + ", isWSDL = " + current.isWSDL());
                JBIAdapterBuilder.this.logger.log(Level.FINE, "Referenced SDDocument URL = " + referenced.getURL() + ", isWSDL = " + referenced.isWSDL());
                if (referenced.isWSDL()) {
                    JBIAdapterBuilder.this.logger.log(Level.FINE, "Relative address for referenced SDDocument = " + referenced.getURL().toString());
                    return referenced.getURL().toString();
                }
                return "";
            }
        };
    }
}

