/*
 * Decompiled with CFR 0.152.
 */
package net.java.hulp.measure;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.management.openmbean.TabularData;
import net.java.hulp.measure.Probe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group {
    private List<String[]> mCriteria = new ArrayList<String[]>();

    private Group() {
    }

    public static Group createGroup() {
        return new Group();
    }

    public void addPattern(String name, String subtopic) {
        this.mCriteria.add(new String[]{null, name, subtopic});
    }

    public void addPattern(String source, String name, String subtopic) {
        this.mCriteria.add(new String[]{source, name, subtopic});
    }

    private List<Pattern[]> getCriteria() {
        ArrayList<Pattern[]> ret = new ArrayList<Pattern[]>();
        for (String[] m : this.mCriteria) {
            if (m.length != 3) {
                throw new RuntimeException("Invalid criteria");
            }
            ret.add(new Pattern[]{Pattern.compile(m[0] == null ? ".*" : m[0]), Pattern.compile(m[1] == null ? ".*" : m[1]), Pattern.compile(m[2] == null ? ".*" : m[2])});
        }
        return ret;
    }

    public TabularData fetchData() {
        return Probe.getData(this.getCriteria());
    }

    public void clearData() {
        Probe.clearData(this.getCriteria());
    }
}

