/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.configuration;

import com.sun.jbi.component.jbiext.KeyStoreUtilClient;
import com.sun.jbi.configuration.ConfigPersistence;
import com.sun.jbi.httpsoapbc.configuration.RuntimeConfigurationMBean;
import com.sun.jbi.httpsoapbc.util.HttpUrlResolverUtil;
import com.sun.jbi.internationalization.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.management.AttributeChangeNotification;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public class RuntimeConfiguration
implements RuntimeConfigurationMBean,
NotificationEmitter {
    private static final Messages mMessages = Messages.getMessages(RuntimeConfiguration.class);
    private static final Logger mLogger = Messages.getLogger(RuntimeConfiguration.class);
    private static final String DEFAULT_OUTBOUND_THREADS = "100";
    private static long MIN_OUTBOUND_THREADS = 5L;
    private static long MAX_OUTBOUND_THREADS = Integer.MAX_VALUE;
    private static int MIN_PORT_NUMBER = 0;
    private static int MAX_PORT_NUMBER = 65535;
    private static final String PERSIST_APPLICATION_VARIABLE_CONFIG_FILE_NAME = "ApplicationVariables.properties";
    private static final String PERSIST_APPLICATION_CONFIG_FILE_NAME = "ApplicationConfigurations.properties";
    private static final String APPLICATION_VARIABLES_ROW_KEY = "name";
    private static final String APPLICATION_VARIABLES_VALUE_FIELD = "value";
    private static final String APPLICATION_VARIABLES_TYPE_FIELD = "type";
    private static final String APPLICATION_CONFIG_ROW_KEY = "configurationName";
    private static final String APPLICATION_CONFIG_PROPERTY_URL = "httpUrlLocation";
    private Properties mConfig;
    private String mWorkspaceRoot;
    private Map mAppVarMap;
    private Map mAppConfigMap;
    private CompositeType mAppVarRowType = null;
    private CompositeType mAppConfigRowType = null;
    private TabularType mAppVarTabularType = null;
    private TabularType mAppConfigTabularType = null;
    private NotificationBroadcasterSupport broadcasterSupport = new NotificationBroadcasterSupport();
    private KeyStoreUtilClient mKeyStoreUtilClient;

    public RuntimeConfiguration(String workspaceRoot, KeyStoreUtilClient keystoreUtilClient) throws MBeanException {
        this.mWorkspaceRoot = workspaceRoot;
        this.mKeyStoreUtilClient = keystoreUtilClient;
        try {
            this.mConfig = ConfigPersistence.loadConfig((String)workspaceRoot);
            this.mAppVarMap = this.loadApplicationVariablesConfig(workspaceRoot);
            this.mAppConfigMap = this.loadApplicationConfiguration(workspaceRoot);
            this.mAppConfigRowType = this.createApplicationConfigurationCompositeType();
            this.mAppConfigTabularType = this.createApplicationConfigurationTabularType();
            this.mAppVarRowType = this.createApplicationVariableCompositeType();
            this.mAppVarTabularType = this.createApplicationVariableTabularType();
        }
        catch (Exception e) {
            throw new MBeanException(e, mMessages.getString("HTTPBC-E01210.Faile_to_construct_composite_data_structures", (Object)e.getLocalizedMessage()));
        }
    }

    public Integer getOutboundThreads() {
        String val = this.mConfig.getProperty("OutboundThreads", DEFAULT_OUTBOUND_THREADS);
        return Integer.valueOf(val);
    }

    public void setOutboundThreads(Integer val) throws InvalidAttributeValueException, MBeanException {
        if (val == null) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E01202.Invalid_argument_for_setting_attribute", new Object[]{"OutboundThreads", "null"}));
        }
        if ((long)val.intValue() < MIN_OUTBOUND_THREADS || (long)val.intValue() > MAX_OUTBOUND_THREADS) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E01201.Invalid_value_for_attribute", new Object[]{val, "OutboundThreads", new Long(MIN_OUTBOUND_THREADS), new Long(MAX_OUTBOUND_THREADS)}));
        }
        Integer oldVal = this.getOutboundThreads();
        this.mConfig.put("OutboundThreads", val.toString());
        this.persistConfiguration();
        if (mLogger.isLoggable(Level.CONFIG)) {
            mLogger.log(Level.CONFIG, "HTTPBC-C01201.Attr_changed_detail", new Object[]{"OutboundThreads", oldVal != null ? oldVal.toString() : "null", val.toString()});
        }
        long seqNo = 0L;
        String msg = "Attribute changed";
        String attrType = Integer.class.getName();
        AttributeChangeNotification notif = new AttributeChangeNotification(this, seqNo, System.currentTimeMillis(), msg, "OutboundThreads", attrType, oldVal, val);
        this.broadcasterSupport.sendNotification(notif);
    }

    public Integer getHttpDefaultPort() {
        String val = this.mConfig.getProperty("HttpDefaultPort", "-1");
        if (val == null || "".equals(val)) {
            return null;
        }
        return Integer.valueOf(val);
    }

    public void setHttpDefaultPort(Integer val) throws InvalidAttributeValueException, MBeanException {
        if (val == null) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E01202.Invalid_argument_for_setting_attribute", new Object[]{"HttpDefaultPort", "null"}));
        }
        if (val < MIN_PORT_NUMBER || val > MAX_PORT_NUMBER) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E01201.Invalid_value_for_attribute", new Object[]{val, "HttpDefaultPort", new Integer(MIN_PORT_NUMBER), new Integer(MAX_PORT_NUMBER)}));
        }
        Integer httpsPortVal = this.getHttpsDefaultPort();
        if (httpsPortVal != null && val.equals(httpsPortVal)) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E01227.Invalid_http_port_same_as_https_port", (Object)val));
        }
        Integer oldVal = this.getHttpDefaultPort();
        this.mConfig.put("HttpDefaultPort", val.toString());
        this.persistConfiguration();
        if (mLogger.isLoggable(Level.CONFIG)) {
            mLogger.log(Level.CONFIG, "HTTPBC-C01201.Attr_changed_detail", new Object[]{"HttpDefaultPort", oldVal != null ? oldVal.toString() : "null", val.toString()});
        }
        long seqNo = 0L;
        String msg = "Attribute changed";
        String attrType = Integer.class.getName();
        AttributeChangeNotification notif = new AttributeChangeNotification(this, seqNo, System.currentTimeMillis(), msg, "HttpDefaultPort", attrType, oldVal, val);
        this.broadcasterSupport.sendNotification(notif);
    }

    public Integer getHttpsDefaultPort() {
        String val = this.mConfig.getProperty("HttpsDefaultPort", "-1");
        if (val == null || "".equals(val)) {
            return null;
        }
        return Integer.valueOf(val);
    }

    public void setHttpsDefaultPort(Integer val) throws InvalidAttributeValueException, MBeanException {
        if (val == null) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E01202.Invalid_argument_for_setting_attribute", new Object[]{"HttpsDefaultPort", "null"}));
        }
        if (val < MIN_PORT_NUMBER || val > MAX_PORT_NUMBER) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E01201.Invalid_value_for_attribute", new Object[]{val, "HttpsDefaultPort", new Integer(MIN_PORT_NUMBER), new Integer(MAX_PORT_NUMBER)}));
        }
        Integer httpPortVal = this.getHttpDefaultPort();
        if (httpPortVal != null && val.equals(httpPortVal)) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E01228.Invalid_https_port_same_as_http_port", (Object)val));
        }
        Integer oldVal = this.getHttpsDefaultPort();
        this.mConfig.put("HttpsDefaultPort", val.toString());
        this.persistConfiguration();
        if (mLogger.isLoggable(Level.CONFIG)) {
            mLogger.log(Level.CONFIG, "HTTPBC-C01201.Attr_changed_detail", new Object[]{"HttpsDefaultPort", oldVal != null ? oldVal.toString() : "null", val.toString()});
        }
        long seqNo = 0L;
        String msg = "Attribute changed";
        String attrType = Integer.class.getName();
        AttributeChangeNotification notif = new AttributeChangeNotification(this, seqNo, System.currentTimeMillis(), msg, "HttpsDefaultPort", attrType, oldVal, val);
        this.broadcasterSupport.sendNotification(notif);
    }

    public Boolean getUseJVMProxySettings() {
        String val = this.mConfig.getProperty("UseJVMProxySettings");
        if (val == null || "".equals(val) || "false".equalsIgnoreCase(val)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void setUseJVMProxySettings(Boolean val) throws InvalidAttributeValueException, MBeanException {
        if (val == null) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E01202.Invalid_argument_for_setting_attribute", new Object[]{"UseJVMProxySettings", "null"}));
        }
        Boolean oldVal = this.getUseJVMProxySettings();
        this.mConfig.put("UseJVMProxySettings", val.toString());
        this.persistConfiguration();
        if (mLogger.isLoggable(Level.CONFIG)) {
            mLogger.log(Level.CONFIG, "HTTPBC-C01201.Attr_changed_detail", new Object[]{"UseJVMProxySettings", oldVal != null ? oldVal.toString() : "false", val.toString()});
        }
        long seqNo = 0L;
        String msg = "Attribute changed";
        String attrType = Boolean.class.getName();
        AttributeChangeNotification notif = new AttributeChangeNotification(this, seqNo, System.currentTimeMillis(), msg, "UseJVMProxySettings", attrType, oldVal, val);
        this.broadcasterSupport.sendNotification(notif);
    }

    public String getProxyType() {
        return this.mConfig.getProperty("ProxyType");
    }

    public void setProxyType(String val) throws MBeanException {
        String oldVal = this.getProxyType();
        this.mConfig.put("ProxyType", val);
        this.persistConfiguration();
        if (mLogger.isLoggable(Level.CONFIG)) {
            mLogger.log(Level.CONFIG, "HTTPBC-C01201.Attr_changed_detail", new Object[]{"ProxyType", oldVal, val});
        }
        long seqNo = 0L;
        String msg = "Attribute changed";
        String attrType = String.class.getName();
        AttributeChangeNotification notif = new AttributeChangeNotification(this, seqNo, System.currentTimeMillis(), msg, "ProxyType", attrType, oldVal, val);
        this.broadcasterSupport.sendNotification(notif);
    }

    public String getProxyHost() {
        return this.mConfig.getProperty("ProxyHost");
    }

    public void setProxyHost(String val) throws MBeanException {
        String oldVal = this.getProxyHost();
        this.mConfig.put("ProxyHost", val);
        this.persistConfiguration();
        if (mLogger.isLoggable(Level.CONFIG)) {
            mLogger.log(Level.CONFIG, "HTTPBC-C01201.Attr_changed_detail", new Object[]{"ProxyHost", oldVal, val});
        }
        long seqNo = 0L;
        String msg = "Attribute changed";
        String attrType = String.class.getName();
        AttributeChangeNotification notif = new AttributeChangeNotification(this, seqNo, System.currentTimeMillis(), msg, "ProxyHost", attrType, oldVal, val);
        this.broadcasterSupport.sendNotification(notif);
    }

    public Integer getProxyPort() {
        String val = this.mConfig.getProperty("ProxyPort");
        if (val == null || "".equals(val)) {
            return null;
        }
        return Integer.valueOf(val);
    }

    public void setProxyPort(Integer val) throws InvalidAttributeValueException, MBeanException {
        if (val == null) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E01202.Invalid_argument_for_setting_attribute", new Object[]{"ProxyPort", "null"}));
        }
        if (val < MIN_PORT_NUMBER || val > MAX_PORT_NUMBER) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E01201.Invalid_value_for_attribute", new Object[]{val, "ProxyPort", new Integer(MIN_PORT_NUMBER), new Integer(MAX_PORT_NUMBER)}));
        }
        Integer oldVal = this.getProxyPort();
        this.mConfig.put("ProxyPort", val.toString());
        this.persistConfiguration();
        if (mLogger.isLoggable(Level.CONFIG)) {
            mLogger.log(Level.CONFIG, "HTTPBC-C01201.Attr_changed_detail", new Object[]{"ProxyPort", oldVal != null ? oldVal.toString() : "null", val.toString()});
        }
        long seqNo = 0L;
        String msg = "Attribute changed";
        String attrType = Integer.class.getName();
        AttributeChangeNotification notif = new AttributeChangeNotification(this, seqNo, System.currentTimeMillis(), msg, "ProxyPort", attrType, oldVal, val);
        this.broadcasterSupport.sendNotification(notif);
    }

    public String getNonProxyHosts() {
        return this.mConfig.getProperty("NonProxyHosts");
    }

    public void setNonProxyHosts(String val) throws MBeanException {
        String oldVal = this.getNonProxyHosts();
        this.mConfig.put("NonProxyHosts", val);
        this.persistConfiguration();
        if (mLogger.isLoggable(Level.CONFIG)) {
            mLogger.log(Level.CONFIG, "HTTPBC-C01201.Attr_changed_detail", new Object[]{"NonProxyHosts", oldVal, val});
        }
        long seqNo = 0L;
        String msg = "Attribute changed";
        String attrType = String.class.getName();
        AttributeChangeNotification notif = new AttributeChangeNotification(this, seqNo, System.currentTimeMillis(), msg, "NonProxyHosts", attrType, oldVal, val);
        this.broadcasterSupport.sendNotification(notif);
    }

    public String getProxyUserName() {
        return this.mConfig.getProperty("ProxyUserName");
    }

    public void setProxyUserName(String val) throws MBeanException {
        String oldVal = this.getProxyUserName();
        this.mConfig.put("ProxyUserName", val);
        this.persistConfiguration();
        if (mLogger.isLoggable(Level.CONFIG)) {
            mLogger.log(Level.CONFIG, "HTTPBC-C01201.Attr_changed_detail", new Object[]{"ProxyUserName", oldVal, val});
        }
        long seqNo = 0L;
        String msg = "Attribute changed";
        String attrType = String.class.getName();
        AttributeChangeNotification notif = new AttributeChangeNotification(this, seqNo, System.currentTimeMillis(), msg, "ProxyUserName", attrType, oldVal, val);
        this.broadcasterSupport.sendNotification(notif);
    }

    public String getProxyPassword() {
        String val = (String)this.mConfig.get("ProxyPassword");
        if (val != null && !"".equals(val)) {
            return "*******";
        }
        return val;
    }

    public String retrieveProxyPassword(Object obj) throws MBeanException {
        if (obj == null || obj != this) {
            return "*******";
        }
        String encryptedProxyPassword = this.mConfig.getProperty("ProxyPassword");
        try {
            if (encryptedProxyPassword != null && !"".equals(encryptedProxyPassword)) {
                return this.mKeyStoreUtilClient.decrypt(encryptedProxyPassword);
            }
        }
        catch (Exception ex) {
            throw new MBeanException(ex);
        }
        return encryptedProxyPassword;
    }

    public void setProxyPassword(String val) throws MBeanException {
        String newVal = val;
        String oldVal = this.retrieveProxyPassword(this);
        try {
            if (val != null) {
                String base64Encoded = this.mKeyStoreUtilClient.encrypt(val);
                this.mConfig.put("ProxyPassword", base64Encoded);
            }
        }
        catch (Exception ex) {
            throw new MBeanException(ex);
        }
        this.persistConfiguration();
        if (mLogger.isLoggable(Level.CONFIG)) {
            mLogger.log(Level.CONFIG, "HTTPBC-C01201.Attr_changed_detail", new Object[]{"ProxyPassword", "********", "********"});
        }
        long seqNo = 0L;
        String msg = "Attribute changed";
        String attrType = String.class.getName();
        AttributeChangeNotification notif = new AttributeChangeNotification(this, seqNo, System.currentTimeMillis(), msg, "ProxyPassword", attrType, "*******", "*******");
        this.broadcasterSupport.sendNotification(notif);
    }

    public String getAMConfigDirectory() {
        return this.mConfig.getProperty("AMConfigDirectory", "");
    }

    public void setAMConfigDirectory(String val) throws InvalidAttributeValueException, MBeanException {
        if (val == null) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E01202.Invalid_argument_for_setting_attribute", new Object[]{"AMConfigDirectory", "null"}));
        }
        if (!new File(val).exists()) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E01226.Invalid_value_generic", new Object[]{val, "AMConfigDirectory"}));
        }
        String oldVal = this.getAMConfigDirectory();
        this.mConfig.put("AMConfigDirectory", val);
        this.persistConfiguration();
        if (mLogger.isLoggable(Level.CONFIG)) {
            mLogger.log(Level.CONFIG, "HTTPBC-C01201.Attr_changed_detail", new Object[]{"AMConfigDirectory", oldVal != null ? oldVal.toString() : "null", val.toString()});
        }
        long seqNo = 0L;
        String msg = "Attribute changed";
        String attrType = Integer.class.getName();
        AttributeChangeNotification notif = new AttributeChangeNotification(this, seqNo, System.currentTimeMillis(), msg, "AMConfigDirectory", attrType, oldVal, val);
        this.broadcasterSupport.sendNotification(notif);
    }

    public CompositeType queryApplicationConfigurationType() {
        return this.mAppConfigRowType;
    }

    public void addApplicationConfiguration(String name, CompositeData appConfig) throws InvalidAttributeValueException, MBeanException {
        if (this.mAppConfigMap.containsKey(name)) {
            throw new MBeanException(new Exception(mMessages.getString("HTTPBC-E01211.Application_config_name_already_exists", (Object)name)));
        }
        CompositeType rowType = appConfig.getCompositeType();
        if (rowType.keySet().size() != 2) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E01212.Invalid_Item_Size_for_app_config", new Object[]{name, rowType.keySet().size()}));
        }
        if (!appConfig.containsKey(APPLICATION_CONFIG_ROW_KEY)) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E01213.Invalid_key_for_composite_data_for_app_config", (Object)name));
        }
        String appConfigValue = (String)appConfig.get(APPLICATION_CONFIG_PROPERTY_URL);
        if (appConfigValue == null) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E01214.Invalid_app_config_composite_data_null_url", (Object)name));
        }
        this.validateHttpUrl(appConfigValue);
        this.mAppConfigMap.put(name, appConfigValue);
        if (mLogger.isLoggable(Level.CONFIG)) {
            mLogger.log(Level.CONFIG, mMessages.getString("HTTPBC-C01205.New_application_configuration_added", new Object[]{name, appConfigValue}));
        }
        this.persistApplicationConfigurationObjects();
    }

    public void deleteApplicationConfiguration(String name) throws MBeanException {
        if (!this.mAppConfigMap.containsKey(name)) {
            throw new MBeanException(new Exception(mMessages.getString("HTTPBC-E01215.Application_configuration_does_not_exist_for_delete", (Object)name)));
        }
        this.mAppConfigMap.remove(name);
        if (mLogger.isLoggable(Level.CONFIG)) {
            mLogger.log(Level.CONFIG, mMessages.getString("HTTPBC-C01206.Application_configuration_deleted", (Object)name));
        }
        this.persistApplicationConfigurationObjects();
    }

    public void setApplicationConfiguration(String name, CompositeData appConfig) throws InvalidAttributeValueException, MBeanException {
        if (!this.mAppConfigMap.containsKey(name)) {
            throw new MBeanException(new Exception(mMessages.getString("HTTPBC-E01216.Application_configuration_does_not_exist_for_set", (Object)name)));
        }
        CompositeType rowType = appConfig.getCompositeType();
        if (rowType.keySet().size() != 2) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E01212.Invalid_Item_Size_for_app_config", new Object[]{name, rowType.keySet().size()}));
        }
        if (!appConfig.containsKey(APPLICATION_CONFIG_ROW_KEY)) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E01213.Invalid_key_for_composite_data_for_app_config", (Object)name));
        }
        String appConfigValue = (String)appConfig.get(APPLICATION_CONFIG_PROPERTY_URL);
        if (appConfigValue == null) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E01214.Invalid_app_config_composite_data_null_url", (Object)name));
        }
        this.validateHttpUrl(appConfigValue);
        this.mAppConfigMap.put(name, appConfigValue);
        if (mLogger.isLoggable(Level.CONFIG)) {
            mLogger.log(Level.CONFIG, mMessages.getString("HTTPBC-C01207.Application_configuration_updated", new Object[]{name, appConfigValue}));
        }
        this.persistApplicationConfigurationObjects();
    }

    public TabularData getApplicationConfigurations() {
        TabularDataSupport tabularData = new TabularDataSupport(this.mAppConfigTabularType);
        for (String name : this.mAppConfigMap.keySet()) {
            String value = (String)this.mAppConfigMap.get(name);
            Object[] data = new Object[]{name, value};
            try {
                CompositeDataSupport rowData = new CompositeDataSupport(this.mAppConfigRowType, new String[]{APPLICATION_CONFIG_ROW_KEY, APPLICATION_CONFIG_PROPERTY_URL}, data);
                tabularData.put(rowData);
            }
            catch (OpenDataException e) {
                throw new RuntimeException(mMessages.getString("HTTPBC-E01217.Unable_to_construct_composite_data_for_app_config"), e);
            }
        }
        return tabularData;
    }

    public void addApplicationVariable(String name, CompositeData appVar) throws InvalidAttributeValueException, MBeanException {
        if (this.mAppVarMap.containsKey(name)) {
            throw new MBeanException(new Exception(mMessages.getString("HTTPBC-E01218.Application_variable_name_already_exists", (Object)name)));
        }
        CompositeType rowType = appVar.getCompositeType();
        if (rowType.keySet().size() != 3) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E01219.Invalid_Item_Size_for_app_variable", (Object)rowType.keySet().size()));
        }
        if (!appVar.containsKey(APPLICATION_VARIABLES_ROW_KEY)) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E01220.Invalid_key_for_composite_data_for_app_variable", (Object)name));
        }
        String appVarValue = (String)appVar.get(APPLICATION_VARIABLES_VALUE_FIELD);
        String appVarType = (String)appVar.get(APPLICATION_VARIABLES_TYPE_FIELD);
        if (appVarValue == null) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E01221.Invalid_app_variable_composite_data_no_value_field", (Object)name));
        }
        if (appVarType == null) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E01222.Invalid_app_variable_composite_data_no_type_field", (Object)name));
        }
        this.mAppVarMap.put(name, new String[]{appVarValue, appVarType});
        if (mLogger.isLoggable(Level.CONFIG)) {
            mLogger.log(Level.CONFIG, mMessages.getString("HTTPBC-C01203.New_application_variable_added", new Object[]{name, appVarValue}));
        }
        this.persistApplicationVariablesConfig();
    }

    public void deleteApplicationVariable(String name) throws MBeanException {
        if (!this.mAppVarMap.containsKey(name)) {
            throw new MBeanException(new Exception(mMessages.getString("HTTPBC-E01223.Application_variable_does_not_exist_for_delete", (Object)name)));
        }
        this.mAppVarMap.remove(name);
        if (mLogger.isLoggable(Level.CONFIG)) {
            mLogger.log(Level.CONFIG, mMessages.getString("HTTPBC-C01204.Application_variable_deleted", (Object)name));
        }
        this.persistApplicationVariablesConfig();
    }

    public void setApplicationVariable(String name, CompositeData appVar) throws InvalidAttributeValueException, MBeanException {
        if (!this.mAppVarMap.containsKey(name)) {
            throw new MBeanException(new Exception(mMessages.getString("HTTPBC-E01224.Application_variable_does_not_exist_for_set", (Object)name)));
        }
        CompositeType rowType = appVar.getCompositeType();
        if (rowType.keySet().size() != 3) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E01219.Invalid_Item_Size_for_app_variable", (Object)rowType.keySet().size()));
        }
        if (!appVar.containsKey(APPLICATION_VARIABLES_ROW_KEY)) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E01220.Invalid_key_for_composite_data_for_app_variable", (Object)name));
        }
        String appVarValue = (String)appVar.get(APPLICATION_VARIABLES_VALUE_FIELD);
        String appVarType = (String)appVar.get(APPLICATION_VARIABLES_TYPE_FIELD);
        if (appVarValue == null) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E01221.Invalid_app_variable_composite_data_no_value_field", (Object)name));
        }
        if (appVarType == null) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E01222.Invalid_app_variable_composite_data_no_type_field", (Object)name));
        }
        this.mAppVarMap.put(name, new String[]{appVarValue, appVarType});
        if (mLogger.isLoggable(Level.CONFIG)) {
            mLogger.log(Level.CONFIG, mMessages.getString("HTTPBC-C01202.Application_variable_updated", new Object[]{name, appVarValue}));
        }
        this.persistApplicationVariablesConfig();
    }

    public TabularData getApplicationVariables() {
        TabularDataSupport tabularData = new TabularDataSupport(this.mAppVarTabularType);
        for (String name : this.mAppVarMap.keySet()) {
            Object[] objectArray;
            String[] metadata = (String[])this.mAppVarMap.get(name);
            String value = metadata[0];
            String type = metadata[1];
            if ("PASSWORD".equals(type)) {
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = name;
                objectArray2[1] = "*******";
                objectArray = objectArray2;
                objectArray2[2] = type;
            } else {
                Object[] objectArray3 = new Object[3];
                objectArray3[0] = name;
                objectArray3[1] = value;
                objectArray = objectArray3;
                objectArray3[2] = type;
            }
            Object[] data = objectArray;
            try {
                CompositeDataSupport rowData = new CompositeDataSupport(this.mAppVarRowType, new String[]{APPLICATION_VARIABLES_ROW_KEY, APPLICATION_VARIABLES_VALUE_FIELD, APPLICATION_VARIABLES_TYPE_FIELD}, data);
                tabularData.put(rowData);
            }
            catch (OpenDataException e) {
                throw new RuntimeException(mMessages.getString("HTTPBC-E01225.Unable_to_construct_composite_data_for_app_variable"), e);
            }
        }
        return tabularData;
    }

    public Map retrieveApplicationVariablesMap() {
        return this.mAppVarMap;
    }

    public void updateApplicationVariablesMap(Map appVarMap) throws MBeanException {
        this.mAppVarMap = appVarMap;
        this.persistApplicationVariablesConfig();
    }

    public Map retrieveApplicationConfigurationsMap() {
        return this.mAppConfigMap;
    }

    public void updateApplicationConfigurationsMap(Map appConfigMap) throws MBeanException {
        this.mAppConfigMap = appConfigMap;
        this.persistApplicationConfigurationObjects();
    }

    private CompositeType createApplicationVariableCompositeType() throws OpenDataException {
        if (this.mAppVarRowType != null) {
            return this.mAppVarRowType;
        }
        String[] appVarRowAttrNames = new String[]{APPLICATION_VARIABLES_ROW_KEY, APPLICATION_VARIABLES_VALUE_FIELD, APPLICATION_VARIABLES_TYPE_FIELD};
        String[] appVarRowAttrDesc = new String[]{"Application Variable Name", "Application Variable Value", "Application Variable Type"};
        OpenType[] appVarRowAttrTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING};
        this.mAppVarRowType = new CompositeType("ApplicationVariables", "Application Variable Composite Data", appVarRowAttrNames, appVarRowAttrDesc, appVarRowAttrTypes);
        return this.mAppVarRowType;
    }

    private TabularType createApplicationVariableTabularType() throws OpenDataException {
        if (this.mAppVarTabularType != null) {
            return this.mAppVarTabularType;
        }
        if (this.mAppVarRowType == null) {
            this.mAppVarRowType = this.createApplicationVariableCompositeType();
        }
        this.mAppVarTabularType = new TabularType("ApplicationVariableList", "List of Application Variables", this.mAppVarRowType, new String[]{APPLICATION_VARIABLES_ROW_KEY});
        return this.mAppVarTabularType;
    }

    private CompositeType createApplicationConfigurationCompositeType() throws OpenDataException {
        if (this.mAppConfigRowType != null) {
            return this.mAppConfigRowType;
        }
        String[] appConfigRowAttrNames = new String[]{APPLICATION_CONFIG_ROW_KEY, APPLICATION_CONFIG_PROPERTY_URL};
        String[] appConfigAttrDesc = new String[]{"Application Configuration Name", "HTTP URL Location"};
        OpenType[] appConfigAttrTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING};
        this.mAppConfigRowType = new CompositeType("AppliationConfigurationObject", "Application Configuration Composite Data", appConfigRowAttrNames, appConfigAttrDesc, appConfigAttrTypes);
        return this.mAppConfigRowType;
    }

    private TabularType createApplicationConfigurationTabularType() throws OpenDataException {
        if (this.mAppConfigTabularType != null) {
            return this.mAppConfigTabularType;
        }
        if (this.mAppConfigRowType == null) {
            this.mAppConfigRowType = this.createApplicationConfigurationCompositeType();
        }
        this.mAppConfigTabularType = new TabularType("ApplicationConfigurationObjectList", "List of Application Configuration Objects", this.mAppConfigRowType, new String[]{APPLICATION_CONFIG_ROW_KEY});
        return this.mAppConfigTabularType;
    }

    private void persistApplicationVariablesConfig() throws MBeanException {
        try {
            File appVarPersistFileName = new File(this.mWorkspaceRoot, PERSIST_APPLICATION_VARIABLE_CONFIG_FILE_NAME);
            FileOutputStream os = new FileOutputStream(appVarPersistFileName);
            for (String key : this.mAppVarMap.keySet()) {
                String[] metadata = (String[])this.mAppVarMap.get(key);
                String value = metadata[0];
                String type = metadata[1];
                if (type.equals("PASSWORD")) {
                    value = this.mKeyStoreUtilClient.encrypt(value);
                }
                String prop = value != null ? key + "=" + value + "{" + type + "}\n" : key + "={" + type + "}\n";
                ((OutputStream)os).write(prop.getBytes());
            }
            ((OutputStream)os).close();
        }
        catch (Exception ex) {
            throw new MBeanException(ex, mMessages.getString("HTTPBC-E01207.Failed_to_persist_application_variables", (Object)PERSIST_APPLICATION_VARIABLE_CONFIG_FILE_NAME));
        }
    }

    private Map loadApplicationVariablesConfig(String workspaceRoot) throws MBeanException {
        Properties persistedConfig = new Properties();
        HashMap<String, String[]> appVarMap = new HashMap<String, String[]>();
        File appVarPersistFileName = new File(workspaceRoot, PERSIST_APPLICATION_VARIABLE_CONFIG_FILE_NAME);
        if (!appVarPersistFileName.exists()) {
            return appVarMap;
        }
        try {
            FileInputStream is = new FileInputStream(appVarPersistFileName);
            persistedConfig.load(is);
            ((InputStream)is).close();
            Enumeration<?> e = persistedConfig.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String metadata = persistedConfig.getProperty(name);
                int startIndex = metadata.indexOf("{");
                String value = startIndex == 0 ? null : metadata.substring(0, startIndex);
                String type = metadata.substring(startIndex + 1, metadata.length() - 1);
                if (type.equals("PASSWORD")) {
                    value = this.mKeyStoreUtilClient.decrypt(value);
                }
                appVarMap.put(name, new String[]{value, type});
            }
        }
        catch (Exception ex) {
            throw new MBeanException(ex, mMessages.getString("HTTPBC-E01208.Failed_to_load_application_variables", (Object)PERSIST_APPLICATION_VARIABLE_CONFIG_FILE_NAME));
        }
        return appVarMap;
    }

    private void persistApplicationConfigurationObjects() throws MBeanException {
        try {
            File appConfigPersistFileName = new File(this.mWorkspaceRoot, PERSIST_APPLICATION_CONFIG_FILE_NAME);
            FileOutputStream os = new FileOutputStream(appConfigPersistFileName);
            for (String key : this.mAppConfigMap.keySet()) {
                String value = (String)this.mAppConfigMap.get(key);
                String prop = value != null ? key + "=" + value + "\n" : key + "=\n";
                ((OutputStream)os).write(prop.getBytes());
            }
            ((OutputStream)os).close();
        }
        catch (Exception ex) {
            throw new MBeanException(ex, mMessages.getString("HTTPBC-E01229.Failed_to_persist_application_configurations", (Object)PERSIST_APPLICATION_CONFIG_FILE_NAME));
        }
    }

    private Map loadApplicationConfiguration(String workspaceRoot) throws MBeanException {
        Properties persistedConfig = new Properties();
        HashMap<String, String> appConfigMap = new HashMap<String, String>();
        File appConfigPersistFileName = new File(workspaceRoot, PERSIST_APPLICATION_CONFIG_FILE_NAME);
        if (!appConfigPersistFileName.exists()) {
            return appConfigMap;
        }
        try {
            FileInputStream is = new FileInputStream(appConfigPersistFileName);
            persistedConfig.load(is);
            ((InputStream)is).close();
            Enumeration<?> e = persistedConfig.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = persistedConfig.getProperty(name);
                appConfigMap.put(name, value);
            }
        }
        catch (Exception ex) {
            throw new MBeanException(ex, mMessages.getString("HTTPBC-E01230.Failed_to_load_application_configurations", (Object)PERSIST_APPLICATION_CONFIG_FILE_NAME));
        }
        return appConfigMap;
    }

    void persistConfiguration() throws MBeanException {
        try {
            ConfigPersistence.persistConfig((String)this.mWorkspaceRoot, (Properties)this.mConfig);
        }
        catch (JBIException ex) {
            throw new MBeanException((Exception)((Object)ex), mMessages.getString("HTTPBC-E01209.Failed_to_persist_mbean_config", (Object)this.mWorkspaceRoot));
        }
    }

    void validateHttpUrl(String urlLocation) throws InvalidAttributeValueException {
        try {
            new HttpUrlResolverUtil().validateHttpUrl(urlLocation);
        }
        catch (Exception ex) {
            throw new InvalidAttributeValueException(ex.getMessage());
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"jmx.attribute.change"}, AttributeChangeNotification.class.getName(), "Attribute changed")};
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.broadcasterSupport.addNotificationListener(listener, filter, handback);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.broadcasterSupport.removeNotificationListener(listener);
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.broadcasterSupport.removeNotificationListener(listener, filter, handback);
    }

    public void dump(StringBuffer msgBuf) {
        msgBuf.append("OutboundThreads (max outbound threads)");
        msgBuf.append(": ").append(this.getOutboundThreads()).append('\n');
        msgBuf.append("HttpDefaultPort");
        msgBuf.append(": ").append(this.getHttpDefaultPort()).append('\n');
        msgBuf.append("HttpsDefaultPort");
        msgBuf.append(": ").append(this.getHttpsDefaultPort()).append('\n');
        msgBuf.append("AMConfigDirectory");
        msgBuf.append(": ").append(this.getAMConfigDirectory()).append('\n');
        msgBuf.append("ProxyType");
        msgBuf.append(": ").append(this.getProxyType()).append('\n');
        msgBuf.append("ProxyHost");
        msgBuf.append(": ").append(this.getProxyHost()).append('\n');
        msgBuf.append("ProxyPort");
        msgBuf.append(": ").append(this.getProxyPort()).append('\n');
        msgBuf.append("NonProxyHosts");
        msgBuf.append(": ").append(this.getNonProxyHosts()).append('\n');
        msgBuf.append("ProxyUserName");
        msgBuf.append(": ").append(this.getProxyUserName()).append('\n');
        msgBuf.append("UseJVMProxySettings");
        msgBuf.append(": ").append(this.getUseJVMProxySettings()).append('\n');
        msgBuf.append("ApplicationVariables").append(": { ");
        for (String name : this.mAppVarMap.keySet()) {
            msgBuf.append('[').append(name).append(',');
            String[] valueType = (String[])this.mAppVarMap.get(name);
            if ("PASSWORD".equals(valueType[1])) {
                msgBuf.append("*******").append(']');
                continue;
            }
            msgBuf.append(valueType[0]).append(']');
        }
        msgBuf.append(" }\n");
        msgBuf.append("ApplicationConfigurations").append(": { ");
        for (String name : this.mAppConfigMap.keySet()) {
            msgBuf.append('[').append(name).append(',');
            String value = (String)this.mAppConfigMap.get(name);
            msgBuf.append(value).append(']');
        }
        msgBuf.append(" }");
    }
}

