/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc;

import com.sun.jbi.common.qos.messaging.BaseMessagingChannel;
import com.sun.jbi.common.qos.messaging.MessagingChannel;
import com.sun.jbi.component.jbiext.KeyStoreUtilClient;
import com.sun.jbi.configuration.RuntimeConfigurationHelper;
import com.sun.jbi.eManager.provider.EndpointStatus;
import com.sun.jbi.eManager.provider.PerformanceMeasurement;
import com.sun.jbi.eManager.provider.StatusProviderHelper;
import com.sun.jbi.eManager.provider.StatusReporting;
import com.sun.jbi.httpsoapbc.Endpoint;
import com.sun.jbi.httpsoapbc.EndpointChangeListener;
import com.sun.jbi.httpsoapbc.Extension;
import com.sun.jbi.httpsoapbc.ExtensionMBean;
import com.sun.jbi.httpsoapbc.HttpSoapBindingDeployer;
import com.sun.jbi.httpsoapbc.HttpSoapComponentContext;
import com.sun.jbi.httpsoapbc.HttpSoapEndpoint;
import com.sun.jbi.httpsoapbc.HttpSoapPerformanceMeasurement;
import com.sun.jbi.httpsoapbc.OutboundReceiver;
import com.sun.jbi.httpsoapbc.configuration.RuntimeConfiguration;
import com.sun.jbi.httpsoapbc.embedded.EmbeddedServerController;
import com.sun.jbi.httpsoapbc.jaxwssupport.JAXWSEndpointFactory;
import com.sun.jbi.httpsoapbc.management.HTTPManagement;
import com.sun.jbi.httpsoapbc.management.HTTPManagementMBean;
import com.sun.jbi.httpsoapbc.management.HTTPManagementMBeanHelper;
import com.sun.jbi.httpsoapbc.proxy.HttpProxy;
import com.sun.jbi.httpsoapbc.security.http.impl.BasicAuthenticator;
import com.sun.jbi.httpsoapbc.util.AlertsUtil;
import com.sun.jbi.httpsoapbc.util.TransformerPool;
import com.sun.jbi.internationalization.Messages;
import com.sun.xml.ws.api.server.WSEndpoint;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.management.MBeanNames;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.AttributeChangeNotification;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class HttpSoapBindingLifeCycle
implements ComponentLifeCycle,
EndpointChangeListener {
    private static final String JBI_DESC_ID_NS = "http://www.sun.com/jbi/descriptor/identification";
    private static final String JBI_VERSIONINFO_TAG = "VersionInfo";
    private static final String JBI_SPECVER_ATTR = "specification-version";
    private static final String JBI_BUILDVER_ATTR = "build-number";
    private static final String WS_ADDRESSING_NS = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
    private static final Messages mMessages = Messages.getMessages(HttpSoapBindingLifeCycle.class);
    private Logger mLogger;
    public static final Integer DEFAULT_CONTAINER_PORT = new Integer(8282);
    public static final Integer DEFAULT_SSL_CONTAINER_PORT = new Integer(443);
    public static final String SHORT_DISPLAY_NAME = "sun-http-binding";
    static final String PROCESSING_EXTENSION = "ProcessingExtension";
    public static final String PERF_CAT_NORMALIZATION = "Normalization";
    public static final String PERF_CAT_DENORMALIZATION = "Denormalization";
    public static final String[] HTTPSOAPBC_PERF_CATEGORIES = new String[]{"Normalization", "Denormalization"};
    int mOutboundCorePoolSize = 5;
    int mOutboundKeepAliveTime = 600;
    TimeUnit mOutboundTimeUnit = TimeUnit.SECONDS;
    int mOutboundMaxPoolSize = Integer.MAX_VALUE;
    private String mComponentName;
    private ComponentContext mContext;
    private OutboundReceiver mOutboundReceiver;
    private Thread mOutboundReceiverThread;
    private Map mEndpoints = new HashMap();
    private Map mPortReferenceCountMap = new HashMap();
    private Map mEndpointMapping = Collections.synchronizedMap(new HashMap());
    private ObjectName mExtensionMBeanName;
    private ObjectName mProcessingExtensionMBeanName;
    private ObjectName mDeployerMBeanName;
    private MessagingChannel mChannel;
    private EmbeddedServerController mEmbeddedController;
    private StatusProviderHelper mStatusProviderHelper;
    private RuntimeConfiguration mRuntimeConfig;
    private RuntimeConfigurationHelper mRuntimeConfigHelper;
    private HTTPManagementMBeanHelper mManagementMBeanHelper;
    private HTTPManagementMBean mManagementMBean;
    private JAXWSEndpointFactory mJAXWSEndpointFactory;
    private HttpProxy mProxy;
    private BasicAuthenticator mBasicAuthenticator;
    private volatile ThreadPoolExecutor threadPool;
    private TransformerPool mTransformerPool;
    private NotificationListener listener = new NotificationListener(){

        public void handleNotification(Notification notification, Object obj) {
            AttributeChangeNotification attrNotif;
            String attrName;
            if (notification instanceof AttributeChangeNotification && (attrName = (attrNotif = (AttributeChangeNotification)notification).getAttributeName()).equals("OutboundThreads")) {
                Integer newVal = (Integer)attrNotif.getNewValue();
                HttpSoapBindingLifeCycle.this.setThreads(newVal);
            }
        }
    };
    private List appserverContainerPorts = new ArrayList();
    private HttpSoapBindingDeployer mServiceUnitManager;

    public HttpSoapBindingLifeCycle() {
        this.mTransformerPool = new TransformerPool();
    }

    public ObjectName getDeploymentMBeanName() {
        return this.mDeployerMBeanName;
    }

    public ObjectName getExtensionMBeanName() {
        return this.mExtensionMBeanName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ComponentContext jbiContext) throws JBIException {
        if (jbiContext == null) {
            throw new JBIException(mMessages.getString("HTTPBC-E00155.Null_component_context"));
        }
        this.mContext = jbiContext;
        this.mComponentName = jbiContext.getComponentName();
        HttpSoapComponentContext.getInstance().setContext(this.mContext);
        HttpSoapComponentContext.getInstance().setAssociatedLifeCycle(this);
        Messages.registerContext((ComponentContext)this.mContext);
        this.mLogger = Messages.getLogger(this.getClass());
        this.mJAXWSEndpointFactory = new JAXWSEndpointFactory();
        this.mEmbeddedController = new EmbeddedServerController(this);
        MBeanServer mbServer = jbiContext.getMBeanServer();
        MBeanNames mbnHndl = jbiContext.getMBeanNames();
        this.mProcessingExtensionMBeanName = mbnHndl.createCustomComponentMBeanName(PROCESSING_EXTENSION);
        try {
            StandardMBean extensionBean = new StandardMBean(new Extension(), ExtensionMBean.class);
            if (!mbServer.isRegistered(this.mProcessingExtensionMBeanName)) {
                mbServer.registerMBean(extensionBean, this.mProcessingExtensionMBeanName);
                if (this.mLogger.isLoggable(Level.FINE)) {
                    this.mLogger.log(Level.FINE, "Registered extension MBean with name " + this.mProcessingExtensionMBeanName);
                }
            } else if (this.mLogger.isLoggable(Level.FINE)) {
                this.mLogger.log(Level.FINE, "Skipping registration of Extension MBean " + this.mProcessingExtensionMBeanName + " because it is already registered.");
            }
        }
        catch (JMException ex) {
            String text = mMessages.getString("HTTPBC-W00121.Exception_during_extension_mbean_register", (Object)ex.getMessage());
            AlertsUtil.getAlerter().critical(text, SHORT_DISPLAY_NAME, null, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-W00121");
            throw new JBIException(text, (Throwable)ex);
        }
        try {
            ObjectName statusMBeanObjName = mbnHndl.createCustomComponentMBeanName("Statistics");
            this.mStatusProviderHelper = new StatusProviderHelper(SHORT_DISPLAY_NAME, statusMBeanObjName, jbiContext.getMBeanServer());
            this.mStatusProviderHelper.registerMBean(HTTPSOAPBC_PERF_CATEGORIES, (PerformanceMeasurement)new HttpSoapPerformanceMeasurement());
            if (this.mLogger.isLoggable(Level.FINE)) {
                this.mLogger.log(Level.FINE, "Registered Status Provider MBean for " + jbiContext.getComponentName());
            }
        }
        catch (Exception ex) {
            String text = mMessages.getString("HTTPBC-W00120.Exception_during_status_mbean_register", (Object)ex.getMessage());
            AlertsUtil.getAlerter().critical(text, SHORT_DISPLAY_NAME, null, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-W00120");
            throw new JBIException(text, (Throwable)ex);
        }
        try {
            Integer threadCount;
            KeyStoreUtilClient keystoreUtil = new KeyStoreUtilClient(this.mContext);
            this.mRuntimeConfig = new RuntimeConfiguration(this.mContext.getWorkspaceRoot(), keystoreUtil);
            ObjectName runtimeConfigMBeanObjName = mbnHndl.createCustomComponentMBeanName("Configuration");
            this.mRuntimeConfigHelper = new RuntimeConfigurationHelper(runtimeConfigMBeanObjName, jbiContext.getMBeanServer());
            this.mRuntimeConfigHelper.registerMBean((Object)this.mRuntimeConfig);
            if (this.mLogger.isLoggable(Level.FINE)) {
                this.mLogger.log(Level.FINE, "Registered runtime configuration MBean for " + jbiContext.getComponentName());
            }
            if ((threadCount = this.mRuntimeConfig.getOutboundThreads()) != null) {
                this.setThreads(threadCount);
            }
            if (this.threadPool == null) {
                HttpSoapBindingLifeCycle httpSoapBindingLifeCycle = this;
                synchronized (httpSoapBindingLifeCycle) {
                    this.threadPool = new ThreadPoolExecutor(this.mOutboundCorePoolSize, this.mOutboundMaxPoolSize, (long)this.mOutboundKeepAliveTime, this.mOutboundTimeUnit, new LinkedBlockingQueue<Runnable>(), new DaemonThreadFactory());
                }
            }
            this.mRuntimeConfig.addNotificationListener(this.listener, null, null);
        }
        catch (Exception ex) {
            String text = mMessages.getString("HTTPBC-W00122.Exception_during_runtimecfg_mbean_register", (Object)ex.getLocalizedMessage());
            AlertsUtil.getAlerter().critical(text, SHORT_DISPLAY_NAME, null, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-W00122");
            throw new JBIException(text, (Throwable)ex);
        }
        try {
            ObjectName managementMBeanObjName = mbnHndl.createCustomComponentMBeanName("Administration");
            this.mManagementMBean = new HTTPManagement(this);
            this.mManagementMBeanHelper = new HTTPManagementMBeanHelper(managementMBeanObjName, jbiContext.getMBeanServer());
            this.mManagementMBeanHelper.registerMBean(this.mManagementMBean);
            if (this.mLogger.isLoggable(Level.FINE)) {
                this.mLogger.log(Level.FINE, "Registered management MBean for " + jbiContext.getComponentName() + " with name " + managementMBeanObjName);
            }
        }
        catch (Exception ex) {
            String text = mMessages.getString("HTTPBC-W00126.Exception_during_management_mbean_register", (Object)ex.getMessage());
            AlertsUtil.getAlerter().critical(text, SHORT_DISPLAY_NAME, null, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-W00126");
            throw new JBIException(text, (Throwable)ex);
        }
        this.mServiceUnitManager = new HttpSoapBindingDeployer(jbiContext, this.mRuntimeConfig);
        this.mServiceUnitManager.addEndpointChangeListener(this);
    }

    public void shutDown() throws JBIException {
        String text;
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, "HTTPBC-R00102.Shutting_down_binding", this.mComponentName);
        }
        if (this.mChannel != null) {
            this.mChannel.close();
        }
        try {
            MBeanServer mbServer = this.mContext.getMBeanServer();
            mbServer.unregisterMBean(this.mProcessingExtensionMBeanName);
        }
        catch (Exception ex) {
            text = mMessages.getString("HTTPBC-W00124.Exception_during_extension_mbean_deregister", (Object)ex.getLocalizedMessage());
            this.mLogger.log(Level.WARNING, text, ex);
            AlertsUtil.getAlerter().warning(text, SHORT_DISPLAY_NAME, null, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-W00124");
        }
        try {
            this.mStatusProviderHelper.unregisterMBean();
        }
        catch (Exception ex) {
            text = mMessages.getString("HTTPBC-W00123.Exception_during_status_mbean_deregister", (Object)ex.getLocalizedMessage());
            AlertsUtil.getAlerter().critical(text, SHORT_DISPLAY_NAME, null, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-W00123");
            throw new JBIException(text, (Throwable)ex);
        }
        try {
            this.mRuntimeConfigHelper.unregisterMBean();
        }
        catch (Exception ex) {
            text = mMessages.getString("HTTPBC-W00125.Exception_during_runtimecfg_mbean_deregister", (Object)ex.getLocalizedMessage());
            AlertsUtil.getAlerter().critical(text, SHORT_DISPLAY_NAME, null, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-W00125");
            throw new JBIException(text, (Throwable)ex);
        }
        try {
            this.mManagementMBeanHelper.unregisterMBean();
        }
        catch (Exception ex) {
            text = mMessages.getString("HTTPBC-W00127.Exception_during_management_mbean_deregister", (Object)ex.getLocalizedMessage());
            AlertsUtil.getAlerter().critical(text, SHORT_DISPLAY_NAME, null, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-W00127");
            throw new JBIException(text, (Throwable)ex);
        }
        this.mEmbeddedController.stopAll();
        Messages.unregisterContext();
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, "HTTPBC-R00103.Binding_shutdown", this.mComponentName);
        }
        AlertsUtil.getAlerter().info(mMessages.getString("HTTPBC-R00103.Binding_shutdown", (Object)this.mComponentName), SHORT_DISPLAY_NAME, null, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-R00103");
    }

    public void start() throws JBIException {
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, "HTTPBC-R00100.Binding_starting", this.mComponentName);
        }
        try {
            this.mChannel = new BaseMessagingChannel(this.mContext);
            HttpSoapComponentContext.getInstance().setBindingChannel(this.mChannel);
        }
        catch (MessagingException me) {
            String text = mMessages.getString("HTTPBC-E00141.No_binding_channel", (Object)me.getLocalizedMessage());
            this.mLogger.log(Level.SEVERE, text, me);
            AlertsUtil.getAlerter().critical(text, SHORT_DISPLAY_NAME, null, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00141");
            throw me;
        }
        try {
            this.startDefaultHttpPorts();
            this.startOutbound();
        }
        catch (Exception ex) {
            String text = mMessages.getString("HTTPBC-E00101.Start_failed", new Object[]{this.mComponentName, ex.getLocalizedMessage()});
            AlertsUtil.getAlerter().critical(text, SHORT_DISPLAY_NAME, null, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00101");
            throw new JBIException(text, (Throwable)ex);
        }
        this.logComponentInfo();
    }

    public void stop() throws JBIException {
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, "HTTPBC-R00104.Stopping_binding", this.mComponentName);
        }
        try {
            this.stopOutbound();
            if (this.mLogger.isLoggable(Level.INFO)) {
                this.mLogger.log(Level.INFO, "HTTPBC-R00105.Binding_stopped", this.mComponentName);
            }
            AlertsUtil.getAlerter().info(mMessages.getString("HTTPBC-R00105.Binding_stopped", (Object)this.mComponentName), SHORT_DISPLAY_NAME, null, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-R00105");
        }
        catch (Exception ex) {
            String text = mMessages.getString("HTTPBC-E00104.Stopping_binding_failed", (Object)ex.getLocalizedMessage());
            AlertsUtil.getAlerter().critical(text, SHORT_DISPLAY_NAME, null, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00104");
            throw new JBIException(text, (Throwable)ex);
        }
    }

    MessagingChannel getBindingChannel() {
        return this.mChannel;
    }

    Map getEndpointBeans() {
        return this.mEndpoints;
    }

    public StatusProviderHelper getStatusProviderHelper() {
        return this.mStatusProviderHelper;
    }

    public Endpoint getEndpointBeanForContext(String context, int port) {
        String search = port + ":" + context;
        Endpoint match = (Endpoint)this.mEndpointMapping.get(search);
        if (match == null) {
            Set mapEntries = this.mEndpointMapping.entrySet();
            for (Map.Entry entry : mapEntries) {
                String key = (String)entry.getKey();
                if (!search.startsWith(key)) continue;
                match = (Endpoint)entry.getValue();
                break;
            }
        }
        return match;
    }

    public void endpointDeployed(Endpoint endpoint) throws Exception {
        Iterator it = this.mEndpoints.values().iterator();
        URL endpointURL = endpoint.getEndpointUrl();
        String endpointName = endpoint.getUniqueName();
        while (it.hasNext()) {
            Endpoint activatedEndpoint = (Endpoint)it.next();
            if (!activatedEndpoint.isInbound() || !endpoint.isInbound() || !activatedEndpoint.getEndpointUrl().equals(endpointURL)) continue;
            String msg = mMessages.getString("HTTPBC-E00142.Endpoint_already_started", new Object[]{endpointName, endpointURL.toString()});
            throw new Exception(msg);
        }
        this.mEndpoints.put(endpointName, endpoint);
    }

    public void endpointInitialized(Endpoint endpoint) throws Exception {
        String uniqueEndpointName = endpoint.getUniqueName();
        this.mEndpoints.put(uniqueEndpointName, endpoint);
        StatusReporting reporting = this.mStatusProviderHelper.getStatusReporter();
        String portName = endpoint.getEndpointName();
        QName serviceName = endpoint.getServiceName();
        String uniqueName = null;
        if (endpoint.isInbound()) {
            uniqueName = this.mStatusProviderHelper.createConsumingEndpointIdentifier(serviceName, portName);
            reporting.addConsumingEndpoint(uniqueName);
        } else {
            uniqueName = this.mStatusProviderHelper.createProvisioningEndpointIdentifier(serviceName, portName);
            reporting.addProvisioningEndpoint(uniqueName);
        }
        EndpointStatus stat = reporting.getEndpointStatus(uniqueName);
        endpoint.setEndpointStatus(stat);
    }

    public void endpointActivated(Endpoint aEndpoint) throws Exception {
        final Endpoint endpoint = aEndpoint;
        if (this.mLogger.isLoggable(Level.FINE)) {
            this.mLogger.log(Level.FINE, "Activating " + (endpoint.isInbound() ? "inbound" : "outbound") + " endpoint - service name: [" + endpoint.getServiceName() + "] endpoint name [" + endpoint.getEndpointName() + "]");
        }
        EndpointStatus status = endpoint.getEndpointStatus();
        String uniqueName = endpoint.getUniqueName();
        if (endpoint.isInbound()) {
            String context = endpoint.getUrlContext();
            int port = endpoint.getUrlPort();
            String protocol = endpoint.getEndpointUrl().getProtocol();
            if (context == null) {
                throw new Exception(mMessages.getString("HTTPBC-E00143.Endpoint_no_context", (Object)uniqueName));
            }
            context = "".equals(context) ? "/" : context;
            this.mEndpointMapping.put(port + ":" + context, endpoint);
            this.incrementPortReferenceCount(port);
            if (!this.appserverContainerPorts.contains(new Integer(port))) {
                try {
                    this.mEmbeddedController.startServer(port, protocol);
                }
                catch (Throwable ex) {
                    this.mEmbeddedController.stopServer(port);
                    this.mEndpoints.remove(uniqueName);
                    this.endpointDeactivated(endpoint);
                    throw new Exception(ex);
                }
            } else if (this.mLogger.isLoggable(Level.FINE)) {
                this.mLogger.log(Level.FINE, "Endpoint URL matches a container port " + Integer.valueOf(port) + " already. Not starting an embedded server for " + context);
            }
            try {
                WSEndpoint wsendpoint = this.mJAXWSEndpointFactory.createWSEndpoint(port, context, endpoint);
                wsendpoint.setExecutor((Executor)this.threadPool);
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                final Document document = builder.newDocument();
                ServiceEndpoint sep = new ServiceEndpoint(){

                    public QName getServiceName() {
                        return endpoint.getServiceName();
                    }

                    public String getEndpointName() {
                        return endpoint.getEndpointName();
                    }

                    public DocumentFragment getAsReference(QName operation) {
                        DocumentFragment fragment = document.createDocumentFragment();
                        Element address = document.createElementNS(HttpSoapBindingLifeCycle.WS_ADDRESSING_NS, "wsa:Address");
                        address.setTextContent(endpoint.getEndpointUrl().toString());
                        fragment.appendChild(address);
                        Element serviceName = document.createElementNS(HttpSoapBindingLifeCycle.WS_ADDRESSING_NS, "wsa:ServiceName");
                        String serviceNs = endpoint.getServiceName().getNamespaceURI();
                        String serviceLocalName = endpoint.getServiceName().getLocalPart();
                        serviceName.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ns0", serviceNs);
                        serviceName.setTextContent("ns0:" + serviceLocalName);
                        Attr port = document.createAttribute("PortName");
                        port.setValue(endpoint.getEndpointName());
                        fragment.appendChild(serviceName);
                        return fragment;
                    }

                    public QName[] getInterfaces() {
                        return new QName[]{endpoint.getInterfaceName()};
                    }
                };
                ServiceEndpoint[] seps = this.mContext.getExternalEndpointsForService(endpoint.getServiceName());
                if (seps == null || seps.length == 0) {
                    this.mContext.registerExternalEndpoint(sep);
                    endpoint.setEndpointReference(sep);
                    if (this.mLogger.isLoggable(Level.FINE)) {
                        this.mLogger.log(Level.FINE, "Registered an external endpoint with service name: " + endpoint.getServiceName() + " and endpoint name: " + endpoint.getEndpointName());
                    }
                }
                if (this.mLogger.isLoggable(Level.FINE)) {
                    this.mLogger.log(Level.FINE, "Inbound endpoint " + uniqueName + " prepared, mapped to context " + context);
                }
            }
            catch (Exception e) {
                this.mEndpoints.remove(uniqueName);
                this.endpointDeactivated(endpoint);
                throw e;
            }
        }
        this.populateEndpointWSDLInfo(status, endpoint);
        if (this.mLogger.isLoggable(Level.FINE)) {
            this.mLogger.log(Level.FINE, "Activated " + (endpoint.isInbound() ? "inbound" : "outbound") + "endpoint - service name: [" + endpoint.getServiceName() + "] endpoint name [" + endpoint.getEndpointName() + "]");
        }
    }

    public void endpointDeactivated(Endpoint endpoint) throws Exception {
        if (this.mLogger.isLoggable(Level.FINE)) {
            this.mLogger.log(Level.FINE, "Deactivating endpoints");
        }
        String uniqueName = endpoint.getUniqueName();
        if (endpoint.isInbound()) {
            String context = endpoint.getUrlContext();
            int port = endpoint.getUrlPort();
            if (context == null) {
                this.mLogger.log(Level.SEVERE, "HTTPBC-E00143.Endpoint_no_context", uniqueName);
            } else {
                this.mEndpointMapping.remove(port + ":" + context);
                int refCount = this.decrementPortReferenceCount(port);
                if (refCount == 0) {
                    if (this.mLogger.isLoggable(Level.FINE)) {
                        this.mLogger.log(Level.FINE, "Port " + port + " is no longer referenced by any active endpoint. About to stop this port...");
                    }
                    this.mEmbeddedController.stopServer(port);
                }
            }
            ServiceEndpoint sep = endpoint.getEndpointReference();
            if (sep != null) {
                this.mContext.deregisterExternalEndpoint(sep);
            }
        }
        if (this.mLogger.isLoggable(Level.FINE)) {
            this.mLogger.log(Level.FINE, "Endpoints deactivated");
        }
    }

    public boolean resumeActivatedEndpoint(String endpointName) {
        if (endpointName.endsWith(",Provider")) {
            String warningMsg = mMessages.getString("HTTPBC-W01306.Will_not_resume_for_outbound_endpoint", (Object)endpointName);
            if (this.mLogger.isLoggable(Level.WARNING)) {
                this.mLogger.log(Level.WARNING, warningMsg);
            }
            AlertsUtil.getAlerter().info(warningMsg, SHORT_DISPLAY_NAME, null, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-W01306");
            return false;
        }
        String consumingEndpointName = endpointName.endsWith(",Consumer") ? endpointName : endpointName + "," + "Consumer";
        Endpoint endpoint = (Endpoint)this.mEndpoints.get(consumingEndpointName);
        if (endpoint == null) {
            String warningMsg = mMessages.getString("HTTPBC-W01303.Cannot_find_consumer_endpoint_for_resume", (Object)endpointName);
            if (this.mLogger.isLoggable(Level.WARNING)) {
                this.mLogger.log(Level.WARNING, warningMsg);
            }
            AlertsUtil.getAlerter().info(warningMsg, SHORT_DISPLAY_NAME, null, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-W01303");
            return false;
        }
        if (this.mLogger.isLoggable(Level.FINE)) {
            this.mLogger.log(Level.FINE, "Resuming endpoint - service name: [" + endpoint.getServiceName() + "] endpoint name [" + endpoint.getEndpointName() + "]");
        }
        String context = endpoint.getUrlContext();
        int port = endpoint.getUrlPort();
        if (context != null) {
            context = "".equals(context) ? "/" : context;
            this.mEndpointMapping.put(port + ":" + context, endpoint);
        }
        return true;
    }

    public boolean suspendActivatedEndpoint(String endpointName) {
        if (endpointName.endsWith(",Provider")) {
            String warningMsg = mMessages.getString("HTTPBC-W01307.Will_not_suspend_for_outbound_endpoint", (Object)endpointName);
            if (this.mLogger.isLoggable(Level.WARNING)) {
                this.mLogger.log(Level.WARNING, warningMsg);
            }
            AlertsUtil.getAlerter().info(warningMsg, SHORT_DISPLAY_NAME, null, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-W01307");
            return false;
        }
        String consumingEndpointName = endpointName.endsWith(",Consumer") ? endpointName : endpointName + "," + "Consumer";
        Endpoint endpoint = (Endpoint)this.mEndpoints.get(consumingEndpointName);
        if (endpoint == null) {
            String warningMsg = mMessages.getString("HTTPBC-W01304.Cannot_find_consumer_endpoint_for_suspend=HTTPBC-E01304", (Object)endpointName);
            if (this.mLogger.isLoggable(Level.WARNING)) {
                this.mLogger.log(Level.WARNING, warningMsg);
            }
            AlertsUtil.getAlerter().info(warningMsg, SHORT_DISPLAY_NAME, null, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-W01304");
            return false;
        }
        if (this.mLogger.isLoggable(Level.FINE)) {
            this.mLogger.log(Level.FINE, "Suspending endpoint - service name: [" + endpoint.getServiceName() + "] endpoint name [" + endpoint.getEndpointName() + "]");
        }
        String context = endpoint.getUrlContext();
        int port = endpoint.getUrlPort();
        if (context != null) {
            context = "".equals(context) ? "/" : context;
            this.mEndpointMapping.remove(port + ":" + context);
        }
        return true;
    }

    public boolean isEndpointActive(String endpointName) {
        if (endpointName.endsWith(",Provider") && this.mEndpoints.containsKey(endpointName)) {
            return true;
        }
        boolean isActive = false;
        String consumingEndpointName = endpointName.endsWith(",Consumer") ? endpointName : endpointName + "," + "Consumer";
        Endpoint endpoint = (Endpoint)this.mEndpoints.get(consumingEndpointName);
        if (endpoint == null) {
            String warningMsg = mMessages.getString("HTTPBC-W01305.Cannot_check_is_active_no_endpoint", (Object)endpointName);
            if (this.mLogger.isLoggable(Level.WARNING)) {
                this.mLogger.log(Level.WARNING, warningMsg);
            }
            AlertsUtil.getAlerter().info(warningMsg, SHORT_DISPLAY_NAME, null, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-W01305");
            return false;
        }
        if (this.mLogger.isLoggable(Level.FINE)) {
            this.mLogger.log(Level.FINE, "Checking if endpoint - service name: [" + endpoint.getServiceName() + "] endpoint name [" + endpoint.getEndpointName() + "] is active...");
        }
        String context = endpoint.getUrlContext();
        int port = endpoint.getUrlPort();
        if (context != null) {
            context = "".equals(context) ? "/" : context;
            isActive = this.mEndpointMapping.containsKey(port + ":" + context);
        }
        return isActive;
    }

    public String[] getActiveConsumingEndpoints() {
        ArrayList<String> endpointNames = new ArrayList<String>();
        for (Endpoint aEndpoint : this.mEndpointMapping.values()) {
            endpointNames.add(aEndpoint.getUniqueName());
        }
        return endpointNames.toArray(new String[0]);
    }

    public String[] getInactiveConsumingEndpoints() {
        ArrayList<String> endpointNames = new ArrayList<String>();
        for (String uniqueName : this.mEndpoints.keySet()) {
            if (this.isEndpointActive(uniqueName)) continue;
            endpointNames.add(uniqueName);
        }
        return endpointNames.toArray(new String[0]);
    }

    public void endpointShutdown(Endpoint endpoint) throws Exception {
        String uniqueName = endpoint.getUniqueName();
        this.mEndpoints.remove(uniqueName);
        StatusReporting reporting = this.mStatusProviderHelper.getStatusReporter();
        QName serviceName = endpoint.getServiceName();
        String portName = endpoint.getEndpointName();
        if (endpoint.isInbound()) {
            uniqueName = this.mStatusProviderHelper.createConsumingEndpointIdentifier(serviceName, portName);
            reporting.removeConsumingEndpoints(new String[]{uniqueName});
        } else {
            uniqueName = this.mStatusProviderHelper.createProvisioningEndpointIdentifier(serviceName, portName);
            reporting.removeProvisioningEndpoints(new String[]{uniqueName});
        }
    }

    void startOutbound() {
        this.mOutboundReceiver = new OutboundReceiver(this.mChannel, this.mEndpoints, this.mRuntimeConfig, this.mManagementMBean);
        this.mOutboundReceiverThread = new Thread(this.mOutboundReceiver);
        this.mOutboundReceiverThread.start();
        this.mProxy = new HttpProxy(this.mRuntimeConfig);
        if (this.mLogger.isLoggable(Level.FINE)) {
            this.mLogger.log(Level.FINE, "Outbound processing started; HttpProxy instance " + this.mProxy);
        }
        this.mProxy.register();
        this.mBasicAuthenticator = new BasicAuthenticator();
        this.mBasicAuthenticator.register();
    }

    void stopOutbound() {
        this.mOutboundReceiver.stopReceiving();
        HttpSoapBindingLifeCycle httpSoapBindingLifeCycle = this;
        httpSoapBindingLifeCycle.mProxy.unregister();
        this.mBasicAuthenticator.unregister();
    }

    void determineServerPorts(MBeanServer mbServer) {
        String HTTP_LISTENER_OBJECT_NAME_PATTERN = "*:j2eeType=X-HTTPListenerConfig,*";
        ObjectName pattern = null;
        try {
            pattern = new ObjectName("*:j2eeType=X-HTTPListenerConfig,*");
        }
        catch (Exception ex) {
            String text = mMessages.getString("HTTPBC-W00130.Mbean_search_pattern_invalid_continue", (Object)"*:j2eeType=X-HTTPListenerConfig,*");
            this.mLogger.log(Level.WARNING, text, ex);
        }
        boolean useDefaults = false;
        Set<ObjectInstance> listenerConfigs = mbServer.queryMBeans(pattern, null);
        if (listenerConfigs != null && listenerConfigs.size() > 0) {
            Iterator<ObjectInstance> iter = listenerConfigs.iterator();
            boolean failure = false;
            while (iter.hasNext()) {
                ObjectInstance instance = iter.next();
                try {
                    String portStr = (String)mbServer.getAttribute(instance.getObjectName(), "Port");
                    Integer port = Integer.valueOf(portStr);
                    if (this.mLogger.isLoggable(Level.FINE)) {
                        this.mLogger.log(Level.FINE, "Container listening port found: " + port);
                    }
                    this.appserverContainerPorts.add(port);
                }
                catch (Exception ex) {
                    this.mLogger.log(Level.WARNING, "HTTPBC-W00131.Listen_port_query_failed", ex);
                    failure = true;
                }
            }
            if (failure && this.appserverContainerPorts.size() == 0) {
                useDefaults = true;
            }
        } else {
            useDefaults = true;
        }
        if (useDefaults) {
            String defaultPortsDisplayString = DEFAULT_CONTAINER_PORT + " " + DEFAULT_SSL_CONTAINER_PORT;
            this.appserverContainerPorts.add(DEFAULT_CONTAINER_PORT);
            this.appserverContainerPorts.add(DEFAULT_SSL_CONTAINER_PORT);
        }
    }

    boolean hasCorrespodingInboundEndpoint(HttpSoapEndpoint[] endpoints, QName fullServiceName, String endpointName) {
        boolean hasCorresponding = false;
        for (int endpointCount = 0; endpointCount < endpoints.length && !hasCorresponding; ++endpointCount) {
            if (!endpoints[endpointCount].isInbound() || !fullServiceName.equals(endpoints[endpointCount].getServiceName()) || !endpointName.equals(endpoints[endpointCount].getEndpointName())) continue;
            hasCorresponding = true;
        }
        return hasCorresponding;
    }

    public ServiceUnitManager getServiceUnitManager() {
        return this.mServiceUnitManager;
    }

    public ByteBuffer queryResource(String context, Endpoint endpoint) throws Exception {
        return this.mServiceUnitManager.queryResource(context, endpoint);
    }

    private void logComponentInfo() {
        StringBuffer msgBuf = new StringBuffer(mMessages.getString("HTTPBC-R00101.Binding_started_detailed", (Object)this.mComponentName));
        msgBuf.append('\n');
        String installRoot = this.mContext.getInstallRoot();
        this.identity(msgBuf, installRoot);
        this.mRuntimeConfig.dump(msgBuf);
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, msgBuf.toString());
        }
        AlertsUtil.getAlerter().info(msgBuf.toString(), SHORT_DISPLAY_NAME, null, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-R00101");
    }

    private void identity(StringBuffer buf, String idDescPath) {
        String JBI_XML_PATH = idDescPath.concat("/META-INF/jbi.xml");
        String specVersion = "unknown";
        String buildNumber = "unknown";
        File desc = new File(JBI_XML_PATH);
        try {
            DocumentBuilderFactory aFactory = DocumentBuilderFactory.newInstance();
            aFactory.setIgnoringComments(true);
            aFactory.setNamespaceAware(true);
            DocumentBuilder aDocumentBuilder = aFactory.newDocumentBuilder();
            Document document = aDocumentBuilder.parse(JBI_XML_PATH);
            NodeList versioninfoNodes = document.getElementsByTagNameNS(JBI_DESC_ID_NS, JBI_VERSIONINFO_TAG);
            for (int i = 0; i < versioninfoNodes.getLength(); ++i) {
                Node buildVerAttrNode;
                Node versioninfoNode = versioninfoNodes.item(i);
                if (!versioninfoNode.hasAttributes()) continue;
                NamedNodeMap attrMap = versioninfoNode.getAttributes();
                Node specVerAttrNode = attrMap.getNamedItem(JBI_SPECVER_ATTR);
                if (specVerAttrNode != null && specVerAttrNode.getNodeType() == 2) {
                    specVersion = specVerAttrNode.getNodeValue();
                }
                if ((buildVerAttrNode = attrMap.getNamedItem(JBI_BUILDVER_ATTR)) != null && buildVerAttrNode.getNodeType() == 2) {
                    buildNumber = buildVerAttrNode.getNodeValue();
                }
                break;
            }
        }
        catch (ParserConfigurationException e) {
            String msg = mMessages.getString("HTTPBC-E00154.JBI_xml_docbuilder_error", (Object)JBI_XML_PATH);
            this.mLogger.log(Level.WARNING, msg, e);
            AlertsUtil.getAlerter().warning(msg, SHORT_DISPLAY_NAME, null, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00154");
        }
        catch (SAXException e) {
            String msg = mMessages.getString("HTTPBC-E00152.JBI_xml_ident_parse_error", (Object)JBI_XML_PATH);
            this.mLogger.log(Level.WARNING, msg, e);
            AlertsUtil.getAlerter().warning(msg, SHORT_DISPLAY_NAME, null, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00152");
        }
        catch (IOException e) {
            String msg = mMessages.getString("HTTPBC-E00153.JBI_xml_ident_io_error", (Object)JBI_XML_PATH);
            this.mLogger.log(Level.WARNING, msg, e);
            AlertsUtil.getAlerter().warning(msg, SHORT_DISPLAY_NAME, null, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00153");
        }
        buf.append("specification-version: ").append(specVersion).append('\n');
        buf.append("build-number: ").append(buildNumber).append('\n');
    }

    public void setThreads(int threadCount) {
        this.mOutboundMaxPoolSize = threadCount;
        if (this.threadPool != null) {
            this.threadPool.setMaximumPoolSize(threadCount);
        }
    }

    private void populateEndpointWSDLInfo(EndpointStatus endpointStatus, Endpoint endpoint) throws Exception {
        HashMap<String, String> importedResources = new HashMap<String, String>();
        Transformer transformer = this.mTransformerPool.retrieve();
        if (endpointStatus != null) {
            Definition originalWsdlDef = endpoint.getServiceDescriptor();
            StringWriter originalWsdl = new StringWriter();
            WSDLFactory wsdlFactory = WSDLFactory.newInstance();
            WSDLWriter writer = wsdlFactory.newWSDLWriter();
            writer.writeWSDL(originalWsdlDef, (Writer)originalWsdl);
            endpointStatus.setWSDLDefinition(originalWsdl.toString());
            for (Definition aImportedWSDL : endpoint.getImportedWSDLDefinitions().values()) {
                if (aImportedWSDL == null) continue;
                StringWriter sWriter = new StringWriter();
                writer.writeWSDL(aImportedWSDL, (Writer)sWriter);
                importedResources.put(aImportedWSDL.getTargetNamespace(), sWriter.toString());
            }
            for (Element aImportedSchema : endpoint.getImportedXSDSchemas().values()) {
                if (aImportedSchema == null) continue;
                DOMSource src = new DOMSource(aImportedSchema);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                StreamResult dest = new StreamResult(baos);
                transformer.transform(src, dest);
                importedResources.put(aImportedSchema.getAttribute("targetNamespace"), baos.toString());
            }
            endpointStatus.setWSDLImportedResources(importedResources);
            this.mTransformerPool.relinquish(transformer);
        }
    }

    private void startDefaultHttpPorts() {
        block5: {
            try {
                Integer httpDefaultPort = this.mRuntimeConfig.getHttpDefaultPort();
                Integer httpsDefaultPort = this.mRuntimeConfig.getHttpsDefaultPort();
                if (httpDefaultPort != null && httpDefaultPort != -1) {
                    this.mEmbeddedController.startServer(httpDefaultPort, "http");
                    if (this.mLogger.isLoggable(Level.FINE)) {
                        this.mLogger.log(Level.FINE, "Started default HTTP port (a.k.a. HttpDefaultPort) " + httpDefaultPort);
                    }
                }
                if (this.mLogger.isLoggable(Level.FINE)) {
                    this.mLogger.log(Level.FINE, "Default HTTPS port will not be started automatically when HTTP BC starts up...");
                }
            }
            catch (Throwable e) {
                if (!this.mLogger.isLoggable(Level.WARNING)) break block5;
                this.mLogger.log(Level.WARNING, mMessages.getString("HTTPBC-E00156.Failed_to_start_default_ports", (Object)e.getMessage()));
            }
        }
    }

    private void incrementPortReferenceCount(int port) {
        if (port != this.mRuntimeConfig.getHttpDefaultPort() && port != this.mRuntimeConfig.getHttpsDefaultPort()) {
            int refCount = 0;
            if (this.mPortReferenceCountMap.containsKey(new Integer(port))) {
                refCount = (Integer)this.mPortReferenceCountMap.get(new Integer(port));
            }
            this.mPortReferenceCountMap.put(new Integer(port), new Integer(++refCount));
        }
    }

    private int decrementPortReferenceCount(int port) {
        int refCount = 0;
        if (port != this.mRuntimeConfig.getHttpDefaultPort() && port != this.mRuntimeConfig.getHttpsDefaultPort() && this.mPortReferenceCountMap.containsKey(new Integer(port))) {
            refCount = (Integer)this.mPortReferenceCountMap.get(new Integer(port));
            if (refCount == 1) {
                this.mPortReferenceCountMap.remove(new Integer(port));
            } else {
                this.mPortReferenceCountMap.put(new Integer(port), new Integer(refCount - 1));
            }
        }
        return --refCount;
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        private DaemonThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread daemonThread = new Thread(r, "HTTPBC-JAXWS-Engine-" + this.threadNumber.getAndIncrement());
            daemonThread.setDaemon(Boolean.TRUE);
            return daemonThread;
        }
    }
}

