/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc;

import com.sun.jbi.common.qos.redelivery.RedeliveryConfig;
import com.sun.jbi.eManager.provider.EndpointStatus;
import com.sun.jbi.httpsoapbc.Endpoint;
import com.sun.jbi.httpsoapbc.HttpSoapBindingDeployer;
import com.sun.jbi.httpsoapbc.OperationMetaData;
import com.sun.jbi.httpsoapbc.RequestThrottlingController;
import com.sun.jbi.httpsoapbc.extensions.Policy;
import com.sun.jbi.httpsoapbc.extensions.PolicyReference;
import com.sun.jbi.httpsoapbc.security.api.CredentialValidator;
import com.sun.jbi.httpsoapbc.security.api.EndpointSecurityConfig;
import com.sun.jbi.httpsoapbc.security.api.HTTPBasicAuthCredential;
import com.sun.jbi.httpsoapbc.security.api.HttpBcSecurityException;
import com.sun.jbi.httpsoapbc.security.impl.CredentialValidatorManager;
import com.sun.jbi.httpsoapbc.security.util.impl.Base64Impl;
import com.sun.jbi.internationalization.Messages;
import com.sun.xml.ws.api.server.WSEndpoint;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.security.auth.Subject;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.OperationType;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractEndpoint
implements Endpoint,
Serializable {
    private static final Messages mMessages = Messages.getMessages(HttpSoapBindingDeployer.class);
    private static final String ENDPOINT_TYPE_INBOUND = "Consumer";
    private static final String ENDPOINT_TYPE_OUTBOUND = "Provider";
    private Logger mLogger = Messages.getLogger(this.getClass());
    protected Definition mDefinition;
    protected Port mMatchedPort;
    protected File mOriginalWSDL;
    protected List mOriginalWSDLImports;
    protected List mImportedWSDLNamespaces;
    protected List mImportedXSDNamespaces;
    protected EndpointStatus mEndpointStatus;
    protected URL mEndpointUrl;
    protected ServiceEndpoint mServiceEndpoint;
    protected String mEndpointName;
    protected String mWsdlPath;
    protected QName mServiceName;
    protected QName mInterfaceName;
    protected boolean mIsInbound;
    protected boolean mIsDynamicEPR;
    protected URL mDynamicEPRUrl;
    protected Map mOperationNameToMetaData;
    protected Map mImportedWSDLDefinitions;
    protected Map mImportedXSDDefinitions;
    protected WSEndpoint mWSEndpoint;
    protected String mServiceUnitID;
    protected String mServiceUnitRootPath;
    protected int maxConcurrencyLimit = -1;
    protected RedeliveryConfig mRedeliveryConfig;
    protected int pendingExchanges = 0;
    protected RequestThrottlingController throttlingController;
    protected CredentialValidatorManager mCredValidatorMgr;
    protected Policy mSecPolicy;
    protected boolean mAuthenticateClient = false;
    protected Base64Impl base64;
    protected boolean securityEnabled;
    protected HTTPBasicAuthCredential basicAuthCredentials;
    protected EndpointSecurityConfig mSecurityConfig;
    protected long mMessageIdCounter = 0L;

    public AbstractEndpoint(Definition def, QName serviceName, String endpointName, QName interfaceName, boolean isProvider, String wsdlPath, EndpointSecurityConfig securityConfig, String serviceUnitID, String serviceUnitRootPath, CredentialValidatorManager cvm) {
        this.mDefinition = def;
        this.mServiceName = serviceName;
        this.mEndpointName = QName.valueOf(endpointName).getLocalPart();
        this.mInterfaceName = interfaceName;
        this.mIsInbound = !isProvider;
        this.mWsdlPath = wsdlPath;
        this.mSecurityConfig = securityConfig;
        this.mOriginalWSDLImports = new ArrayList();
        this.mImportedWSDLNamespaces = new ArrayList();
        this.mImportedXSDNamespaces = new ArrayList();
        this.mImportedWSDLDefinitions = new HashMap();
        this.mImportedXSDDefinitions = new HashMap();
        this.mServiceUnitID = serviceUnitID;
        this.mServiceUnitRootPath = serviceUnitRootPath;
        this.mCredValidatorMgr = cvm;
    }

    public void setEndpointStatus(EndpointStatus val) {
        this.mEndpointStatus = val;
    }

    public EndpointStatus getEndpointStatus() {
        return this.mEndpointStatus;
    }

    public String getUniqueName() {
        String serviceNamespaceURI = this.getServiceName().getNamespaceURI();
        String serviceName = this.getServiceName().getLocalPart();
        String endpointName = this.getEndpointName();
        return AbstractEndpoint.getUniqueName(serviceNamespaceURI, serviceName, endpointName, this.isInbound());
    }

    public static String getUniqueName(String aServiceNamespaceURI, String aServiceName, String aEndpointName, boolean isInbound) {
        String aEndpointType = isInbound ? ENDPOINT_TYPE_INBOUND : ENDPOINT_TYPE_OUTBOUND;
        return aServiceNamespaceURI + "," + aServiceName + "," + aEndpointName + "," + aEndpointType;
    }

    public WSEndpoint getWSEndpoint() {
        return this.mWSEndpoint;
    }

    public void setWSEndpoint(WSEndpoint wsEndpoint) {
        this.mWSEndpoint = wsEndpoint;
    }

    public Definition getServiceDescriptor() {
        return this.mDefinition;
    }

    public void setServiceDescriptor(Definition def) {
        this.mDefinition = def;
    }

    public Document getServiceDescriptorAsDocument() {
        try {
            WSDLFactory wsdlFactory = WSDLFactory.newInstance();
            WSDLWriter writer = wsdlFactory.newWSDLWriter();
            return writer.getDocument(this.getServiceDescriptor());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ByteBuffer getServiceDescriptorAsByteBuffer() {
        try {
            WSDLFactory wsdlFactory = WSDLFactory.newInstance();
            WSDLWriter writer = wsdlFactory.newWSDLWriter();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            writer.writeWSDL(this.getServiceDescriptor(), (OutputStream)baos);
            return ByteBuffer.wrap(baos.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setOriginalWSDL(File originalWSDL) {
        this.mOriginalWSDL = originalWSDL;
    }

    public File getOriginalWSDL() {
        return this.mOriginalWSDL;
    }

    public void addWSDLImport(URL anImport) {
        this.mOriginalWSDLImports.add(anImport);
    }

    public List getWSDLImports() {
        return this.mOriginalWSDLImports;
    }

    public void addImportedWSDLNamespace(String namespace) {
        this.mImportedWSDLNamespaces.add(namespace);
    }

    public List getImportedWSDLNamespaces() {
        return this.mImportedWSDLNamespaces;
    }

    public void addImportedXSDNamespace(String namespace) {
        this.mImportedXSDNamespaces.add(namespace);
    }

    public List getImportedXSDNamespaces() {
        return this.mImportedXSDNamespaces;
    }

    public void addImportedWSDLDefinition(String namespace, Definition definition) {
        this.mImportedWSDLDefinitions.put(namespace, definition);
    }

    public Map getImportedWSDLDefinitions() {
        return this.mImportedWSDLDefinitions;
    }

    public void addImportedXSDSchema(String namespace, Element schemaElement) {
        this.mImportedXSDDefinitions.put(namespace, schemaElement);
    }

    public Map getImportedXSDSchemas() {
        return this.mImportedXSDDefinitions;
    }

    public URL getEndpointUrl() {
        return this.mEndpointUrl;
    }

    public void setEndpointUrl(URL endpointUrl) {
        this.mEndpointUrl = endpointUrl;
    }

    public int getUrlPort() {
        if (this.mEndpointUrl.getPort() == -1) {
            return this.mEndpointUrl.getDefaultPort();
        }
        return this.mEndpointUrl.getPort();
    }

    public String getUrlContext() {
        return this.mEndpointUrl.getPath();
    }

    public ServiceEndpoint getEndpointReference() {
        return this.mServiceEndpoint;
    }

    public void setEndpointReference(ServiceEndpoint serviceEndpoint) {
        this.mServiceEndpoint = serviceEndpoint;
    }

    public String getEndpointName() {
        return this.mEndpointName;
    }

    public void setEndpointName(String endpointName) {
        this.mEndpointName = endpointName;
    }

    public QName getServiceName() {
        return this.mServiceName;
    }

    public void setServiceName(QName serviceName) {
        this.mServiceName = serviceName;
    }

    public QName getInterfaceName() {
        return this.mInterfaceName;
    }

    public void setInterfaceName(QName interfaceName) {
        this.mInterfaceName = interfaceName;
    }

    public boolean isInbound() {
        return this.mIsInbound;
    }

    public void setIsInbound(boolean isInbound) {
        this.mIsInbound = isInbound;
    }

    public Map getOperationNameToMetaData() {
        return this.mOperationNameToMetaData;
    }

    public void setOperationNameToMetaData(Map opNameToMetaData) {
        this.mOperationNameToMetaData = opNameToMetaData;
    }

    public BindingOperation[] getOperations(Definition def, String serviceName, String endpointName) {
        List l;
        Binding binding = this.getBinding(def, serviceName, endpointName);
        if (binding != null && (l = binding.getBindingOperations()) != null && l.size() > 0) {
            return l.toArray(new BindingOperation[0]);
        }
        return null;
    }

    public Binding getBinding(Definition def, String serviceName, String endpointName) {
        Object location = null;
        Service svc = def.getService(QName.valueOf(serviceName));
        if (svc == null) {
            return null;
        }
        Port port = svc.getPort(QName.valueOf(endpointName).getLocalPart());
        if (port == null) {
            return null;
        }
        return port.getBinding();
    }

    String determineMEP(BindingOperation bo) {
        String mep = null;
        OperationType type = bo.getOperation().getStyle();
        if (this.mIsInbound) {
            if (type.equals(OperationType.REQUEST_RESPONSE) || type.equals(OperationType.SOLICIT_RESPONSE)) {
                mep = "inout";
            } else if (type.equals(OperationType.ONE_WAY) || type.equals(OperationType.NOTIFICATION)) {
                mep = "inonly";
            }
        } else if (type.equals(OperationType.REQUEST_RESPONSE) || type.equals(OperationType.SOLICIT_RESPONSE)) {
            mep = "outin";
        } else if (type.equals(OperationType.ONE_WAY) || type.equals(OperationType.NOTIFICATION)) {
            mep = "outonly";
        }
        return mep;
    }

    public Port getPort() {
        Port port = null;
        Service svc = this.mDefinition.getService(this.mServiceName);
        if (svc == null) {
            return null;
        }
        port = svc.getPort(QName.valueOf(this.mEndpointName).getLocalPart());
        return port;
    }

    protected PolicyReference getPolicyReference() {
        Port port = this.getPort();
        if (port != null) {
            Iterator extIter;
            List extElems = port.getExtensibilityElements();
            Iterator iterator = extIter = extElems == null ? null : extElems.iterator();
            while (extIter != null && extIter.hasNext()) {
                ExtensibilityElement ee = (ExtensibilityElement)extIter.next();
                if (!PolicyReference.class.isInstance(ee)) continue;
                return (PolicyReference)ee;
            }
        }
        return null;
    }

    public boolean isBasicAuthenticationEnabled() {
        PolicyReference reference = this.getPolicyReference();
        if (reference != null) {
            String policyReferenceURI = reference.getURI();
            if (policyReferenceURI == null) {
                return false;
            }
            Policy pol = this.getPolicy(reference);
            if (pol != null) {
                return pol.getMustSupportBasicAuthentication().getAuthEnabled();
            }
        }
        return false;
    }

    public Policy getPolicy(PolicyReference pr) {
        Policy p = null;
        if (pr != null) {
            Iterator extIter;
            List extElems = this.mDefinition.getExtensibilityElements();
            Iterator iterator = extIter = extElems == null ? null : extElems.iterator();
            while (extIter != null && extIter.hasNext()) {
                ExtensibilityElement ee = (ExtensibilityElement)extIter.next();
                if (!Policy.class.isInstance(ee) || !((Policy)ee).getID().equalsIgnoreCase(pr.getURI().substring(1))) continue;
                p = (Policy)ee;
            }
        }
        return p;
    }

    public void setIsDynamicEPR(boolean isDynamic) {
        this.mIsDynamicEPR = isDynamic;
    }

    public boolean isDynamicEPR() {
        return this.mIsDynamicEPR;
    }

    public void setDynamicEPRUrl(URL url) {
        this.mDynamicEPRUrl = url;
    }

    public URL getDynamicEPRUrl() {
        return this.mDynamicEPRUrl;
    }

    public QName createOperationAddress(OperationMetaData opMetaData) {
        String opName = opMetaData.getOperationName();
        if (this.mInterfaceName == null) {
            Binding binding = this.getBinding(this.mDefinition, this.mServiceName.toString(), this.mEndpointName);
            this.mInterfaceName = binding.getPortType().getQName();
        }
        return new QName(this.mInterfaceName.getNamespaceURI(), opName);
    }

    public String getServiceUnitID() {
        return this.mServiceUnitID;
    }

    public String getServiceUnitRootPath() {
        return this.mServiceUnitRootPath;
    }

    public int getMaxConcurrencyLimit() {
        return this.maxConcurrencyLimit;
    }

    public void setMaxConcurrencyLimit(int maxConcurrencyLimit) {
        this.maxConcurrencyLimit = maxConcurrencyLimit;
    }

    public RedeliveryConfig getRedeliveryConfiguration() {
        return this.mRedeliveryConfig;
    }

    public void setRedeliveryConfiguration(RedeliveryConfig redeliveryConfig) {
        this.mRedeliveryConfig = redeliveryConfig;
    }

    public synchronized int getPendingExchangeReplies() {
        return this.pendingExchanges;
    }

    public synchronized void incrementPendingExchangeReplies() {
        ++this.pendingExchanges;
    }

    public synchronized void decrementPendingExchangeReplies() {
        --this.pendingExchanges;
        if (this.throttlingController != null) {
            this.throttlingController.resumeSuspendedRequests(this);
        }
    }

    public void setInboundRequestThrottlingController(RequestThrottlingController controller) {
        this.throttlingController = controller;
    }

    public Subject handleSecurity(String header) throws HttpBcSecurityException {
        Subject subj;
        block14: {
            subj = null;
            if (this.mAuthenticateClient) {
                CredentialValidator cv = null;
                try {
                    cv = this.mCredValidatorMgr.acquireCredentialValidator(this.getUniqueName(), this.mSecPolicy);
                    if (cv != null) {
                        if (header == null) {
                            throw new HttpBcSecurityException(mMessages.getString("HTTPBC-E01023.NoAuthorizationHeader"));
                        }
                        if (!header.startsWith("Basic")) {
                            throw new HttpBcSecurityException(mMessages.getString("HTTPBC-E01024.BasicAuthorizationHeaderRequired", (Object)header));
                        }
                        String trimHeader = header.trim();
                        String decoded = "";
                        try {
                            if (this.base64 == null) {
                                this.base64 = new Base64Impl();
                            }
                            decoded = this.base64.decode(trimHeader.substring(5).trim());
                        }
                        catch (Exception e) {
                            QName qualifiedEndpointName = new QName(this.getServiceName().getNamespaceURI(), this.getEndpointName());
                            String err = mMessages.getString("HTTPBC-E01035.Failed_to_decode_authorization_header", new Object[]{qualifiedEndpointName.toString(), e.getLocalizedMessage()});
                            throw new HttpBcSecurityException(err, e);
                        }
                        String username = null;
                        String password = null;
                        String[] credentials = decoded.split(":");
                        if (credentials.length != 2) {
                            throw new HttpBcSecurityException(mMessages.getString("HTTPBC-E01033.Invalid_authorization_header", (Object)header));
                        }
                        username = credentials[0];
                        password = credentials[1];
                        subj = cv.validateCredential(username, password.toCharArray());
                        break block14;
                    }
                    QName qualifiedEndpointName = new QName(this.getServiceName().getNamespaceURI(), this.getEndpointName());
                    String err = mMessages.getString("HTTPBC-E01034.Failed_to_acquire_credential_validator", new Object[]{qualifiedEndpointName.toString()});
                    throw new Exception(err);
                }
                catch (Exception e) {
                    throw new HttpBcSecurityException(e);
                }
                finally {
                    if (cv != null) {
                        this.mCredValidatorMgr.releaseCredentialValidator(cv);
                    }
                }
            }
        }
        return subj;
    }

    public HTTPBasicAuthCredential getBasicAuthCredential() {
        return this.basicAuthCredentials;
    }

    public synchronized long getCRMPMessageId() {
        return ++this.mMessageIdCounter;
    }

    protected void initSecuritySupport() throws Exception {
        this.securityEnabled = this.isBasicAuthenticationEnabled();
        if (this.securityEnabled) {
            PolicyReference pr = this.getPolicyReference();
            if (pr == null) {
                QName qualifiedEndpointName = new QName(this.getServiceName().getNamespaceURI(), this.getEndpointName());
                String err = mMessages.getString("HTTPBC-E01031.Invalid_endpoint_config_no_policyref", new Object[]{qualifiedEndpointName.toString()});
                throw new Exception(err);
            }
            this.mSecPolicy = this.getPolicy(pr);
            if (this.mSecPolicy == null) {
                QName qualifiedEndpointName = new QName(this.getServiceName().getNamespaceURI(), this.getEndpointName());
                String err = mMessages.getString("HTTPBC-E01032.Invalid_endpoint_config_no_policy", new Object[]{qualifiedEndpointName.toString(), this.getPolicyReference().getURI()});
                throw new Exception(err);
            }
            if (this.isInbound()) {
                this.mAuthenticateClient = true;
            } else if (this.basicAuthCredentials == null) {
                this.basicAuthCredentials = new HTTPBasicAuthCredential(this.mSecPolicy.getUserName(), this.mSecPolicy.getPassword().toCharArray());
            }
        }
    }

    public void shutdown() throws JBIException {
    }
}

