/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc;

import com.sun.jbi.httpsoapbc.NodeListImpl;
import com.sun.jbi.httpsoapbc.OperationMetaData;
import com.sun.jbi.httpsoapbc.util.DebugLog;
import com.sun.jbi.httpsoapbc.util.StringUtil;
import com.sun.jbi.internationalization.Messages;
import com.sun.jbi.nms.wsdl11wrapper.HelperFactory;
import com.sun.jbi.nms.wsdl11wrapper.WrapperBuilder;
import com.sun.jbi.nms.wsdl11wrapper.WrapperProcessingException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataSource;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.handler.MessageContext;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XmlPostNormalizer {
    private static final int INITIAL_STREAM_SIZE = 131072;
    private static final String SOAP_HEADERS_PROPERTY = "com.sun.jbi.headers.soap";
    private static final String HTTP_HEADERS_PROPERTY = "com.sun.jbi.headers.http";
    private static Messages mMessages = Messages.getMessages(XmlPostNormalizer.class);
    private static Logger mLog = Messages.getLogger(XmlPostNormalizer.class);
    private static TransformerFactory cTransformerFactory = TransformerFactory.newInstance();
    private boolean mIsHeaderCopyEnabled = false;
    DocumentBuilder mBuilder = null;
    WrapperBuilder wrapperBuilder;

    public XmlPostNormalizer() throws MessagingException {
        try {
            this.wrapperBuilder = HelperFactory.createBuilder();
        }
        catch (WrapperProcessingException ex) {
            throw new MessagingException("Failed to create wrapper builder", (Throwable)ex);
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            this.mBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new MessagingException("Failed to create document builder", (Throwable)ex);
        }
    }

    private Document newDocument() throws ParserConfigurationException {
        Document doc = null;
        doc = this.mBuilder.newDocument();
        return doc;
    }

    public NormalizedMessage normalize(Object message, MessageExchange exchange, OperationMetaData meta, boolean inMsg, MessageContext context) throws MessagingException {
        NormalizedMessage normalMsg = exchange.createMessage();
        try {
            Transformer transformer = cTransformerFactory.newTransformer();
            DataSource sourceMsg = (DataSource)message;
            Document normalDoc = this.newDocument();
            Object normalRoot = null;
            Object type = null;
            String name = null;
            Message msg = null;
            if (inMsg) {
                name = meta.getInMsgName();
                msg = meta.getInputMessage();
            } else {
                name = meta.getOutMsgName();
                msg = meta.getOutputMessage();
            }
            this.wrapperBuilder.initialize(normalDoc, msg, name);
            Document xmlDoc = null;
            Collection parts = msg.getParts().values();
            if (!parts.isEmpty()) {
                for (Part part : parts) {
                    NodeList nodeList;
                    QName elementName = part.getElementName();
                    if (elementName == null) {
                        String value = StringUtil.streamToString(sourceMsg.getInputStream(), "UTF-8");
                        Text node = normalDoc.createTextNode(value == null ? "" : value);
                        nodeList = new NodeListImpl();
                        ((NodeListImpl)nodeList).addItem(node);
                        this.wrapperBuilder.addPart(part.getName(), nodeList);
                        continue;
                    }
                    String localname = elementName.getLocalPart();
                    String uri = elementName.getNamespaceURI();
                    if (xmlDoc == null) {
                        xmlDoc = this.mBuilder.parse(sourceMsg.getInputStream());
                    }
                    if ((nodeList = xmlDoc.getElementsByTagNameNS(uri, localname)).getLength() <= 0) continue;
                    this.wrapperBuilder.addPart(part.getName(), nodeList);
                }
            }
            normalDoc = this.wrapperBuilder.getResult();
            if (this.mIsHeaderCopyEnabled && context != null && inMsg) {
                this.processHTTPRequestHeaders(normalMsg, context);
            }
            if (mLog.isLoggable(Level.FINE)) {
                DebugLog.debugLog(mLog, Level.FINE, "Normalized message", normalDoc);
            }
            normalMsg.setContent((Source)new DOMSource(normalDoc));
        }
        catch (TransformerConfigurationException ex) {
            throw new MessagingException("TransformerFactory creation error", (Throwable)ex);
        }
        catch (TransformerException ex) {
            throw new MessagingException("message transformation failed (source to result)", (Throwable)ex);
        }
        catch (SAXException ex) {
            String msg = mMessages.getString("HTTPBC-E00798.Normalize_fail");
            throw new MessagingException(msg, (Throwable)ex);
        }
        catch (IOException ex) {
            throw new MessagingException("parsing failed due to I/O error", (Throwable)ex);
        }
        catch (ParserConfigurationException tex) {
            throw new MessagingException("unable to obtain normalized message as a DOM document", (Throwable)tex);
        }
        catch (WrapperProcessingException ex) {
            String msg = mMessages.getString("HTTPBC-E00798.Normalize_fail");
            throw new MessagingException(msg, (Throwable)ex);
        }
        catch (ClassCastException ex) {
            String msg = mMessages.getString("HTTPBC-E00797.Normalize_fail_nonsource", (Object)message.getClass().toString());
            throw new MessagingException(msg, (Throwable)ex);
        }
        return normalMsg;
    }

    private void processHTTPRequestHeaders(NormalizedMessage normalMsg, MessageContext context) {
        HashMap<String, String> httpHeadersProperty = (HashMap<String, String>)normalMsg.getProperty(HTTP_HEADERS_PROPERTY);
        if (httpHeadersProperty == null) {
            httpHeadersProperty = new HashMap<String, String>();
            normalMsg.setProperty(HTTP_HEADERS_PROPERTY, httpHeadersProperty);
        }
        Map requestHeaders = (Map)context.get((Object)"javax.xml.ws.http.request.headers");
        for (Map.Entry entry : requestHeaders.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)((List)entry.getValue()).get(0);
            httpHeadersProperty.put(key, value);
        }
    }
}

